/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.builder;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Stack;
import org.eclipse.mylyn.internal.wikitext.core.parser.builder.DitaTopicDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.builder.AbstractXmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineItem;
import org.eclipse.mylyn.wikitext.core.util.DefaultXmlStreamWriter;
import org.eclipse.mylyn.wikitext.core.util.FormattingXMLStreamWriter;
import org.eclipse.mylyn.wikitext.core.util.XmlStreamWriter;

public class DitaBookMapDocumentBuilder
extends AbstractXmlDocumentBuilder
implements Closeable {
    private String bookTitle;
    private String doctype = "<!DOCTYPE bookmap PUBLIC \"-//OASIS//DTD DITA 1.1 BookMap//EN\"  \"http://docs.oasis-open.org/dita/v1.1/OS/dtd/bookmap.dtd\">";
    private String topicDoctype;
    private String topicFilenameSuffix = ".dita";
    private String topicFolder;
    private File targetFile;
    private DitaTopicDocumentBuilder currentTopic;
    private String latestHeadingId;
    private File currentTopicFile;
    private final Stack<Integer> headingLevels = new Stack();
    private boolean mapEntryOpen;
    private String titleText;
    private Writer currentTopicOut;
    private OutlineItem outline;
    private int topicBreakLevel = 1;
    private boolean formattingDependencies = true;

    public DitaBookMapDocumentBuilder(Writer out) {
        super(out);
    }

    public DitaBookMapDocumentBuilder(XmlStreamWriter writer) {
        super(writer);
    }

    protected XmlStreamWriter createXmlStreamWriter(Writer out) {
        XmlStreamWriter writer = super.createXmlStreamWriter(out);
        return new FormattingXMLStreamWriter(writer);
    }

    public String getBookTitle() {
        return this.bookTitle;
    }

    public void setBookTitle(String bookTitle) {
        this.bookTitle = bookTitle;
    }

    public String getTopicDoctype() {
        return this.topicDoctype;
    }

    public void setTopicDoctype(String topicDoctype) {
        this.topicDoctype = topicDoctype;
    }

    public String getDoctype() {
        return this.doctype;
    }

    public void setDoctype(String doctype) {
        this.doctype = doctype;
    }

    public String getTopicFilenameSuffix() {
        return this.topicFilenameSuffix;
    }

    public void setTopicFilenameSuffix(String topicFilenameSuffix) {
        this.topicFilenameSuffix = topicFilenameSuffix;
    }

    public String getTopicFolder() {
        return this.topicFolder;
    }

    public void setTopicFolder(String topicFolder) {
        this.topicFolder = topicFolder;
    }

    public File getTargetFile() {
        return this.targetFile;
    }

    public void setTargetFile(File targetFile) {
        this.targetFile = targetFile;
    }

    private DitaTopicDocumentBuilder getCurrentTopic() {
        if (this.currentTopic == null) {
            try {
                this.currentTopicFile = this.computeFile(this.latestHeadingId);
                this.currentTopicOut = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(this.currentTopicFile)), "utf-8");
            }
            catch (IOException e1) {
                throw new IllegalStateException(e1);
            }
            String relativeTopic = this.currentTopicFile.getName();
            if (this.topicFolder != null) {
                relativeTopic = String.valueOf(this.topicFolder) + '/' + relativeTopic;
            }
            this.writer.writeEmptyElement("chapter");
            this.writer.writeAttribute("href", relativeTopic);
            this.titleText = "";
            this.mapEntryOpen = true;
            this.currentTopic = new DitaTopicDocumentBuilder(new DefaultXmlStreamWriter(this.currentTopicOut), this.formattingDependencies);
            if (this.topicDoctype != null) {
                this.currentTopic.setDoctype(this.topicDoctype);
            }
            this.currentTopic.setTopicBreakLevel(this.topicBreakLevel);
            this.currentTopic.setOutline(this.outline);
            this.currentTopic.setFilename(this.currentTopicFile.getName());
            this.currentTopic.beginDocument();
        }
        return this.currentTopic;
    }

    private File computeFile(String headingId) {
        String name = DitaTopicDocumentBuilder.computeName(headingId, this.topicFilenameSuffix);
        File folder = this.targetFile.getParentFile();
        if (this.topicFolder != null) {
            folder = new File(folder, this.topicFolder);
        }
        return new File(folder, name);
    }

    public void acronym(String text, String definition) {
        this.getCurrentTopic().acronym(text, definition);
    }

    public void beginBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        this.getCurrentTopic().beginBlock(type, attributes);
    }

    public void beginHeading(int level, Attributes attributes) {
        this.headingLevels.push(level);
        if (level <= this.topicBreakLevel) {
            this.closeCurrentTopic();
            this.latestHeadingId = attributes.getId();
        }
        this.getCurrentTopic().beginHeading(level, attributes);
    }

    public void beginSpan(DocumentBuilder.SpanType type, Attributes attributes) {
        this.getCurrentTopic().beginSpan(type, attributes);
    }

    public void characters(String text) {
        if (this.mapEntryOpen) {
            this.titleText = String.valueOf(this.titleText) + text;
        }
        this.getCurrentTopic().characters(text);
    }

    public void charactersUnescaped(String literal) {
        this.getCurrentTopic().charactersUnescaped(literal);
    }

    public void endBlock() {
        this.getCurrentTopic().endBlock();
    }

    public void beginDocument() {
        this.writer.writeStartDocument();
        this.writer.writeDTD(this.doctype);
        this.writer.writeStartElement("bookmap");
        this.writer.writeStartElement("title");
        if (this.bookTitle != null) {
            this.writer.writeCharacters(this.bookTitle);
        }
        this.writer.writeEndElement();
    }

    public void endDocument() {
        this.closeCurrentTopic();
        this.writer.writeEndElement();
        this.writer.writeEndDocument();
    }

    private void closeCurrentTopic() {
        if (this.currentTopic != null) {
            this.currentTopic.endDocument();
            this.currentTopic = null;
            if (this.currentTopicOut != null) {
                try {
                    this.currentTopicOut.close();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
                this.currentTopicOut = null;
            }
        }
    }

    public void endHeading() {
        int level = this.headingLevels.pop();
        if (level <= this.topicBreakLevel && this.mapEntryOpen) {
            this.mapEntryOpen = false;
            this.writer.writeAttribute("navtitle", this.titleText);
            this.titleText = null;
        }
        this.getCurrentTopic().endHeading();
    }

    public void endSpan() {
        this.getCurrentTopic().endSpan();
    }

    public void entityReference(String entity) {
        this.getCurrentTopic().entityReference(entity);
    }

    public void image(Attributes attributes, String url) {
        this.getCurrentTopic().image(attributes, url);
    }

    public void imageLink(Attributes linkAttributes, Attributes imageAttributes, String href, String imageUrl) {
        this.getCurrentTopic().imageLink(linkAttributes, imageAttributes, href, imageUrl);
    }

    public void lineBreak() {
        this.getCurrentTopic().lineBreak();
    }

    public void link(Attributes attributes, String hrefOrHashName, String text) {
        this.getCurrentTopic().link(attributes, hrefOrHashName, text);
    }

    public void close() throws IOException {
        if (this.currentTopicOut != null) {
            try {
                this.currentTopicOut.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            this.currentTopicOut = null;
        }
    }

    public OutlineItem getOutline() {
        return this.outline;
    }

    public void setOutline(OutlineItem outline) {
        this.outline = outline;
    }

    public int getTopicBreakLevel() {
        return this.topicBreakLevel;
    }

    public void setTopicBreakLevel(int topicBreakLevel) {
        this.topicBreakLevel = topicBreakLevel;
    }

    public boolean isFormattingDependencies() {
        return this.formattingDependencies;
    }

    public void setFormattingDependencies(boolean formattingDependencies) {
        this.formattingDependencies = formattingDependencies;
    }
}

