/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation.tostringgeneration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationMessages;

public class ToStringTemplateParser {
    protected String[] beginning;
    protected String[] body;
    protected String separator;
    protected String[] ending;
    protected Map descriptions;
    public static final String OBJECT_NAME_VARIABLE = "${object.className}";
    public static final String OBJECT_GET_NAME_VARIABLE = "${object.getClassName}";
    public static final String OBJECT_SUPER_TOSTRING_VARIABLE = "${object.superToString}";
    public static final String OBJECT_HASHCODE_VARIABLE = "${object.hashCode}";
    public static final String OBJECT_SYSTEM_HASHCODE_VARIABLE = "${object.identityHashCode}";
    public static final String MEMBER_NAME_VARIABLE = "${member.name}";
    public static final String MEMBER_NAME_PARENTHESIS_VARIABLE = "${member.name()}";
    public static final String MEMBER_VALUE_VARIABLE = "${member.value}";
    private static final String OTHER_MEMBERS_VARIABLE = "${otherMembers}";
    private static final String[] OBJECT_RELAED_VARIABLE = new String[]{"${object.className}", "${object.getClassName}", "${object.superToString}", "${object.hashCode}", "${object.identityHashCode}"};
    private static final String[] MEMBER_RELATED_VARIABLE = new String[]{"${member.name}", "${member.name()}", "${member.value}"};
    private static final String[] OBJECT_AND_MEMBER_RELATED_VARIABLES = new String[]{"${object.className}", "${object.getClassName}", "${object.superToString}", "${object.hashCode}", "${object.identityHashCode}", "${member.name}", "${member.name()}", "${member.value}"};
    public static final String DEFAULT_TEMPLATE = "${object.className} [${member.name()}=${member.value}, ${otherMembers}]";
    private static final String[] VARIABLES = new String[]{"${object.className}", "${object.getClassName}", "${object.superToString}", "${object.hashCode}", "${object.identityHashCode}", "${member.name}", "${member.name()}", "${member.value}", "${otherMembers}"};
    private static final String[] VARIABLE_DESCRIPTIONS = new String[]{CodeGenerationMessages.GenerateToStringOperation_objectClassNameVariableDescription, CodeGenerationMessages.GenerateToStringOperation_objectClassGetNameVariableDescription, CodeGenerationMessages.GenerateToStringOperation_objectSuperToStringVariableDescription, CodeGenerationMessages.GenerateToStringOperation_objectHashCodeVariableDescription, CodeGenerationMessages.GenerateToStringOperation_objectIdentityHashCodeVariableDescription, CodeGenerationMessages.GenerateToStringOperation_memberNameVariableDescription, CodeGenerationMessages.GenerateToStringOperation_memberNameParenthesesVariableDescription, CodeGenerationMessages.GenerateToStringOperation_memberValueVariableDescription, CodeGenerationMessages.GenerateToStringOperation_otherFieldsVariableDescription};

    protected String[] getMemberRelatedVariables() {
        return MEMBER_RELATED_VARIABLE;
    }

    protected String[] getObjectRelatedVariables() {
        return OBJECT_RELAED_VARIABLE;
    }

    protected String[] getObjectAndMemberRelatedVariables() {
        return OBJECT_AND_MEMBER_RELATED_VARIABLES;
    }

    public void parseTemplate(String template) {
        String[] emptyArray = new String[]{};
        int beginningEnd = this.firstOccuranceOf(template, this.getMemberRelatedVariables());
        if (beginningEnd >= 0) {
            this.beginning = this.extractElements(template.substring(0, beginningEnd), this.getObjectRelatedVariables()).toArray(emptyArray);
        } else {
            beginningEnd = 0;
            this.beginning = emptyArray;
        }
        int endingStart = template.indexOf(OTHER_MEMBERS_VARIABLE);
        if (endingStart == -1) {
            endingStart = template.length();
        }
        ArrayList bodyList = this.extractElements(template.substring(beginningEnd, endingStart), this.getObjectAndMemberRelatedVariables());
        try {
            this.separator = (String)bodyList.get(bodyList.size() - 1);
            bodyList.remove(bodyList.size() - 1);
        }
        catch (Exception exception) {
            this.separator = "";
        }
        this.body = bodyList.toArray(emptyArray);
        this.ending = this.extractElements(template.substring(endingStart + OTHER_MEMBERS_VARIABLE.length()), this.getObjectRelatedVariables()).toArray(emptyArray);
    }

    protected int firstOccuranceOf(String template, String[] wantedVariables) {
        int result = -1;
        int i = 0;
        while (i < wantedVariables.length) {
            int indexOf = template.indexOf(wantedVariables[i]);
            if (result == -1 || indexOf > 0 && indexOf < result) {
                result = indexOf;
            }
            ++i;
        }
        return result;
    }

    protected ArrayList extractElements(String template, String[] wantedVariables) {
        ArrayList<String> result = new ArrayList<String>();
        while (template.length() != 0) {
            String foundVariable = null;
            int variablePosition = template.length();
            int i = 0;
            while (i < wantedVariables.length) {
                int position = template.indexOf(wantedVariables[i]);
                if (position >= 0 && position < variablePosition) {
                    variablePosition = position;
                    foundVariable = wantedVariables[i];
                }
                ++i;
            }
            if (variablePosition == template.length()) {
                result.add(template);
                break;
            }
            if (variablePosition != 0) {
                result.add(template.substring(0, variablePosition));
            }
            result.add(foundVariable);
            template = template.substring(variablePosition + foundVariable.length());
        }
        return result;
    }

    public String[] getBeginning() {
        return this.beginning;
    }

    public String[] getBody() {
        return this.body;
    }

    public String[] getEnding() {
        return this.ending;
    }

    public String getSeparator() {
        return this.separator;
    }

    public Map getVariableDescriptions() {
        if (this.descriptions == null) {
            this.descriptions = new HashMap();
            int i = 0;
            while (i < VARIABLES.length) {
                this.descriptions.put(VARIABLES[i], VARIABLE_DESCRIPTIONS[i]);
                ++i;
            }
        }
        return this.descriptions;
    }

    public String[] getVariables() {
        return VARIABLES;
    }
}

