/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.designers.handlers;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ebam.designers.views.ReportView;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecReportHandler
extends AbstractHandler {
    private static Logger logger = LoggerFactory.getLogger(ExecReportHandler.class);
    public static final String BIRT_EXTENSION = ".rptdesign";

    public Object execute(ExecutionEvent arg0) throws ExecutionException {
        logger.debug("IN");
        try {
            IWorkbenchPage iworkbenchpage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (iworkbenchpage.findView("org.eclipse.ebam.designers.views.ReportView") != null) {
                IViewReference ref = iworkbenchpage.findViewReference("org.eclipse.ebam.designers.views.ReportView");
                iworkbenchpage.hideView(ref);
            }
            if (iworkbenchpage.findView("org.eclipse.ebam.designers.views.ReportView") == null) {
                Bundle bundle = Platform.getBundle((String)"org.eclipse.ebam.designers");
                String reportsPath = this.getReportsPath(bundle);
                logger.info("reports folder path is " + reportsPath);
                String tempPath = this.getTempPath(bundle);
                logger.info("temp folder path is " + tempPath);
                if (reportsPath != null) {
                    String[] reports = this.getReports(reportsPath);
                    logger.debug("found reports # " + reports.length);
                    IViewPart part = iworkbenchpage.showView("org.eclipse.ebam.designers.views.ReportView");
                    ReportView reportView = (ReportView)part;
                    reportView.executeReportOnBrowser(reportsPath, reports, tempPath);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.debug("OUT");
        return null;
    }

    protected String getReportsPath(Bundle bundle) {
        logger.debug("IN");
        String eclipsePath = null;
        URL url = bundle.getEntry("/reports");
        String path = null;
        try {
            path = FileLocator.toFileURL((URL)url).getPath();
        }
        catch (IOException iOException) {
            logger.error("error in getting the bundle path, return null");
            return null;
        }
        if (path == null) {
            return null;
        }
        eclipsePath = path.substring(1);
        logger.debug("OUT");
        return eclipsePath;
    }

    protected String getTempPath(Bundle bundle) {
        logger.debug("IN");
        String tempdir = System.getProperty("java.io.tmpdir");
        if (!tempdir.endsWith("/") && !tempdir.endsWith("\\")) {
            tempdir = String.valueOf(tempdir) + System.getProperty("file.separator");
        }
        logger.debug("OUT");
        return tempdir;
    }

    protected String[] getReports(String eclipsePath) {
        File dir = new File(eclipsePath);
        if (!dir.isDirectory()) {
            return new String[0];
        }
        File[] containedFile = dir.listFiles();
        Vector<String> vectors = new Vector<String>();
        int i = 0;
        while (i < containedFile.length) {
            int index;
            File file = containedFile[i];
            String name = file.getName();
            String extension = name.substring(index = name.lastIndexOf(46));
            if (extension.equalsIgnoreCase(BIRT_EXTENSION)) {
                vectors.add(name);
            }
            ++i;
        }
        String[] reports = new String[vectors.size()];
        int i2 = 0;
        Iterator iterator = vectors.iterator();
        while (iterator.hasNext()) {
            String string;
            reports[i2] = string = (String)iterator.next();
            ++i2;
        }
        return reports;
    }
}

