/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.wizards;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.wst.ws.service.policy.IServicePolicy;
import org.eclipse.wst.wsdl.internal.generator.BaseGenerator;
import org.eclipse.wst.wsdl.internal.generator.BindingGenerator;
import org.eclipse.wst.wsdl.ui.internal.Messages;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.asd.ASDEditorCSHelpIds;
import org.eclipse.wst.wsdl.ui.internal.asd.contentgenerator.ui.extension.ContentGeneratorUIExtension;
import org.eclipse.wst.wsdl.ui.internal.asd.contentgenerator.ui.extension.ContentGeneratorUIExtensionRegistry;
import org.eclipse.wst.wsdl.ui.internal.contentgenerator.ui.BaseContentGeneratorOptionsPage;
import org.eclipse.wst.wsdl.ui.internal.contentgenerator.ui.ISoapStyleInfo;
import org.eclipse.wst.wsdl.ui.internal.util.ServicePolicyHelper;
import org.eclipse.wst.wsdl.ui.internal.util.ValidateHelper;
import org.eclipse.wst.wsdl.ui.internal.wizards.ContentGeneratorOptionsPage;
import org.eclipse.wst.wsdl.ui.internal.wizards.NewWSDLWizard;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xml.ui.internal.dialogs.UpdateListener;

public class WSDLNewFileOptionsPage
extends WizardPage
implements ModifyListener,
UpdateListener,
SelectionListener {
    protected WizardNewFileCreationPage newFileCreationPage;
    protected Text targetNamespaceText;
    protected Text prefixText;
    protected boolean updatePortOpFieldBoolean = true;
    protected PageBook protocolPageBook;
    protected Combo protocolCombo;
    protected Link WSIPreferenceLink;
    private BindingGenerator generator;
    private Map pageMap = new HashMap();
    private IServicePolicy activeServicePolicy;
    protected DelayedEvent delayedTask;
    Composite wsdlSkeletonGroup;
    Button createSkeletonCheckBox;

    public WSDLNewFileOptionsPage(String pageName) {
        super(pageName);
    }

    public void setBindingGenerator(BindingGenerator generator) {
        this.generator = generator;
    }

    public WSDLNewFileOptionsPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setDescription(Messages._UI_DESCRIPTION_NEW_WSDL_FILE);
    }

    public WSDLNewFileOptionsPage(String pageName, String title, ImageDescriptor titleImage, WizardNewFileCreationPage newFilePage) {
        super(pageName, title, titleImage);
        this.setDescription(Messages._UI_DESCRIPTION_NEW_WSDL_FILE);
        this.newFileCreationPage = newFilePage;
    }

    public void createControl(Composite parent) {
        ContentGeneratorUIExtension ext;
        Composite base = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)base, Messages._UI_HELP);
        base.setLayout((Layout)new GridLayout());
        Composite wsdlGroup = new Composite(base, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        wsdlGroup.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        wsdlGroup.setLayoutData((Object)data);
        GridData gd = (GridData)wsdlGroup.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        Label targetNamespace = new Label(wsdlGroup, 16384);
        targetNamespace.setText(Messages._UI_LABEL_TARGET_NAMESPACE);
        GridData nsData = new GridData();
        nsData.horizontalAlignment = 4;
        targetNamespace.setLayoutData((Object)nsData);
        this.targetNamespaceText = new Text(wsdlGroup, 2052);
        GridData textData = new GridData();
        textData.horizontalAlignment = 4;
        textData.grabExcessHorizontalSpace = true;
        textData.widthHint = 10;
        this.targetNamespaceText.setLayoutData((Object)textData);
        this.targetNamespaceText.addModifyListener((ModifyListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.targetNamespaceText, ASDEditorCSHelpIds.WSDL_WIZARD_OPTIONS_PAGE_TNS_TEXT);
        Label prefix = new Label(wsdlGroup, 16384);
        prefix.setText(Messages._UI_LABEL_PREFIX_WITH_COLON);
        GridData prefixData = new GridData();
        prefixData.horizontalAlignment = 4;
        prefix.setLayoutData((Object)prefixData);
        this.prefixText = new Text(wsdlGroup, 2052);
        GridData prefixTextData = new GridData();
        prefixTextData.horizontalAlignment = 4;
        prefixTextData.grabExcessHorizontalSpace = true;
        prefixTextData.widthHint = 10;
        this.prefixText.setLayoutData((Object)prefixTextData);
        this.prefixText.addModifyListener((ModifyListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.prefixText, ASDEditorCSHelpIds.WSDL_WIZARD_OPTIONS_PAGE_PREFIX_TEXT);
        this.createSkeletonCheckBox = new Button(base, 32);
        this.createSkeletonCheckBox.setText(Messages._UI_LABEL_CREATE_WSDL_SKELETON);
        this.createSkeletonCheckBox.setSelection(true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.createSkeletonCheckBox, ASDEditorCSHelpIds.WSDL_WIZARD_OPTIONS_PAGE_CREATE_SKELETON_CHECKBOX);
        this.wsdlSkeletonGroup = new Composite(base, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 2;
        this.wsdlSkeletonGroup.setLayout((Layout)layout2);
        GridData data2 = new GridData();
        data2.verticalAlignment = 4;
        data2.horizontalAlignment = 4;
        this.wsdlSkeletonGroup.setLayoutData((Object)data2);
        this.createLabel(this.wsdlSkeletonGroup, Messages._UI_LABEL_BINDING_PROTOCOL);
        this.protocolCombo = new Combo(this.wsdlSkeletonGroup, 8);
        GridData dataC = new GridData();
        dataC.horizontalAlignment = 4;
        dataC.grabExcessHorizontalSpace = true;
        this.protocolCombo.setLayoutData((Object)dataC);
        IProject project = this.getProject();
        this.activeServicePolicy = ServicePolicyHelper.getActivePolicyWithProtocol(project);
        String defaultProtocolNS = ServicePolicyHelper.getDefaultBinding(project, this.activeServicePolicy);
        String defaultProtocolLabel = null;
        ContentGeneratorUIExtensionRegistry registry = WSDLEditorPlugin.getInstance().getContentGeneratorUIExtensionRegistry();
        ContentGeneratorUIExtension extension = registry.getExtensionForNamespace(defaultProtocolNS);
        if (extension != null) {
            defaultProtocolLabel = extension.getLabel();
        }
        Iterator it = registry.getBindingExtensionNames().iterator();
        int defaultIndex = 0;
        boolean defaultFound = false;
        while (it.hasNext()) {
            String label;
            String protocolName = (String)it.next();
            String protocolLabel = null;
            ext = registry.getExtensionForName(protocolName);
            if (ext != null && (label = ext.getLabel()) != null) {
                protocolLabel = label;
                this.protocolCombo.add(protocolLabel);
            }
            if (defaultFound || protocolLabel == null || (defaultFound = protocolLabel.equals(defaultProtocolLabel))) continue;
            ++defaultIndex;
        }
        if (!defaultFound) {
            defaultIndex = 0;
        }
        this.protocolCombo.addModifyListener((ModifyListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.protocolCombo, ASDEditorCSHelpIds.WSDL_WIZARD_OPTIONS_PAGE_PROTOCOL_COMBO);
        this.protocolPageBook = new PageBook(base, 0);
        GridData gdFill = new GridData();
        gdFill.horizontalAlignment = 4;
        gdFill.grabExcessHorizontalSpace = true;
        gdFill.verticalAlignment = 4;
        gdFill.grabExcessVerticalSpace = true;
        this.protocolPageBook.setLayoutData((Object)gdFill);
        if (this.protocolCombo.getItemCount() > 0) {
            String protocol = this.protocolCombo.getItem(defaultIndex);
            ext = registry.getExtensionForLabel(protocol);
            ContentGeneratorOptionsPage page = ext.getBindingContentGeneratorOptionsPage();
            page.init((BaseGenerator)this.generator);
            this.protocolPageBook.showPage((Control)page.getControl());
            this.protocolPageBook.setVisible(true);
            this.protocolCombo.select(defaultIndex);
            this.updatePageBook(protocol);
        }
        this.wsdlSkeletonGroup.setVisible(true);
        this.WSIPreferenceLink = new Link(base, 0);
        this.WSIPreferenceLink.setText("<A>" + Messages._WSI_COMPLIANCE_LINK_TEXT + "</A>");
        this.WSIPreferenceLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WSDLNewFileOptionsPage.this.getNewWSDLWizard().openProjectWSIProperties();
                IProject project = WSDLNewFileOptionsPage.this.getProject();
                WSDLNewFileOptionsPage.this.activeServicePolicy = ServicePolicyHelper.getActivePolicyWithProtocol(project);
                WSDLNewFileOptionsPage.this.setPageComplete(WSDLNewFileOptionsPage.this.validatePage());
            }
        });
        this.WSIPreferenceLink.setLayoutData((Object)new GridData(1032));
        Link preferencesLink = new Link(base, 0);
        preferencesLink.setText("<a>" + Messages._UI_LINK_TEXT_MODIFY_DEFAULT_VALUES_SETTING + "</a>");
        preferencesLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)WSDLNewFileOptionsPage.this.getShell(), (String)"org.eclipse.wst.wsdl.ui.internal.WSDLPreferencePage", (String[])new String[]{"org.eclipse.wst.wsdl.ui.internal.WSDLPreferencePage"}, null);
                if (preferenceDialog != null) {
                    preferenceDialog.open();
                }
            }
        });
        this.createSkeletonCheckBox.addSelectionListener((SelectionListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)base, ASDEditorCSHelpIds.WSDL_WIZARD_OPTIONS_PAGE);
        base.layout();
        this.setControl((Control)base);
    }

    private NewWSDLWizard getNewWSDLWizard() {
        return (NewWSDLWizard)this.getWizard();
    }

    private String computeDefaultDefinitionName() {
        String name = "DefaultName";
        IPath path = this.getNewWSDLWizard().getNewFilePath();
        if (path != null) {
            name = path.removeFileExtension().lastSegment().toString();
        }
        return name;
    }

    private String computeDefaultNamespaceName() {
        IPath path;
        String namespace = WSDLEditorPlugin.getInstance().getPreferenceStore().getString("defaultNamespace");
        if (!namespace.endsWith("/")) {
            namespace = namespace.concat("/");
        }
        if ((path = this.getNewWSDLWizard().getNewFilePath()) != null) {
            namespace = String.valueOf(namespace) + path.removeFileExtension().toString() + "/";
        }
        return namespace;
    }

    private String computeDefaultPrefix() {
        return WSDLEditorPlugin.getInstance().getPreferenceStore().getString("defaultPrefix");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.targetNamespaceText.setText(this.computeDefaultNamespaceName());
            this.prefixText.setText(this.computeDefaultPrefix());
        }
    }

    public String getTargetNamespace() {
        return this.targetNamespaceText.getText();
    }

    public String getPrefix() {
        return this.prefixText.getText().trim();
    }

    public String getDefinitionName() {
        return this.computeDefaultDefinitionName();
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget == this.targetNamespaceText) {
            this.startDelayedEvent(e);
        } else if (e.widget == this.prefixText) {
            this.setPageComplete(this.validatePage());
        } else if (e.widget == this.protocolCombo) {
            String protocol = this.protocolCombo.getText();
            ContentGeneratorUIExtension ext = WSDLEditorPlugin.getInstance().getContentGeneratorUIExtensionRegistry().getExtensionForLabel(protocol);
            this.generator.setContentGenerator(BindingGenerator.getContentGenerator((String)ext.getNamespace()));
            this.updatePageBook(protocol);
            this.setPageComplete(this.validatePage());
        }
    }

    protected void updatePageBook(String protocol) {
        if (protocol != null) {
            ContentGeneratorOptionsPage page = (ContentGeneratorOptionsPage)this.pageMap.get(protocol);
            if (page == null && (page = this.createContentGeneratorOptionsPage(protocol)) != null) {
                page.init((BaseGenerator)this.generator);
                page.createControl((Composite)this.protocolPageBook);
                this.pageMap.put(protocol, page);
                if (page instanceof BaseContentGeneratorOptionsPage) {
                    ((BaseContentGeneratorOptionsPage)page).setWizardPage(this);
                }
            }
            if (page != null) {
                this.protocolPageBook.showPage((Control)page.getControl());
                this.protocolPageBook.layout();
                this.protocolPageBook.getParent().layout();
                Point size = this.protocolPageBook.getShell().getSize();
                Point minSize = this.protocolPageBook.getShell().computeSize(-1, -1, true);
                int newX = Math.max(size.x, minSize.x);
                int newY = Math.max(size.y, minSize.y);
                this.protocolPageBook.getShell().setSize(newX, newY);
                page.setOptionsOnGenerator();
            }
        }
    }

    public ContentGeneratorOptionsPage createContentGeneratorOptionsPage(String protocol) {
        ContentGeneratorOptionsPage optionsPage = null;
        ContentGeneratorUIExtension extension = WSDLEditorPlugin.getInstance().getContentGeneratorUIExtensionRegistry().getExtensionForLabel(protocol);
        if (extension != null) {
            optionsPage = extension.getBindingContentGeneratorOptionsPage();
        }
        return optionsPage;
    }

    public void updateOccured(Object arg1, Object arg2) {
        this.setPageComplete(this.validatePage());
    }

    public boolean validatePage() {
        boolean ready = true;
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.targetNamespaceText.getText().trim().equals("")) {
            if (ready) {
                this.setErrorMessage(null);
            }
            return false;
        }
        if (!this.validateTargetNamespace(this.targetNamespaceText.getText())) {
            ready = false;
        }
        if (this.createSkeletonCheckBox.getSelection()) {
            if (!this.displayDialogMessages()) {
                ready = false;
            }
        } else {
            this.setMessage(Messages._UI_DESCRIPTION_NEW_WSDL_FILE, 0);
        }
        return ready;
    }

    protected boolean displayDialogMessages() {
        String protocol = this.getProtocol();
        if (!(this.pageMap.get(protocol) instanceof ContentGeneratorOptionsPage)) {
            return false;
        }
        if (!this.validateProtocol(protocol)) {
            return this.getMessageType() != 3;
        }
        ContentGeneratorOptionsPage optionsPage = (ContentGeneratorOptionsPage)this.pageMap.get(protocol);
        IFile targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile(this.newFileCreationPage.getContainerFullPath().append(this.newFileCreationPage.getFileName()));
        if (optionsPage instanceof BaseContentGeneratorOptionsPage) {
            ((BaseContentGeneratorOptionsPage)optionsPage).setTargetIFile(targetFile);
            String message = ((IMessageProvider)optionsPage).getMessage();
            int messageType = ((IMessageProvider)optionsPage).getMessageType();
            if (messageType == 0) {
                this.setMessage(Messages._UI_DESCRIPTION_NEW_WSDL_FILE, 0);
            } else {
                this.setMessage(message, messageType);
            }
            if (messageType == 3) {
                return false;
            }
        }
        return true;
    }

    protected boolean validatePrefix(String prefix) {
        String errorMessage = ValidateHelper.checkXMLPrefix(prefix);
        return errorMessage == null || errorMessage.length() == 0;
    }

    private boolean validateProtocol(String protocol) {
        String namespace;
        ContentGeneratorUIExtensionRegistry registry = WSDLEditorPlugin.getInstance().getContentGeneratorUIExtensionRegistry();
        ContentGeneratorUIExtension extension = registry.getExtensionForLabel(protocol);
        if (extension != null && (namespace = extension.getNamespace()) != null) {
            String defaultBinding;
            IProject project = this.getProject();
            if (this.activeServicePolicy != null && !(defaultBinding = ServicePolicyHelper.getDefaultBinding(project, this.activeServicePolicy)).equals(namespace)) {
                int messageType = ServicePolicyHelper.getMessageSeverity(project, this.activeServicePolicy);
                if (messageType == 3) {
                    ContentGeneratorUIExtension ext = registry.getExtensionForNamespace(defaultBinding);
                    if (ext != null) {
                        String n = ext.getLabel();
                        this.setMessage(NLS.bind((String)Messages._ERROR_WSI_COMPLIANCE_PROTOCOL, (Object[])new String[]{n}), 3);
                    }
                    return false;
                }
                if (messageType == 2) {
                    ContentGeneratorUIExtension ext = registry.getExtensionForNamespace(defaultBinding);
                    if (ext != null) {
                        String n = ext.getLabel();
                        this.setMessage(NLS.bind((String)Messages._WARN_WSI_COMPLIANCE_PROTOCOL, (Object[])new String[]{n}), 2);
                    }
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean validateXMLName(String xmlName) {
        String errorMessage = ValidateHelper.checkXMLName(xmlName);
        if (errorMessage == null || errorMessage.length() == 0) {
            return true;
        }
        this.setErrorMessage(errorMessage);
        return false;
    }

    protected boolean validateTargetNamespace(String ns) {
        boolean test = true;
        try {
            new URI(ns);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.setErrorMessage(Messages._UI_ERROR_NAMESPACE_INVALID);
            test = false;
        }
        return test;
    }

    protected void startDelayedEvent(ModifyEvent e) {
        if (this.delayedTask == null || this.delayedTask.getEvent() == null) {
            this.delayedTask = new DelayedEvent();
            this.delayedTask.setEvent(e);
            Display.getDefault().timerExec(500, (Runnable)this.delayedTask);
        } else {
            ModifyEvent delayedEvent = this.delayedTask.getEvent();
            if (e.widget == delayedEvent.widget) {
                this.delayedTask.setEvent(null);
            }
            this.delayedTask = new DelayedEvent();
            this.delayedTask.setEvent(e);
            Display.getDefault().timerExec(500, (Runnable)this.delayedTask);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.createSkeletonCheckBox) {
            if (this.createSkeletonCheckBox.getSelection()) {
                this.wsdlSkeletonGroup.setVisible(true);
                this.protocolPageBook.setVisible(true);
            } else {
                this.wsdlSkeletonGroup.setVisible(false);
                this.protocolPageBook.setVisible(false);
            }
            this.setPageComplete(this.validatePage());
        }
    }

    private Label createLabel(Composite comp, String labelString) {
        Label label = new Label(comp, 16384);
        label.setText(labelString);
        GridData nsData = new GridData();
        nsData.horizontalAlignment = 4;
        label.setLayoutData((Object)nsData);
        return label;
    }

    public Vector getNamespaceInfo() {
        Vector<NamespaceInfo> namespaces = new Vector<NamespaceInfo>();
        NamespaceInfo info1 = new NamespaceInfo();
        info1.prefix = "wsdl";
        info1.uri = "http://schemas.xmlsoap.org/wsdl/";
        namespaces.addElement(info1);
        NamespaceInfo info8 = new NamespaceInfo();
        info8.prefix = "xsd";
        info8.uri = "http://www.w3.org/2001/XMLSchema";
        namespaces.addElement(info8);
        return namespaces;
    }

    public boolean getCreateSkeletonBoolean() {
        return this.createSkeletonCheckBox.getSelection();
    }

    public String getProtocol() {
        return this.protocolCombo.getText();
    }

    public boolean isSoapDocLiteralProtocol() {
        ContentGeneratorOptionsPage optionsPage = (ContentGeneratorOptionsPage)this.pageMap.get(this.getProtocol());
        if (optionsPage instanceof ISoapStyleInfo) {
            return ((ISoapStyleInfo)((Object)optionsPage)).isDocumentLiteralPattern();
        }
        return false;
    }

    public IProject getProject() {
        IPath path = this.newFileCreationPage.getContainerFullPath();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = null;
        if (path != null) {
            project = workspace.validatePath(path.toString(), 4).isOK() ? workspace.getRoot().getProject(path.toString()) : workspace.getRoot().getFile(path).getProject();
        }
        return project;
    }

    public IServicePolicy getServicePolicy() {
        return this.activeServicePolicy;
    }

    class DelayedEvent
    implements Runnable {
        protected ModifyEvent event;

        DelayedEvent() {
        }

        public void run() {
            if (this.event != null) {
                WSDLNewFileOptionsPage.this.setPageComplete(WSDLNewFileOptionsPage.this.validatePage());
                this.event = null;
            }
        }

        public ModifyEvent getEvent() {
            return this.event;
        }

        public void setEvent(ModifyEvent event) {
            this.event = event;
        }
    }
}

