/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.Arrays;
import org.eclipse.jpt.utility.internal.model.value.ValueAspectAdapter;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValuePropertyAdapter<V extends Model>
extends ValueAspectAdapter<V> {
    protected final String[] propertyNames;
    protected final PropertyChangeListener valuePropertyListener;

    public ValuePropertyAdapter(WritablePropertyValueModel<V> valueHolder, String ... propertyNames) {
        super(valueHolder);
        this.propertyNames = propertyNames;
        this.valuePropertyListener = this.buildValuePropertyListener();
    }

    protected PropertyChangeListener buildValuePropertyListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                ValuePropertyAdapter.this.propertyChanged(event);
            }

            public String toString() {
                return "value property listener: " + Arrays.asList(ValuePropertyAdapter.this.propertyNames);
            }
        };
    }

    @Override
    protected void engageValue_() {
        String[] stringArray = this.propertyNames;
        int n = this.propertyNames.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName = stringArray[n2];
            ((Model)this.value).addPropertyChangeListener(propertyName, this.valuePropertyListener);
            ++n2;
        }
    }

    @Override
    protected void disengageValue_() {
        String[] stringArray = this.propertyNames;
        int n = this.propertyNames.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName = stringArray[n2];
            ((Model)this.value).removePropertyChangeListener(propertyName, this.valuePropertyListener);
            ++n2;
        }
    }

    protected void propertyChanged(PropertyChangeEvent event) {
        this.valueAspectChanged();
    }
}

