/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jpt.utility.internal.model.value.AspectCollectionValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.StaticPropertyValueModel;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionAspectAdapter<S extends Model, E>
extends AspectCollectionValueModelAdapter<S, E> {
    protected final String[] collectionNames;
    protected static final String[] EMPTY_COLLECTION_NAMES = new String[0];
    protected final CollectionChangeListener collectionChangeListener;

    protected CollectionAspectAdapter(String collectionName, S subject) {
        this(new String[]{collectionName}, subject);
    }

    protected CollectionAspectAdapter(String[] collectionNames, S subject) {
        this(new StaticPropertyValueModel<S>(subject), collectionNames);
    }

    protected CollectionAspectAdapter(PropertyValueModel<? extends S> subjectHolder, String ... collectionNames) {
        super(subjectHolder);
        this.collectionNames = collectionNames;
        this.collectionChangeListener = this.buildCollectionChangeListener();
    }

    protected CollectionAspectAdapter(PropertyValueModel<? extends S> subjectHolder, Collection<String> collectionNames) {
        this(subjectHolder, collectionNames.toArray(new String[collectionNames.size()]));
    }

    protected CollectionAspectAdapter(PropertyValueModel<? extends S> subjectHolder) {
        this(subjectHolder, EMPTY_COLLECTION_NAMES);
    }

    protected CollectionChangeListener buildCollectionChangeListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionAddEvent event) {
                CollectionAspectAdapter.this.itemsAdded(event);
            }

            public void itemsRemoved(CollectionRemoveEvent event) {
                CollectionAspectAdapter.this.itemsRemoved(event);
            }

            public void collectionCleared(CollectionClearEvent event) {
                CollectionAspectAdapter.this.collectionCleared(event);
            }

            public void collectionChanged(CollectionChangeEvent event) {
                CollectionAspectAdapter.this.collectionChanged(event);
            }

            public String toString() {
                return "collection change listener: " + Arrays.asList(CollectionAspectAdapter.this.collectionNames);
            }
        };
    }

    @Override
    protected void engageSubject_() {
        String[] stringArray = this.collectionNames;
        int n = this.collectionNames.length;
        int n2 = 0;
        while (n2 < n) {
            String collectionName = stringArray[n2];
            ((Model)this.subject).addCollectionChangeListener(collectionName, this.collectionChangeListener);
            ++n2;
        }
    }

    @Override
    protected void disengageSubject_() {
        String[] stringArray = this.collectionNames;
        int n = this.collectionNames.length;
        int n2 = 0;
        while (n2 < n) {
            String collectionName = stringArray[n2];
            ((Model)this.subject).removeCollectionChangeListener(collectionName, this.collectionChangeListener);
            ++n2;
        }
    }

    protected void itemsAdded(CollectionAddEvent event) {
        this.fireItemsAdded(event.clone(this, "values"));
    }

    protected void itemsRemoved(CollectionRemoveEvent event) {
        this.fireItemsRemoved(event.clone(this, "values"));
    }

    protected void collectionCleared(CollectionClearEvent event) {
        this.fireCollectionCleared(event.clone(this, "values"));
    }

    protected void collectionChanged(CollectionChangeEvent event) {
        this.fireCollectionChanged(event.clone(this, "values"));
    }
}

