/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.eclipse.jpt.utility.internal.ClassName;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterables.ArrayIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionTools {
    public static final Class<?>[] ZERO_PARAMETER_TYPES = new Class[0];
    public static final Object[] ZERO_ARGUMENTS = new Object[0];
    private static final String CR = StringTools.CR;
    public static final Class<?> VOID_CLASS = Void.TYPE;
    public static final Class<Void> VOID_WRAPPER_CLASS = Void.class;
    static final Iterable<Primitive> PRIMITIVES = ReflectionTools.buildPrimitives();
    public static final char BYTE_CODE = 'B';
    public static final char CHAR_CODE = 'C';
    public static final char DOUBLE_CODE = 'D';
    public static final char FLOAT_CODE = 'F';
    public static final char INT_CODE = 'I';
    public static final char LONG_CODE = 'J';
    public static final char SHORT_CODE = 'S';
    public static final char BOOLEAN_CODE = 'Z';
    public static final char VOID_CODE = 'V';
    static final int MAX_PRIMITIVE_CLASS_NAME_LENGTH = ReflectionTools.calculateMaxPrimitiveClassNameLength();
    static final int MAX_PRIMITIVE_WRAPPER_CLASS_NAME_LENGTH = ReflectionTools.calculateMaxPrimitiveWrapperClassNameLength();

    public static Object getFieldValue(Object object, String fieldName) {
        try {
            return ReflectionTools.getFieldValue_(object, fieldName);
        }
        catch (NoSuchFieldException ex) {
            throw new RuntimeException(ex + CR + ReflectionTools.buildFullyQualifiedFieldName(object, fieldName), ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex + CR + ReflectionTools.buildFullyQualifiedFieldName(object, fieldName), ex);
        }
    }

    public static Object getFieldValue_(Object object, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        return ReflectionTools.getField_(object, fieldName).get(object);
    }

    public static Object getStaticFieldValue(Class<?> javaClass, String fieldName) {
        try {
            return ReflectionTools.getStaticFieldValue_(javaClass, fieldName);
        }
        catch (NoSuchFieldException ex) {
            throw new RuntimeException(ex + CR + ReflectionTools.buildFullyQualifiedFieldName(javaClass, fieldName), ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex + CR + ReflectionTools.buildFullyQualifiedFieldName(javaClass, fieldName), ex);
        }
    }

    public static Object getStaticFieldValue_(Class<?> javaClass, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        return ReflectionTools.getField_(javaClass, fieldName).get(null);
    }

    public static void setFieldValue(Object object, String fieldName, Object value) {
        try {
            ReflectionTools.setFieldValue_(object, fieldName, value);
        }
        catch (NoSuchFieldException ex) {
            throw new RuntimeException(ex + CR + ReflectionTools.buildFullyQualifiedFieldName(object, fieldName), ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex + CR + ReflectionTools.buildFullyQualifiedFieldName(object, fieldName), ex);
        }
    }

    public static void setFieldValue_(Object object, String fieldName, Object value) throws NoSuchFieldException, IllegalAccessException {
        ReflectionTools.getField_(object, fieldName).set(object, value);
    }

    public static void setStaticFieldValue(Class<?> javaClass, String fieldName, Object value) {
        try {
            ReflectionTools.setStaticFieldValue_(javaClass, fieldName, value);
        }
        catch (NoSuchFieldException ex) {
            throw new RuntimeException(ex + CR + ReflectionTools.buildFullyQualifiedFieldName(javaClass, fieldName), ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex + CR + ReflectionTools.buildFullyQualifiedFieldName(javaClass, fieldName), ex);
        }
    }

    public static void setStaticFieldValue_(Class<?> javaClass, String fieldName, Object value) throws NoSuchFieldException, IllegalAccessException {
        ReflectionTools.getField_(javaClass, fieldName).set(null, value);
    }

    public static Field getField(Object object, String fieldName) {
        try {
            return ReflectionTools.getField_(object, fieldName);
        }
        catch (NoSuchFieldException ex) {
            throw new RuntimeException(ex + CR + ReflectionTools.buildFullyQualifiedFieldName(object, fieldName), ex);
        }
    }

    public static Field getField_(Object object, String fieldName) throws NoSuchFieldException {
        return ReflectionTools.getField_(object.getClass(), fieldName);
    }

    public static Field getField(Class<?> javaClass, String fieldName) {
        try {
            return ReflectionTools.getField_(javaClass, fieldName);
        }
        catch (NoSuchFieldException ex) {
            throw new RuntimeException(ex + CR + ReflectionTools.buildFullyQualifiedFieldName(javaClass, fieldName), ex);
        }
    }

    public static Field getField_(Class<?> javaClass, String fieldName) throws NoSuchFieldException {
        Field field = null;
        try {
            field = javaClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException ex) {
            Class<?> superclass = javaClass.getSuperclass();
            if (superclass == null) {
                throw ex;
            }
            return ReflectionTools.getField_(superclass, fieldName);
        }
        field.setAccessible(true);
        return field;
    }

    public static Iterable<Field> getAllFields(Class<?> javaClass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Class<?> tempClass = javaClass;
        while (tempClass != null) {
            ReflectionTools.addDeclaredFieldsTo(tempClass, fields);
            tempClass = tempClass.getSuperclass();
        }
        return fields;
    }

    private static void addDeclaredFieldsTo(Class<?> javaClass, ArrayList<Field> fields) {
        for (Field field : ReflectionTools.getDeclaredFields(javaClass)) {
            fields.add(field);
        }
    }

    public static Iterable<Field> getDeclaredFields(Class<?> javaClass) {
        Field[] fields;
        Field[] fieldArray = fields = javaClass.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            field.setAccessible(true);
            ++n2;
        }
        return new ArrayIterable<Field>(fields);
    }

    public static Object executeMethod(Object receiver, String methodName) {
        return ReflectionTools.executeMethod(receiver, methodName, ZERO_PARAMETER_TYPES, ZERO_ARGUMENTS);
    }

    public static Object executeMethod(Object receiver, String methodName, Class<?> parameterType, Object argument) {
        return ReflectionTools.executeMethod(receiver, methodName, new Class[]{parameterType}, new Object[]{argument});
    }

    public static Object executeMethod(Object receiver, String methodName, Class<?>[] parameterTypes, Object[] arguments) {
        return ReflectionTools.executeMethod(ReflectionTools.getMethod(receiver, methodName, parameterTypes), receiver, arguments);
    }

    public static Object executeMethod(Method method, Object receiver, Object[] arguments) {
        try {
            return method.invoke(receiver, arguments);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex + CR + method, ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(method + CR + ex.getTargetException(), ex);
        }
    }

    public static Object executeMethod_(Object receiver, String methodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return ReflectionTools.executeMethod_(receiver, methodName, ZERO_PARAMETER_TYPES, ZERO_ARGUMENTS);
    }

    public static Object executeMethod_(Object receiver, String methodName, Class<?> parameterType, Object argument) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return ReflectionTools.executeMethod_(receiver, methodName, new Class[]{parameterType}, new Object[]{argument});
    }

    public static Object executeMethod_(Object receiver, String methodName, Class<?>[] parameterTypes, Object[] arguments) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return ReflectionTools.getMethod_(receiver, methodName, parameterTypes).invoke(receiver, arguments);
    }

    public static Object executeStaticMethod(Class<?> javaClass, String methodName) {
        return ReflectionTools.executeStaticMethod(javaClass, methodName, ZERO_PARAMETER_TYPES, ZERO_ARGUMENTS);
    }

    public static Object executeStaticMethod(Class<?> javaClass, String methodName, Class<?> parameterType, Object argument) {
        return ReflectionTools.executeStaticMethod(javaClass, methodName, new Class[]{parameterType}, new Object[]{argument});
    }

    public static Object executeStaticMethod(Class<?> javaClass, String methodName, Class<?>[] parameterTypes, Object[] arguments) {
        try {
            return ReflectionTools.executeStaticMethod_(javaClass, methodName, parameterTypes, arguments);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex + CR + ReflectionTools.buildFullyQualifiedMethodSignature(javaClass, methodName, parameterTypes), ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex + CR + ReflectionTools.buildFullyQualifiedMethodSignature(javaClass, methodName, parameterTypes), ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(String.valueOf(ReflectionTools.buildFullyQualifiedMethodSignature(javaClass, methodName, parameterTypes)) + CR + ex.getTargetException(), ex);
        }
    }

    public static Object executeStaticMethod_(Class<?> javaClass, String methodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return ReflectionTools.executeStaticMethod_(javaClass, methodName, ZERO_PARAMETER_TYPES, ZERO_ARGUMENTS);
    }

    public static Object executeStaticMethod_(Class<?> javaClass, String methodName, Class<?> parameterType, Object argument) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return ReflectionTools.executeStaticMethod_(javaClass, methodName, new Class[]{parameterType}, new Object[]{argument});
    }

    public static Object executeStaticMethod_(Class<?> javaClass, String methodName, Class<?>[] parameterTypes, Object[] arguments) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return ReflectionTools.getStaticMethod_(javaClass, methodName, parameterTypes).invoke(null, arguments);
    }

    public static Method getMethod(Class<?> javaClass, String methodName) {
        return ReflectionTools.getMethod(javaClass, methodName, ZERO_PARAMETER_TYPES);
    }

    public static Method getMethod_(Class<?> javaClass, String methodName) throws NoSuchMethodException {
        return ReflectionTools.getMethod_(javaClass, methodName, ZERO_PARAMETER_TYPES);
    }

    public static Method getMethod(Class<?> javaClass, String methodName, Class<?> parameterType) {
        return ReflectionTools.getMethod(javaClass, methodName, new Class[]{parameterType});
    }

    public static Method getMethod_(Class<?> javaClass, String methodName, Class<?> parameterType) throws NoSuchMethodException {
        return ReflectionTools.getMethod_(javaClass, methodName, new Class[]{parameterType});
    }

    public static Method getMethod(Class<?> javaClass, String methodName, Class<?>[] parameterTypes) {
        try {
            return ReflectionTools.getMethod_(javaClass, methodName, parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex + CR + ReflectionTools.buildFullyQualifiedMethodSignature(javaClass, methodName, parameterTypes), ex);
        }
    }

    public static Method getMethod_(Class<?> javaClass, String methodName, Class<?>[] parameterTypes) throws NoSuchMethodException {
        Method method = null;
        try {
            method = javaClass.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            Class<?> superclass = javaClass.getSuperclass();
            if (superclass == null) {
                throw ex;
            }
            return ReflectionTools.getMethod_(superclass, methodName, parameterTypes);
        }
        method.setAccessible(true);
        return method;
    }

    public static Method getMethod(Object object, String methodName) {
        return ReflectionTools.getMethod(object.getClass(), methodName);
    }

    public static Method getMethod_(Object object, String methodName) throws NoSuchMethodException {
        return ReflectionTools.getMethod_(object.getClass(), methodName);
    }

    public static Method getMethod(Object object, String methodName, Class<?>[] parameterTypes) {
        return ReflectionTools.getMethod(object.getClass(), methodName, parameterTypes);
    }

    public static Method getMethod_(Object object, String methodName, Class<?>[] parameterTypes) throws NoSuchMethodException {
        return ReflectionTools.getMethod_(object.getClass(), methodName, parameterTypes);
    }

    public static Method getMethod(Object object, String methodName, Class<?> parameterType) {
        return ReflectionTools.getMethod(object.getClass(), methodName, parameterType);
    }

    public static Method getMethod_(Object object, String methodName, Class<?> parameterType) throws NoSuchMethodException {
        return ReflectionTools.getMethod_(object.getClass(), methodName, parameterType);
    }

    public static Method getStaticMethod(Class<?> javaClass, String methodName) {
        return ReflectionTools.getStaticMethod(javaClass, methodName, ZERO_PARAMETER_TYPES);
    }

    public static Method getStaticMethod(Class<?> javaClass, String methodName, Class<?> parameterTypes) {
        return ReflectionTools.getStaticMethod(javaClass, methodName, new Class[]{parameterTypes});
    }

    public static Method getStaticMethod(Class<?> javaClass, String methodName, Class<?>[] parameterTypes) {
        try {
            return ReflectionTools.getStaticMethod_(javaClass, methodName, parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex + CR + ReflectionTools.buildFullyQualifiedMethodSignature(javaClass, methodName, parameterTypes), ex);
        }
    }

    public static Method getStaticMethod_(Class<?> javaClass, String methodName) throws NoSuchMethodException {
        return ReflectionTools.getStaticMethod_(javaClass, methodName, ZERO_PARAMETER_TYPES);
    }

    public static Method getStaticMethod_(Class<?> javaClass, String methodName, Class<?> parameterTypes) throws NoSuchMethodException {
        return ReflectionTools.getStaticMethod_(javaClass, methodName, new Class[]{parameterTypes});
    }

    public static Method getStaticMethod_(Class<?> javaClass, String methodName, Class<?>[] parameterTypes) throws NoSuchMethodException {
        Method method = ReflectionTools.getMethod_(javaClass, methodName, parameterTypes);
        if (Modifier.isStatic(method.getModifiers())) {
            return method;
        }
        throw new NoSuchMethodException(ReflectionTools.buildFullyQualifiedMethodSignature(javaClass, methodName, parameterTypes));
    }

    public static Iterable<Method> getAllMethods(Class<?> javaClass) {
        ArrayList<Method> methods = new ArrayList<Method>();
        Class<?> tempClass = javaClass;
        while (tempClass != null) {
            ReflectionTools.addDeclaredMethodsTo(tempClass, methods);
            tempClass = tempClass.getSuperclass();
        }
        return methods;
    }

    private static void addDeclaredMethodsTo(Class<?> javaClass, ArrayList<Method> methods) {
        for (Method method : ReflectionTools.getDeclaredMethods(javaClass)) {
            methods.add(method);
        }
    }

    public static Iterable<Method> getDeclaredMethods(Class<?> javaClass) {
        Method[] methods;
        Method[] methodArray = methods = javaClass.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            method.setAccessible(true);
            ++n2;
        }
        return new ArrayIterable<Method>(methods);
    }

    public static <T> Constructor<T> getDefaultConstructor(Class<T> javaClass) {
        return ReflectionTools.getConstructor(javaClass);
    }

    public static <T> Constructor<T> getConstructor(Class<T> javaClass) {
        return ReflectionTools.getConstructor(javaClass, ZERO_PARAMETER_TYPES);
    }

    public static <T> Constructor<T> getConstructor(Class<T> javaClass, Class<?> parameterType) {
        return ReflectionTools.getConstructor(javaClass, new Class[]{parameterType});
    }

    public static <T> Constructor<T> getConstructor(Class<T> javaClass, Class<?>[] parameterTypes) {
        try {
            return ReflectionTools.getConstructor_(javaClass, parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex + CR + ReflectionTools.buildFullyQualifiedConstructorSignature(javaClass, parameterTypes), ex);
        }
    }

    public static <T> Constructor<T> getDefaultConstructor_(Class<T> javaClass) throws NoSuchMethodException {
        return ReflectionTools.getConstructor_(javaClass);
    }

    public static <T> Constructor<T> getConstructor_(Class<T> javaClass) throws NoSuchMethodException {
        return ReflectionTools.getConstructor_(javaClass, ZERO_PARAMETER_TYPES);
    }

    public static <T> Constructor<T> getConstructor_(Class<T> javaClass, Class<?> parameterType) throws NoSuchMethodException {
        return ReflectionTools.getConstructor_(javaClass, new Class[]{parameterType});
    }

    public static <T> Constructor<T> getConstructor_(Class<T> javaClass, Class<?>[] parameterTypes) throws NoSuchMethodException {
        Constructor<T> constructor = javaClass.getDeclaredConstructor(parameterTypes);
        constructor.setAccessible(true);
        return constructor;
    }

    public static <T> Iterable<Constructor<T>> getDeclaredConstructors(Class<T> javaClass) {
        Constructor<?>[] constructors;
        Constructor<?>[] constructorArray = constructors = javaClass.getDeclaredConstructors();
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> constructor = constructorArray[n2];
            constructor.setAccessible(true);
            ++n2;
        }
        return new ArrayIterable<Constructor<T>>(constructors);
    }

    public static Class<?> classForName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(className, ex);
        }
    }

    public static Class<?> classForName(String className, boolean initialize, ClassLoader classLoader) {
        try {
            return Class.forName(className, initialize, classLoader);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(className, ex);
        }
    }

    public static int getArrayDepth(Class<?> javaClass) {
        int depth = 0;
        while (javaClass.isArray()) {
            ++depth;
            javaClass = javaClass.getComponentType();
        }
        return depth;
    }

    public static Class<?> getElementType(Class<?> javaClass) {
        while (javaClass.isArray()) {
            javaClass = javaClass.getComponentType();
        }
        return javaClass;
    }

    public static Class<?> getWrapperClass(Class<?> primitiveClass) {
        for (Primitive primitive : PRIMITIVES) {
            if (primitive.javaClass != primitiveClass) continue;
            return primitive.wrapperClass;
        }
        return null;
    }

    public static boolean classIsPrimitiveWrapper(Class<?> javaClass) {
        if (javaClass.isArray() || javaClass.getName().length() > MAX_PRIMITIVE_WRAPPER_CLASS_NAME_LENGTH) {
            return false;
        }
        for (Primitive primitive : PRIMITIVES) {
            if (javaClass != primitive.wrapperClass) continue;
            return true;
        }
        return false;
    }

    public static boolean classIsVariablePrimitiveWrapper(Class<?> javaClass) {
        return ReflectionTools.classIsPrimitiveWrapper(javaClass) && javaClass != VOID_WRAPPER_CLASS;
    }

    public static boolean classIsVariablePrimitive(Class<?> javaClass) {
        return javaClass.isPrimitive() && javaClass != VOID_CLASS;
    }

    public static Class<?> getClassForCode(int classCode) {
        return ReflectionTools.getClassForCode((char)classCode);
    }

    public static Class<?> getClassForCode(char classCode) {
        for (Primitive primitive : PRIMITIVES) {
            if (primitive.code != classCode) continue;
            return primitive.javaClass;
        }
        return null;
    }

    public static char getCodeForClass(Class<?> primitiveClass) {
        if (!primitiveClass.isArray() && primitiveClass.getName().length() <= MAX_PRIMITIVE_CLASS_NAME_LENGTH) {
            for (Primitive primitive : PRIMITIVES) {
                if (primitive.javaClass != primitiveClass) continue;
                return primitive.code;
            }
        }
        return '\u0000';
    }

    public static Object newInstance(String className) {
        return ReflectionTools.newInstance(className, null);
    }

    public static Object newInstance(String className, Class<?> parameterType, Object argument) {
        return ReflectionTools.newInstance(className, parameterType, argument, null);
    }

    public static Object newInstance(String className, Class<?>[] parameterTypes, Object[] arguments) {
        return ReflectionTools.newInstance(className, parameterTypes, arguments, null);
    }

    public static Object newInstance(String className, ClassLoader classLoader) {
        return ReflectionTools.newInstance(ReflectionTools.classForName(className, false, classLoader));
    }

    public static Object newInstance(String className, Class<?> parameterType, Object argument, ClassLoader classLoader) {
        return ReflectionTools.newInstance(ReflectionTools.classForName(className, false, classLoader), parameterType, argument);
    }

    public static Object newInstance(String className, Class<?>[] parameterTypes, Object[] arguments, ClassLoader classLoader) {
        return ReflectionTools.newInstance(ReflectionTools.classForName(className, false, classLoader), parameterTypes, arguments);
    }

    public static <T> T newInstance(Class<T> javaClass) {
        return ReflectionTools.newInstance(javaClass, ZERO_PARAMETER_TYPES, ZERO_ARGUMENTS);
    }

    public static <T> T newInstance(Class<T> javaClass, Class<?> parameterType, Object argument) {
        return ReflectionTools.newInstance(javaClass, new Class[]{parameterType}, new Object[]{argument});
    }

    public static <T> T newInstance(Class<T> javaClass, Class<?>[] parameterTypes, Object[] arguments) {
        try {
            return ReflectionTools.newInstance_(javaClass, parameterTypes, arguments);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex + CR + ReflectionTools.buildFullyQualifiedConstructorSignature(javaClass, parameterTypes), ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex + CR + ReflectionTools.buildFullyQualifiedConstructorSignature(javaClass, parameterTypes), ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(String.valueOf(ReflectionTools.buildFullyQualifiedConstructorSignature(javaClass, parameterTypes)) + CR + ex.getTargetException(), ex);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex + CR + ReflectionTools.buildFullyQualifiedConstructorSignature(javaClass, parameterTypes), ex);
        }
    }

    public static <T> T newInstance_(Class<T> javaClass) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return ReflectionTools.newInstance_(javaClass, ZERO_PARAMETER_TYPES, ZERO_ARGUMENTS);
    }

    public static <T> T newInstance_(Class<T> javaClass, Class<?> parameterType, Object argument) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return ReflectionTools.newInstance_(javaClass, new Class[]{parameterType}, new Object[]{argument});
    }

    public static <T> T newInstance_(Class<T> javaClass, Class<?>[] parameterTypes, Object[] arguments) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return ReflectionTools.getConstructor_(javaClass, parameterTypes).newInstance(arguments);
    }

    public static Class<?> getClassForTypeDeclaration(String typeDeclaration) {
        return ReflectionTools.getClassForTypeDeclaration(typeDeclaration, null);
    }

    public static Class<?> getClassForTypeDeclaration_(String typeDeclaration) throws ClassNotFoundException {
        return ReflectionTools.getClassForTypeDeclaration_(typeDeclaration, null);
    }

    public static Class<?> getClassForTypeDeclaration(String typeDeclaration, ClassLoader classLoader) {
        TypeDeclaration td = ReflectionTools.buildTypeDeclaration(typeDeclaration);
        return ReflectionTools.getClassForTypeDeclaration(td.elementTypeName, td.arrayDepth, classLoader);
    }

    public static Class<?> getClassForTypeDeclaration_(String typeDeclaration, ClassLoader classLoader) throws ClassNotFoundException {
        TypeDeclaration td = ReflectionTools.buildTypeDeclaration(typeDeclaration);
        return ReflectionTools.getClassForTypeDeclaration_(td.elementTypeName, td.arrayDepth, classLoader);
    }

    private static TypeDeclaration buildTypeDeclaration(String typeDeclaration) {
        typeDeclaration = StringTools.removeAllWhitespace(typeDeclaration);
        int arrayDepth = ReflectionTools.getArrayDepthForTypeDeclaration_(typeDeclaration);
        String elementTypeName = ReflectionTools.getElementTypeNameForTypeDeclaration_(typeDeclaration, arrayDepth);
        return new TypeDeclaration(elementTypeName, arrayDepth);
    }

    public static int getArrayDepthForTypeDeclaration(String typeDeclaration) {
        return ReflectionTools.getArrayDepthForTypeDeclaration_(StringTools.removeAllWhitespace(typeDeclaration));
    }

    private static int getArrayDepthForTypeDeclaration_(String typeDeclaration) {
        int last = typeDeclaration.length() - 1;
        int depth = 0;
        int close = last;
        while (typeDeclaration.charAt(close) == ']') {
            if (typeDeclaration.charAt(close - 1) != '[') {
                throw new IllegalArgumentException("invalid type declaration: " + typeDeclaration);
            }
            close = last - ++depth * 2;
        }
        return depth;
    }

    public static String getElementTypeNameForTypeDeclaration(String typeDeclaration) {
        typeDeclaration = StringTools.removeAllWhitespace(typeDeclaration);
        return ReflectionTools.getElementTypeNameForTypeDeclaration_(typeDeclaration, ReflectionTools.getArrayDepthForTypeDeclaration_(typeDeclaration));
    }

    public static String getElementTypeNameForTypeDeclaration(String typeDeclaration, int arrayDepth) {
        return ReflectionTools.getElementTypeNameForTypeDeclaration_(StringTools.removeAllWhitespace(typeDeclaration), arrayDepth);
    }

    private static String getElementTypeNameForTypeDeclaration_(String typeDeclaration, int arrayDepth) {
        return typeDeclaration.substring(0, typeDeclaration.length() - arrayDepth * 2);
    }

    public static Class<?> getClassForTypeDeclaration(String elementTypeName, int arrayDepth) {
        return ReflectionTools.getClassForTypeDeclaration(elementTypeName, arrayDepth, null);
    }

    public static Class<?> getClassForTypeDeclaration_(String elementTypeName, int arrayDepth) throws ClassNotFoundException {
        return ReflectionTools.getClassForTypeDeclaration_(elementTypeName, arrayDepth, null);
    }

    public static Class<?> getClassForTypeDeclaration(String elementTypeName, int arrayDepth, ClassLoader classLoader) {
        try {
            return ReflectionTools.getClassForTypeDeclaration_(elementTypeName, arrayDepth, classLoader);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Class<?> getClassForTypeDeclaration_(String elementTypeName, int arrayDepth, ClassLoader classLoader) throws ClassNotFoundException {
        Primitive pcc = null;
        if (elementTypeName.length() <= MAX_PRIMITIVE_CLASS_NAME_LENGTH) {
            for (Primitive primitive : PRIMITIVES) {
                if (!primitive.javaClass.getName().equals(elementTypeName)) continue;
                pcc = primitive;
                break;
            }
        }
        if (arrayDepth == 0) {
            return pcc == null ? Class.forName(elementTypeName, false, classLoader) : pcc.javaClass;
        }
        StringBuilder sb = new StringBuilder(100);
        int i = arrayDepth;
        while (i-- > 0) {
            sb.append('[');
        }
        if (pcc == null) {
            ClassName.append(elementTypeName, sb);
        } else {
            sb.append(pcc.code);
        }
        return Class.forName(sb.toString(), false, classLoader);
    }

    public static String getClassNameForTypeDeclaration(String typeDeclaration) {
        TypeDeclaration td = ReflectionTools.buildTypeDeclaration(typeDeclaration);
        return ReflectionTools.getClassNameForTypeDeclaration(td.elementTypeName, td.arrayDepth);
    }

    public static String getClassNameForTypeDeclaration(String elementTypeName, int arrayDepth) {
        if (arrayDepth == 0) {
            return elementTypeName;
        }
        if (elementTypeName.equals(ClassName.VOID_CLASS_NAME)) {
            throw new IllegalArgumentException(String.valueOf('\'') + ClassName.VOID_CLASS_NAME + "' must have an array depth of zero: " + arrayDepth + '.');
        }
        StringBuilder sb = new StringBuilder(100);
        int i = arrayDepth;
        while (i-- > 0) {
            sb.append('[');
        }
        Primitive pcc = null;
        if (elementTypeName.length() <= MAX_PRIMITIVE_CLASS_NAME_LENGTH) {
            for (Primitive primitive : PRIMITIVES) {
                if (!primitive.javaClass.getName().equals(elementTypeName)) continue;
                pcc = primitive;
                break;
            }
        }
        if (pcc == null) {
            ClassName.append(elementTypeName, sb);
        } else {
            sb.append(pcc.code);
        }
        return sb.toString();
    }

    private static String buildFullyQualifiedConstructorSignature(Class<?> javaClass, Class<?>[] parameterTypes) {
        return ReflectionTools.buildFullyQualifiedMethodSignature(javaClass, null, parameterTypes);
    }

    private static String buildFullyQualifiedFieldName(Class<?> javaClass, String fieldName) {
        StringBuilder sb = new StringBuilder(200);
        sb.append(javaClass.getName());
        sb.append('.');
        sb.append(fieldName);
        return sb.toString();
    }

    private static String buildFullyQualifiedFieldName(Object object, String fieldName) {
        return ReflectionTools.buildFullyQualifiedFieldName(object.getClass(), fieldName);
    }

    private static String buildFullyQualifiedMethodSignature(Class<?> javaClass, String methodName, Class<?>[] parameterTypes) {
        StringBuilder sb = new StringBuilder(200);
        sb.append(javaClass.getName());
        if (methodName != null) {
            sb.append('.');
            sb.append(methodName);
        }
        sb.append('(');
        int max = parameterTypes.length - 1;
        if (max != -1) {
            int i = 0;
            while (i < max) {
                sb.append(parameterTypes[i].getName());
                sb.append(", ");
                ++i;
            }
            sb.append(parameterTypes[max].getName());
        }
        sb.append(')');
        return sb.toString();
    }

    private static int calculateMaxPrimitiveClassNameLength() {
        int max = -1;
        for (Primitive primitive : PRIMITIVES) {
            int len = primitive.javaClass.getName().length();
            if (len <= max) continue;
            max = len;
        }
        return max;
    }

    private static int calculateMaxPrimitiveWrapperClassNameLength() {
        int max = -1;
        for (Primitive primitive : PRIMITIVES) {
            int len = primitive.wrapperClass.getName().length();
            if (len <= max) continue;
            max = len;
        }
        return max;
    }

    private static Iterable<Primitive> buildPrimitives() {
        Primitive[] array = new Primitive[]{new Primitive('B', Byte.class), new Primitive('C', Character.class), new Primitive('D', Double.class), new Primitive('F', Float.class), new Primitive('I', Integer.class), new Primitive('J', Long.class), new Primitive('S', Short.class), new Primitive('Z', Boolean.class), new Primitive('V', Void.class)};
        return new ArrayIterable<Primitive>(array);
    }

    private ReflectionTools() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Primitive {
        final char code;
        final Class<?> javaClass;
        final Class<?> wrapperClass;
        private static final String WRAPPER_CLASS_TYPE_FIELD_NAME = "TYPE";

        Primitive(char code, Class<?> wrapperClass) {
            this.code = code;
            this.wrapperClass = wrapperClass;
            this.javaClass = (Class)ReflectionTools.getStaticFieldValue(wrapperClass, WRAPPER_CLASS_TYPE_FIELD_NAME);
        }
    }

    private static class TypeDeclaration {
        final String elementTypeName;
        final int arrayDepth;

        TypeDeclaration(String elementTypeName, int arrayDepth) {
            this.elementTypeName = elementTypeName;
            this.arrayDepth = arrayDepth;
        }
    }
}

