/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Giulio Gavardi (Engineering Group) - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.ebam.emf.utilities;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.eclipse.ebam.emf.activator.ModelConnectorActivator;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.apache.xpath.XPathAPI;

/** Class called by the designer wiith the purpose to read connection configuration as stored in persistence.xml
 * 
 * @author gavardi
 *
 */

public class ConnectionUtilities {


	/**
	 * Logger.
	 */
	private static Logger logger = 
		LoggerFactory.getLogger(ConnectionUtilities.class);


	String user;
	String password;
	String url;
	String driver;

	public static final String PERSISTENCE_URL = "/bin/META-INF/persistence.xml";


	/**
	 *  function that read persistence.xml and get user, pwd, url and driver data
	 * @throws Exception
	 */
	public void getConnectionData() throws Exception{
		logger.debug("IN");
		String content = null;
		Bundle bundle = FrameworkUtil.getBundle(ModelConnectorActivator.class);
		URL urlFile = bundle.getEntry(PERSISTENCE_URL); 
		InputStream is;
		is = urlFile.openStream();
		BufferedReader br = new BufferedReader(new InputStreamReader(is));
		StringBuilder sb = new StringBuilder();
		String line = null;

		while ((line = br.readLine()) != null){
			sb.append(line);
		}
		br.close();
		content = sb.toString();
		StringBuffer strBufferContent = new StringBuffer(content);
		DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
		DocumentBuilder db = dbf.newDocumentBuilder();

		ByteArrayInputStream bais = new ByteArrayInputStream(
				strBufferContent.toString().getBytes("UTF-8"));

		InputSource inputSource = new InputSource(bais);
		Document doc = db.parse(inputSource);
		doc.getDocumentElement().normalize();

		NodeList nodes = XPathAPI.selectNodeList(doc, "//persistence/properties/property");

		Node node = XPathAPI.selectSingleNode(doc, "//persistence/properties/property[@name='eclipselink.target-database']");

		String targetC = XPathAPI.eval(doc, "//property[@name='eclipselink.target-database']/@value").toString();
		String driverC = XPathAPI.eval(doc, "//property[@name='javax.persistence.jdbc.driver']/@value").toString();
		logger.debug("found driver "+driverC);
		String urlDbC = XPathAPI.eval(doc, "//property[@name='javax.persistence.jdbc.url']/@value").toString();
		logger.debug("found url "+urlDbC);
		String userC = XPathAPI.eval(doc, "//property[@name='javax.persistence.jdbc.user']/@value").toString();
		logger.debug("found url "+userC);
		String passwordC = XPathAPI.eval(doc, "//property[@name='javax.persistence.jdbc.password']/@value").toString();
		logger.debug("found url "+passwordC);

		this.driver = driverC;
		this.user = userC;
		this.password = passwordC;
		this.url = urlDbC;
		
		
		logger.debug("OUT");
	}




	public String getUser() {
		return user;
	}
	public void setUser(String user) {
		this.user = user;
	}
	public String getPassword() {
		return password;
	}
	public void setPassword(String password) {
		this.password = password;
	}
	public String getUrl() {
		return url;
	}
	public void setUrl(String url) {
		this.url = url;
	}
	public String getDriver() {
		return driver;
	}
	public void setDriver(String driver) {
		this.driver = driver;
	}








}
