/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.core.model;

import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;

public class DataStoreSchema {
    private DataStore _dataStore;
    private DataElement _abstractedBy;
    private DataElement _abstracts;
    private DataElement _contents;
    private DataElement _container;
    private DataElement _attributes;
    private DataElement _objectDescriptor;
    private DataElement _commandDescriptor;
    private DataElement _relationDescriptor;
    private DataElement _abstractObjectDescriptor;
    private DataElement _abstractCommandDescriptor;
    private DataElement _abstractRelationDescriptor;
    public static final String C_VALIDATE_TICKET = "C_VALIDATE_TICKET";
    public static final String C_SET = "C_SET";
    public static final String C_MODIFY = "C_MODIFY";
    public static final String C_SET_HOST = "C_SET_HOST";
    public static final String C_SCHEMA = "C_SCHEMA";
    public static final String C_SET_PREFERENCE = "C_SET_PREFERENCE";
    public static final String C_ADD_MINERS = "C_ADD_MINERS";
    public static final String C_ACTIVATE_MINER = "C_ACTIVATE_MINER";
    public static final String C_INIT_MINERS = "C_INIT_MINERS";
    public static final String C_OPEN = "C_OPEN";
    public static final String C_CANCEL = "C_CANCEL";
    public static final String C_SEND_INPUT = "C_SEND_INPUT";
    public static final String C_QUERY = "C_QUERY";
    public static final String C_REFRESH = "C_REFRESH";
    public static final String C_EXIT = "C_EXIT";
    public static final String C_CLOSE = "C_CLOSE";
    public static final String C_NOTIFICATION = "C_NOTIFICATION";
    public static final String C_QUERY_INSTALL = "C_QUERY_INSTALL";
    public static final String C_QUERY_CLIENT_IP = "C_QUERY_CLIENT_IP";
    public static final String C_QUERY_JVM = "C_QUERY_JVM";

    public DataStoreSchema(DataStore dataStore) {
        this._dataStore = dataStore;
    }

    public DataElement getAbstractedByRelation() {
        return this._abstractedBy;
    }

    public DataElement getAbstractsRelation() {
        return this._abstracts;
    }

    public DataElement getContentsRelation() {
        return this._contents;
    }

    public DataElement getAttributesRelation() {
        return this._attributes;
    }

    public DataElement getContainerType() {
        return this._container;
    }

    public DataElement getObjectDescriptor() {
        return this._objectDescriptor;
    }

    public DataElement getCommandDescriptor() {
        return this._commandDescriptor;
    }

    public DataElement getRelationDescriptor() {
        return this._relationDescriptor;
    }

    public DataElement getAbstractObjectDescriptor() {
        return this._abstractObjectDescriptor;
    }

    public DataElement getAbstractCommandDescriptor() {
        return this._abstractCommandDescriptor;
    }

    public DataElement getAbstractRelationDescriptor() {
        return this._abstractRelationDescriptor;
    }

    public void extendSchema(DataElement schemaRoot) {
        this._dataStore.createObject(schemaRoot, "ui_commanddescriptor", "ui_commanddescriptor");
        this._commandDescriptor = this._dataStore.createCommandDescriptor(schemaRoot, "commanddescriptor");
        this._objectDescriptor = this._dataStore.createObjectDescriptor(schemaRoot, "objectdescriptor");
        this._relationDescriptor = this._dataStore.createRelationDescriptor(schemaRoot, "relationdescriptor");
        this._abstractObjectDescriptor = this._dataStore.createAbstractObjectDescriptor(schemaRoot, "abstractobjectdescriptor");
        this._abstractCommandDescriptor = this._dataStore.createAbstractCommandDescriptor(schemaRoot, "abstractcommanddescriptor");
        this._abstractRelationDescriptor = this._dataStore.createAbstractRelationDescriptor(schemaRoot, "abstractrelationdescriptor");
        DataElement cancellable = this._dataStore.createAbstractObjectDescriptor(schemaRoot, "Cancellable");
        DataElement rootD = this._dataStore.createObjectDescriptor(schemaRoot, "root");
        DataElement hostD = this._dataStore.createObjectDescriptor(schemaRoot, "host");
        DataElement logD = this._dataStore.createObjectDescriptor(schemaRoot, "log");
        DataElement statusD = this._dataStore.createObjectDescriptor(schemaRoot, "status");
        this._dataStore.createObjectDescriptor(schemaRoot, "deleted");
        DataElement allD = this._dataStore.createObjectDescriptor(schemaRoot, "all");
        this._dataStore.createObjectDescriptor(schemaRoot, "invocation");
        this._dataStore.createObjectDescriptor(schemaRoot, "pattern");
        this._dataStore.createObjectDescriptor(schemaRoot, "input");
        this._dataStore.createObjectDescriptor(schemaRoot, "output");
        this._contents = this._dataStore.createRelationDescriptor(schemaRoot, "contents");
        this._contents.setDepth(100);
        DataElement descriptorForD = this._dataStore.createRelationDescriptor(schemaRoot, "descriptor for");
        descriptorForD.setDepth(1);
        DataElement parentD = this._dataStore.createRelationDescriptor(schemaRoot, "parent");
        parentD.setDepth(1);
        this._attributes = this._dataStore.createRelationDescriptor(schemaRoot, "attributes");
        this._attributes.setDepth(0);
        DataElement argsD = this._dataStore.createRelationDescriptor(schemaRoot, "arguments");
        this._abstracts = this._dataStore.createRelationDescriptor(schemaRoot, "abstracts");
        this._abstractedBy = this._dataStore.createRelationDescriptor(schemaRoot, "abstracted by");
        DataElement caRelations = this._dataStore.createAbstractRelationDescriptor(schemaRoot, "Contents and Arguments");
        this._dataStore.createReference(caRelations, this._contents, this._contents);
        this._dataStore.createReference(caRelations, argsD, this._contents);
        this._dataStore.createReference(this._objectDescriptor, this._contents, this._contents);
        this._dataStore.createReference(this._objectDescriptor, parentD, this._contents);
        this._dataStore.createReference(this._objectDescriptor, this._abstracts, this._contents);
        this._dataStore.createReference(this._objectDescriptor, this._abstractedBy, this._contents);
        this._dataStore.createReference(this._abstractObjectDescriptor, this._contents, this._contents);
        this._dataStore.createReference(this._abstractObjectDescriptor, parentD, this._contents);
        this._dataStore.createReference(this._abstractObjectDescriptor, this._abstracts, this._contents);
        this._dataStore.createReference(this._abstractObjectDescriptor, this._abstractedBy, this._contents);
        this._dataStore.createReference(statusD, this._contents, this._contents);
        this._dataStore.createReference(this._commandDescriptor, allD, this._contents);
        this._dataStore.createReference(this._commandDescriptor, caRelations, this._contents);
        this._dataStore.createReference(this._commandDescriptor, argsD, this._contents);
        this._dataStore.createReference(this._commandDescriptor, this._contents, this._contents);
        DataElement logDetails = this._dataStore.createAbstractObjectDescriptor(logD, "Commands");
        this._dataStore.createReference(logDetails, this._commandDescriptor, this._contents);
        this._dataStore.createReference(logDetails, allD, this._contents);
        this._dataStore.createReference(logD, caRelations, this._contents);
        this._dataStore.createReference(logD, this._contents, this._contents);
        this._container = this._dataStore.createAbstractObjectDescriptor(schemaRoot, "Container Object");
        this._dataStore.createCommandDescriptor(this._container, "Query", "*", C_QUERY, false);
        this._dataStore.createReference(this._container, this._contents, this._contents);
        DataElement fileD = this._dataStore.createObjectDescriptor(schemaRoot, "file");
        DataElement dirD = this._dataStore.createObjectDescriptor(schemaRoot, "directory");
        DataElement fsObject = this._dataStore.createAbstractObjectDescriptor(schemaRoot, "Filesystem Objects");
        this._dataStore.createReference(this._container, fsObject, this._abstracts, this._abstractedBy);
        this._dataStore.createReference(fileD, fsObject, this._abstracts, this._abstractedBy);
        this._dataStore.createReference(fsObject, dirD, this._abstracts, this._abstractedBy);
        this._dataStore.createReference(fsObject, fileD, this._contents);
        this._dataStore.createReference(fsObject, dirD, this._contents);
        this._dataStore.createReference(fsObject, fsObject, this._contents);
        this._dataStore.createReference(dirD, fileD, this._contents);
        this._dataStore.createReference(dirD, dirD, this._contents);
        DataElement minersD = this._dataStore.createObjectDescriptor(schemaRoot, "miners");
        DataElement minerD = this._dataStore.createObjectDescriptor(schemaRoot, "miner");
        DataElement dataD = this._dataStore.createObjectDescriptor(schemaRoot, "data");
        this._dataStore.createObjectDescriptor(schemaRoot, "transient");
        this._dataStore.createObjectDescriptor(schemaRoot, "state");
        this._dataStore.createReference(this._container, rootD, this._abstracts, this._abstractedBy);
        this._dataStore.createReference(this._container, hostD, this._abstracts, this._abstractedBy);
        this._dataStore.createReference(this._container, logD, this._abstracts, this._abstractedBy);
        this._dataStore.createReference(this._container, minersD, this._abstracts, this._abstractedBy);
        this._dataStore.createReference(this._container, minerD, this._abstracts, this._abstractedBy);
        this._dataStore.createReference(this._container, dataD, this._abstracts, this._abstractedBy);
        this._dataStore.createCommandDescriptor(cancellable, "Cancel", "*", C_CANCEL);
        this._dataStore.createCommandDescriptor(rootD, "Set", "-", C_SET, false);
        this._dataStore.createCommandDescriptor(rootD, "Set Host", "-", C_SET_HOST, false);
        this._dataStore.createCommandDescriptor(rootD, "Init Miners", "*", C_INIT_MINERS, false);
        this._dataStore.createCommandDescriptor(rootD, "Add Miners", "-", C_ADD_MINERS, false);
        this._dataStore.createCommandDescriptor(rootD, "Activate Miner", "-", C_ACTIVATE_MINER, false);
        this._dataStore.createCommandDescriptor(rootD, "Set Preference", "-", C_SET_PREFERENCE, false);
        this._dataStore.createCommandDescriptor(rootD, "Show Ticket", "-", C_VALIDATE_TICKET, false);
        this._dataStore.createCommandDescriptor(rootD, "Get Schema", "*", C_SCHEMA, false);
        this._dataStore.createCommandDescriptor(rootD, "Exit", "*", C_EXIT, false);
        this._dataStore.createCommandDescriptor(rootD, "Query Install", "*", C_QUERY_INSTALL, false);
        this._dataStore.createCommandDescriptor(rootD, "Query Client IP", "*", C_QUERY_CLIENT_IP, false);
        this._dataStore.createCommandDescriptor(rootD, "Query JVM", "*", C_QUERY_JVM, false);
        this._dataStore.createCommandDescriptor(rootD, "Notification", "*", C_NOTIFICATION, false);
        this._dataStore.createCommandDescriptor(rootD, "Send Input", "*", C_SEND_INPUT, false);
        int i = 0;
        while (i < schemaRoot.getNestedSize()) {
            DataElement descriptor = schemaRoot.get(i);
            descriptor.setUpdated(true);
            int j = 0;
            while (j < descriptor.getNestedSize()) {
                DataElement subDescriptor = descriptor.get(j);
                subDescriptor.setUpdated(true);
                ++j;
            }
            schemaRoot.setUpdated(true);
            ++i;
        }
    }
}

