/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.designers.wizards.pages.contactwidgets;

import org.eclipse.ebam.designers.exception.DatabaseConnectionException;
import org.eclipse.ebam.designers.swtutils.ImageDescriptors;
import org.eclipse.ebam.designers.wizards.pages.contactwidgets.ContactWizardPage;
import org.eclipse.ebam.designers.wizards.pages.contactwidgets.ContactsListComposite;
import org.eclipse.ebam.designers.wizards.pages.contactwidgets.detailtabs.ContactDetailTabItem;
import org.eclipse.ebam.emf.SbiAlarmContactsTransactions;
import org.eclipse.ebam.model.entities.SbiAlarmContact;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContactsDetailComposite
extends Composite {
    private ContactWizardPage contactWizardPage = null;
    private ContactDetailTabItem detailTabItem = null;
    private CTabFolder tabFolder = null;
    private Button buttonSave = null;
    private static Logger logger = LoggerFactory.getLogger(ContactsDetailComposite.class);

    public ContactsDetailComposite(Composite parent, int style, ContactWizardPage page) {
        super(parent, style);
        this.contactWizardPage = page;
    }

    public void drawComp() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.setLayout((Layout)gridLayout);
        this.buttonSave = new Button((Composite)this, 8);
        this.buttonSave.setToolTipText("Save contact details");
        this.buttonSave.setLayoutData((Object)new GridData(128));
        Image saveImage = ImageDescriptors.getSaveIcon().createImage();
        this.buttonSave.setImage(saveImage);
        this.buttonSave.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    ContactsDetailComposite.this.saveButtonPush();
                }
                catch (DatabaseConnectionException databaseConnectionException) {
                    logger.error("database connection exception");
                    MessageDialog.openError((Shell)ContactsDetailComposite.this.getShell(), (String)"Error", (String)"Error in removing contact");
                }
            }
        });
        this.tabFolder = new CTabFolder((Composite)this, 2048);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        this.tabFolder.setEnabled(false);
        this.detailTabItem = new ContactDetailTabItem(this.tabFolder, 0, this);
        this.detailTabItem.setText("Detail");
        this.detailTabItem.drawComp(this.tabFolder);
        this.buttonSave.setEnabled(false);
    }

    private void saveButtonPush() throws DatabaseConnectionException {
        logger.debug("IN");
        Table contactsTable = this.getContactWizardPage().getListComposite().getContactsTable();
        int index = contactsTable.getSelectionIndex();
        SbiAlarmContact sbiContact = null;
        if (index == -1) {
            sbiContact = new SbiAlarmContact();
        } else {
            TableItem item = contactsTable.getItem(index);
            Integer id = (Integer)item.getData();
            try {
                sbiContact = new SbiAlarmContactsTransactions().getSbiAlarmContactById(id);
            }
            catch (Exception e) {
                logger.error("error in getting sbiContact with id " + id, (Throwable)e);
                throw new DatabaseConnectionException(e, "error in getting sbiContact with id " + id);
            }
        }
        ContactDetailTabItem contactDetailTabItem = (ContactDetailTabItem)this.tabFolder.getItem(0);
        contactDetailTabItem.recoverSavingInformations(sbiContact);
        if (sbiContact.getName() == null || sbiContact.getName().equalsIgnoreCase("")) {
            return;
        }
        SbiAlarmContactsTransactions sbiACT = new SbiAlarmContactsTransactions();
        try {
            if (index == -1) {
                sbiACT.createNewSbiAlarmContact(sbiContact);
                TableItem tableItem = new TableItem(contactsTable, 0);
                tableItem.setText(0, sbiContact.getName());
                tableItem.setData((Object)sbiContact.getAlarmContactId());
                contactsTable.redraw();
            } else {
                sbiACT.mergeSbiAlarmContact(sbiContact);
                TableItem item = contactsTable.getItem(index);
                item.setText(0, sbiContact.getName());
            }
        }
        catch (Exception e1) {
            logger.error("Error in inserting o updating contact ", (Throwable)e1);
            throw new DatabaseConnectionException(e1, "Error in inserting or updating contact");
        }
        contactDetailTabItem.fillEmptyValues();
        contactsTable.setSelection(-1);
        this.buttonSave.setEnabled(false);
        logger.debug("OUT");
    }

    public Integer getListSelectedContactId() {
        logger.debug("IN");
        ContactsListComposite listComp = this.getContactWizardPage().getListComposite();
        int selectedIndex = listComp.getContactsTable().getSelectionIndex();
        if (selectedIndex == -1) {
            return null;
        }
        TableItem item = listComp.getContactsTable().getItem(selectedIndex);
        if (item == null) {
            return null;
        }
        Object o = item.getData();
        if (o == null) {
            return null;
        }
        Integer id = (Integer)o;
        logger.debug("OUT");
        return id;
    }

    public ContactWizardPage getContactWizardPage() {
        return this.contactWizardPage;
    }

    public void setContactWizardPage(ContactWizardPage ContactWizardPage2) {
        this.contactWizardPage = ContactWizardPage2;
    }

    public ContactDetailTabItem getDetailTabItem() {
        return this.detailTabItem;
    }

    public void setDetailTabItem(ContactDetailTabItem detailTabItem) {
        this.detailTabItem = detailTabItem;
    }

    public CTabFolder getTabFolder() {
        return this.tabFolder;
    }

    public void setTabFolder(CTabFolder tabFolder) {
        this.tabFolder = tabFolder;
    }

    public Button getButtonSave() {
        return this.buttonSave;
    }

    public void setButtonSave(Button buttonSave) {
        this.buttonSave = buttonSave;
    }
}

