/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.ui.internal.persistence.connection;

import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.PersistenceUnitTransactionType;
import org.eclipse.jpt.eclipselink.core.context.persistence.connection.Connection;
import org.eclipse.jpt.eclipselink.ui.internal.EclipseLinkUiMessages;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourcePropertiesComposite<T extends Connection>
extends Pane<T> {
    public DataSourcePropertiesComposite(Pane<T> parentComposite, Composite parent) {
        super(parentComposite, parent);
    }

    private WritablePropertyValueModel<String> buildJtaDataSourceHolder() {
        return new PropertyAspectAdapter<PersistenceUnit, String>(this.buildPersistenceUnitHolder(), new String[]{"jtaDataSource"}){

            protected String buildValue_() {
                return ((PersistenceUnit)this.subject).getJtaDataSource();
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((PersistenceUnit)this.subject).setJtaDataSource(value);
            }
        };
    }

    private PropertyValueModel<Boolean> buildJTADataSourceHolder() {
        return new TransformationPropertyValueModel<PersistenceUnitTransactionType, Boolean>(this.buildTransactionTypeHolder()){

            protected Boolean transform(PersistenceUnitTransactionType value) {
                return this.transform2(value);
            }

            private boolean transform2(PersistenceUnitTransactionType value) {
                return value == null || value == PersistenceUnitTransactionType.JTA;
            }
        };
    }

    private WritablePropertyValueModel<String> buildNonJtaDataSourceHolder() {
        return new PropertyAspectAdapter<PersistenceUnit, String>(this.buildPersistenceUnitHolder(), new String[]{"nonJtaDataSource"}){

            protected String buildValue_() {
                return ((PersistenceUnit)this.subject).getNonJtaDataSource();
            }

            protected void setValue_(String value) {
                if (value.length() == 0) {
                    value = null;
                }
                ((PersistenceUnit)this.subject).setNonJtaDataSource(value);
            }
        };
    }

    private PropertyValueModel<Boolean> buildNonJTADataSourceHolder() {
        return new TransformationPropertyValueModel<PersistenceUnitTransactionType, Boolean>(this.buildTransactionTypeHolder()){

            protected Boolean transform(PersistenceUnitTransactionType value) {
                return value == PersistenceUnitTransactionType.RESOURCE_LOCAL;
            }
        };
    }

    private PropertyValueModel<PersistenceUnitTransactionType> buildTransactionTypeHolder() {
        return new PropertyAspectAdapter<PersistenceUnit, PersistenceUnitTransactionType>(this.buildPersistenceUnitHolder(), new String[]{"specifiedTransactionType", "defaultTransactionType"}){

            protected PersistenceUnitTransactionType buildValue_() {
                return ((PersistenceUnit)this.subject).getTransactionType();
            }
        };
    }

    private PropertyValueModel<PersistenceUnit> buildPersistenceUnitHolder() {
        return new PropertyAspectAdapter<Connection, PersistenceUnit>(this.getSubjectHolder()){

            protected PersistenceUnit buildValue_() {
                return ((Connection)this.subject).getPersistenceUnit();
            }
        };
    }

    protected void initializeLayout(Composite container) {
        int groupBoxMargin = this.getGroupBoxMargin();
        container = this.addSubPane(container, 0, groupBoxMargin, 0, groupBoxMargin);
        PropertyValueModel<Boolean> jtaEnabled = this.buildJTADataSourceHolder();
        Label jtaLabel = this.addLabel(container, EclipseLinkUiMessages.PersistenceXmlConnectionTab_jtaDataSourceLabel, jtaEnabled);
        Text jtaText = this.addText(container, this.buildJtaDataSourceHolder(), this.getHelpID(), jtaEnabled);
        this.addLabeledComposite(container, (Control)jtaLabel, (Control)jtaText, this.getHelpID());
        PropertyValueModel<Boolean> nonJtaEnabled = this.buildNonJTADataSourceHolder();
        Label nonJtaLabel = this.addLabel(container, EclipseLinkUiMessages.PersistenceXmlConnectionTab_nonJtaDataSourceLabel, nonJtaEnabled);
        Text nonJtaText = this.addText(container, this.buildNonJtaDataSourceHolder(), this.getHelpID(), nonJtaEnabled);
        this.addLabeledComposite(container, (Control)nonJtaLabel, (Control)nonJtaText, this.getHelpID());
    }

    public String getHelpID() {
        return "org.eclipse.jpt.ui.persistence_connection";
    }
}

