/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.xml.namespace.QName;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcessVisitor;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.ErrorList;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversal;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversalContext;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BP2105
extends AssertionProcessVisitor
implements WSITag {
    private final WSDLValidatorImpl validator;
    private ErrorList errors = new ErrorList();
    private boolean importFound = false;

    public BP2105(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    public void visit(Import im, Object parent, WSDLTraversalContext ctx) {
        this.importFound = true;
        if (im.getDefinition() != null && im.getLocationURI() != null) {
            this.processWSDL(im.getDefinition().getDocumentBaseURI());
        }
    }

    private boolean isExtensibilityElement(Element el) {
        boolean isEx = true;
        isEx = isEx && !XMLUtils.equals(el, WSDL_BINDING);
        isEx = isEx && !XMLUtils.equals(el, WSDL_DEFINITIONS);
        isEx = isEx && !XMLUtils.equals(el, WSDL_DOCUMENTATION);
        isEx = isEx && !XMLUtils.equals(el, WSDL_FAULT);
        isEx = isEx && !XMLUtils.equals(el, WSDL_IMPORT);
        isEx = isEx && !XMLUtils.equals(el, WSDL_INPUT);
        isEx = isEx && !XMLUtils.equals(el, WSDL_MESSAGE);
        isEx = isEx && !XMLUtils.equals(el, WSDL_OPERATION);
        isEx = isEx && !XMLUtils.equals(el, WSDL_OUTPUT);
        isEx = isEx && !XMLUtils.equals(el, WSDL_PART);
        isEx = isEx && !XMLUtils.equals(el, WSDL_PORT);
        isEx = isEx && !XMLUtils.equals(el, WSDL_PORTTYPE);
        isEx = isEx && !XMLUtils.equals(el, WSDL_SERVICE);
        isEx = isEx && !XMLUtils.equals(el, WSDL_TYPES);
        return isEx;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "failed";
        Definition definition = (Definition)entryContext.getEntry().getEntryDetail();
        if (definition.getImports() == null || definition.getImports().size() == 0) {
            this.result = "notApplicable";
        } else {
            this.processWSDL(definition.getDocumentBaseURI());
            WSDLTraversal traversal = new WSDLTraversal();
            traversal.setVisitor(this);
            traversal.visitImport(true);
            traversal.ignoreReferences();
            traversal.ignoreImport();
            traversal.traverse((Definition)entryContext.getEntry().getEntryDetail());
            if (!this.errors.isEmpty()) {
                this.result = "failed";
                this.failureDetail = this.validator.createFailureDetail(this.errors.toString(), entryContext);
            } else {
                this.result = !this.importFound ? "notApplicable" : "passed";
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private void processWSDL(String location) {
        try {
            Document doc = this.validator.parseXMLDocumentURL(location, null);
            this.checkWSDL(doc.getDocumentElement());
        }
        catch (Throwable t) {
            this.errors.add(t.toString());
        }
    }

    private void createFailed(Node root) {
        Attr a = XMLUtils.getAttribute((Element)root, ATTR_WSDL_LOCATION);
        String schemaLocation = a != null ? a.getValue() : "";
        a = XMLUtils.getAttribute((Element)root, ATTR_WSDL_NAMESPACE);
        String namespace = a != null ? a.getValue() : "";
        this.errors.add(new QName(namespace, schemaLocation));
    }

    private void checkWSDL(Node root) {
        if (root != null) {
            Element im = XMLUtils.findChildElement((Element)root, WSDL_IMPORT);
            boolean documentIsPresent = XMLUtils.findChildElement((Element)root, WSDL_DOCUMENTATION) != null;
            while (im != null) {
                Element el = XMLUtils.findPreviousSibling(im);
                if (el != null) {
                    while (this.isExtensibilityElement(el) && el != null) {
                        el = XMLUtils.findPreviousSibling(el);
                    }
                }
                if (documentIsPresent && el != null) {
                    if (!XMLUtils.equals(el, WSDL_DOCUMENTATION) && !XMLUtils.equals(el, WSDL_IMPORT)) {
                        this.createFailed(root);
                    }
                } else if (el != null && !XMLUtils.equals(el, WSDL_DEFINITIONS) && !XMLUtils.equals(el, WSDL_IMPORT) && el.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/")) {
                    this.createFailed(root);
                }
                im = XMLUtils.findElement(im, WSDL_IMPORT);
            }
        }
    }
}

