/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.pass;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.executor.transform.FilterUtil;
import org.eclipse.birt.data.engine.executor.transform.OdiResultSetWrapper;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.executor.transform.pass.PassUtil;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.FilterByRow;
import org.eclipse.birt.data.engine.script.FilterPassController;

class FilterCalculator {
    private ResultSetPopulator populator;
    private FilterByRow filterByRow;
    private DataEngineSession session;

    private FilterCalculator(ResultSetPopulator populator, FilterByRow filterByRow) {
        this.populator = populator;
        this.filterByRow = filterByRow;
        this.session = populator.getSession();
    }

    static void applyFilters(ResultSetPopulator populator, FilterByRow filterByRow) throws DataException {
        new FilterCalculator(populator, filterByRow).applyFilters();
    }

    private void applyFilters() throws DataException {
        FilterPassController filterPass = new FilterPassController();
        Iterator filterIt = this.filterByRow.getFilterList().iterator();
        while (filterIt.hasNext()) {
            FilterUtil.prepareFilterExpression(this.session.getTempDir(), ((IFilterDefinition)filterIt.next()).getExpression(), filterPass, this.populator.getEventHandler().getExecutorHelper());
        }
        this.doFiltering(filterPass);
    }

    private void doFiltering(FilterPassController filterPass) throws DataException {
        boolean needMultiPass = false;
        needMultiPass = FilterUtil.hasMutipassFilters(this.filterByRow.getFilterList());
        if (needMultiPass) {
            this.makeMultiPassToFilter(filterPass);
        } else {
            PassUtil.pass(this.populator, new OdiResultSetWrapper(this.populator.getResultIterator()), false);
        }
    }

    private void makeMultiPassToFilter(FilterPassController filterPass) throws DataException {
        int max = this.populator.getQuery().getMaxRows();
        this.populator.getQuery().setMaxRows(0);
        ResultSetCache sCache = this.populator.getCache();
        this.makeFirstPassToMultiPassFilter(filterPass);
        this.populator.setCache(sCache);
        sCache.reset();
        sCache.next();
        this.populator.getQuery().setMaxRows(max);
        this.makeSecondPassToMultiPassFilter(filterPass);
        for (IFilterDefinition fd : this.filterByRow.getFilterList()) {
            if (!FilterUtil.isFilterNeedMultiPass(fd)) continue;
            fd.getExpression().setHandle(null);
        }
        filterPass.setSecondPassRowCount(0);
    }

    private void makeFirstPassToMultiPassFilter(FilterPassController filterPass) throws DataException {
        filterPass.setForceReset(true);
        filterPass.setPassLevel(1);
        filterPass.setRowCount(this.populator.getCache().getCount());
        ArrayList temp = new ArrayList();
        temp.addAll(this.filterByRow.getFilterList());
        this.filterByRow.getFilterList().clear();
        int i = 0;
        while (i < temp.size()) {
            if (FilterUtil.isFilterNeedMultiPass((IFilterDefinition)temp.get(i))) {
                this.filterByRow.getFilterList().add(temp.get(i));
            }
            ++i;
        }
        PassUtil.pass(this.populator, new OdiResultSetWrapper(this.populator.getResultIterator()), false);
        this.filterByRow.getFilterList().clear();
        this.filterByRow.getFilterList().addAll(temp);
    }

    private void makeSecondPassToMultiPassFilter(FilterPassController filterPass) throws DataException {
        filterPass.setPassLevel(2);
        PassUtil.pass(this.populator, new OdiResultSetWrapper(this.populator.getResultIterator()), false);
        filterPass.setPassLevel(0);
        filterPass.setRowCount(-1);
    }
}

