/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.core.script.IScriptEngineFactory;

public abstract class ScriptEngineFactoryManager {
    protected static Logger logger = Logger.getLogger(ScriptEngineFactoryManager.class.getName());
    private static ScriptEngineFactoryManager instance;
    private Map<String, IScriptEngineFactory> factories = new HashMap<String, IScriptEngineFactory>();

    public static void setInstance(ScriptEngineFactoryManager manager) {
        instance = manager;
    }

    public static ScriptEngineFactoryManager getInstance() {
        return instance;
    }

    protected ScriptEngineFactoryManager() {
    }

    public synchronized IScriptEngineFactory getScriptEngineFactory(String language) {
        if (this.factories.containsKey(language)) {
            return this.factories.get(language);
        }
        IScriptEngineFactory factory = this.createFactory(language);
        this.factories.put(language, factory);
        return factory;
    }

    protected abstract IScriptEngineFactory createFactory(String var1);
}

