/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.ArchiveLockManager;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.IArchiveLockManager;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAFolderInputStream;
import org.eclipse.birt.core.archive.RAInputStream;

public class FolderArchiveReader
implements IDocArchiveReader {
    static Logger logger = Logger.getLogger(FolderArchiveReader.class.getName());
    private String folderName;
    private HashSet<RAFolderInputStream> inputStreams = new HashSet();

    public FolderArchiveReader(String folderName) throws IOException {
        if (folderName == null || folderName.length() == 0) {
            throw new IOException("The folder archive name is null or empty string.");
        }
        File fd = new File(folderName);
        if (!fd.isDirectory()) {
            throw new IOException("The specified name is not a folder name. The FolderArchiveReader is expecting a valid folder archive name.");
        }
        this.folderName = fd.getCanonicalPath();
    }

    public String getName() {
        return this.folderName;
    }

    public void open() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        IOException exception = null;
        HashSet<RAFolderInputStream> hashSet = this.inputStreams;
        synchronized (hashSet) {
            ArrayList<RAFolderInputStream> inputs = new ArrayList<RAFolderInputStream>(this.inputStreams);
            for (RAFolderInputStream in : inputs) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    if (exception != null) {
                        exception = ex;
                    }
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
    }

    public RAInputStream getStream(String relativePath) throws IOException {
        String path = ArchiveUtil.generateFullPath(this.folderName, relativePath);
        File file = new File(path);
        if (file.exists()) {
            return new RAFolderInputStream(this.inputStreams, file);
        }
        throw new IOException(String.valueOf(relativePath) + " doesn't exit");
    }

    public RAInputStream getInputStream(String relativePath) throws IOException {
        return this.getStream(relativePath);
    }

    public boolean exists(String relativePath) {
        String fullPath = ArchiveUtil.generateFullPath(this.folderName, relativePath);
        File fd = new File(fullPath);
        return fd.exists();
    }

    public List listStreams(String relativeStoragePath) throws IOException {
        File[] files;
        ArrayList<String> streamList = new ArrayList<String>();
        String storagePath = ArchiveUtil.generateFullPath(this.folderName, relativeStoragePath);
        File dir = new File(storagePath);
        if (dir.exists() && dir.isDirectory() && (files = dir.listFiles()) != null) {
            int i = 0;
            while (i < files.length) {
                String relativePath;
                File file = files[i];
                if (file.isFile() && !ArchiveUtil.needSkip(relativePath = ArchiveUtil.generateRelativePath(this.folderName, file.getPath()))) {
                    streamList.add(relativePath);
                }
                ++i;
            }
        }
        return streamList;
    }

    public List listAllStreams() throws IOException {
        ArrayList list = new ArrayList();
        ArchiveUtil.listAllFiles(new File(this.folderName), list);
        ArrayList<String> streams = new ArrayList<String>();
        int i = 0;
        while (i < list.size()) {
            File file = (File)list.get(i);
            String relativePath = ArchiveUtil.generateRelativePath(this.folderName, file.getPath());
            if (!ArchiveUtil.needSkip(relativePath)) {
                streams.add(relativePath);
            }
            ++i;
        }
        return streams;
    }

    public Object lock(String stream) throws IOException {
        String path = ArchiveUtil.generateFullPath(this.folderName, String.valueOf(stream) + ".lck");
        IArchiveLockManager lockManager = ArchiveLockManager.getInstance();
        return lockManager.lock(path);
    }

    public void unlock(Object lock) {
        IArchiveLockManager lockManager = ArchiveLockManager.getInstance();
        lockManager.unlock(lock);
    }
}

