/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.ui.internal.Trace;

public abstract class BaseLabelProvider
implements ILabelProvider {
    protected ILabelDecorator decorator;
    private transient List<ILabelProviderListener> listeners;
    private ILabelProviderListener providerListener;

    public BaseLabelProvider() {
        this(null);
    }

    public BaseLabelProvider(ILabelDecorator decorator) {
        if (decorator == null) {
            decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        }
        this.decorator = decorator;
        if (decorator != null) {
            this.providerListener = new ILabelProviderListener(){

                public void labelProviderChanged(LabelProviderChangedEvent event) {
                    BaseLabelProvider.this.fireListener(event);
                }
            };
            decorator.addListener(this.providerListener);
        }
    }

    public BaseLabelProvider(boolean noDecorator) {
    }

    public void addListener(ILabelProviderListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList<ILabelProviderListener>();
        }
        this.listeners.add(listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    protected void fireListener(LabelProviderChangedEvent event) {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        int size = this.listeners.size();
        ILabelProviderListener[] srl = new ILabelProviderListener[size];
        this.listeners.toArray(srl);
        int i = 0;
        while (i < size) {
            try {
                srl[i].labelProviderChanged(event);
            }
            catch (Exception e) {
                Trace.trace((byte)2, "  Error firing label change event to " + srl[i], e);
            }
            ++i;
        }
    }

    public void dispose() {
        if (this.decorator != null) {
            this.decorator.removeListener(this.providerListener);
        }
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        return "";
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    protected String notNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

