/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import org.eclipse.birt.report.model.api.AutoTextHandle;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignVisitor;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FreeFormHandle;
import org.eclipse.birt.report.model.api.GraphicMasterPageHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TextDataHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;

abstract class ScriptedDesignVisitor
extends DesignVisitor {
    protected ReportDesignHandle handle;

    ScriptedDesignVisitor(ReportDesignHandle handle) {
        this.handle = handle;
    }

    protected abstract void handleOnPrepare(ReportItemHandle var1);

    protected abstract void handleOnPrepare(CellHandle var1);

    protected abstract void handleOnPrepare(GroupHandle var1);

    protected abstract void handleOnPrepare(RowHandle var1);

    public void visitReportDesign(ReportDesignHandle handle) {
        SlotHandle pageSlot = handle.getMasterPages();
        int i = 0;
        while (i < pageSlot.getCount()) {
            this.apply(pageSlot.get(i));
            ++i;
        }
        SlotHandle componentsSlot = handle.getComponents();
        int i2 = 0;
        while (i2 < componentsSlot.getCount()) {
            this.apply(componentsSlot.get(i2));
            ++i2;
        }
        SlotHandle bodySlot = handle.getBody();
        int i3 = 0;
        while (i3 < bodySlot.getCount()) {
            this.apply(bodySlot.get(i3));
            ++i3;
        }
        SlotHandle dataSourceSlot = handle.getDataSources();
        int i4 = 0;
        while (i4 < dataSourceSlot.getCount()) {
            this.apply(dataSourceSlot.get(i4));
            ++i4;
        }
        SlotHandle dataSetSlot = handle.getDataSets();
        int i5 = 0;
        while (i5 < dataSetSlot.getCount()) {
            this.apply(dataSetSlot.get(i5));
            ++i5;
        }
        SlotHandle parameterSlot = handle.getParameters();
        int i6 = 0;
        while (i6 < parameterSlot.getCount()) {
            this.apply(parameterSlot.get(i6));
            ++i6;
        }
        SlotHandle scratchSlot = handle.getScratchPad();
        int i7 = 0;
        while (i7 < scratchSlot.getCount()) {
            this.apply(scratchSlot.get(i7));
            ++i7;
        }
        SlotHandle styleSlot = handle.getStyles();
        int i8 = 0;
        while (i8 < styleSlot.getCount()) {
            this.apply(styleSlot.get(i8));
            ++i8;
        }
    }

    public void visitGraphicMasterPage(GraphicMasterPageHandle handle) {
        SlotHandle contentSlot = handle.getContent();
        int i = 0;
        while (i < contentSlot.getCount()) {
            this.apply(contentSlot.get(i));
            ++i;
        }
    }

    public void visitSimpleMasterPage(SimpleMasterPageHandle handle) {
        SlotHandle headerSlot = handle.getPageHeader();
        int i = 0;
        while (i < headerSlot.getCount()) {
            this.apply(headerSlot.get(i));
            ++i;
        }
        SlotHandle footerSlot = handle.getPageFooter();
        int i2 = 0;
        while (i2 < footerSlot.getCount()) {
            this.apply(footerSlot.get(i2));
            ++i2;
        }
    }

    public void visitAutoText(AutoTextHandle handle) {
        this.handleOnPrepare((ReportItemHandle)handle);
    }

    public void visitList(ListHandle handle) {
        this.handleOnPrepare((ReportItemHandle)handle);
        SlotHandle headerSlot = handle.getHeader();
        int i = 0;
        while (i < headerSlot.getCount()) {
            this.apply(headerSlot.get(i));
            ++i;
        }
        SlotHandle detailSlot = handle.getDetail();
        int i2 = 0;
        while (i2 < detailSlot.getCount()) {
            this.apply(detailSlot.get(i2));
            ++i2;
        }
        SlotHandle footerSlot = handle.getFooter();
        int i3 = 0;
        while (i3 < footerSlot.getCount()) {
            this.apply(footerSlot.get(i3));
            ++i3;
        }
        SlotHandle groupsSlot = handle.getGroups();
        int i4 = 0;
        while (i4 < groupsSlot.getCount()) {
            this.apply(groupsSlot.get(i4));
            ++i4;
        }
    }

    public void visitFreeForm(FreeFormHandle handle) {
        this.handleOnPrepare((ReportItemHandle)handle);
        SlotHandle slot = handle.getReportItems();
        int i = 0;
        while (i < slot.getCount()) {
            this.apply(slot.get(i));
            ++i;
        }
    }

    public void visitTextDataItem(TextDataHandle handle) {
        this.handleOnPrepare((ReportItemHandle)handle);
    }

    public void visitParameterGroup(ParameterGroupHandle handle) {
        SlotHandle parameters = handle.getParameters();
        int size = parameters.getCount();
        int n = 0;
        while (n < size) {
            this.apply(parameters.get(n));
            ++n;
        }
    }

    public void visitCascadingParameterGroup(CascadingParameterGroupHandle handle) {
        SlotHandle parameters = handle.getParameters();
        int size = parameters.getCount();
        int n = 0;
        while (n < size) {
            this.apply(parameters.get(n));
            ++n;
        }
    }

    public void visitScalarParameter(ScalarParameterHandle handle) {
    }

    public void visitLabel(LabelHandle handle) {
        this.handleOnPrepare((ReportItemHandle)handle);
    }

    public void visitDataItem(DataItemHandle handle) {
        this.handleOnPrepare((ReportItemHandle)handle);
    }

    public void visitGrid(GridHandle handle) {
        this.handleOnPrepare((ReportItemHandle)handle);
        SlotHandle columnSlot = handle.getColumns();
        int i = 0;
        while (i < columnSlot.getCount()) {
            this.apply(columnSlot.get(i));
            ++i;
        }
        SlotHandle rowSlot = handle.getRows();
        int i2 = 0;
        while (i2 < rowSlot.getCount()) {
            this.apply(rowSlot.get(i2));
            ++i2;
        }
    }

    public void visitImage(ImageHandle handle) {
        this.handleOnPrepare((ReportItemHandle)handle);
    }

    public void visitTable(TableHandle handle) {
        this.handleOnPrepare((ReportItemHandle)handle);
        SlotHandle headerSlot = handle.getHeader();
        int i = 0;
        while (i < headerSlot.getCount()) {
            this.apply(headerSlot.get(i));
            ++i;
        }
        SlotHandle detailSlot = handle.getDetail();
        int i2 = 0;
        while (i2 < detailSlot.getCount()) {
            this.apply(detailSlot.get(i2));
            ++i2;
        }
        SlotHandle footerSlot = handle.getFooter();
        int i3 = 0;
        while (i3 < footerSlot.getCount()) {
            this.apply(footerSlot.get(i3));
            ++i3;
        }
        SlotHandle columnSlot = handle.getColumns();
        int i4 = 0;
        while (i4 < columnSlot.getCount()) {
            this.apply(columnSlot.get(i4));
            ++i4;
        }
        SlotHandle groupSlot = handle.getGroups();
        int i5 = 0;
        while (i5 < groupSlot.getCount()) {
            this.apply(groupSlot.get(i5));
            ++i5;
        }
    }

    public void visitColumn(ColumnHandle handle) {
    }

    public void visitRow(RowHandle handle) {
        this.handleOnPrepare(handle);
        SlotHandle cellSlot = handle.getCells();
        int i = 0;
        while (i < cellSlot.getCount()) {
            this.apply(cellSlot.get(i));
            ++i;
        }
    }

    public void visitCell(CellHandle handle) {
        this.handleOnPrepare(handle);
        SlotHandle contentSlot = handle.getContent();
        int i = 0;
        while (i < contentSlot.getCount()) {
            this.apply(contentSlot.get(i));
            ++i;
        }
    }

    public void visitListGroup(ListGroupHandle handle) {
        this.handleOnPrepare((GroupHandle)handle);
        SlotHandle headerSlot = handle.getHeader();
        int i = 0;
        while (i < headerSlot.getCount()) {
            this.apply(headerSlot.get(i));
            ++i;
        }
        SlotHandle footerSlot = handle.getFooter();
        int i2 = 0;
        while (i2 < footerSlot.getCount()) {
            this.apply(footerSlot.get(i2));
            ++i2;
        }
    }

    public void visitTableGroup(TableGroupHandle handle) {
        this.handleOnPrepare((GroupHandle)handle);
        SlotHandle headerSlot = handle.getHeader();
        int i = 0;
        while (i < headerSlot.getCount()) {
            this.apply(headerSlot.get(i));
            ++i;
        }
        SlotHandle footerSlot = handle.getFooter();
        int i2 = 0;
        while (i2 < footerSlot.getCount()) {
            this.apply(footerSlot.get(i2));
            ++i2;
        }
    }

    public void visitTextItem(TextItemHandle handle) {
        this.handleOnPrepare((ReportItemHandle)handle);
    }

    protected void visitExtendedItem(ExtendedItemHandle handle) {
    }
}

