/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import com.ibm.icu.util.ULocale;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.data.oda.i18n.JdbcResourceHandle;
import org.eclipse.birt.report.data.oda.jdbc.Connection;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class JDBCException
extends OdaException {
    private static final long serialVersionUID = -3923215393730764306L;
    public static final int ERROR_JDBC = 101;
    private static Logger logger = Logger.getLogger(Connection.class.getName());
    private String errorCode;
    private Object[] argv;
    private static JdbcResourceHandle resourceHandle = new JdbcResourceHandle(ULocale.getDefault());

    public JDBCException(String errorCode, int vendorCode) {
        super(errorCode, null, vendorCode);
        this.errorCode = errorCode;
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, JDBCException.class.getName(), "JDBCException", errorCode);
        }
    }

    public JDBCException(String errorCode, SQLException cause) {
        super("JDBCException", cause == null ? "" : cause.getSQLState(), 101);
        this.initCause(cause);
        this.errorCode = errorCode;
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, JDBCException.class.getName(), "JDBCException", errorCode);
            JDBCException.logSQLException(logger, Level.FINE, cause);
        }
    }

    public JDBCException(String errorCode, SQLException cause, Object argv) {
        super("JDBCException", cause == null ? "" : cause.getSQLState(), 101);
        this.initCause(cause);
        this.errorCode = errorCode;
        this.argv = new Object[]{argv};
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, JDBCException.class.getName(), "JDBCException", errorCode);
            JDBCException.logSQLException(logger, Level.FINE, cause);
        }
    }

    public JDBCException(String errorCode, SQLException cause, Object[] argv) {
        super("JDBCException", cause == null ? "" : cause.getSQLState(), 101);
        this.initCause(cause);
        this.errorCode = errorCode;
        this.argv = argv;
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, JDBCException.class.getName(), "JDBCException", errorCode);
            JDBCException.logSQLException(logger, Level.FINE, cause);
        }
    }

    public String getMessage() {
        String extraMsg;
        String msg = this.argv == null ? resourceHandle.getMessage(this.errorCode) : resourceHandle.getMessage(this.errorCode, this.argv);
        Throwable cause = this.getCause();
        if (cause != null && (extraMsg = cause instanceof SQLException ? JDBCException.getSQLExceptionMesssage((SQLException)cause) : cause.getLocalizedMessage()) != null && extraMsg.length() > 0) {
            msg = String.valueOf(msg) + "\n" + extraMsg;
        }
        return msg;
    }

    public static void logSQLException(Logger logger, Level logLevel, SQLException sqlException) {
        assert (logger != null);
        SQLException e = sqlException;
        int count = 1;
        while (e != null) {
            logger.log(logLevel, "SQL Exception #" + count, e);
            if (++count > 50) break;
            e = e.getNextException();
        }
    }

    public static String getSQLExceptionMesssage(SQLException sqlException) {
        assert (sqlException != null);
        String msg = new String();
        SQLException e = sqlException;
        int count = 1;
        while (e != null) {
            msg = String.valueOf(msg) + "SQL error #" + count + ": " + e.getLocalizedMessage() + "\n";
            if (++count > 50) break;
            e = e.getNextException();
        }
        return msg;
    }
}

