/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util.copy;

import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.api.elements.structures.PropertyBinding;
import org.eclipse.birt.report.model.api.util.IElementCopy;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.util.XPathUtil;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.DesignSessionImpl;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.strategy.CopyForPastePolicy;
import org.eclipse.birt.report.model.elements.strategy.DummyCopyPolicy;
import org.eclipse.birt.report.model.util.copy.ContextCopiedElement;

class ContextCopyPasteBasePolicy {
    ContextCopyPasteBasePolicy() {
    }

    public IElementCopy createCopy(DesignElement source, Module root) {
        DesignElement localized;
        DesignElement destination;
        String location;
        long extendsElementID;
        String libLocation;
        String xpath;
        block10: {
            xpath = XPathUtil.getXPath(source.getHandle(root));
            String extendsName = source.getExtendsName();
            libLocation = null;
            extendsElementID = 0L;
            if (!StringUtil.isBlank(extendsName)) {
                DesignElement element;
                String namespace = StringUtil.extractNamespace(extendsName);
                Library lib = root.getLibraryWithNamespace(namespace);
                if (lib != null) {
                    libLocation = lib.getLocation();
                }
                if ((element = source.getExtendsElement()) != null) {
                    extendsElementID = element.getID();
                }
            }
            location = null;
            if (root != null && root.getSystemId() != null) {
                location = root.getLocation();
            }
            destination = null;
            if (extendsElementID != 0L) {
                try {
                    destination = (DesignElement)source.doClone(DummyCopyPolicy.getInstance());
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    assert (false);
                    return null;
                }
            }
            localized = null;
            try {
                localized = (DesignElement)source.doClone(CopyForPastePolicy.getInstance());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                localized = null;
                if ($assertionsDisabled) break block10;
                throw new AssertionError();
            }
        }
        ContextCopiedElement retValue = new ContextCopiedElement(destination, localized, xpath, location, libLocation, extendsElementID, root.getPropertyBindings(source));
        return retValue;
    }

    public boolean isValidCopy(ContainerContext context, Module module, IElementCopy copy) {
        if (!(copy instanceof ContextCopiedElement)) {
            return false;
        }
        DesignElement copied = ((ContextCopiedElement)copy).getLocalizedCopy();
        if (copied == null) {
            return false;
        }
        return context.canContain(module, copied);
    }

    public IDesignElement preWorkForPaste(ContainerContext context, IElementCopy content, Module module) {
        ContextCopiedElement copy = null;
        try {
            copy = (ContextCopiedElement)((ContextCopiedElement)content).clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            assert (false);
            return null;
        }
        String location = copy.getRootLocation();
        if (location == null) {
            return copy.getLocalizedCopy();
        }
        DesignElement copiedElement = copy.getCopy();
        DesignSessionImpl session = module.getSession();
        Module copiedRoot = session.getOpenedModule(location);
        if (copiedRoot == null) {
            return copy.getLocalizedCopy();
        }
        String nameSpace = StringUtil.extractNamespace(copiedElement.getExtendsName());
        if (!StringUtil.isEmpty(nameSpace)) {
            Library lib = module.getLibraryWithNamespace(nameSpace);
            if (lib == null) {
                return copy.getLocalizedCopy();
            }
            long extendsElementID = copy.getExtendsElementID();
            if (extendsElementID == 0L) {
                return copy.getLocalizedCopy();
            }
            String libLocation = copy.getLibLocation();
            if (libLocation == null) {
                return copy.getLocalizedCopy();
            }
            if (!libLocation.equals(lib.getLocation())) {
                return copy.getLocalizedCopy();
            }
            Library copiedLib = copiedRoot.getLibraryWithNamespace(nameSpace);
            if (copiedLib == null) {
                return copy.getLocalizedCopy();
            }
            if (!libLocation.equals(copiedLib.getLocation())) {
                return copy.getLocalizedCopy();
            }
            DesignElement libElement = lib.getElementByID(extendsElementID);
            if (libElement == null) {
                return copy.getLocalizedCopy();
            }
            DesignElement copyLibElement = copiedLib.getElementByID(extendsElementID);
            if (libElement.getDefn() != copyLibElement.getDefn()) {
                return copy.getLocalizedCopy();
            }
        }
        return copy.getCopy();
    }

    public void copyPropertyBindings(IElementCopy copy, DesignElementHandle target) throws SemanticException {
        if (target == null || target.getRoot() == null || target.getRoot().getPropertyDefn("propertyBindings") == null) {
            return;
        }
        for (PropertyBinding propBinding : ((ContextCopiedElement)copy).getPropertyBindings()) {
            target.setPropertyBinding(propBinding.getName(), propBinding.getExpressionProperty("value"));
        }
    }
}

