/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.doc.legacy;

import java.io.FileNotFoundException;
import org.eclipse.birt.doc.legacy.SpecChoice;
import org.eclipse.birt.doc.legacy.SpecElement;
import org.eclipse.birt.doc.legacy.SpecInheritedProperty;
import org.eclipse.birt.doc.legacy.SpecMethod;
import org.eclipse.birt.doc.legacy.SpecProperty;
import org.eclipse.birt.doc.legacy.SpecSlot;
import org.eclipse.birt.doc.util.HtmlDocReader;

public class LegacySpecParser
extends HtmlDocReader {
    protected SpecElement element = new SpecElement();
    static String DESIGN_OBJECT = "JavaScript Design-time Object:";
    static String DESIGN_OBJECT2 = "Design Object:";
    static String RUNTIME_OBJECT = "JavaScript Runtime Object:";
    static String RUNTIME_OBJECT2 = "Runtime Object:";
    static String AVAILABILITY = "Availability:";
    static String BASE_ELEMENT = "Base Element:";
    private static final String XML_ELEMENT_NAME = "XML Element Name:";
    private static final String STYLE_NAME = "Predefined Style Name:";
    private static final String CARDINALITY = "Cardinality:";
    static final String DISPLAY_NAME = "Display Name:";
    static final String ROM_TYPE = "ROM Type:";
    static final String JS_TYPE = "JavaScript Type:";
    static final String DEFAULT_VALUE = "Default value:";
    static final String INHERITED = "Inherited:";
    static final String RUNTIME_SETTABLE = "Settable at runtime:";
    private static final String EXPRESSION_TYPE = "Expression type:";
    private static final String CONTEXT = "Context:";
    private static final String CONTEXT2 = "Expression Context:";
    private static final String ELEMENT_NAME = "Element Name:";
    private static final String USER_VISIBLE = "User Visible:";
    private static final String DEFAULT_STYLE = "Default Style:";
    private static final String REQUIRED = "Required:";
    private static final String DESIGNER_VISIBLE = "Visible in BIRT designer:";

    public void parse(String fileName, int itemType) throws FileNotFoundException {
        this.element.type = itemType;
        this.parser.open(fileName);
        int posn = fileName.lastIndexOf(46);
        if (posn != -1) {
            this.element.name = fileName.substring(0, posn);
            posn = this.element.name.lastIndexOf("/");
            if (posn != -1) {
                this.element.name = this.element.name.substring(posn + 1);
            }
        }
        this.skipTo("body");
        this.parseHeader();
        this.parseSummaryText();
        this.parseBlocks();
        this.parseProps();
        this.parser.close();
    }

    private String label(SpecElement element) {
        String label = "[" + Integer.toString(this.parser.getLineNo()) + "] ";
        label = element.type == 0 ? String.valueOf(label) + "Element " : String.valueOf(label) + "Structure ";
        label = String.valueOf(label) + element.name + ": ";
        return label;
    }

    private void warning(SpecElement element, String msg) {
        System.out.print(this.label(element));
        System.out.println(msg);
    }

    private void error(SpecElement element, String msg) {
        System.err.print(this.label(element));
        System.err.println(msg);
    }

    private String label(SpecElement element, SpecProperty prop) {
        return "[" + Integer.toString(this.parser.getLineNo()) + "] Property " + element.name + "." + prop.name + ": ";
    }

    private void warning(SpecElement element, SpecProperty prop, String msg) {
        System.out.print(this.label(element, prop));
        System.out.println(msg);
    }

    private void error(SpecElement element, SpecProperty prop, String msg) {
        System.err.print(this.label(element, prop));
        System.err.println(msg);
    }

    private String label(SpecElement element, SpecMethod method) {
        return "[" + Integer.toString(this.parser.getLineNo()) + "] Method " + element.name + "." + method.name + ": ";
    }

    private void warning(SpecElement element, SpecMethod method, String msg) {
        System.out.print(this.label(element, method));
        System.out.println(msg);
    }

    private String label(SpecElement element, SpecSlot slot) {
        return "[" + Integer.toString(this.parser.getLineNo()) + "] Method " + element.name + "." + slot.name + ": ";
    }

    private void warning(SpecElement element, SpecSlot slot, String msg) {
        System.out.print(this.label(element, slot));
        System.out.println(msg);
    }

    private String getHeaderText(String text) {
        int posn = text.lastIndexOf("&nbsp;");
        if (posn != -1) {
            text = text.substring(posn + 6);
        }
        return text;
    }

    private void parseHeader() {
        this.skipTo("h2");
        this.element.displayName = this.getHeaderText(this.getTextTo("/h2", true));
    }

    private void parseSummaryText() {
        int token = this.getToken();
        if (!this.isPara(token, "MsoBodyText")) {
            this.pushToken(token);
            return;
        }
        this.element.summary = this.getTextTo("/p");
    }

    protected String copyBlock() {
        int token;
        this.parser.ignoreWhitespace(false);
        StringBuffer text = new StringBuffer();
        boolean inCell = false;
        boolean inHead = false;
        boolean inCode = false;
        boolean inIgnore = false;
        boolean inList = false;
        while ((token = this.getToken()) != -1) {
            String value;
            if (token == 1) {
                String fragment = this.parser.getTokenText();
                if (fragment.equals("&nbsp;")) continue;
                text.append(fragment);
                continue;
            }
            if (token != 3) continue;
            if (this.isPara(token, "ManpageTitle")) {
                this.pushToken(token);
                break;
            }
            String tag = this.parser.getTokenText().toLowerCase();
            if (this.isBlockEnd(tag)) {
                this.pushToken(token);
                break;
            }
            if (tag.equals("thead")) {
                inHead = true;
            } else if (tag.equals("/thead")) {
                inHead = false;
            }
            if (tag.equals("p")) {
                value = this.parser.getAttrib("class");
                if (value != null && value.equals("Bullet")) {
                    if (!inList) {
                        text.append("\n<ul>\n");
                    }
                    inList = true;
                    text.append("<li>");
                    token = this.getToken();
                    if (this.isElement(token, "span")) {
                        token = this.getToken();
                        if (token != 1) {
                            this.pushToken(token);
                        }
                    } else {
                        this.pushToken(token);
                    }
                    value = this.getTextTo("/p", true);
                    while (value.startsWith("&nbsp;")) {
                        value = value.substring(6);
                    }
                    text.append(value.trim());
                    text.append("</li>\n");
                    continue;
                }
                if (inCell) continue;
                if (inList) {
                    text.append("</ul>\n");
                }
                inList = false;
                text.append("<p>");
                continue;
            }
            if (tag.equals("span")) {
                value = this.parser.getAttrib("class");
                if (value != null && value.equals("CodeText")) {
                    text.append("<code>");
                    inCode = true;
                    continue;
                }
                value = this.parser.getAttrib("style");
                if (value == null) {
                    text.append(this.parser.getFullElement());
                    continue;
                }
                if (value.startsWith("font-weight: normal") || value.startsWith("font-style: normal;")) {
                    inIgnore = true;
                    continue;
                }
                if (inList) {
                    text.append("</ul>\n");
                    inList = false;
                }
                text.append(this.parser.getFullElement());
                continue;
            }
            if (tag.equals("/span")) {
                if (inCode) {
                    text.append("</code>");
                    inCode = false;
                    continue;
                }
                if (inIgnore) {
                    inIgnore = false;
                    continue;
                }
                text.append(this.parser.getFullElement());
                continue;
            }
            if (tag.equals("/p")) {
                if (inCell) continue;
                text.append("</p>");
                continue;
            }
            if (tag.equals("b") || tag.equals("/b")) {
                if (inHead) continue;
                text.append(this.parser.getFullElement());
                continue;
            }
            if (tag.equals("a") || tag.equals("/a")) continue;
            if (tag.equals("table")) {
                text.append("<table class=\"section-table\">");
                continue;
            }
            if (tag.equals("tr")) {
                text.append("<tr>");
                continue;
            }
            if (tag.equals("td")) {
                inCell = true;
                text.append("<td");
                value = this.parser.getAttrib("rowspan");
                if (!this.isBlank(value)) {
                    text.append(" rowspan=\"" + value + "\"");
                }
                if (!this.isBlank(value = this.parser.getAttrib("colspan"))) {
                    text.append(" colspan=\"" + value + "\"");
                }
                text.append(">");
                continue;
            }
            text.append(this.parser.getFullElement());
            if (tag.equals("/td") || tag.equals("/tr")) {
                inCell = false;
                continue;
            }
            if (!tag.equals("/table")) continue;
            inCell = false;
            inHead = false;
        }
        if (inList) {
            text.append("</ul>\n");
        }
        this.parser.ignoreWhitespace(true);
        return text.toString().trim();
    }

    private void parseBlocks() {
        while (true) {
            int token;
            if (!this.isPara(token = this.getToken(), "ManpageTitle")) {
                this.pushToken(token);
                return;
            }
            String heading = this.getTextTo("/p", true);
            if (heading.equalsIgnoreCase("Summary")) {
                this.parseSummaryBlock();
                continue;
            }
            if (heading.equalsIgnoreCase("Inherited Properties")) {
                this.parseInheritedPropertyBlock();
                continue;
            }
            if (heading.equalsIgnoreCase("Properties")) {
                this.parsePropertyBlock();
                continue;
            }
            if (heading.equalsIgnoreCase("Methods")) {
                this.parseMethodBlock();
                continue;
            }
            if (heading.equalsIgnoreCase("Contents")) {
                this.parseSlotBlock();
                continue;
            }
            if (heading.equalsIgnoreCase("Description")) {
                this.element.description = this.append(this.element.description, this.parseTextBlock());
                continue;
            }
            if (heading.equalsIgnoreCase("XML Summary")) {
                this.element.xmlSummary = this.parseTextBlock();
                continue;
            }
            if (heading.equalsIgnoreCase("See Also")) {
                this.element.seeAlso = this.parseTextBlock();
                continue;
            }
            this.warning(this.element, "Unrecognized header: " + heading);
            this.element.description = this.append(this.element.description, "\n\n<h4>" + heading + "</h4>\n\n" + this.copyBlock() + "\n");
        }
    }

    private void skipBlock() {
        int token;
        while ((token = this.getToken()) != -1) {
            if (token != 3) continue;
            if (this.isPara(token, "ManpageTitle")) {
                this.pushToken(token);
                break;
            }
            String tag = this.parser.getTokenText().toLowerCase();
            if (!this.isBlockEnd(tag)) continue;
            this.pushToken(token);
            break;
        }
    }

    private String getSince(String text) {
        if (text.indexOf("Not in") != -1) {
            return "reserved";
        }
        if (text.indexOf("After the") != -1) {
            return "reserved";
        }
        return "1.0";
    }

    private void parseSummaryBlock() {
        int token = this.getToken();
        while (this.isPara(token, "MsoBodyText")) {
            String tail;
            String line = this.getTextTo("/p", true);
            if (this.startsWith(line, DESIGN_OBJECT)) {
                this.element.designObjName = this.getObjName(this.getTail(line, DESIGN_OBJECT));
            } else if (this.startsWith(line, DESIGN_OBJECT2)) {
                this.element.designObjName = this.getObjName(this.getTail(line, DESIGN_OBJECT2));
            } else if (this.startsWith(line, RUNTIME_OBJECT)) {
                this.element.stateObjName = this.getObjName(this.getTail(line, RUNTIME_OBJECT));
            } else if (this.startsWith(line, RUNTIME_OBJECT2)) {
                this.element.stateObjName = this.getObjName(this.getTail(line, RUNTIME_OBJECT2));
            } else if (this.startsWith(line, XML_ELEMENT_NAME)) {
                this.element.xmlElement = this.getTail(line, XML_ELEMENT_NAME);
            } else if (this.startsWith(line, STYLE_NAME)) {
                this.element.styleNames = this.getTail(line, STYLE_NAME);
            } else if (this.startsWith(line, AVAILABILITY)) {
                tail = this.getTail(line, AVAILABILITY);
                this.element.since = this.getSince(tail);
            } else if (!this.startsWith(line, BASE_ELEMENT)) {
                if (this.startsWith(line, DISPLAY_NAME)) {
                    tail = this.getObjName(this.getTail(line, DISPLAY_NAME));
                    if (!tail.equals(this.element.displayName)) {
                        tail = String.valueOf(tail) + " " + this.element.getTypeName();
                    }
                    if (!tail.equals(this.element.displayName)) {
                        this.error(this.element, "Display name: " + tail + " Does not match heading " + this.element.displayName);
                    }
                } else {
                    this.warning(this.element, "Unrecognized summary header: " + line);
                }
            }
            token = this.getToken();
        }
        this.pushToken(token);
    }

    private String getObjName(String name) {
        int posn = name.indexOf("(");
        if (posn != -1) {
            name = name.substring(0, posn - 1);
        }
        return name.trim();
    }

    public SpecElement getElement() {
        return this.element;
    }

    private String[] getMemberBlock() {
        int token = this.getToken();
        String[] fields = new String[2];
        if (this.isPara(token, "Property")) {
            fields[0] = this.getTextTo("/p", true);
        } else if (this.isPara(token, "MsoBodyText")) {
            fields[0] = this.getTextTo("/p", false);
            if (fields[0].startsWith("<code>")) {
                fields[0] = this.strip(fields[0], "code");
            }
        } else {
            this.pushToken(token);
            return null;
        }
        token = this.getToken();
        if (this.isPara(token, "PropertyDescrip")) {
            fields[1] = this.getTextTo("/p");
        }
        return fields;
    }

    private void parseInheritedPropertyBlock() {
        String[] fields;
        while ((fields = this.getMemberBlock()) != null) {
            SpecInheritedProperty prop = new SpecInheritedProperty();
            prop.name = fields[0];
            prop.description = fields[1];
            this.element.addInheritedProperty(prop);
        }
        return;
    }

    private void parsePropertyBlock() {
        String[] fields;
        while ((fields = this.getMemberBlock()) != null) {
            SpecProperty prop = new SpecProperty();
            prop.name = fields[0];
            prop.isArray = 2;
            if (prop.name.endsWith("[]")) {
                prop.name = prop.name.substring(0, prop.name.length() - 2);
                prop.isArray = 1;
            } else if (prop.name.endsWith("[ ]")) {
                prop.name = prop.name.substring(0, prop.name.length() - 3);
                prop.isArray = 1;
            }
            prop.shortDescrip = fields[1];
            if (prop.name.startsWith("<i>")) continue;
            this.element.addProperty(prop);
        }
        return;
    }

    private void parseMethodBlock() {
        String[] fields;
        while ((fields = this.getMemberBlock()) != null) {
            SpecMethod method = new SpecMethod();
            method.name = fields[0];
            method.shortDescrip = fields[1];
            this.element.addMethod(method);
        }
        return;
    }

    private void parseSlotBlock() {
        String[] fields;
        while ((fields = this.getMemberBlock()) != null) {
            SpecSlot slot = new SpecSlot();
            slot.name = fields[0];
            slot.shortDescrip = fields[1];
            this.element.addSlot(slot);
        }
        return;
    }

    private String parseDescripBlock() {
        return this.copyBlock();
    }

    private String parseTextBlock() {
        return this.strip(this.parseDescripBlock(), "p");
    }

    private void parseProps() {
        int token;
        while ((token = this.getToken()) == 3 && this.parser.getTokenText().equalsIgnoreCase("h3")) {
            String heading = this.getHeaderText(this.getTextTo("/h3", true));
            if ((heading = heading.trim()).endsWith("Property")) {
                heading = heading.substring(0, heading.length() - 9);
                this.parseProperty(heading);
                continue;
            }
            if (heading.endsWith("Method")) {
                heading = heading.substring(0, heading.length() - 7);
                this.parseMethod(heading);
                continue;
            }
            if (heading.endsWith("Slot")) {
                heading = heading.substring(0, heading.length() - 5);
                this.parseSlot(heading);
                continue;
            }
            this.warning(this.element, ": Unrecognized h3 header: " + heading);
        }
    }

    private void parseProperty(String propName) {
        int token;
        SpecProperty prop = this.element.getProperty(propName);
        if (prop == null) {
            prop = new SpecProperty();
            prop.name = propName;
            this.element.addProperty(prop);
        }
        if (this.isPara(token = this.getToken(), "MsoBodyText")) {
            prop.summary = this.getTextTo("/p", true);
            token = this.getToken();
        }
        while (true) {
            if (!this.isPara(token, "ManpageTitle")) {
                this.pushToken(token);
                return;
            }
            String heading = this.getTextTo("/p", true);
            if (heading.equalsIgnoreCase("Synopsis")) {
                this.skipBlock();
            } else if (heading.equalsIgnoreCase("Summary")) {
                this.parsePropertySummaryBlock(prop);
            } else if (heading.equalsIgnoreCase("ROM Summary")) {
                this.parsePropertySummaryBlock(prop);
            } else if (heading.equalsIgnoreCase("Description")) {
                prop.description = this.append(prop.description, this.parseTextBlock());
            } else if (heading.equalsIgnoreCase("See Also")) {
                prop.seeAlso = this.parseTextBlock();
            } else if (heading.equalsIgnoreCase("Choices")) {
                this.parseChoices(prop);
            } else if (heading.equalsIgnoreCase("Runtime Scripting") || heading.equalsIgnoreCase("XML Summary")) {
                prop.description = this.append(prop.description, "\n\n<h4>" + heading + "</h4>\n\n" + this.copyBlock() + "\n");
            } else if (!heading.equals("&nbsp;")) {
                this.warning(this.element, prop, "Unrecognized property header: " + heading);
                prop.description = this.append(prop.description, "\n\n<h4>" + heading + "</h4>\n\n" + this.copyBlock() + "\n");
            }
            token = this.getToken();
        }
    }

    private void parsePropertySummaryBlock(SpecProperty prop) {
        int token = this.getToken();
        while (this.isPara(token, "MsoBodyText")) {
            String tail;
            String line = this.getTextTo("/p", true);
            if (this.startsWith(line, DISPLAY_NAME)) {
                prop.displayName = this.getTail(line, DISPLAY_NAME);
            } else if (this.startsWith(line, ROM_TYPE)) {
                prop.romType = this.getTail(line, ROM_TYPE);
            } else if (this.startsWith(line, REQUIRED)) {
                tail = this.getTail(line, REQUIRED);
                prop.required = tail.indexOf("Yes") != -1 ? 1 : 2;
            } else if (line.equals("Required.")) {
                prop.required = 1;
            } else if (!this.startsWith(line, "Name") && !this.startsWith(line, "Type")) {
                if (this.startsWith(line, JS_TYPE)) {
                    tail = this.getTail(line, JS_TYPE);
                    prop.isArray = 2;
                    if (tail.startsWith("Array of ")) {
                        tail = tail.substring(9);
                        prop.isArray = 1;
                        if (tail.endsWith("objects")) {
                            tail = tail.substring(0, tail.length() - 8);
                        }
                    }
                    prop.jsType = tail.trim();
                } else if (this.startsWith(line, DEFAULT_VALUE)) {
                    tail = this.getTail(line, DEFAULT_VALUE);
                    if (!tail.startsWith("None") && !tail.equalsIgnoreCase("See Description.")) {
                        prop.defaultValue = tail.toLowerCase();
                    }
                } else if (this.startsWith(line, EXPRESSION_TYPE)) {
                    prop.exprType = this.getObjName(this.getTail(line, EXPRESSION_TYPE));
                } else if (this.startsWith(line, INHERITED)) {
                    tail = this.getTail(line, INHERITED);
                    prop.inherited = tail.indexOf("Yes") != -1 ? 1 : 2;
                } else if (this.startsWith(line, RUNTIME_SETTABLE)) {
                    tail = this.getTail(line, RUNTIME_SETTABLE);
                    prop.runtimeSettable = tail.indexOf("Yes") != -1 ? 1 : 2;
                } else if (this.startsWith(line, USER_VISIBLE)) {
                    tail = this.getTail(line, USER_VISIBLE);
                    prop.runtimeSettable = tail.indexOf("Yes") != -1 ? 2 : 1;
                } else if (this.startsWith(line, DESIGNER_VISIBLE)) {
                    tail = this.getTail(line, DESIGNER_VISIBLE);
                    prop.runtimeSettable = tail.indexOf("Yes") != -1 ? 2 : 1;
                } else if (this.startsWith(line, AVAILABILITY)) {
                    tail = this.getTail(line, AVAILABILITY);
                    prop.since = this.getSince(tail);
                } else if (this.startsWith(line, CONTEXT2)) {
                    prop.exprContext = this.getTail(line, CONTEXT2);
                } else {
                    this.warning(this.element, prop, "Unrecognized summary header: " + line);
                    prop.description = this.append(prop.description, "\n<br>\n" + line);
                }
            }
            token = this.getToken();
        }
        this.pushToken(token);
    }

    private void parseChoices(SpecProperty prop) {
        block5: {
            String tag;
            this.skipTo("table");
            int token = this.getToken();
            if (this.isElement(token, "thead")) {
                this.skipTo("/thead");
            } else {
                this.skipTo("/tr");
            }
            String descrip = null;
            while (true) {
                if ((token = this.getToken()) != 3) {
                    continue;
                }
                tag = this.parser.getTokenText().toLowerCase();
                if (tag.equals("/table")) break block5;
                if (!tag.equals("tr")) {
                    this.error(this.element, prop, "Unexpected tag in table: " + tag);
                    break block5;
                }
                String value = this.getCell(prop, null, true);
                if (value == null) break block5;
                SpecChoice choice = new SpecChoice();
                choice.displayName = value;
                value = this.getCell(prop, null, true);
                if (value == null) break block5;
                choice.name = value;
                choice.description = descrip = this.getCell(prop, descrip, false);
                prop.addChoice(choice);
                token = this.getToken();
                tag = this.parser.getTokenText().toLowerCase();
                if (!tag.equals("/tr")) break;
            }
            this.error(this.element, prop, "Unexpected tag in table: " + tag);
        }
        this.skipBlock();
    }

    private String getCell(SpecProperty prop, String prev, boolean textOnly) {
        StringBuffer text;
        block6: {
            int token = this.getToken();
            if (token != 3) {
                this.error(this.element, prop, "Unexpected token in table");
                return null;
            }
            String tag = this.parser.getTokenText().toLowerCase();
            if (tag.equals("/tr") || tag.equals("/table") || tag.equals("tr")) {
                this.pushToken(token);
                return prev;
            }
            if (!tag.equals("td")) {
                this.error(this.element, prop, "Unexpected tag in table: " + tag);
                return null;
            }
            text = new StringBuffer();
            while (true) {
                if ((token = this.getToken()) == 3 && this.parser.getTokenText().equals("p")) {
                    continue;
                }
                if (token == 3 && this.parser.getTokenText().equals("/td")) break block6;
                if (token == 3) {
                    if (textOnly) continue;
                    text.append(this.parser.getFullElement());
                    continue;
                }
                if (token != 1) break;
                text.append(this.parser.getTokenText());
            }
            this.error(this.element, prop, "Unexpected token in table");
            return null;
        }
        return text.toString().trim();
    }

    private void parseMethod(String methodName) {
        int token;
        SpecMethod method = this.element.getMethod(methodName);
        if (method == null) {
            method = new SpecMethod();
            method.name = methodName;
            this.element.addMethod(method);
        }
        if (this.isPara(token = this.getToken(), "MsoBodyText")) {
            method.summary = this.getTextTo("/p", true);
            token = this.getToken();
        }
        while (true) {
            if (!this.isPara(token, "ManpageTitle")) {
                this.pushToken(token);
                return;
            }
            String heading = this.getTextTo("/p", true);
            if (heading.equalsIgnoreCase("Synopsis")) {
                this.skipBlock();
            } else if (heading.equalsIgnoreCase("Summary")) {
                this.parseMethodSummaryBlock(method);
            } else if (heading.equalsIgnoreCase("Description")) {
                method.description = this.append(method.description, this.parseTextBlock());
            } else if (heading.equalsIgnoreCase("See Also")) {
                method.seeAlso = this.parseTextBlock();
            } else if (heading.equalsIgnoreCase("Returns")) {
                method.returns = this.parseTextBlock();
            } else if (heading.equalsIgnoreCase("Arguments")) {
                String args = this.parseTextBlock();
                if (!args.equalsIgnoreCase("None")) {
                    this.warning(this.element, method, "Arguments not yet supported");
                }
            } else {
                this.warning(this.element, method, "Unrecognized method header: " + heading);
                method.description = this.append(method.description, "\n\n<h4>" + heading + "</h4>\n\n" + this.copyBlock() + "\n");
            }
            token = this.getToken();
        }
    }

    private void parseMethodSummaryBlock(SpecMethod method) {
        int token = this.getToken();
        while (this.isPara(token, "MsoBodyText")) {
            String line = this.getTextTo("/p", true);
            if (this.startsWith(line, DISPLAY_NAME)) {
                method.displayName = this.getTail(line, DISPLAY_NAME);
            } else if (this.startsWith(line, AVAILABILITY)) {
                String tail = this.getTail(line, AVAILABILITY);
                method.since = this.getSince(tail);
            } else if (this.startsWith(line, CONTEXT)) {
                method.context = this.getTail(line, CONTEXT);
            } else {
                this.warning(this.element, method, "Unrecognized method summary header: " + line);
            }
            token = this.getToken();
        }
        this.pushToken(token);
    }

    private void parseSlot(String slotName) {
        int token;
        SpecSlot slot = this.element.getSlot(slotName);
        if (slot == null) {
            slot = new SpecSlot();
            slot.name = slotName;
            this.element.addSlot(slot);
        }
        if (this.isPara(token = this.getToken(), "MsoBodyText")) {
            slot.summary = this.getTextTo("/p", true);
            token = this.getToken();
        }
        while (true) {
            if (!this.isPara(token, "ManpageTitle")) {
                this.pushToken(token);
                return;
            }
            String heading = this.getTextTo("/p", true);
            if (heading.equalsIgnoreCase("Summary")) {
                this.parseSlotSummaryBlock(slot);
            } else if (heading.equalsIgnoreCase("Description")) {
                slot.description = this.append(slot.description, this.parseTextBlock());
            } else if (heading.equalsIgnoreCase("Contents")) {
                slot.contents = this.parseTextBlock();
            } else if (heading.equalsIgnoreCase("XML Summary")) {
                this.parseSlotSummaryBlock(slot);
            } else if (heading.equalsIgnoreCase("See Also")) {
                slot.seeAlso = this.parseTextBlock();
            } else {
                this.warning(this.element, slot, "Unrecognized method header: " + heading);
                slot.description = this.append(slot.description, "\n\n<h4>" + heading + "</h4>\n\n" + this.copyBlock() + "\n");
            }
            token = this.getToken();
        }
    }

    private void parseSlotSummaryBlock(SpecSlot slot) {
        int token = this.getToken();
        while (this.isPara(token, "MsoBodyText")) {
            String tail;
            String line = this.getTextTo("/p", true);
            if (this.startsWith(line, DISPLAY_NAME)) {
                slot.displayName = this.getTail(line, DISPLAY_NAME);
            } else if (this.startsWith(line, AVAILABILITY)) {
                tail = this.getTail(line, AVAILABILITY);
                slot.since = this.getSince(tail);
            } else if (this.startsWith(line, CARDINALITY)) {
                tail = this.getTail(line, CARDINALITY);
                slot.cardinality = tail.equalsIgnoreCase("Multiple") ? 2 : 1;
            } else if (this.startsWith(line, ELEMENT_NAME)) {
                slot.xmlElement = this.getTail(line, ELEMENT_NAME);
            } else if (this.startsWith(line, XML_ELEMENT_NAME)) {
                slot.xmlElement = this.getTail(line, XML_ELEMENT_NAME);
            } else if (this.startsWith(line, DEFAULT_STYLE)) {
                slot.styleNames = this.getTail(line, DEFAULT_STYLE);
            } else {
                this.warning(this.element, slot, "Unrecognized method summary header: " + line);
            }
            token = this.getToken();
        }
        this.pushToken(token);
    }
}

