/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.integrate;

import java.io.IOException;
import org.eclipse.birt.chart.integrate.SimpleActionHandle;
import org.eclipse.birt.chart.integrate.SimpleActionUtil;
import org.eclipse.birt.chart.ui.i18n.Messages;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SimpleHyperlinkBuilder
extends TrayDialog {
    private Button noneRadio;
    private Button uriRadio;
    private static final String RADIO_NONE = Messages.getString("SimpleHyperlinkBuilder.Label.RadioNone");
    private static final String RADIO_URI = Messages.getString("SimpleHyperlinkBuilder.Label.RadioURI");
    private static final String TITLE = Messages.getString("SimpleHyperlinkBuilder.Title");
    private static final String LABEL_SELECT_TYPE = Messages.getString("SimpleHyperlinkBuilder.Label.SelectType");
    private static final String LABEL_LOCATION = Messages.getString("SimpleHyperlinkBuilder.Label.Location");
    private static final String LABEL_TARGET = Messages.getString("SimpleHyperlinkBuilder.Label.Target");
    private static final String REQUIED_MARK = "*";
    private Composite displayArea;
    private Text locationEditor;
    private Combo targetChooser;
    private SimpleActionHandle inputHandle;

    protected SimpleHyperlinkBuilder(Shell shell) {
        super(shell);
    }

    public String getResultString() throws IOException {
        return SimpleActionUtil.serializeAction((SimpleActionHandle)this.inputHandle);
    }

    public void setInputString(String input) {
        this.setInput(SimpleActionUtil.deserializeAction((String)input));
    }

    public String getTitle() {
        return this.getShell().getText();
    }

    public void setTitle(String title) {
        this.getShell().setText(title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.setTitle(TITLE);
        this.createSelectionArea(composite);
        new Label(composite, 258).setLayoutData((Object)new GridData(768));
        this.displayArea = new Composite(composite, 0);
        this.displayArea.setLayoutData((Object)new GridData(400, 300));
        new Label(composite, 258).setLayoutData((Object)new GridData(768));
        if (this.inputHandle.getTargetWindow().length() > 0) {
            this.uriRadio.setSelection(true);
            this.uriRadio.notifyListeners(13, new Event());
        }
        return composite;
    }

    private void createSelectionArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(2, false));
        new Label(composite, 0).setText(LABEL_SELECT_TYPE);
        this.noneRadio = new Button(composite, 16);
        this.noneRadio.setText(RADIO_NONE);
        this.noneRadio.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SimpleHyperlinkBuilder.this.clearArea();
            }
        });
        new Label(composite, 0);
        this.uriRadio = new Button(composite, 16);
        this.uriRadio.setText(RADIO_URI);
        this.uriRadio.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SimpleHyperlinkBuilder.this.clearArea();
                SimpleHyperlinkBuilder.this.displayArea.setLayout((Layout)new GridLayout(2, false));
                new Label(SimpleHyperlinkBuilder.this.displayArea, 0).setText(SimpleHyperlinkBuilder.REQUIED_MARK + LABEL_LOCATION);
                SimpleHyperlinkBuilder.this.locationEditor = new Text(SimpleHyperlinkBuilder.this.displayArea, 2052);
                SimpleHyperlinkBuilder.this.locationEditor.setLayoutData((Object)new GridData(768));
                SimpleHyperlinkBuilder.this.locationEditor.setText(SimpleHyperlinkBuilder.this.inputHandle.getURI());
                SimpleHyperlinkBuilder.this.createTargetBar();
                SimpleHyperlinkBuilder.this.displayArea.layout();
            }
        });
    }

    private void createTargetBar() {
        new Label(this.displayArea, 0).setText(LABEL_TARGET);
        this.targetChooser = new Combo(this.displayArea, 2056);
        this.targetChooser.setLayoutData((Object)new GridData(768));
        this.targetChooser.setItems(new String[]{"_blank", "_parent", "_self", "_top"});
        if (this.inputHandle.getTargetWindow().length() > 0) {
            this.targetChooser.setText(this.inputHandle.getTargetWindow());
        } else {
            this.targetChooser.select(0);
        }
    }

    private void clearArea() {
        Control[] controls = this.displayArea.getChildren();
        int i = 0;
        while (i < controls.length) {
            controls[i].dispose();
            ++i;
        }
    }

    public void setInput(SimpleActionHandle input) {
        this.inputHandle = input;
    }

    protected void okPressed() {
        if (this.noneRadio.getSelection()) {
            this.inputHandle = null;
        } else {
            this.inputHandle.setURI(this.locationEditor.getText().trim());
            this.inputHandle.setTargetWindow(this.targetChooser.getText());
        }
        super.okPressed();
    }
}

