/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkCustomConverter;
import org.eclipse.jpt.eclipselink.core.internal.DefaultEclipseLinkJpaValidationMessages;
import org.eclipse.jpt.eclipselink.core.internal.context.java.JavaEclipseLinkConverter;
import org.eclipse.jpt.eclipselink.core.resource.java.EclipseLinkConverterAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaEclipseLinkCustomConverter
extends JavaEclipseLinkConverter
implements EclipseLinkCustomConverter {
    private String converterClass;
    private String fullyQualifiedConverterClass;
    public static final String FULLY_QUALIFIED_CONVERTER_CLASS_PROPERTY = "fullyQualifiedConverterClass";

    public JavaEclipseLinkCustomConverter(JavaJpaContextNode parent) {
        super(parent);
    }

    @Override
    public String getType() {
        return "customConverter";
    }

    @Override
    public String getAnnotationName() {
        return "org.eclipse.persistence.annotations.Converter";
    }

    @Override
    protected EclipseLinkConverterAnnotation getAnnotation() {
        return (EclipseLinkConverterAnnotation)super.getAnnotation();
    }

    @Override
    public String getConverterClass() {
        return this.converterClass;
    }

    @Override
    public void setConverterClass(String newConverterClass) {
        String oldConverterClass = this.converterClass;
        this.converterClass = newConverterClass;
        this.getAnnotation().setConverterClass(newConverterClass);
        this.firePropertyChanged("converterClass", oldConverterClass, newConverterClass);
    }

    protected void setConverterClass_(String newConverterClass) {
        String oldConverterClass = this.converterClass;
        this.converterClass = newConverterClass;
        this.firePropertyChanged("converterClass", oldConverterClass, newConverterClass);
    }

    public String getFullyQualifiedConverterClass() {
        return this.fullyQualifiedConverterClass;
    }

    protected void setFullyQualifiedConverterClass(String converterClass) {
        String old = this.fullyQualifiedConverterClass;
        this.fullyQualifiedConverterClass = converterClass;
        this.firePropertyChanged(FULLY_QUALIFIED_CONVERTER_CLASS_PROPERTY, old, converterClass);
    }

    protected String buildFullyQualifiedConverterClass(EclipseLinkConverterAnnotation resourceConverter) {
        return resourceConverter == null ? null : resourceConverter.getFullyQualifiedConverterClassName();
    }

    @Override
    protected void initialize(JavaResourcePersistentMember jrpm) {
        super.initialize(jrpm);
        EclipseLinkConverterAnnotation resourceConverter = this.getAnnotation();
        this.converterClass = this.converterClass(resourceConverter);
        this.fullyQualifiedConverterClass = this.buildFullyQualifiedConverterClass(resourceConverter);
    }

    @Override
    public void update(JavaResourcePersistentMember jrpm) {
        super.update(jrpm);
        EclipseLinkConverterAnnotation resourceConverter = this.getAnnotation();
        this.setConverterClass_(this.converterClass(resourceConverter));
        this.setFullyQualifiedConverterClass(this.buildFullyQualifiedConverterClass(resourceConverter));
    }

    protected String converterClass(EclipseLinkConverterAnnotation resourceConverter) {
        return resourceConverter == null ? null : resourceConverter.getConverterClass();
    }

    public TextRange getConverterClassTextRange(CompilationUnit astRoot) {
        return this.getAnnotation().getConverterClassTextRange(astRoot);
    }

    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateConverterClass(messages, astRoot);
    }

    protected void validateConverterClass(List<IMessage> messages, CompilationUnit astRoot) {
        if (this.converterClass == null) {
            return;
        }
        if (!this.getAnnotation().converterClassImplementsInterface("org.eclipse.persistence.mappings.converters.Converter", astRoot)) {
            messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(1, "CONVERTER_CLASS_IMPLEMENTS_CONVERTER", new String[]{this.converterClass}, this, this.getConverterClassTextRange(astRoot)));
        }
    }
}

