/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ase.catalog;

import java.sql.Connection;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogSchema;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEIndex;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.impl.SybaseASEUniqueConstraintImpl;
import org.eclipse.datatools.modelbase.sql.constraints.IndexMember;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASECatalogUniqueConstraint
extends SybaseASEUniqueConstraintImpl
implements ICatalogObject,
IAdaptable {
    private static final long serialVersionUID = 2468476166981904163L;
    private boolean isMemberLoaded = false;
    private boolean isSystemGenedIndexLoaded = false;

    public void refresh() {
        this.isMemberLoaded = false;
        this.isSystemGenedIndexLoaded = false;
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public Connection getConnection() {
        SybaseASECatalogSchema schema = (SybaseASECatalogSchema)this.getBaseTable().getSchema();
        return schema.getConnection();
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 14: {
                this.getSystemGenedIndex();
                break;
            }
            case 12: {
                this.getMembers();
            }
        }
        return super.eIsSet(eFeature);
    }

    public Database getCatalogDatabase() {
        return this.getBaseTable().getSchema().getDatabase();
    }

    public EList getMembers() {
        if (!this.isMemberLoaded) {
            this.loadMemebers();
        }
        return super.getMembers();
    }

    private void loadMemebers() {
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        EList members = super.getMembers();
        members.clear();
        SybaseASEIndex uniqueIndex = this.getSystemGenedIndex();
        EList indexMems = uniqueIndex.getMembers();
        int i = 0;
        while (i < indexMems.size()) {
            IndexMember mem = (IndexMember)indexMems.get(i);
            members.add((Object)mem.getColumn());
            ++i;
        }
        this.isMemberLoaded = true;
        this.eSetDeliver(deliver);
    }

    public SybaseASEIndex getSystemGenedIndex() {
        if (!this.isSystemGenedIndexLoaded) {
            this.loadSystemGenedIndex();
        }
        return super.getSystemGenedIndex();
    }

    private void loadSystemGenedIndex() {
        EList indexList = this.getBaseTable().getIndex();
        int i = 0;
        while (i < indexList.size()) {
            SybaseASEIndex index = (SybaseASEIndex)indexList.get(i);
            if (index.getName().equals(this.getName())) {
                super.setSystemGenedIndex(index);
                break;
            }
            ++i;
        }
    }

    public Object getAdapter(Class adapter) {
        Object adapterObject = Platform.getAdapterManager().getAdapter((Object)this, adapter);
        if (adapterObject == null) {
            adapterObject = Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
        }
        return adapterObject;
    }
}

