/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq;

import com.sun.messaging.jmq.resources.SharedResources;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;

public class Version {
    private static String[] patchTermsList = new String[]{"SP", "UR", "_", "U", "PATCH", "UPDATE"};
    private static HashSet patchTerms = new HashSet();
    private String propname = "/com/sun/messaging/jmq/version.properties";
    private static String imqhome_propname;
    private static final String IMQ_HOME;
    private static final String PATCHIDFILE;
    private Properties props = null;
    private String miniCopyright = "Copyright (c) 2007 Sun Microsystems, Inc.  All rights reserved.\nUse is subject to license terms.";
    private String shortCopyright = "Copyright (c) 2007 Sun Microsystems, Inc.  All rights reserved.\nU.S. Government Rights - Commercial software.\n\nGovernment users are subject to the Sun Microsystems, Inc. standard license\nagreement and applicable provisions of the FAR and its supplements.  Use is\nsubject to license terms.  This distribution may include materials developed\nby third parties.  Sun, Sun Microsystems, the Sun logo, Java, Solaris,\nSuntone, The Network is the Computer, We're the dot in .com and iForce\nare trademarks or registered trademarks of Sun Microsystems, Inc. in\nthe U.S. and other countries.  All SPARC trademarks are used under license\nand are trademarks or registered trademarks of SPARC International, Inc.\nin the U.S. and other countries.  UNIX is a registered trademark in the U.S.\nand other countries, exclusively licensed through X/Open Company, Ltd.\n\nCopyright (c) 2007 Sun Microsystems, Inc. Tous droits r\u00e9serv\u00e9s.\nL'utilisation est soumise aux termes du contrat de licence.  Cette\ndistribution peut comprendre des composants d\u00e9velopp\u00e9s\npar des tierces parties.  Sun, Sun Microsystems, le logo Sun, Java,\nSolaris, SunTone, The Network is the Computer, We're the dot in .com et\niForce sont des marques de fabrique ou des marques d\u00e9pos\u00e9es de\nSun Microsystems, Inc. aux Etats-Unis et dans d'autres pays.  Toutes les\nmarques SPARC sont utilis\u00e9es sous licence et sont des marques de fabrique\nou des marques d\u00e9pos\u00e9es de SPARC International, Inc. aux Etats-Unis\net dans d'autres pays.  UNIX est une marque d\u00e9pos\u00e9e aux Etats-Unis\net dans d'autres pays et licenci\u00e9e exlusivement par X/Open Company, Ltd.\n";
    private String longCopyright = "Copyright (c) 2007 Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,\nCalifornia 95054, U.S.A.  All rights reserved.\n\nU.S. Government Rights - Commercial software.  Government users are subject to\nthe Sun Microsystems, Inc. standard license agreement and applicable\nprovisions of the FAR and its supplements.  Use is subject to license terms.\nThis distribution may include materials developed by third parties.  Sun,\nSun Microsystems, the Sun logo, Java, Solaris, SunTone, The Network is the\nComputer, We're the dot in .com, iForce, Sun Java Enterprise System and\nSun Java Enterprise System are trademarks or registered trademarks of Sun\nMicrosystems, Inc. in the U.S. and other countries.  All SPARC trademarks are\nused under license and are trademarks or registered trademarks of SPARC\nInternational, Inc. in the U.S. and other countries.  Products bearing SPARC\ntrademarks are based upon architecture developed by Sun Microsystems, Inc.\nUNIX is a registered trademark in the U.S. and other countries, exclusively\nlicensed through X/Open Company, Ltd.  This product is covered and controlled\nby U.S. Export Control laws and may be subject to the export or import laws in\nother countries.  Nuclear, missile, chemical biological weapons or nuclear\nmaritime end uses or end users, whether direct or indirect, are strictly\nprohibited.  Export or reexport to countries subject to U.S. embargo or to\nentities identified on U.S. export exclusion lists, including, but not limited\nto, the denied persons and specially designated nationals lists is strictly\nprohibited.\nCopyright (c) 2007 Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,\nCalifornia 95054, Etats-Unis.  Tous droits r\u00e9serv\u00e9s.\n\nL'utilisation est soumise aux termes de la Licence.  Cette distribution peut\ncomprendre des composants d\u00e9velopp\u00e9s par des tierces parties.  Sun,\nSun Microsystems, le logo Sun, Java, Solaris, SunTone, The Network is the\nComputer, We're the dot in .com, iForce, Sun Java Enterprise System et Sun Java\nEnterprise System sont des marques de fabrique ou des marques d\u00e9pos\u00e9es\nde Sun Microsystems, Inc. aux Etats-Unis et dans d'autres pays.  Toutes les marques\nSPARC sont utilis\u00e9es sous licence et sont des marques de fabrique ou des\nmarques d\u00e9pos\u00e9es de SPARC International, Inc. aux Etats-Unis et dans\nd'autres pays.  Les produits portant les marques SPARC sont bas\u00e9s sur une\narchitecture d\u00e9velopp\u00e9e par Sun Microsystems, Inc.  UNIX est une marque\nd\u00e9pos\u00e9e aux Etats-Unis et dans d'autres pays et licenci\u00e9e\nexlusivement par X/Open Company, Ltd.  Ce produit est soumis \u00e0 la\nl\u00e9gislation am\u00e9ricaine en mati\u00e8re de contr\u00f4le des\nexportations et peut \u00eatre soumis \u00e0 la r\u00e8glementation en vigueur\ndans d'autres pays dans le domaine des exportations et importations.  Les\nutilisations, ou utilisateurs finaux, pour des armes nucl\u00e9aires, des missiles,\ndes armes biologiques et chimiques ou du nucl\u00e9aire maritime, directement ou\nindirectement, sont strictement interdites.  Les exportations ou r\u00e9exportations\nvers les pays sous embargo am\u00e9ricain, ou vers des entit\u00e9s figurant sur les\nlistes d'exclusion d'exportation am\u00e9ricaines, y compris, mais de mani\u00e8re\nnon exhaustive, la liste de personnes qui font objet d'un ordre de ne pas participer,\nd'une fa\u00e7on directe ou indirecte, aux exportations des produits ou des services\nqui sont r\u00e9gis  par la l\u00e9gislation am\u00e9ricaine en mati\u00e8re de\ncontr\u00f4le des exportations et la liste de ressortissants sp\u00e9cifiquement\nd\u00e9sign\u00e9s, sont rigoureusement interdites.\n";
    public static final int MINI_COPYRIGHT = 0;
    public static final int SHORT_COPYRIGHT = 1;
    public static final int LONG_COPYRIGHT = 2;
    private static String thisPackage;
    private static SharedResources rb;

    public Version() {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(this.propname);
            if (inputStream == null) {
                System.err.println(rb.getString("S3006"));
            }
            this.props = new Properties();
            this.props.load(inputStream);
        }
        catch (Exception exception) {
            System.err.println(rb.getString("S3007"));
            exception.printStackTrace();
        }
    }

    public Properties getProps() {
        return this.props;
    }

    public String getProductVersion() {
        return this.props.getProperty("imq.product.version");
    }

    public int getMajorVersion() {
        try {
            return Integer.parseInt(this.props.getProperty("imq.product.major"));
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int getMinorVersion() {
        try {
            return Integer.parseInt(this.props.getProperty("imq.product.minor"));
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public String getVersionProperty(String string) {
        return this.props.getProperty(string);
    }

    public String getBuildMilestone() {
        String string = this.props.getProperty("imq.build.milestone");
        if ("FCS".equals(string)) {
            return "";
        }
        return string;
    }

    public String getBuildDate() {
        return this.props.getProperty("imq.build.date");
    }

    public String getBuildVersion() {
        return this.props.getProperty("imq.product.version") + " " + this.getBuildMilestone() + " (Build " + this.props.getProperty("imq.build.number") + "-" + this.props.getProperty("imq.build.letter") + ")";
    }

    public String getProductName() {
        return this.props.getProperty("imq.product.name");
    }

    public String getReleaseQID() {
        return this.props.getProperty("imq.product.releaseqid");
    }

    public String getAbbreviatedProductName() {
        return this.props.getProperty("imq.product.name.abbrev");
    }

    public String getLowerCaseAbbreviatedProductName() {
        return this.props.getProperty("imq.product.name.abbrev.lowercase");
    }

    public String getShortProductName() {
        return this.props.getProperty("imq.product.name.short");
    }

    public String getProductCopyrightDate() {
        return this.props.getProperty("imq.product.copyright.date");
    }

    public String getProductCompanyName() {
        return this.props.getProperty("imq.product.companyname");
    }

    public String getVersionPackageName() {
        return this.props.getProperty("imq.version.package");
    }

    public String getImplementationVersion() {
        return this.props.getProperty("imq.api.version");
    }

    public String getProtocolVersion() {
        return this.props.getProperty("imq.protocol.version");
    }

    public String getTargetJMSVersion() {
        return this.props.getProperty("imq.jms.api.version");
    }

    public String getUserAgent() {
        return this.getShortProductName() + "/" + this.getProductVersion() + " " + "(JMS; " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + ")";
    }

    public String toString() {
        return this.getBanner(false);
    }

    public String getHeader() {
        return this.getHeader(2);
    }

    public String getHeader(int n) {
        return rb.getString("S1000") + this.getProductName() + " " + this.getReleaseQID() + SharedResources.NL + this.getProductCompanyName() + SharedResources.NL + rb.getString("S1001") + this.getBuildVersion() + SharedResources.NL + rb.getString("S1002") + this.getBuildDate() + SharedResources.NL + SharedResources.NL + this.getCopyright(n) + SharedResources.NL + rb.getString("S1000");
    }

    public String getCopyright(int n) {
        switch (n) {
            case 0: {
                return this.miniCopyright;
            }
            case 1: {
                return this.shortCopyright;
            }
            case 2: {
                return this.longCopyright;
            }
        }
        return this.shortCopyright;
    }

    public String[] getPatchIds() {
        String string;
        File file = new File(PATCHIDFILE);
        if (!file.exists()) {
            return null;
        }
        if (!file.canRead()) {
            return null;
        }
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(PATCHIDFILE);
            properties.load(fileInputStream);
        }
        catch (Exception exception) {
            return null;
        }
        String string2 = this.getMajorVersion() + "." + this.getMinorVersion();
        String[] stringArray = new String[1000];
        int n = 0;
        for (int i = 1; i < stringArray.length && (string = properties.getProperty(string2 + "_" + i)) != null; ++i) {
            stringArray[n++] = string;
        }
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = stringArray[i];
        }
        return stringArray2;
    }

    public String getPatchString() {
        String[] stringArray = this.getPatchIds();
        String string = "";
        if (stringArray == null) {
            string = "";
        } else if (stringArray.length == 0) {
            string = "";
        } else if (stringArray.length >= 1) {
            for (int i = 0; i < stringArray.length && stringArray[i] != null; ++i) {
                if (string.equals("")) {
                    string = string + rb.getString("S1009") + stringArray[i] + SharedResources.NL;
                    continue;
                }
                if (stringArray[i] == null) continue;
                string = string + rb.getString("S1010") + stringArray[i] + SharedResources.NL;
            }
        }
        return string;
    }

    public String getJMSAdminSpiVersion() {
        return this.props.getProperty("imq.jmsadmin.spi.version");
    }

    public String getVersion() {
        return this.getVersionPackageName() + rb.getString("S1004") + rb.getString("S1005") + this.getImplementationVersion() + SharedResources.NL + rb.getString("S1006") + this.getProtocolVersion() + SharedResources.NL + rb.getString("S1007") + this.getTargetJMSVersion() + SharedResources.NL + this.getPatchString();
    }

    public String getBanner(boolean bl) {
        return this.getBanner(bl, 1);
    }

    public String getBanner(boolean bl, int n) {
        if (this.props == null) {
            return rb.getString("S3008") + thisPackage;
        }
        if (bl) {
            return this.getHeader(n) + this.getVersion();
        }
        return this.getHeader(n);
    }

    public static int[] getIntVersion(String string) throws NumberFormatException {
        int[] nArray = new int[4];
        String string2 = Version.stripTrailingLetters(string.toUpperCase().trim());
        Object var3_3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        String string3 = "";
        for (int i = 0; stringTokenizer.hasMoreTokens() && i < 4; ++i) {
            string3 = stringTokenizer.nextToken();
            try {
                nArray[i] = Integer.parseInt(string3);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                String string4;
                int n = 0;
                if (Character.isDigit(string3.charAt(n))) {
                    string4 = Version.getNumber(string3);
                    try {
                        nArray[i] = Integer.parseInt(string4);
                        ++i;
                    }
                    catch (NumberFormatException numberFormatException2) {
                        System.out.println("Can't parse " + string3 + ": " + numberFormatException);
                    }
                    string3 = string3.substring(n += string4.length());
                }
                for (n = 0; n < string3.length() && !Character.isDigit(string3.charAt(n)); ++n) {
                }
                string4 = string3.substring(0, n).trim();
                if (!patchTerms.contains(string4)) break;
                String string5 = string3.substring(n);
                string5 = Version.getNumber(string5);
                try {
                    nArray[3] = Integer.parseInt(string5);
                }
                catch (NumberFormatException numberFormatException3) {}
                break;
            }
        }
        return nArray;
    }

    static String getNumber(String string) {
        int n;
        for (n = 0; n < string.length() && Character.isDigit(string.charAt(n)); ++n) {
        }
        return string.substring(0, n);
    }

    private static String stripTrailingLetters(String string) {
        boolean bl = false;
        int n = string.length() - 1;
        while (!Character.isDigit(string.charAt(n))) {
            --n;
        }
        if (n == string.length() - 1) {
            return string;
        }
        return string.substring(0, n + 1);
    }

    public static int compareVersions(String string, String string2) {
        return Version.compareVersions(string, string2, true);
    }

    public static int compareVersions(String string, String string2, boolean bl) throws NumberFormatException {
        int[] nArray = Version.getIntVersion(string);
        int[] nArray2 = Version.getIntVersion(string2);
        if (bl) {
            nArray[3] = 0;
            nArray2[3] = 0;
        }
        return Version.compareVersions(nArray, nArray2);
    }

    public static int compareVersions(int[] nArray, int[] nArray2) {
        int n = nArray.length > nArray2.length ? nArray.length : nArray2.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = nArray.length > i ? nArray[i] : 0;
            int n4 = n2 = nArray2.length > i ? nArray2[i] : 0;
            if (n3 > n2) {
                return 1;
            }
            if (n3 >= n2) continue;
            return -1;
        }
        return 0;
    }

    public static String toVersionString(int[] nArray) {
        String string = "";
        for (int i = 0; i < nArray.length; ++i) {
            string = string + nArray[i];
            if (i + 1 >= nArray.length) continue;
            string = string + ".";
        }
        return string;
    }

    public static void main(String[] stringArray) {
        Version version = new Version();
        System.out.println(version);
    }

    static {
        for (int i = 0; i < patchTermsList.length; ++i) {
            try {
                patchTerms.add(patchTermsList[i]);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Version: Could not add patch term " + patchTermsList[i] + ": " + exception);
            }
        }
        imqhome_propname = "imq.home";
        IMQ_HOME = System.getProperty(imqhome_propname, ".");
        PATCHIDFILE = IMQ_HOME + File.separator + "patches" + File.separator + "VERSION";
        thisPackage = "com.sun.messaging";
        rb = SharedResources.getResources();
    }
}

