/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.provisional.commons.ui.WorkbenchUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractTaskEditorSection;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.notifications.TaskDiffUtil;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.views.UpdateRepositoryConfigurationAction;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMetaData;
import org.eclipse.mylyn.tasks.core.sync.TaskJob;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TaskEditorAttributePart
extends AbstractTaskEditorSection {
    private static final int LABEL_WIDTH = 110;
    private static final int COLUMN_WIDTH = 140;
    private static final int COLUMN_GAP = 20;
    private static final int MULTI_COLUMN_WIDTH = 420;
    private static final int MULTI_ROW_HEIGHT = 55;
    private List<AbstractAttributeEditor> attributeEditors;
    private boolean hasIncoming;
    private Composite attributesComposite;

    public TaskEditorAttributePart() {
        this.setPartName(Messages.TaskEditorAttributePart_Attributes);
    }

    private void createAttributeControls(Composite attributesComposite, FormToolkit toolkit, int columnCount) {
        int currentColumn = 1;
        int currentPriority = 0;
        for (AbstractAttributeEditor attributeEditor : this.attributeEditors) {
            int priority;
            int n = priority = attributeEditor.getLayoutHint() != null ? attributeEditor.getLayoutHint().getPriority() : 10;
            if (priority != currentPriority) {
                currentPriority = priority;
                if (currentColumn > 1) {
                    while (currentColumn <= columnCount) {
                        this.getManagedForm().getToolkit().createLabel(attributesComposite, "");
                        ++currentColumn;
                    }
                    currentColumn = 1;
                }
            }
            if (attributeEditor.hasLabel()) {
                attributeEditor.createLabelControl(attributesComposite, toolkit);
                Label label = attributeEditor.getLabelControl();
                String text = label.getText();
                String shortenText = TaskDiffUtil.shortenText((Drawable)label, text, 110);
                label.setText(shortenText);
                if (!text.equals(shortenText)) {
                    label.setToolTipText(text);
                }
                GridData gd = GridDataFactory.fillDefaults().align(131072, 0x1000000).hint(110, -1).create();
                if (currentColumn > 1) {
                    gd.horizontalIndent = 20;
                    gd.widthHint = 130;
                }
                label.setLayoutData((Object)gd);
                ++currentColumn;
            }
            attributeEditor.createControl(attributesComposite, toolkit);
            LayoutHint layoutHint = attributeEditor.getLayoutHint();
            GridData gd = new GridData(4, 0x1000000, false, false);
            if (layoutHint != null && (layoutHint.rowSpan != LayoutHint.RowSpan.SINGLE || layoutHint.columnSpan != LayoutHint.ColumnSpan.SINGLE)) {
                if (layoutHint.rowSpan == LayoutHint.RowSpan.MULTIPLE) {
                    gd.heightHint = 55;
                }
                if (layoutHint.columnSpan == LayoutHint.ColumnSpan.SINGLE) {
                    gd.widthHint = 140;
                    gd.horizontalSpan = 1;
                } else {
                    gd.widthHint = 420;
                    gd.horizontalSpan = columnCount - currentColumn + 1;
                }
            } else {
                gd.widthHint = 140;
                gd.horizontalSpan = 1;
            }
            attributeEditor.getControl().setLayoutData((Object)gd);
            this.getTaskEditorPage().getAttributeEditorToolkit().adapt(attributeEditor);
            currentColumn += gd.horizontalSpan;
            currentColumn %= columnCount;
        }
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        this.initialize();
        super.createControl(parent, toolkit);
    }

    protected String getInfoOverlayText() {
        TaskAttribute product = this.getModel().getTaskData().getRoot().getMappedAttribute("task.common.product");
        TaskAttribute component = this.getModel().getTaskData().getRoot().getMappedAttribute("task.common.component");
        String productLabel = "";
        if (product != null) {
            productLabel = this.getModel().getTaskData().getAttributeMapper().getValueLabel(product);
        }
        String componentLabel = "";
        if (component != null) {
            componentLabel = this.getModel().getTaskData().getAttributeMapper().getValueLabel(component);
        }
        if (!"".equals(productLabel) && !"".equals(componentLabel)) {
            return String.valueOf(productLabel) + " / " + componentLabel;
        }
        if (!"".equals(productLabel)) {
            return productLabel;
        }
        if (!"".equals(componentLabel)) {
            return componentLabel;
        }
        return null;
    }

    protected boolean shouldExpandOnCreate() {
        return this.getTaskData().isNew() || this.hasIncoming;
    }

    protected Control createContent(FormToolkit toolkit, Composite parent) {
        this.attributesComposite = toolkit.createComposite(parent);
        this.attributesComposite.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Control focus = event.display.getFocusControl();
                if (focus instanceof Text && !((Text)focus).getEditable()) {
                    TaskEditorAttributePart.this.getManagedForm().getForm().setFocus();
                }
            }
        });
        GridLayout attributesLayout = EditorUtil.createSectionClientLayout();
        attributesLayout.numColumns = 4;
        attributesLayout.horizontalSpacing = 7;
        attributesLayout.verticalSpacing = 6;
        this.attributesComposite.setLayout((Layout)attributesLayout);
        GridData attributesData = new GridData(1808);
        attributesData.horizontalSpan = 1;
        attributesData.grabExcessVerticalSpace = false;
        this.attributesComposite.setLayoutData((Object)attributesData);
        this.createAttributeControls(this.attributesComposite, toolkit, attributesLayout.numColumns);
        toolkit.paintBordersFor(this.attributesComposite);
        return this.attributesComposite;
    }

    protected void fillToolBar(ToolBarManager toolBar) {
        UpdateRepositoryConfigurationAction repositoryConfigRefresh = new UpdateRepositoryConfigurationAction(){

            public void run() {
                TaskEditorAttributePart.this.getTaskEditorPage().showEditorBusy(true);
                final TaskJob job = TasksUiInternal.getJobFactory().createUpdateRepositoryConfigurationJob(TaskEditorAttributePart.this.getTaskEditorPage().getConnector(), TaskEditorAttributePart.this.getTaskEditorPage().getTaskRepository(), TaskEditorAttributePart.this.getTaskEditorPage().getTask());
                job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                TaskEditorAttributePart.this.getTaskEditorPage().showEditorBusy(false);
                                if (job.getStatus() != null) {
                                    TaskEditorAttributePart.this.getTaskEditorPage().getTaskEditor().setStatus(Messages.TaskEditorAttributePart_Updating_of_repository_configuration_failed, Messages.TaskEditorAttributePart_Update_Failed, job.getStatus());
                                } else {
                                    TaskEditorAttributePart.this.getTaskEditorPage().refresh();
                                }
                            }
                        });
                    }
                });
                job.setUser(true);
                job.setProperty(WorkbenchUtil.SHOW_IN_TASKBAR_ICON_PROPERTY, (Object)Boolean.TRUE);
                job.setPriority(10);
                job.schedule();
            }
        };
        repositoryConfigRefresh.setImageDescriptor(TasksUiImages.REPOSITORY_SYNCHRONIZE_SMALL);
        repositoryConfigRefresh.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this.getTaskEditorPage().getTaskRepository()));
        repositoryConfigRefresh.setToolTipText(Messages.TaskEditorAttributePart_Refresh_Attributes);
        toolBar.add((IAction)repositoryConfigRefresh);
    }

    private void initialize() {
        this.attributeEditors = new ArrayList<AbstractAttributeEditor>();
        this.hasIncoming = false;
        Map attributes = this.getTaskData().getRoot().getAttributes();
        for (TaskAttribute attribute : attributes.values()) {
            AbstractAttributeEditor attributeEditor;
            TaskAttributeMetaData properties = attribute.getMetaData();
            if (!"task.common.kind.default".equals(properties.getKind()) || (attributeEditor = this.createAttributeEditor(attribute)) == null) continue;
            this.attributeEditors.add(attributeEditor);
            if (!this.getModel().hasIncomingChanges(attribute)) continue;
            this.hasIncoming = true;
        }
        Collections.sort(this.attributeEditors, new Comparator<AbstractAttributeEditor>(){

            @Override
            public int compare(AbstractAttributeEditor o1, AbstractAttributeEditor o2) {
                int p1 = o1.getLayoutHint() != null ? o1.getLayoutHint().getPriority() : 10;
                int p2 = o2.getLayoutHint() != null ? o2.getLayoutHint().getPriority() : 10;
                return p1 - p2;
            }
        });
    }
}

