/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.Date;
import java.util.LinkedHashMap;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonTextSupport;
import org.eclipse.mylyn.internal.tasks.core.LocalRepositoryConnector;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractLocalEditorPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.PriorityEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextEditor;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SummaryPart
extends AbstractLocalEditorPart {
    private Composite headerComposite;
    private CommonTextSupport textSupport;
    private RichTextEditor summaryEditor;
    private Button statusCompleteButton;
    private Button statusIncompleteButton;
    private Text creationDateText;
    private Text completionDateText;
    private PriorityEditor priorityEditor;
    private boolean initialized;

    public SummaryPart() {
        super(Messages.SummaryPart_Section_Title);
    }

    private Label createLabel(Composite composite, FormToolkit toolkit, String label, int indent) {
        Label labelControl = toolkit.createLabel(composite, label);
        labelControl.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        GridDataFactory.defaultsFor((Control)labelControl).indent(indent, 0).applyTo((Control)labelControl);
        return labelControl;
    }

    private void createSummaryControl(Composite composite, FormToolkit toolkit) {
        Composite borderComposite = EditorUtil.createBorder(composite, toolkit);
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(300, -1).grab(true, false).applyTo((Control)borderComposite);
        this.summaryEditor = new RichTextEditor(this.getRepository(), 4, null, null, (ITask)this.getTask());
        this.summaryEditor.setSpellCheckingEnabled(true);
        this.summaryEditor.setReadOnly(!this.isSummaryEditable());
        this.summaryEditor.createControl(borderComposite, toolkit);
        if (this.textSupport != null) {
            this.textSupport.install((TextViewer)this.summaryEditor.getViewer(), true);
        }
        this.summaryEditor.getViewer().addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                if (!SummaryPart.this.getTask().getSummary().equals(SummaryPart.this.summaryEditor.getText())) {
                    SummaryPart.this.markDirty(SummaryPart.this.summaryEditor.getControl());
                }
            }
        });
        this.summaryEditor.getViewer().getControl().setMenu(composite.getMenu());
        EditorUtil.setHeaderFontSizeAndStyle(this.summaryEditor.getControl());
    }

    public Control createControl(Composite parent, FormToolkit toolkit) {
        Composite composite = toolkit.createComposite(parent);
        GridLayout layout = EditorUtil.createSectionClientLayout();
        layout.numColumns = 2;
        layout.marginTop = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 3;
        composite.setLayout((Layout)layout);
        this.priorityEditor = new PriorityEditor(){

            protected void valueChanged(String value) {
                SummaryPart.this.priorityEditor.select(value, ITask.PriorityLevel.fromString((String)value));
                SummaryPart.this.priorityEditor.setToolTipText(value);
                SummaryPart.this.markDirty(SummaryPart.this.priorityEditor.getControl());
            }
        };
        LinkedHashMap<String, String> labelByValue = new LinkedHashMap<String, String>();
        ITask.PriorityLevel[] priorityLevelArray = ITask.PriorityLevel.values();
        int n = priorityLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITask.PriorityLevel level = priorityLevelArray[n2];
            labelByValue.put(level.toString(), level.getDescription());
            ++n2;
        }
        this.priorityEditor.setLabelByValue(labelByValue);
        this.priorityEditor.createControl(composite, toolkit);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).span(1, 2).applyTo(this.priorityEditor.getControl());
        this.createSummaryControl(composite, toolkit);
        this.createHeaderControls(composite, toolkit);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.headerComposite);
        toolkit.paintBordersFor(composite);
        return composite;
    }

    protected Composite createHeaderControls(Composite composite, FormToolkit toolkit) {
        this.headerComposite = toolkit.createComposite(composite);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.headerComposite.setLayout((Layout)layout);
        this.createLabel(this.headerComposite, toolkit, Messages.TaskPlanningEditor_Status, 0);
        this.statusIncompleteButton = toolkit.createButton(this.headerComposite, Messages.TaskPlanningEditor_Incomplete, 16);
        this.statusIncompleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SummaryPart.this.statusIncompleteButton.getSelection()) {
                    SummaryPart.this.statusCompleteButton.setSelection(false);
                    SummaryPart.this.markDirty((Control)SummaryPart.this.statusCompleteButton);
                }
            }
        });
        this.statusCompleteButton = toolkit.createButton(this.headerComposite, Messages.TaskPlanningEditor_Complete, 16);
        this.statusCompleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SummaryPart.this.statusCompleteButton.getSelection()) {
                    SummaryPart.this.statusIncompleteButton.setSelection(false);
                    SummaryPart.this.markDirty((Control)SummaryPart.this.statusCompleteButton);
                }
            }
        });
        this.createLabel(this.headerComposite, toolkit, this.getCreatedDateLabel(), 6);
        this.creationDateText = new Text(this.headerComposite, 0x800008);
        toolkit.adapt((Control)this.creationDateText, false, false);
        this.creationDateText.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
        this.createLabel(this.headerComposite, toolkit, Messages.TaskPlanningEditor_Completed, 6);
        this.completionDateText = new Text(this.headerComposite, 0x800008);
        toolkit.adapt((Control)this.completionDateText, false, false);
        this.completionDateText.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
        layout.numColumns = this.headerComposite.getChildren().length;
        toolkit.paintBordersFor(this.headerComposite);
        return this.headerComposite;
    }

    public void setFocus() {
        if (this.summaryEditor != null) {
            this.summaryEditor.getControl().setFocus();
        }
    }

    private String getDateString(Date date) {
        if (date == null) {
            return "-";
        }
        return EditorUtil.getDateFormat().format(date);
    }

    private String getDateTimeString(Date date) {
        if (date == null) {
            return "-";
        }
        return EditorUtil.getDateTimeFormat().format(date);
    }

    public void refresh(boolean discardChanges) {
        if (this.shouldRefresh(this.priorityEditor.getControl(), discardChanges)) {
            ITask.PriorityLevel level = ITask.PriorityLevel.fromString((String)this.getTask().getPriority());
            this.priorityEditor.select(level.toString(), level);
        }
        if (this.shouldRefresh((Control)this.statusCompleteButton, discardChanges)) {
            this.statusIncompleteButton.setSelection(!this.getTask().isCompleted());
            this.statusCompleteButton.setSelection(this.getTask().isCompleted());
        }
        if (this.shouldRefresh(this.summaryEditor.getControl(), discardChanges)) {
            this.summaryEditor.setText(this.getTask().getSummary());
            if (!this.initialized) {
                this.initialized = true;
                if (LocalRepositoryConnector.DEFAULT_SUMMARY.equals(this.getTask().getSummary())) {
                    this.summaryEditor.getViewer().setSelectedRange(0, this.summaryEditor.getText().length());
                }
            }
        }
        this.creationDateText.setText(this.getDateString(this.getTask().getCreationDate()));
        this.updateToolTip(this.creationDateText, this.getTask().getCreationDate());
        this.completionDateText.setText(this.getDateString(this.getTask().getCompletionDate()));
        this.updateToolTip(this.completionDateText, this.getTask().getCompletionDate());
        this.headerComposite.layout(true);
    }

    private void updateToolTip(Text text, Date date) {
        if (date != null) {
            text.setToolTipText(this.getDateTimeString(date));
        } else {
            text.setToolTipText(null);
        }
    }

    public void commit(boolean onSave) {
        ITask.PriorityLevel level = ITask.PriorityLevel.fromString((String)this.priorityEditor.getValue());
        if (level != null) {
            this.getTask().setPriority(level.toString());
        }
        this.clearState(this.priorityEditor.getControl());
        this.getTask().setSummary(this.summaryEditor.getText());
        this.clearState(this.summaryEditor.getControl());
        if (this.statusCompleteButton.getSelection()) {
            if (!this.getTask().isCompleted()) {
                this.getTask().setCompletionDate(new Date());
            }
        } else if (this.getTask().isCompleted()) {
            this.getTask().setCompletionDate(null);
        }
        this.clearState((Control)this.statusCompleteButton);
        super.commit(onSave);
    }

    public void setTextSupport(CommonTextSupport textSupport) {
        this.textSupport = textSupport;
    }

    public CommonTextSupport getTextSupport() {
        return this.textSupport;
    }

    public void setSummary(String value) {
        if (!this.summaryEditor.getControl().isDisposed()) {
            this.summaryEditor.setText(value);
        }
    }

    protected String getCreatedDateLabel() {
        return Messages.TaskPlanningEditor_Created;
    }

    protected boolean isSummaryEditable() {
        return this.getTask() instanceof LocalTask;
    }
}

