/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.postscript.truetypefont;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.emitter.postscript.truetypefont.ITrueTypeWriter;
import org.eclipse.birt.report.engine.emitter.postscript.truetypefont.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrueTypeFont {
    private static final int MAX_STRING_LENGTH = 16384;
    private static final int HEAD_LOCA_FORMAT_OFFSET = 51;
    private static final String WINANSI = "Cp1252";
    private boolean embedded;
    private boolean fontSpecific = true;
    private boolean justNames = false;
    private HashMap<String, int[]> positionTables;
    private RandomAccessFileOrArray rf;
    private String fileName;
    private int directoryOffset;
    private String ttcIndex;
    private String style = "";
    private FontHeader head = new FontHeader();
    private HorizontalHeader hhea = new HorizontalHeader();
    private WindowsMetrics os_2 = new WindowsMetrics();
    private int[] GlyphWidths;
    private int[][] bboxes;
    private HashMap<Integer, int[]> cmap10;
    private HashMap<Integer, int[]> cmap31;
    private IntHashtable kerning = new IntHashtable();
    private String fontName;
    private String[][] fullName;
    private String[][] familyName;
    private double italicAngle;
    private double underlineThickness;
    private double underlinePosition;
    private boolean isFixedPitch = false;
    private static Logger logger = Logger.getLogger(TrueTypeFont.class.getName());
    static final int ARG_1_AND_2_ARE_WORDS = 1;
    static final int WE_HAVE_A_SCALE = 8;
    static final int MORE_COMPONENTS = 32;
    static final int WE_HAVE_AN_X_AND_Y_SCALE = 64;
    static final int WE_HAVE_A_TWO_BY_TWO = 128;
    private byte[] directoryRawData = new byte[12];
    private HashMap<String, byte[]> metadataTables;
    private String[][] notice;
    private String[][] version;
    private static Map<File, TrueTypeFont> fonts = new HashMap<File, TrueTypeFont>();

    protected TrueTypeFont() {
    }

    TrueTypeFont(String ttFile) throws DocumentException, IOException {
        this(ttFile, false);
    }

    TrueTypeFont(String ttFile, boolean justNames) throws DocumentException, IOException {
        this.justNames = justNames;
        String nameBase = TrueTypeFont.getBaseName(ttFile);
        String ttcName = TrueTypeFont.getTTCName(nameBase);
        if (nameBase.length() < ttFile.length()) {
            this.style = ttFile.substring(nameBase.length());
        }
        this.embedded = false;
        this.fileName = ttcName;
        this.ttcIndex = "";
        if (ttcName.length() < nameBase.length()) {
            this.ttcIndex = nameBase.substring(ttcName.length() + 1);
        }
        if (!(this.fileName.toLowerCase().endsWith(".ttf") || this.fileName.toLowerCase().endsWith(".otf") || this.fileName.toLowerCase().endsWith(".ttc"))) {
            throw new DocumentException(String.valueOf(this.fileName) + this.style + " is not a TTF, OTF or TTC font file.");
        }
        this.process();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TrueTypeFont getInstance(String fileName) throws DocumentException, IOException {
        File file = new File(fileName);
        if (fonts.containsKey(file)) {
            return fonts.get(file);
        }
        Map<File, TrueTypeFont> map = fonts;
        synchronized (map) {
            if (fonts.containsKey(file)) {
                return fonts.get(file);
            }
            TrueTypeFont font = new TrueTypeFont(fileName);
            fonts.put(new File(fileName), font);
            return font;
        }
    }

    protected static String getBaseName(String name) {
        if (name.endsWith(",Bold")) {
            return name.substring(0, name.length() - 5);
        }
        if (name.endsWith(",Italic")) {
            return name.substring(0, name.length() - 7);
        }
        if (name.endsWith(",BoldItalic")) {
            return name.substring(0, name.length() - 11);
        }
        return name;
    }

    protected static String getTTCName(String name) {
        int idx = name.toLowerCase().indexOf(".ttc,");
        if (idx < 0) {
            return name;
        }
        return name.substring(0, idx + 4);
    }

    void fillTables() throws DocumentException, IOException {
        this.fillHead();
        this.fillHHea();
        this.fillOS();
        this.processPost();
    }

    private void processPost() throws DocumentException, IOException {
        int[] tableLocation = this.getTableLocation("post");
        if (tableLocation == null) {
            this.italicAngle = -Math.atan2(this.hhea.caretSlopeRun, this.hhea.caretSlopeRise) * 180.0 / Math.PI;
            return;
        }
        this.rf.seek(tableLocation[0] + 4);
        short mantissa = this.rf.readShort();
        int fraction = this.rf.readUnsignedShort();
        this.italicAngle = (double)mantissa + (double)fraction / 16384.0;
        this.underlinePosition = (double)this.rf.readShort() / (double)this.head.unitsPerEm;
        this.underlineThickness = (double)this.rf.readShort() / (double)this.head.unitsPerEm;
        this.isFixedPitch = this.rf.readInt() != 0;
    }

    private void fillOS() throws DocumentException, IOException {
        int[] tableLocation = this.getTableLocation("OS/2");
        this.rf.seek(tableLocation[0]);
        int version = this.rf.readUnsignedShort();
        this.os_2.xAvgCharWidth = this.rf.readShort();
        this.os_2.usWeightClass = this.rf.readUnsignedShort();
        this.os_2.usWidthClass = this.rf.readUnsignedShort();
        this.os_2.fsType = this.rf.readShort();
        this.os_2.ySubscriptXSize = this.rf.readShort();
        this.os_2.ySubscriptYSize = this.rf.readShort();
        this.os_2.ySubscriptXOffset = this.rf.readShort();
        this.os_2.ySubscriptYOffset = this.rf.readShort();
        this.os_2.ySuperscriptXSize = this.rf.readShort();
        this.os_2.ySuperscriptYSize = this.rf.readShort();
        this.os_2.ySuperscriptXOffset = this.rf.readShort();
        this.os_2.ySuperscriptYOffset = this.rf.readShort();
        this.os_2.yStrikeoutSize = this.rf.readShort();
        this.os_2.yStrikeoutPosition = this.rf.readShort();
        this.os_2.sFamilyClass = this.rf.readShort();
        this.rf.readFully(this.os_2.panose);
        this.rf.skipBytes(16);
        this.rf.readFully(this.os_2.achVendID);
        this.os_2.fsSelection = this.rf.readUnsignedShort();
        this.os_2.usFirstCharIndex = this.rf.readUnsignedShort();
        this.os_2.usLastCharIndex = this.rf.readUnsignedShort();
        this.os_2.sTypoAscender = this.rf.readShort();
        this.os_2.sTypoDescender = this.rf.readShort();
        if (this.os_2.sTypoDescender > 0) {
            this.os_2.sTypoDescender = -this.os_2.sTypoDescender;
        }
        this.os_2.sTypoLineGap = this.rf.readShort();
        this.os_2.usWinAscent = this.rf.readUnsignedShort();
        this.os_2.usWinDescent = this.rf.readUnsignedShort();
        this.os_2.ulCodePageRange1 = 0;
        this.os_2.ulCodePageRange2 = 0;
        if (version > 0) {
            this.os_2.ulCodePageRange1 = this.rf.readInt();
            this.os_2.ulCodePageRange2 = this.rf.readInt();
        }
        if (version > 1) {
            this.rf.skipBytes(2);
            this.os_2.sCapHeight = this.rf.readShort();
        } else {
            this.os_2.sCapHeight = (int)(0.7 * (double)this.head.unitsPerEm);
        }
    }

    private void fillHHea() throws DocumentException, IOException {
        int[] tableLocation = this.getTableLocation("hhea");
        this.rf.seek(tableLocation[0] + 4);
        this.hhea.Ascender = this.rf.readShort();
        this.hhea.Descender = this.rf.readShort();
        this.hhea.LineGap = this.rf.readShort();
        this.hhea.advanceWidthMax = this.rf.readUnsignedShort();
        this.hhea.minLeftSideBearing = this.rf.readShort();
        this.hhea.minRightSideBearing = this.rf.readShort();
        this.hhea.xMaxExtent = this.rf.readShort();
        this.hhea.caretSlopeRise = this.rf.readShort();
        this.hhea.caretSlopeRun = this.rf.readShort();
        this.rf.skipBytes(12);
        this.hhea.numberOfHMetrics = this.rf.readUnsignedShort();
    }

    private void fillHead() throws DocumentException, IOException {
        int[] tableLocation = this.getTableLocation("head");
        this.rf.seek(tableLocation[0] + 16);
        this.head.flags = this.rf.readUnsignedShort();
        this.head.unitsPerEm = this.rf.readUnsignedShort();
        this.rf.skipBytes(16);
        this.head.xMin = this.rf.readShort();
        this.head.yMin = this.rf.readShort();
        this.head.xMax = this.rf.readShort();
        this.head.yMax = this.rf.readShort();
        this.head.macStyle = this.rf.readUnsignedShort();
        this.rf.skip(4L);
        int indexToLocFormat = this.rf.readUnsignedShort();
        this.head.locaBytesPerEntry = indexToLocFormat == 0 ? 2 : 4;
    }

    private int[] getTableLocation(String name) throws DocumentException {
        int[] table_location = this.positionTables.get(name);
        if (table_location == null) {
            throw new DocumentException("Table 'head' does not exist in " + this.fileName + this.style);
        }
        return table_location;
    }

    String getBaseFont() throws DocumentException, IOException {
        int[] table_location = this.positionTables.get("name");
        if (table_location == null) {
            throw new DocumentException("Table 'name' does not exist in " + this.fileName + this.style);
        }
        this.rf.seek(table_location[0] + 2);
        int numRecords = this.rf.readUnsignedShort();
        int startOfStorage = this.rf.readUnsignedShort();
        int k = 0;
        while (k < numRecords) {
            int platformID = this.rf.readUnsignedShort();
            int nameID = this.rf.readUnsignedShort();
            int length = this.rf.readUnsignedShort();
            int offset = this.rf.readUnsignedShort();
            if (nameID == 6) {
                this.rf.seek(table_location[0] + startOfStorage + offset);
                if (platformID != 0 && platformID != 3) {
                    String name = this.readStandardString(length);
                    name = name.replace(' ', '_');
                    return name.replace('\u0000', '_');
                }
            }
            ++k;
        }
        File file = new File(this.fileName);
        return file.getName().replace(' ', '_');
    }

    String[][] getNames(int id) throws DocumentException, IOException {
        int[] table_location = this.positionTables.get("name");
        if (table_location == null) {
            throw new DocumentException("Table 'name' does not exist in " + this.fileName + this.style);
        }
        this.rf.seek(table_location[0] + 2);
        int numRecords = this.rf.readUnsignedShort();
        int startOfStorage = this.rf.readUnsignedShort();
        ArrayList<String[]> names = new ArrayList<String[]>();
        int k = 0;
        while (k < numRecords) {
            int platformID = this.rf.readUnsignedShort();
            int platformEncodingID = this.rf.readUnsignedShort();
            int languageID = this.rf.readUnsignedShort();
            int nameID = this.rf.readUnsignedShort();
            int length = this.rf.readUnsignedShort();
            int offset = this.rf.readUnsignedShort();
            if (nameID == id) {
                int pos = this.rf.getFilePointer();
                this.rf.seek(table_location[0] + startOfStorage + offset);
                String name = platformID == 0 || platformID == 3 || platformID == 2 && platformEncodingID == 1 ? this.readUnicodeString(length) : this.readStandardString(length);
                names.add(new String[]{String.valueOf(platformID), String.valueOf(platformEncodingID), String.valueOf(languageID), name});
                this.rf.seek(pos);
            }
            ++k;
        }
        String[][] thisName = new String[names.size()][];
        int k2 = 0;
        while (k2 < names.size()) {
            thisName[k2] = (String[])names.get(k2);
            ++k2;
        }
        return thisName;
    }

    void process() throws DocumentException, IOException {
        this.positionTables = new HashMap();
        this.metadataTables = new HashMap();
        try {
            this.rf = new RandomAccessFileOrArray(this.fileName);
            if (this.ttcIndex.length() > 0) {
                int dirIdx = Integer.parseInt(this.ttcIndex);
                if (dirIdx < 0) {
                    throw new DocumentException("The font index for " + this.fileName + " must be positive.");
                }
                String mainTag = this.readStandardString(4);
                if (!mainTag.equals("ttcf")) {
                    throw new DocumentException(String.valueOf(this.fileName) + " is not a valid TTC file.");
                }
                this.rf.skipBytes(4);
                int dirCount = this.rf.readInt();
                if (dirIdx >= dirCount) {
                    throw new DocumentException("The font index for " + this.fileName + " must be between 0 and " + (dirCount - 1) + ". It was " + dirIdx + ".");
                }
                this.rf.skipBytes(dirIdx * 4);
                this.directoryOffset = this.rf.readInt();
            }
            this.rf.seek(this.directoryOffset);
            this.rf.readFully(this.directoryRawData);
            int ttId = Util.getInt(this.directoryRawData, 0);
            if (ttId != 65536 && ttId != 0x4F54544F) {
                throw new DocumentException(String.valueOf(this.fileName) + " is not a valid TTF or OTF file.");
            }
            int num_tables = Util.getUnsignedShort(this.directoryRawData, 4);
            int k = 0;
            while (k < num_tables) {
                byte[] rawData = new byte[16];
                this.rf.readFully(rawData);
                String tag = this.getStandardString(rawData, 0, 4);
                int[] table_location = new int[]{Util.getInt(rawData, 8), Util.getInt(rawData, 12)};
                this.positionTables.put(tag, table_location);
                this.metadataTables.put(tag, rawData);
                ++k;
            }
            this.fontName = this.getBaseFont();
            this.fullName = this.getNames(4);
            this.familyName = this.getNames(1);
            this.notice = this.getNames(0);
            this.version = this.getNames(5);
            if (!this.justNames) {
                this.fillTables();
                this.readGlyphWidths();
                this.readCMaps();
                this.readKerning();
                this.readBbox();
                this.GlyphWidths = null;
            }
        }
        finally {
            if (this.rf != null) {
                this.rf.close();
                if (!this.embedded) {
                    this.rf = null;
                }
            }
        }
    }

    public ITrueTypeWriter getTrueTypeWriter(PrintStream out) throws IOException {
        return new TrueTypeWriter(out);
    }

    protected String readStandardString(int length) throws IOException {
        byte[] buf = new byte[length];
        this.rf.readFully(buf);
        try {
            return new String(buf, WINANSI);
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    protected String readUnicodeString(int length) throws IOException {
        StringBuffer buf = new StringBuffer();
        length /= 2;
        int k = 0;
        while (k < length) {
            buf.append(this.rf.readChar());
            ++k;
        }
        return buf.toString();
    }

    protected void readGlyphWidths() throws DocumentException, IOException {
        int[] table_location = this.positionTables.get("hmtx");
        if (table_location == null) {
            throw new DocumentException("Table 'hmtx' does not exist in " + this.fileName + this.style);
        }
        this.rf.seek(table_location[0]);
        this.GlyphWidths = new int[this.hhea.numberOfHMetrics];
        int k = 0;
        while (k < this.hhea.numberOfHMetrics) {
            this.GlyphWidths[k] = this.rf.readUnsignedShort() * 1000 / this.head.unitsPerEm;
            this.rf.readUnsignedShort();
            ++k;
        }
    }

    protected int getGlyphWidth(int glyph) {
        if (glyph >= this.GlyphWidths.length) {
            glyph = this.GlyphWidths.length - 1;
        }
        return this.GlyphWidths[glyph];
    }

    private void readBbox() throws DocumentException, IOException {
        int k;
        int[] locaTable;
        int entries;
        int[] tableLocation = this.positionTables.get("head");
        if (tableLocation == null) {
            throw new DocumentException("Table 'head' does not exist in " + this.fileName + this.style);
        }
        this.rf.seek(tableLocation[0] + 51);
        boolean locaShortTable = this.rf.readUnsignedShort() == 0;
        tableLocation = this.positionTables.get("loca");
        if (tableLocation == null) {
            return;
        }
        this.rf.seek(tableLocation[0]);
        if (locaShortTable) {
            entries = tableLocation[1] / 2;
            locaTable = new int[entries];
            k = 0;
            while (k < entries) {
                locaTable[k] = this.rf.readUnsignedShort() * 2;
                ++k;
            }
        } else {
            entries = tableLocation[1] / 4;
            locaTable = new int[entries];
            k = 0;
            while (k < entries) {
                locaTable[k] = this.rf.readInt();
                ++k;
            }
        }
        tableLocation = this.positionTables.get("glyf");
        if (tableLocation == null) {
            throw new DocumentException("Table 'glyf' does not exist in " + this.fileName + this.style);
        }
        int tableGlyphOffset = tableLocation[0];
        this.bboxes = new int[locaTable.length - 1][];
        int glyph = 0;
        while (glyph < locaTable.length - 1) {
            int start = locaTable[glyph];
            if (start != locaTable[glyph + 1]) {
                this.rf.seek(tableGlyphOffset + start + 2);
                this.bboxes[glyph] = new int[]{this.rf.readShort() * 1000 / this.head.unitsPerEm, this.rf.readShort() * 1000 / this.head.unitsPerEm, this.rf.readShort() * 1000 / this.head.unitsPerEm, this.rf.readShort() * 1000 / this.head.unitsPerEm};
            }
            ++glyph;
        }
    }

    public void readCMaps() throws DocumentException, IOException {
        int format;
        int[] table_location = this.positionTables.get("cmap");
        if (table_location == null) {
            throw new DocumentException("Table 'cmap' does not exist in " + this.fileName + this.style);
        }
        this.rf.seek(table_location[0]);
        this.rf.skipBytes(2);
        int num_tables = this.rf.readUnsignedShort();
        this.fontSpecific = false;
        int map10 = 0;
        int map31 = 0;
        int map30 = 0;
        int k = 0;
        while (k < num_tables) {
            int platId = this.rf.readUnsignedShort();
            int platSpecId = this.rf.readUnsignedShort();
            int offset = this.rf.readInt();
            if (platId == 3 && platSpecId == 0) {
                this.fontSpecific = true;
                map30 = offset;
            } else if (platId == 3 && platSpecId == 1) {
                map31 = offset;
            }
            if (platId == 1 && platSpecId == 0) {
                map10 = offset;
            }
            ++k;
        }
        if (map10 > 0) {
            this.rf.seek(table_location[0] + map10);
            format = this.rf.readUnsignedShort();
            switch (format) {
                case 0: {
                    this.cmap10 = this.readFormat0();
                    break;
                }
                case 4: {
                    this.cmap10 = this.readFormat4();
                    break;
                }
                case 6: {
                    this.cmap10 = this.readFormat6();
                }
            }
        }
        if (map31 > 0) {
            this.rf.seek(table_location[0] + map31);
            format = this.rf.readUnsignedShort();
            if (format == 4) {
                this.cmap31 = this.readFormat4();
            }
        }
        if (map30 > 0) {
            this.rf.seek(table_location[0] + map30);
            format = this.rf.readUnsignedShort();
            if (format == 4) {
                this.cmap10 = this.readFormat4();
            }
        }
    }

    HashMap<Integer, int[]> readFormat0() throws IOException {
        HashMap<Integer, int[]> h = new HashMap<Integer, int[]>();
        this.rf.skipBytes(4);
        int k = 0;
        while (k < 256) {
            int[] r;
            r = new int[]{this.rf.readUnsignedByte(), this.getGlyphWidth(r[0])};
            h.put(k, r);
            ++k;
        }
        return h;
    }

    HashMap<Integer, int[]> readFormat4() throws IOException {
        HashMap<Integer, int[]> h = new HashMap<Integer, int[]>();
        int table_lenght = this.rf.readUnsignedShort();
        this.rf.skipBytes(2);
        int segCount = this.rf.readUnsignedShort() / 2;
        this.rf.skipBytes(6);
        int[] endCount = new int[segCount];
        int k = 0;
        while (k < segCount) {
            endCount[k] = this.rf.readUnsignedShort();
            ++k;
        }
        this.rf.skipBytes(2);
        int[] startCount = new int[segCount];
        int k2 = 0;
        while (k2 < segCount) {
            startCount[k2] = this.rf.readUnsignedShort();
            ++k2;
        }
        int[] idDelta = new int[segCount];
        int k3 = 0;
        while (k3 < segCount) {
            idDelta[k3] = this.rf.readUnsignedShort();
            ++k3;
        }
        int[] idRO = new int[segCount];
        int k4 = 0;
        while (k4 < segCount) {
            idRO[k4] = this.rf.readUnsignedShort();
            ++k4;
        }
        int[] glyphId = new int[table_lenght / 2 - 8 - segCount * 4];
        int k5 = 0;
        while (k5 < glyphId.length) {
            glyphId[k5] = this.rf.readUnsignedShort();
            ++k5;
        }
        k5 = 0;
        while (k5 < segCount) {
            int j = startCount[k5];
            while (j <= endCount[k5] && j != 65535) {
                block12: {
                    int[] r;
                    int glyph;
                    block11: {
                        block10: {
                            if (idRO[k5] != 0) break block10;
                            glyph = j + idDelta[k5] & 0xFFFF;
                            break block11;
                        }
                        int idx = k5 + idRO[k5] / 2 - segCount + j - startCount[k5];
                        if (idx >= glyphId.length) break block12;
                        glyph = glyphId[idx] + idDelta[k5] & 0xFFFF;
                    }
                    r = new int[]{glyph, this.getGlyphWidth(r[0])};
                    h.put(new Integer(this.fontSpecific ? ((j & 0xFF00) == 61440 ? j & 0xFF : j) : j), r);
                }
                ++j;
            }
            ++k5;
        }
        return h;
    }

    HashMap<Integer, int[]> readFormat6() throws IOException {
        HashMap<Integer, int[]> h = new HashMap<Integer, int[]>();
        this.rf.skipBytes(4);
        int start_code = this.rf.readUnsignedShort();
        int code_count = this.rf.readUnsignedShort();
        int k = 0;
        while (k < code_count) {
            int[] r;
            r = new int[]{this.rf.readUnsignedShort(), this.getGlyphWidth(r[0])};
            h.put(new Integer(k + start_code), r);
            ++k;
        }
        return h;
    }

    void readKerning() throws IOException {
        int[] table_location = this.positionTables.get("kern");
        if (table_location == null) {
            return;
        }
        this.rf.seek(table_location[0] + 2);
        int nTables = this.rf.readUnsignedShort();
        int checkpoint = table_location[0] + 4;
        int length = 0;
        int k = 0;
        while (k < nTables) {
            this.rf.seek(checkpoint += length);
            this.rf.skipBytes(2);
            length = this.rf.readUnsignedShort();
            int coverage = this.rf.readUnsignedShort();
            if ((coverage & 0xFFF7) == 1) {
                int nPairs = this.rf.readUnsignedShort();
                this.rf.skipBytes(6);
                int j = 0;
                while (j < nPairs) {
                    int pair = this.rf.readInt();
                    int value = this.rf.readShort() * 1000 / this.head.unitsPerEm;
                    this.kerning.put(pair, value);
                    ++j;
                }
            }
            ++k;
        }
    }

    public int[] getMetricsTT(int c) {
        if (!this.fontSpecific && this.cmap31 != null) {
            return this.cmap31.get(new Integer(c));
        }
        if (this.fontSpecific && this.cmap10 != null) {
            return this.cmap10.get(new Integer(c));
        }
        if (this.cmap31 != null) {
            return this.cmap31.get(new Integer(c));
        }
        if (this.cmap10 != null) {
            return this.cmap10.get(new Integer(c));
        }
        return null;
    }

    public String getPostscriptFontName() {
        return this.fontName;
    }

    public String[][] getFullFontName() {
        return this.fullName;
    }

    public String[][] getFamilyFontName() {
        return this.familyName;
    }

    public void setPostscriptFontName(String name) {
        this.fontName = name;
    }

    public HashMap<Integer, int[]> getCMap() {
        if (!this.fontSpecific && this.cmap31 != null) {
            return this.cmap31;
        }
        if (this.fontSpecific && this.cmap10 != null) {
            return this.cmap10;
        }
        if (this.cmap31 != null) {
            return this.cmap31;
        }
        if (this.cmap10 != null) {
            return this.cmap10;
        }
        return null;
    }

    private String getStandardString(byte[] source, int index, int length) {
        assert (source.length >= index + length);
        try {
            return new String(source, index, length, WINANSI);
        }
        catch (UnsupportedEncodingException e) {
            throw new ExceptionConverter((Exception)e);
        }
    }

    private String getName(String[][] names) {
        if (names.length > 0 && names[0].length > 0) {
            return this.toPSString(names[0][names[0].length - 1]);
        }
        return null;
    }

    private String toPSString(String data) {
        return "(" + data + ")";
    }

    public int getGlyphIndex(char c) {
        int[] glyphIndexs = this.getCMap().get(new Integer(c));
        return glyphIndexs[0];
    }

    private long calculateChecksum(byte[] data) {
        int length = (data.length + 3) / 4;
        byte[] buffer = new byte[length * 4];
        System.arraycopy(data, 0, buffer, 0, data.length);
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        long checksum = 0L;
        int i = 0;
        while (i < length) {
            long readInt = byteBuffer.getInt();
            if (readInt < 0L) {
                readInt &= 0xFFFFFFFFL;
            }
            checksum += readInt;
            checksum = 0xFFFFFFFFL & checksum;
            ++i;
        }
        return checksum;
    }

    private long calculateChecksum(List<byte[]> datas) {
        int length = 0;
        for (byte[] data : datas) {
            length += data.length;
        }
        byte[] totalArray = new byte[length];
        int offset = 0;
        for (byte[] data : datas) {
            int i = 0;
            while (i < data.length) {
                totalArray[offset + i] = data[i];
                ++i;
            }
            offset += data.length;
        }
        return this.calculateChecksum(totalArray);
    }

    private static void outputAsPsString(PrintStream out, byte[] data) {
        out.print(TrueTypeFont.toPSDataString(Util.toHexString(data)));
    }

    public static String toPSDataString(String data) {
        return "<" + data + ">";
    }

    private void setOffset(byte[] tableMetadata, int offset) {
        Util.putInt32(tableMetadata, 8, offset);
    }

    protected static class FontHeader {
        int flags;
        int unitsPerEm;
        short xMin;
        short yMin;
        short xMax;
        short yMax;
        int macStyle;
        int locaBytesPerEntry;

        protected FontHeader() {
        }
    }

    protected static class HorizontalHeader {
        short Ascender;
        short Descender;
        short LineGap;
        int advanceWidthMax;
        short minLeftSideBearing;
        short minRightSideBearing;
        short xMaxExtent;
        short caretSlopeRise;
        short caretSlopeRun;
        int numberOfHMetrics;

        protected HorizontalHeader() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TrueTypeWriter
    implements ITrueTypeWriter {
        private PrintStream out;
        private RandomAccessFileOrArray rf;
        private Set<TrueTypeGlyph> glyphDefined = new HashSet<TrueTypeGlyph>();
        private String displayName;

        public TrueTypeWriter(PrintStream out) throws IOException {
            this.out = out;
        }

        @Override
        public void initialize(String displayName) throws IOException {
            int[] tableLocation = (int[])TrueTypeFont.this.positionTables.get("loca");
            int locaLength = tableLocation[1];
            int glyphCount = locaLength / ((TrueTypeFont)TrueTypeFont.this).head.locaBytesPerEntry - 1;
            this.rf = new RandomAccessFileOrArray(TrueTypeFont.this.fileName);
            this.out.println("18 dict begin");
            this.out.println("/CIDFontName /" + TrueTypeFont.this.fontName + " def");
            this.out.println("/PaintType 0 def");
            this.out.println("/FontType 42 def");
            this.out.println("/CIDFontType 2 def");
            this.out.println("/GDBytes 2 def");
            this.out.println("/CIDSystemInfo 3 dict dup begin");
            this.out.println("  /Registry (Adobe) def");
            this.out.println("  /Ordering (Identity) def");
            this.out.println("  /Supplement 0 def");
            this.out.println("end def");
            this.out.println("/FontMatrix matrix def");
            this.out.println("/FontBBox " + this.getFontBBox() + " def");
            this.out.println("/CIDCount " + glyphCount + " def");
            this.out.println("/CDevProc {pop pop pop pop pop 0 -1 7 index 2 div .88}bind def");
            this.out.println("/CharStrings 1 dict dup begin /.notdef 0 def end def");
            this.out.println("/Encoding 1 array dup 0 /.notdef put readonly def");
            this.out.println("/GlyphDirectory 16 dict def");
            this.outputSfnts(this.out);
            this.outputCIDMap(this.out, glyphCount);
            this.out.println("CIDFontName currentdict end /CIDFont defineresource pop");
            this.displayName = displayName.replace(' ', '_');
            this.out.println("/" + displayName + " /Identity-H [/" + TrueTypeFont.this.fontName + "] composefont pop");
        }

        @Override
        public String getDisplayName() {
            return this.displayName;
        }

        private String getFontBBox() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("[");
            buffer.append(Util.div(((TrueTypeFont)TrueTypeFont.this).head.xMin, ((TrueTypeFont)TrueTypeFont.this).head.unitsPerEm));
            buffer.append(" ");
            buffer.append(Util.div(((TrueTypeFont)TrueTypeFont.this).head.yMin, ((TrueTypeFont)TrueTypeFont.this).head.unitsPerEm));
            buffer.append(" ");
            buffer.append(Util.div(((TrueTypeFont)TrueTypeFont.this).head.xMax, ((TrueTypeFont)TrueTypeFont.this).head.unitsPerEm));
            buffer.append(" ");
            buffer.append(Util.div(((TrueTypeFont)TrueTypeFont.this).head.yMax, ((TrueTypeFont)TrueTypeFont.this).head.unitsPerEm));
            buffer.append("]");
            return buffer.toString();
        }

        private void outputCIDMap(PrintStream out, int glyphCount) {
            out.print("/CIDMap [<");
            int lineBreakCount = 0;
            int stringLimitCount = 0;
            int i = 0;
            while (i < glyphCount) {
                out.print(Util.toHexString(i));
                ++stringLimitCount;
                if (++lineBreakCount == 20) {
                    out.println();
                    lineBreakCount = 0;
                }
                if (stringLimitCount == Short.MAX_VALUE) {
                    out.print("><");
                    stringLimitCount = 0;
                }
                ++i;
            }
            out.println(">] def");
        }

        @Override
        public void ensureGlyphAvailable(char c) throws IOException {
            List<TrueTypeGlyph> charactersToOutput = this.getCharactersToOutput(c);
            for (TrueTypeGlyph glyph : charactersToOutput) {
                this.ensureRawDataAvailable(glyph);
            }
        }

        private void ensureRawDataAvailable(TrueTypeGlyph glyph) throws IOException {
            if (!this.glyphDefined.contains(glyph)) {
                glyph.ensureRawDataAvailable(this.out, TrueTypeFont.this.fontName);
                this.glyphDefined.add(glyph);
            }
        }

        @Override
        public void ensureGlyphsAvailable(String string) throws IOException {
            int i = 0;
            while (i < string.length()) {
                this.ensureGlyphAvailable(string.charAt(i));
                ++i;
            }
        }

        protected List<TrueTypeGlyph> getCharactersToOutput(char c) throws IOException {
            int glyph = TrueTypeFont.this.getGlyphIndex(c);
            List<TrueTypeGlyph> result = this.getCharactersToOutput(glyph);
            result.add(new TrueTypeGlyph(glyph));
            return result;
        }

        protected List<TrueTypeGlyph> getCharactersToOutput(int glyph) throws IOException {
            ArrayList<TrueTypeGlyph> characters = new ArrayList<TrueTypeGlyph>();
            int[] glyphDataPosition = this.getGlyphDataPosition(glyph);
            int glyphDataOffset = glyphDataPosition[0];
            int glyphDataLength = glyphDataPosition[1];
            if (glyphDataLength == 0) {
                return characters;
            }
            int tableGlyphOffset = ((int[])TrueTypeFont.this.positionTables.get("glyf"))[0];
            this.rf.seek(tableGlyphOffset + glyphDataOffset);
            short numContours = this.rf.readShort();
            if (numContours >= 0) {
                return characters;
            }
            this.rf.skipBytes(8);
            while (true) {
                int flags = this.rf.readUnsignedShort();
                Integer cGlyph = new Integer(this.rf.readUnsignedShort());
                TrueTypeGlyph trueTypeGlyph = new TrueTypeGlyph(cGlyph);
                if (!this.glyphDefined.contains(trueTypeGlyph)) {
                    characters.add(trueTypeGlyph);
                }
                if ((flags & 0x20) == 0) {
                    return characters;
                }
                int skip = (flags & 1) != 0 ? 4 : 2;
                if ((flags & 8) != 0) {
                    skip += 2;
                } else if ((flags & 0x40) != 0) {
                    skip += 4;
                }
                if ((flags & 0x80) != 0) {
                    skip += 8;
                }
                this.rf.skipBytes(skip);
            }
        }

        public byte[] getGlyphData(int glyph) throws IOException {
            int[] glyphDataPosition = this.getGlyphDataPosition(glyph);
            int dataOffsetRelativeToGlyfTable = glyphDataPosition[0];
            int dataLength = glyphDataPosition[1];
            int[] glyphLocation = (int[])TrueTypeFont.this.positionTables.get("glyf");
            int dataOffset = dataOffsetRelativeToGlyfTable + glyphLocation[0];
            byte[] result = new byte[dataLength];
            this.rf.seek(dataOffset);
            this.rf.readFully(result);
            return result;
        }

        private int[] getGlyphDataPosition(int glyphIndex) throws IOException {
            int[] glyphDataPosition = new int[2];
            int[] tableLocation = (int[])TrueTypeFont.this.positionTables.get("loca");
            int offset = tableLocation[0] + ((TrueTypeFont)TrueTypeFont.this).head.locaBytesPerEntry * glyphIndex;
            this.rf.seek(offset);
            if (((TrueTypeFont)TrueTypeFont.this).head.locaBytesPerEntry == 4) {
                glyphDataPosition[0] = this.rf.readInt();
                glyphDataPosition[1] = this.rf.readInt() - glyphDataPosition[0];
            } else {
                glyphDataPosition[0] = this.rf.readUnsignedShort() * 2;
                glyphDataPosition[1] = this.rf.readUnsignedShort() * 2 - glyphDataPosition[0];
            }
            return glyphDataPosition;
        }

        @Override
        public void close() throws IOException {
            this.rf.close();
        }

        private void output(PrintStream out, String key, String value) {
            if (value != null) {
                out.println(String.valueOf(key) + " " + value + " def");
            }
        }

        private void addTables(List<String> tablesToAdd, String[] tablesDesired) {
            int i = 0;
            while (i < tablesDesired.length) {
                String name = tablesDesired[i];
                int[] position = (int[])TrueTypeFont.this.positionTables.get(name);
                if (position != null) {
                    this.addTableNameInOrder(name, tablesToAdd, position);
                }
                ++i;
            }
        }

        private void addTableNameInOrder(String name, List<String> arrayList, int[] position) {
            int j = 0;
            while (j < arrayList.size()) {
                String tableName = arrayList.get(j);
                int[] position1 = (int[])TrueTypeFont.this.positionTables.get(tableName);
                if (position[0] < position1[0]) {
                    arrayList.add(j, name);
                    return;
                }
                ++j;
            }
            arrayList.add(name);
        }

        private void addGdirTable(List<byte[]> metadata, int offset) {
            byte[] gdirMetadata = new byte[16];
            gdirMetadata[0] = 103;
            gdirMetadata[1] = 100;
            gdirMetadata[2] = 105;
            gdirMetadata[3] = 114;
            metadata.add(gdirMetadata);
        }

        private int getEvenLength(int length) {
            return (length + 3) / 4 * 4;
        }

        private byte[] readData(int length) throws IOException {
            byte[] value = new byte[length];
            this.rf.readFully(value);
            return value;
        }

        private boolean hasTable(String tableName) {
            return TrueTypeFont.this.positionTables.get(tableName) != null;
        }

        private void outputSfnts(PrintStream out) {
            String[] tablesDesired = new String[]{"head", "hhea", "maxp", "cvt ", "fpgm", "prep", "hmtx"};
            ArrayList<String> tablesToAdd = new ArrayList<String>();
            this.addTables(tablesToAdd, tablesDesired);
            Collections.sort(tablesToAdd);
            int tableNumber = tablesToAdd.size() + 1;
            int searchRange = this.getSearchRange(tableNumber);
            Util.putInt16(TrueTypeFont.this.directoryRawData, 4, tableNumber);
            Util.putInt16(TrueTypeFont.this.directoryRawData, 6, searchRange);
            Util.putInt16(TrueTypeFont.this.directoryRawData, 8, this.getExponent(searchRange));
            Util.putInt16(TrueTypeFont.this.directoryRawData, 10, (tableNumber << 4) - searchRange);
            ArrayList<byte[]> metadata = new ArrayList<byte[]>();
            ArrayList<byte[]> data = new ArrayList<byte[]>();
            metadata.add(TrueTypeFont.this.directoryRawData);
            this.addGdirTable(metadata, 0);
            int offset = 12 + tableNumber * 16;
            byte[] headData = null;
            int i = 0;
            while (i < tablesToAdd.size()) {
                String name = (String)tablesToAdd.get(i);
                int newOffset = offset;
                try {
                    int[] tableLocation = TrueTypeFont.this.getTableLocation(name);
                    if (tableLocation != null) {
                        byte[] tableMetadata = (byte[])TrueTypeFont.this.metadataTables.get(name);
                        TrueTypeFont.this.setOffset(tableMetadata, offset);
                        metadata.add(tableMetadata);
                        newOffset = offset + this.getEvenLength(tableLocation[1]);
                        List<byte[]> datas = this.readTable(name);
                        if ("head".equals(name)) {
                            headData = datas.get(0);
                        }
                        data.addAll(datas);
                    }
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "failed to add table: " + name);
                }
                offset = newOffset;
                ++i;
            }
            long adjustment = this.calculateChecksumAdjustment(metadata, data);
            Util.putInt32(headData, 8, adjustment);
            out.println("/sfnts [");
            byte[] metadataArray = this.concatMetadata(metadata);
            out.println(this.toHexString(metadataArray));
            for (byte[] bytes : data) {
                out.println(this.toHexString(bytes));
            }
            out.println("] def");
        }

        private String toHexString(byte[] metadataArray) {
            return TrueTypeFont.toPSDataString(Util.toHexString(metadataArray));
        }

        private byte[] concatMetadata(ArrayList<byte[]> metadata) {
            int length = 0;
            for (byte[] data : metadata) {
                length += data.length;
            }
            byte[] result = new byte[length];
            int offset = 0;
            for (byte[] data : metadata) {
                System.arraycopy(data, 0, result, offset, data.length);
                offset += data.length;
            }
            return result;
        }

        private long calculateChecksumAdjustment(List<byte[]> datas1, List<byte[]> datas2) {
            ArrayList<byte[]> allDatas = new ArrayList<byte[]>();
            allDatas.addAll(datas1);
            allDatas.addAll(datas2);
            return this.calculateChecksumAdjustment(allDatas);
        }

        private long calculateChecksumAdjustment(List<byte[]> allDatas) {
            long calculateChecksum = TrueTypeFont.this.calculateChecksum(allDatas);
            long value = 2981146554L;
            long adjustment = value - calculateChecksum;
            return adjustment & 0xFFFFFFFFL;
        }

        private int getSearchRange(int tableNumber) {
            int result = 1;
            int next = result << 1;
            while (next <= tableNumber) {
                result = next;
                next = result << 1;
            }
            return result << 4;
        }

        private int getExponent(int searchRange) {
            assert ((searchRange >>= 4) >= 1);
            int result = 0;
            while (searchRange > 1) {
                searchRange >>= 1;
                ++result;
            }
            return result;
        }

        private List<byte[]> readTable(String name) throws DocumentException, IOException {
            int[] tableLocation = TrueTypeFont.this.getTableLocation(name);
            if (tableLocation == null) {
                return null;
            }
            this.rf.seek(tableLocation[0]);
            byte[] data = this.readData(this.getEvenLength(tableLocation[1]));
            return this.split(data);
        }

        private List<byte[]> split(byte[] data) {
            byte[] slice;
            ArrayList<byte[]> result = new ArrayList<byte[]>();
            int length = data.length;
            int offset = 0;
            while (length > 16384) {
                length -= 16384;
                slice = new byte[16384];
                System.arraycopy(data, offset, slice, 0, slice.length);
                offset += 16384;
                result.add(slice);
            }
            if (length > 0) {
                slice = new byte[length];
                System.arraycopy(data, offset, slice, 0, length);
                result.add(slice);
            }
            return result;
        }

        @Override
        public String toHexString(String text) {
            StringBuffer buffer = new StringBuffer();
            buffer.append('<');
            int i = 0;
            while (i < text.length()) {
                char c = text.charAt(i);
                int glyphIndex = TrueTypeFont.this.getGlyphIndex(c);
                buffer.append(Util.toHexString(glyphIndex));
                ++i;
            }
            buffer.append('>');
            return buffer.toString();
        }

        private class TrueTypeGlyph {
            protected int glyph;

            public TrueTypeGlyph(int glyph) {
                this.glyph = glyph;
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof TrueTypeGlyph)) {
                    return false;
                }
                if (obj == this) {
                    return true;
                }
                TrueTypeGlyph glyph = (TrueTypeGlyph)obj;
                return this.glyph == glyph.glyph;
            }

            public int hashCode() {
                return this.glyph;
            }

            public void ensureRawDataAvailable(PrintStream out, String fontName) {
                out.print(String.valueOf(this.glyph) + " ");
                try {
                    TrueTypeFont.outputAsPsString(out, TrueTypeWriter.this.getGlyphData(this.glyph));
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, e.getMessage());
                }
                out.println(" /" + fontName + " AddT42Glyph");
            }
        }
    }

    protected static class WindowsMetrics {
        short xAvgCharWidth;
        int usWeightClass;
        int usWidthClass;
        short fsType;
        short ySubscriptXSize;
        short ySubscriptYSize;
        short ySubscriptXOffset;
        short ySubscriptYOffset;
        short ySuperscriptXSize;
        short ySuperscriptYSize;
        short ySuperscriptXOffset;
        short ySuperscriptYOffset;
        short yStrikeoutSize;
        short yStrikeoutPosition;
        short sFamilyClass;
        byte[] panose = new byte[10];
        byte[] achVendID = new byte[4];
        int fsSelection;
        int usFirstCharIndex;
        int usLastCharIndex;
        short sTypoAscender;
        short sTypoDescender;
        short sTypoLineGap;
        int usWinAscent;
        int usWinDescent;
        int ulCodePageRange1;
        int ulCodePageRange2;
        int sCapHeight;

        protected WindowsMetrics() {
        }
    }
}

