/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.ui.annotations.initialization;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.initialization.AnnotationAttributeInitializer;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIPlugin;
import org.eclipse.jst.ws.jaxws.core.utils.JDTUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceAttributeInitializer
extends AnnotationAttributeInitializer {
    public List<MemberValuePair> getMemberValuePairs(IJavaElement javaElement, AST ast, Class<? extends Annotation> annotationClass) {
        ArrayList<MemberValuePair> memberValuePairs = new ArrayList<MemberValuePair>();
        if (javaElement.getElementType() == 7) {
            try {
                IType type = (IType)javaElement;
                MemberValuePair nameValuePair = AnnotationsCore.createStringMemberValuePair((AST)ast, (String)"name", (String)this.getName(type));
                MemberValuePair portNameValuePair = AnnotationsCore.createStringMemberValuePair((AST)ast, (String)"portName", (String)this.getPortName(type));
                MemberValuePair serviceNameValuePair = AnnotationsCore.createStringMemberValuePair((AST)ast, (String)"serviceName", (String)this.getServiceName(type));
                MemberValuePair targetNamespaceValuePair = AnnotationsCore.createStringMemberValuePair((AST)ast, (String)"targetNamespace", (String)this.getTargetNamespace(type));
                if (type.isInterface()) {
                    memberValuePairs.add(nameValuePair);
                }
                memberValuePairs.add(targetNamespaceValuePair);
                if (type.isClass()) {
                    memberValuePairs.add(portNameValuePair);
                    memberValuePairs.add(serviceNameValuePair);
                }
            }
            catch (JavaModelException jme) {
                JAXWSUIPlugin.log(jme.getStatus());
            }
        }
        return memberValuePairs;
    }

    public List<ICompletionProposal> getCompletionProposalsForMemberValuePair(IJavaElement javaElement, MemberValuePair memberValuePair) {
        ArrayList<ICompletionProposal> completionProposals = new ArrayList<ICompletionProposal>();
        if (javaElement.getElementType() == 7) {
            IType type = (IType)javaElement;
            String memberValuePairName = memberValuePair.getName().getIdentifier();
            if (memberValuePairName.equals("endpointInterface")) {
                List<String> interfaces = this.getInterfaces(type);
                for (String anInterface : interfaces) {
                    completionProposals.add((ICompletionProposal)this.createCompletionProposal(anInterface, memberValuePair.getValue(), JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.int_obj.gif"), anInterface));
                }
            }
            if (memberValuePairName.equals("name")) {
                completionProposals.add((ICompletionProposal)this.createCompletionProposal(this.getName(type), memberValuePair.getValue()));
            }
            if (memberValuePairName.equals("portName")) {
                completionProposals.add((ICompletionProposal)this.createCompletionProposal(this.getPortName(type), memberValuePair.getValue()));
            }
            if (memberValuePairName.equals("serviceName")) {
                completionProposals.add((ICompletionProposal)this.createCompletionProposal(this.getServiceName(type), memberValuePair.getValue()));
            }
            if (memberValuePairName.equals("targetNamespace")) {
                completionProposals.add((ICompletionProposal)this.createCompletionProposal(this.getTargetNamespace(type), memberValuePair.getValue()));
            }
        }
        return completionProposals;
    }

    public String getName(IType type) {
        return type.getElementName();
    }

    public String getPortName(IType type) {
        return String.valueOf(type.getElementName()) + "Port";
    }

    public String getServiceName(IType type) {
        return String.valueOf(type.getElementName()) + "Service";
    }

    public String getTargetNamespace(IType type) {
        return JDTUtils.getTargetNamespaceFromPackageName((String)type.getPackageFragment().getElementName());
    }

    private List<String> getInterfaces(IType type) {
        try {
            IType[] allInterfaces;
            ArrayList<String> interfaces = new ArrayList<String>();
            ITypeHierarchy typeHierarchy = type.newTypeHierarchy(type.getJavaProject(), null);
            IType[] iTypeArray = allInterfaces = typeHierarchy.getAllInterfaces();
            int n = allInterfaces.length;
            int n2 = 0;
            while (n2 < n) {
                IType aInterface = iTypeArray[n2];
                if (!aInterface.isBinary() && aInterface.getResource().getProject().equals((Object)type.getResource().getProject())) {
                    String packageName = aInterface.getPackageFragment().getElementName();
                    if (packageName.trim().length() > 0) {
                        packageName = String.valueOf(packageName) + ".";
                    }
                    String qualifiedName = String.valueOf(packageName) + aInterface.getPrimaryElement().getElementName();
                    interfaces.add(qualifiedName);
                }
                ++n2;
            }
            return interfaces;
        }
        catch (JavaModelException jme) {
            JAXWSUIPlugin.log(jme.getStatus());
            return Collections.emptyList();
        }
    }
}

