/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.script;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.script.JSObjectMetaData;
import org.eclipse.birt.report.designer.internal.ui.script.JSSyntaxContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JavaClassJSObject
implements JSObjectMetaData {
    private Class<?> clazz;

    public JavaClassJSObject(Class<?> clazz) {
        this.clazz = clazz;
    }

    public JavaClassJSObject(String className) throws ClassNotFoundException {
        this.clazz = Class.forName(className);
    }

    @Override
    public String getName() {
        return this.clazz.getName();
    }

    @Override
    public JSObjectMetaData.JSMethod[] getMethods() {
        ArrayList<JavaClassMethod> jsMehods = new ArrayList<JavaClassMethod>();
        jsMehods.addAll(this.getMethods(this.clazz.getMethods()));
        Collections.sort(jsMehods);
        return jsMehods.toArray(new JSObjectMetaData.JSMethod[jsMehods.size()]);
    }

    private List<JavaClassMethod> getMethods(Method[] methods) {
        ArrayList<JavaClassMethod> jsMehods = new ArrayList<JavaClassMethod>();
        ArrayList<String> setMethodList = new ArrayList<String>();
        ArrayList<String> getMethodList = new ArrayList<String>();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().startsWith("set") && methods[i].getParameterTypes() != null && methods[i].getParameterTypes().length == 1) {
                setMethodList.add(methods[i].getName().substring(3));
            } else if (methods[i].getName().startsWith("get") && methods[i].getParameterTypes() != null && methods[i].getParameterTypes().length == 0) {
                getMethodList.add(methods[i].getName().substring(3));
            } else {
                jsMehods.add(new JavaClassMethod(methods[i]));
            }
            ++i;
        }
        i = 0;
        while (i < methods.length) {
            if (methods[i].getName().startsWith("set") && methods[i].getParameterTypes() != null && methods[i].getParameterTypes().length == 1) {
                if (!getMethodList.contains(methods[i].getName().substring(3))) {
                    jsMehods.add(new JavaClassMethod(methods[i]));
                }
            } else if (methods[i].getName().startsWith("get") && methods[i].getParameterTypes() != null && methods[i].getParameterTypes().length == 0 && !setMethodList.contains(methods[i].getName().substring(3))) {
                jsMehods.add(new JavaClassMethod(methods[i]));
            }
            ++i;
        }
        return jsMehods;
    }

    @Override
    public JSObjectMetaData.JSField[] getFields() {
        ArrayList<JavaClassField> jsFields = new ArrayList<JavaClassField>();
        jsFields.addAll(this.getFields(this.clazz));
        Collections.sort(jsFields);
        return jsFields.toArray(new JSObjectMetaData.JSField[jsFields.size()]);
    }

    private List<JavaClassField> getFields(Class<?> clazz) {
        String methodName;
        Method[] methods = clazz.getMethods();
        ArrayList<JavaClassField> jsFields = new ArrayList<JavaClassField>();
        ArrayList<String> setMethodList = new ArrayList<String>();
        int i = 0;
        while (i < methods.length) {
            methodName = methods[i].getName();
            if (methodName.startsWith("set") && methods[i].getParameterTypes() != null && methods[i].getParameterTypes().length == 1) {
                setMethodList.add(methodName.substring(3));
            }
            ++i;
        }
        i = 0;
        while (i < methods.length) {
            methodName = methods[i].getName();
            if (methods[i].getName().startsWith("get") && methods[i].getParameterTypes() != null && methods[i].getParameterTypes().length == 0 && setMethodList.contains(methodName.substring(3))) {
                Class<?> type = methods[i].getReturnType();
                JavaClassField field = new JavaClassField(methods[i].getDeclaringClass(), this.getFieldName(methodName), this.getClazzName(type), type.isArray());
                if (!jsFields.contains(field)) {
                    jsFields.add(field);
                }
            }
            ++i;
        }
        Field[] fields = clazz.getFields();
        int i2 = 0;
        while (i2 < fields.length) {
            jsFields.add(new JavaClassField(fields[i2]));
            ++i2;
        }
        if (clazz.isArray()) {
            jsFields.add(new JavaClassField(clazz, "length", Integer.TYPE.getName(), false));
        }
        return jsFields;
    }

    private String getFieldName(String methodName) {
        if (methodName.length() == 3) {
            return "";
        }
        return Introspector.decapitalize(methodName.substring(3));
    }

    public String toString() {
        return this.clazz.getName();
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public int getVisibility() {
        return 0;
    }

    private String getSimpleName(Class<?> clazz) {
        String simpleName = null;
        if (clazz.isArray()) {
            simpleName = clazz.getComponentType().getName();
            if (!clazz.getComponentType().isPrimitive()) {
                simpleName = simpleName.substring(simpleName.lastIndexOf(".") + 1);
            }
            simpleName = String.valueOf(simpleName) + "[]";
        } else {
            simpleName = clazz.getName();
            if (!clazz.isPrimitive()) {
                simpleName = simpleName.substring(simpleName.lastIndexOf(".") + 1);
            }
        }
        return simpleName;
    }

    private String getSimpleName(String name) {
        return name.substring(name.lastIndexOf(".") + 1);
    }

    @Override
    public JSObjectMetaData getComponentType() {
        if (this.clazz.isArray()) {
            return new JavaClassJSObject(this.clazz.getComponentType());
        }
        return null;
    }

    private String getClazzName(Class<?> clazz) {
        String name;
        if (clazz.isArray()) {
            name = clazz.getComponentType().getName();
            name = String.valueOf(name) + "[]";
        } else {
            name = clazz.getName();
        }
        return name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JavaClassField
    implements JSObjectMetaData.JSField,
    Comparable {
        private String name;
        private JSObjectMetaData type;
        private String typeName;
        private Field field;
        private Class<?> declareClazz;
        private String displayText;
        private boolean isArray;

        public JavaClassField(Field field) {
            this.field = field;
            this.name = field.getName();
            try {
                this.type = JSSyntaxContext.getJavaClassMeta(field.getType().getName());
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }

        public JavaClassField(Class<?> declareClazz, String name, String type, boolean isArray) {
            this.declareClazz = declareClazz;
            this.name = name;
            try {
                this.type = JSSyntaxContext.getJavaClassMeta(type);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.typeName = type;
            }
            this.isArray = isArray;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public JSObjectMetaData getType() {
            return this.type;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof JavaClassField) || ((JavaClassField)obj).getName() == null) {
                return false;
            }
            return ((JavaClassField)obj).getName().equals(this.name);
        }

        @Override
        public String getDisplayText() {
            if (this.displayText == null) {
                StringBuffer strbuf = new StringBuffer(this.getName());
                strbuf.append(" ");
                if (this.field != null && this.field.getType() != null) {
                    strbuf.append(JavaClassJSObject.this.getSimpleName(this.field.getType()));
                    strbuf.append(" - ");
                } else if (this.type != null) {
                    strbuf.append(JavaClassJSObject.this.getSimpleName(this.type.getName()));
                    if (this.isArray) {
                        strbuf.append("[]");
                    }
                    strbuf.append(" - ");
                } else if (this.typeName != null) {
                    strbuf.append(JavaClassJSObject.this.getSimpleName(this.typeName));
                    strbuf.append(" - ");
                }
                if (this.field == null) {
                    strbuf.append(JavaClassJSObject.this.getSimpleName(this.declareClazz));
                } else {
                    strbuf.append(JavaClassJSObject.this.getSimpleName(this.field.getDeclaringClass()));
                }
                this.displayText = strbuf.toString();
                Object var1_1 = null;
            }
            return this.displayText;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public int getVisibility() {
            if (this.field == null) {
                return 0;
            }
            if ((this.field.getModifiers() & 8) != 0) {
                return 3;
            }
            if ((this.field.getModifiers() & 1) != 0) {
                return 0;
            }
            if ((this.field.getModifiers() & 2) != 0) {
                return 2;
            }
            if ((this.field.getModifiers() & 4) != 0) {
                return 1;
            }
            return 0;
        }

        public int compareTo(Object obj) {
            if (obj instanceof JavaClassField && ((JavaClassField)obj).getName() != null) {
                if (this.getVisibility() == 3 && ((JavaClassField)obj).getVisibility() == 0) {
                    return 1;
                }
                return this.getName().compareToIgnoreCase(((JavaClassField)obj).getName());
            }
            return 0;
        }
    }

    private class JavaClassMethod
    implements JSObjectMetaData.JSMethod,
    Comparable {
        private Method method;
        private String displayText;

        public JavaClassMethod(Method method) {
            this.method = method;
        }

        public String getName() {
            return this.method.getName();
        }

        public JSObjectMetaData getReturn() {
            try {
                return JSSyntaxContext.getJavaClassMeta(this.method.getReturnType().getName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }

        public JSObjectMetaData[] getArguments() {
            Class<?>[] types = this.method.getParameterTypes();
            if (types.length > 0) {
                JSObjectMetaData[] args = new JSObjectMetaData[types.length];
                int i = 0;
                while (i < types.length) {
                    args[i] = JSSyntaxContext.getJavaClassMeta(types[i]);
                    ++i;
                }
                return args;
            }
            return null;
        }

        public String getDisplayText() {
            if (this.displayText == null) {
                StringBuffer strbuf = new StringBuffer(this.getName());
                strbuf.append("(");
                Class<?>[] parameters = this.method.getParameterTypes();
                int i = 0;
                while (i < parameters.length) {
                    if (i > 0) {
                        strbuf.append(", ");
                    }
                    strbuf.append(JavaClassJSObject.this.getSimpleName(parameters[i])).append(" ").append("arg").append(i + 1);
                    ++i;
                }
                strbuf.append(") ");
                strbuf.append(JavaClassJSObject.this.getSimpleName(this.method.getReturnType()));
                strbuf.append(" - ");
                strbuf.append(JavaClassJSObject.this.getSimpleName(this.method.getDeclaringClass()));
                this.displayText = strbuf.toString();
                Object var1_1 = null;
            }
            return this.displayText;
        }

        public String getDescription() {
            return null;
        }

        public int getVisibility() {
            if ((this.method.getModifiers() & 8) != 0) {
                return 3;
            }
            if ((this.method.getModifiers() & 1) != 0) {
                return 0;
            }
            if ((this.method.getModifiers() & 2) != 0) {
                return 2;
            }
            if ((this.method.getModifiers() & 4) != 0) {
                return 1;
            }
            return 0;
        }

        public int compareTo(Object obj) {
            if (obj instanceof JavaClassMethod && ((JavaClassMethod)obj).getName() != null) {
                if (this.getVisibility() == 3 && ((JavaClassMethod)obj).getVisibility() == 0) {
                    return 1;
                }
                return this.getName().compareToIgnoreCase(((JavaClassMethod)obj).getName());
            }
            return 0;
        }
    }
}

