/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures;

import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.SectionBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.ReportElementFigure;
import org.eclipse.birt.report.designer.internal.ui.layout.IFixLayoutHelper;
import org.eclipse.birt.report.designer.internal.ui.layout.ListLayout;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;

public class ListFigure
extends ReportElementFigure
implements IFixLayoutHelper {
    private static final String BORDER_TEXT = Messages.getString((String)"ListFigure.BORDER_TEXT");
    private boolean dirty = true;
    private Dimension recommendSize = new Dimension();

    public ListFigure() {
        SectionBorder border = new SectionBorder();
        border.setIndicatorLabel(BORDER_TEXT);
        border.setIndicatorIcon(ReportPlatformUIImages.getImage("List"));
        this.setBorder((Border)border);
        this.setLayoutManager((LayoutManager)new ListLayout());
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
    }

    public void markDirtyTree(boolean flag) {
        this.markDirtyTree((IFigure)this, flag);
    }

    public void markDirtyTree(IFigure container, boolean flag) {
        if (container instanceof ListFigure) {
            ((ListFigure)container).markDirty(flag);
        }
        List children = container.getChildren();
        for (Object child : children) {
            if (!(child instanceof IFigure)) continue;
            this.markDirtyTree((IFigure)child, flag);
        }
    }

    public void markDirty(boolean flag) {
        this.dirty = flag;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setRecommendSize(Dimension recommendSize) {
        this.recommendSize = recommendSize;
    }

    public Dimension getFixPreferredSize(int w, int h) {
        Dimension size = this.recommendSize.width > 0 ? this.getPreferredSize(this.recommendSize.width, h) : this.getPreferredSize(w, h);
        int width = size.width;
        int height = size.height;
        if (this.recommendSize.width > 0) {
            width = this.recommendSize.width;
        }
        return new Dimension(width, height);
    }

    public Dimension getFixMinimumSize(int w, int h) {
        Dimension size = this.recommendSize.width > 0 ? this.getPreferredSize(this.recommendSize.width, h) : this.getPreferredSize(w, h);
        int width = size.width;
        int height = size.height;
        if (this.recommendSize.width > 0) {
            width = this.recommendSize.width;
        }
        return new Dimension(width, height);
    }
}

