/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.WizardSelectCssStylePage;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;

public class SelectCssStyleWizard
extends Wizard {
    private static final String WIZARD_PAGE_DESCRIPTION_REPORT = Messages.getString((String)"SelectCssStyleWizard.wizardPage.description.report");
    private static final String WIZARD_PAGE_DESCRIPTION_LIBRARY = Messages.getString((String)"SelectCssStyleWizard.wizardPage.description.library");
    private static final String WIZARD_PAGE_TITLE = Messages.getString((String)"SelectCssStyleWizard.wizardPage.title");
    private static final String WIZARD_PAGE_NAME = Messages.getString((String)"SelectCssStyleWizard.wizardPage.name");
    private static final String WIZARD_TITLE = Messages.getString((String)"SelectCssStyleWizard.wizard.title");
    private Object selection;
    private WizardSelectCssStylePage stylePage;

    public SelectCssStyleWizard(Object selection) {
        this.setWindowTitle(WIZARD_TITLE);
        this.selection = selection;
    }

    public Image getDefaultPageImage() {
        return super.getDefaultPageImage();
    }

    public void addPages() {
        DesignElementHandle element;
        this.stylePage = new WizardSelectCssStylePage(WIZARD_PAGE_NAME);
        this.stylePage.setTitle(WIZARD_PAGE_TITLE);
        String pageDesc = WIZARD_PAGE_DESCRIPTION_REPORT;
        if (this.selection != null && this.selection instanceof DesignElementHandle && ((element = (DesignElementHandle)this.selection) instanceof ThemeHandle || element.getContainer() instanceof ThemeHandle)) {
            pageDesc = WIZARD_PAGE_DESCRIPTION_LIBRARY;
        }
        this.stylePage.setDescription(pageDesc);
        this.addPage((IWizardPage)this.stylePage);
    }

    public boolean canFinish() {
        return this.stylePage.isPageComplete();
    }

    public boolean performFinish() {
        CssStyleSheetHandle cssHandle = this.stylePage.getCssHandle();
        if (cssHandle != null) {
            List styleList = this.stylePage.getStyleList();
            ModuleHandle module = SessionHandleAdapter.getInstance().getReportDesignHandle();
            if (this.selection != null && this.selection instanceof DesignElementHandle) {
                DesignElementHandle element = (DesignElementHandle)this.selection;
                if (this.selection instanceof ThemeHandle) {
                    LibraryHandle libraryHandle = (LibraryHandle)module;
                    libraryHandle.importCssStyles(cssHandle, styleList, element.getName());
                } else if (element.getContainer() instanceof ThemeHandle) {
                    LibraryHandle libraryHandle = (LibraryHandle)module;
                    libraryHandle.importCssStyles(cssHandle, styleList, element.getContainer().getName());
                } else if (element instanceof StyleHandle) {
                    module.importCssStyles(cssHandle, styleList);
                }
            } else if (module instanceof LibraryHandle) {
                LibraryHandle libraryHandle = (LibraryHandle)module;
                libraryHandle.importCssStyles(cssHandle, styleList);
            } else if (module instanceof ReportDesignHandle) {
                module.importCssStyles(cssHandle, styleList);
            }
        }
        return true;
    }
}

