/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.EditorPartAction;
import org.eclipse.gef.ui.actions.SaveAction;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.gef.ui.views.palette.PaletteView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jst.jsf.common.ui.internal.actions.IOpenPage;
import org.eclipse.jst.jsf.facesconfig.edit.provider.FacesConfigItemProviderAdapterFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.ui.EditorMessages;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.FacesConfigActionBarContributor;
import org.eclipse.jst.jsf.facesconfig.ui.ModelLoader;
import org.eclipse.jst.jsf.facesconfig.ui.MultiPageEditorOutlinePage;
import org.eclipse.jst.jsf.facesconfig.ui.page.ComponentsPage;
import org.eclipse.jst.jsf.facesconfig.ui.page.IntroductionPage;
import org.eclipse.jst.jsf.facesconfig.ui.page.ManagedBeanPage;
import org.eclipse.jst.jsf.facesconfig.ui.page.OthersPage;
import org.eclipse.jst.jsf.facesconfig.ui.page.OverviewPage;
import org.eclipse.jst.jsf.facesconfig.ui.page.WaitForLoadPage;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.DelegatingZoomManager;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.PageflowEditor;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.command.DelegatingCommandStack;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.command.EMFCommandStackGEFAdapter;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.layout.PageflowLayoutManager;
import org.eclipse.jst.jsf.facesconfig.ui.preference.GEMPreferences;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.internal.BaseSaveAction;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

public class FacesConfigEditor
extends FormEditor
implements IEditingDomainProvider,
ISelectionProvider {
    public static final String EDITOR_ID = "org.eclipse.jst.jsf.facesconfig.ui.FacesConfigEditor";
    public static final String SOURCE_PAGE_ID = "SourcePageId";
    private AdapterFactoryEditingDomain editingDomain;
    private ComposedAdapterFactory adapterFactory;
    private int pageflowPageID;
    private int managedBeanPageID;
    private int componentsPageID;
    private int othersPageID;
    private int sourcePageId;
    private PageflowEditor pageflowPage;
    private StructuredTextEditor sourcePage;
    private Collection selectionChangedListeners = new ArrayList();
    private ISelection editorSelection = StructuredSelection.EMPTY;
    private IContentOutlinePage outlinePage;
    private IProject currentProject;
    private boolean isWebProject;
    private ModelLoader _modelLoader;
    private boolean _isDisposed;
    private final AddPagesTask _addPagesTask = new AddPagesTask();
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected ResourceSet resourceSet;
                    protected Collection changedResources;
                    protected Collection removedResources;

                    ResourceDeltaVisitor() {
                        this.resourceSet = FacesConfigEditor.this.editingDomain.getResourceSet();
                        this.changedResources = new ArrayList();
                        this.removedResources = new ArrayList();
                    }

                    public boolean visit(IResourceDelta delta_) {
                        Resource resource;
                        if (delta_.getFlags() != 131072 && delta_.getResource().getType() == 1 && (delta_.getKind() & 6) != 0 && (resource = this.resourceSet.getResource(URI.createURI((String)delta_.getFullPath().toString()), false)) != null) {
                            if ((delta_.getKind() & 2) != 0) {
                                this.removedResources.add(resource);
                            } else {
                                this.changedResources.add(resource);
                            }
                        }
                        return true;
                    }

                    public Collection getChangedResources() {
                        return this.changedResources;
                    }

                    public Collection getRemovedResources() {
                        return this.removedResources;
                    }
                }
                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                if (!visitor.getRemovedResources().isEmpty()) {
                    FacesConfigEditor.this.removedResources.addAll(visitor.getRemovedResources());
                    if (!FacesConfigEditor.this.isDirty()) {
                        FacesConfigEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                FacesConfigEditor.this.getSite().getPage().closeEditor((IEditorPart)FacesConfigEditor.this, false);
                                FacesConfigEditor.this.dispose();
                            }
                        });
                    }
                }
                if (!visitor.getChangedResources().isEmpty()) {
                    FacesConfigEditor.this.changedResources.addAll(visitor.getChangedResources());
                }
            }
            catch (CoreException exception) {
                EditorPlugin.getDefault().getLog().log((IStatus)new Status(4, EditorPlugin.getPluginId(), 0, exception.getMessage() == null ? "" : exception.getMessage(), (Throwable)exception));
            }
        }
    };
    Collection removedResources = new ArrayList();
    Collection changedResources = new ArrayList();
    Collection savedResources = new ArrayList();
    private ActionRegistry actionRegistry = null;
    private MultiPageCommandStackListener multiPageCommandStackListener = null;
    private DelegatingZoomManager delegatingZoomManager = null;
    private DelegatingCommandStack delegatingCommandStack = null;
    private EMFCommandStackGEFAdapter sourceCommandStack;
    private List editorActionIDs = new ArrayList();

    public FacesConfigEditor() {
        this.initializeEMF();
    }

    private void initializeEMF() {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new FacesConfigItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        this.adapterFactory = new ComposedAdapterFactory(factories);
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                FacesConfigEditor.this.getContainer().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        FacesConfigEditor.this.editorDirtyStateChanged();
                        FacesConfigEditor.this.getActionBarContributor().updateActionBars();
                    }
                });
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (org.eclipse.emf.common.command.CommandStack)commandStack, new HashMap());
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        try {
            super.init(site, input);
        }
        catch (Exception exception) {
            MessageDialog.openError(null, (String)EditorMessages.FacesConfigEditor_Error_OpenModel_Title, (String)EditorMessages.FacesConfigEditor_Error_OpenModel);
            throw new PartInitException(EditorMessages.FacesConfigEditor_Error_OpenModel);
        }
        this.setPartName(input.getName());
        if (!this.isValidInput(input)) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(input, "org.eclipse.ui.DefaultTextEditor");
            this.close(false);
            return;
        }
        this.createActions();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    protected void setInput(IEditorInput input) {
        this.isWebProject = this.matches(input);
        super.setInput(input);
        IFile inputFile = (IFile)input.getAdapter(IFile.class);
        if (inputFile != null) {
            IProject project = inputFile.getProject();
            IPath inputPath = inputFile.getFullPath();
            this._modelLoader = new ModelLoader();
            this._modelLoader.load(project, inputPath, this.isWebProject, this._addPagesTask);
        }
    }

    protected void addPages() {
        this._addPagesTask.maybeAddWaitPage();
    }

    protected void createAndAddPageflowPage() throws PartInitException {
        this.pageflowPage = new PageflowEditor((IEditorPart)this);
        this.pageflowPageID = this.addPage((IEditorPart)this.pageflowPage, this.getEditorInput());
        this.setPageText(this.pageflowPageID, EditorMessages.FacesConfigEditor_Pageflow_TabName);
        this.addPageActionRegistry((IEditorPart)this.pageflowPage);
        this.pageflowPage.getModelsTransform().setFacesConfig(this.getFacesConfig());
        this.pageflowPage.getModelsTransform().setPageflow(this.pageflowPage.getPageflow());
        boolean fornew = this.pageflowPage.getModelsTransform().updatePageflowModelFromEMF();
        this.pageflowPage.setGraphicalViewerContents(this.pageflowPage.getPageflow());
        if (fornew) {
            PageflowLayoutManager.getInstance().layoutPageflow(this.pageflowPage.getPageflow());
        }
        this.pageflowPage.getModelsTransform().setListenToNotify(true);
    }

    public PageflowEditor getPageflowPage() {
        return this.pageflowPage;
    }

    protected void addPageActionRegistry(IEditorPart page) {
        ActionRegistry pageActionRegisty;
        if (page != null && (pageActionRegisty = (ActionRegistry)page.getAdapter(ActionRegistry.class)) != null) {
            Iterator iter = pageActionRegisty.getActions();
            while (iter.hasNext()) {
                this.getActionRegistry().registerAction((IAction)iter.next());
            }
        }
    }

    protected ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    public FacesConfigType getFacesConfig() {
        FacesConfigArtifactEdit edit = this._modelLoader.getEdit();
        if (edit != null) {
            return edit.getFacesConfig();
        }
        return null;
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded() || super.isDirty();
    }

    protected MultiPageCommandStackListener getMultiPageCommandStackListener() {
        if (this.multiPageCommandStackListener == null) {
            this.multiPageCommandStackListener = new MultiPageCommandStackListener();
        }
        return this.multiPageCommandStackListener;
    }

    public void doSave(IProgressMonitor monitor) {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor_) {
                try {
                    if (FacesConfigEditor.this.isWebProject && FacesConfigEditor.this._modelLoader.getEdit() != null) {
                        Resource deploymentDescriptorResource = FacesConfigEditor.this._modelLoader.getEdit().getDeploymentDescriptorResource();
                        if (deploymentDescriptorResource != null) {
                            deploymentDescriptorResource.save(Collections.EMPTY_MAP);
                        }
                        IFile file = ((IFileEditorInput)FacesConfigEditor.this.getEditorInput()).getFile();
                        FacesConfigEditor.this.pageflowPage.doSave(file, monitor_);
                    }
                    FacesConfigEditor.this.sourcePage.doSave(monitor_);
                    FacesConfigEditor.this.getMultiPageCommandStackListener().markSaveLocations();
                }
                catch (Exception e) {
                    EditorPlugin.getDefault().getLog().log((IStatus)new Status(4, EditorPlugin.getPluginId(), 0, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e));
                }
            }
        };
        try {
            for (Object obj : this.pages) {
                if (!(obj instanceof FormPage)) continue;
                ((FormPage)obj).doSave(monitor);
            }
            operation.run(null);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.editorDirtyStateChanged();
        }
        catch (Exception e) {
            EditorPlugin.getDefault().getLog().log((IStatus)new Status(4, EditorPlugin.getPluginId(), 0, e.getMessage(), (Throwable)e));
        }
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            this.doSaveAs(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false), (IEditorInput)new FileEditorInput(file));
        }
    }

    protected void doSaveAs(URI uri, IEditorInput editorInput) {
        ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).setURI(uri);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        NullProgressMonitor progressMonitor = this.getActionBars().getStatusLineManager() != null ? this.getActionBars().getStatusLineManager().getProgressMonitor() : new NullProgressMonitor();
        this.doSave((IProgressMonitor)progressMonitor);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected IPropertySheetPage getPropertySheetPage() {
        return new TabbedPropertySheetPage(new ITabbedPropertySheetPageContributor(){

            public String getContributorId() {
                return FacesConfigEditor.EDITOR_ID;
            }
        });
    }

    private boolean isValidInput(IEditorInput input) {
        IFile file;
        return input != null && (file = (IFile)input.getAdapter(IResource.class)) != null;
    }

    protected DelegatingZoomManager getDelegatingZoomManager() {
        if (!(this.isValidInput(this.getEditorInput()) && this.isWebProject && this._addPagesTask.getArePagesLoaded())) {
            return null;
        }
        if (this.delegatingZoomManager == null) {
            this.delegatingZoomManager = new DelegatingZoomManager();
            this.delegatingZoomManager.setCurrentZoomManager((ZoomManager)this.pageflowPage.getAdapter(ZoomManager.class));
        }
        return this.delegatingZoomManager;
    }

    public DelegatingCommandStack getDelegatingCommandStack() {
        if (this.delegatingCommandStack == null) {
            this.delegatingCommandStack = new DelegatingCommandStack();
        }
        return this.delegatingCommandStack;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IEditingDomainProvider.class) {
            return new IEditingDomainProvider(){

                public EditingDomain getEditingDomain() {
                    return FacesConfigEditor.this.editingDomain;
                }
            };
        }
        if (adapter == EditingDomain.class) {
            return this.editingDomain;
        }
        if (adapter == AdapterFactory.class) {
            return this.adapterFactory;
        }
        if (adapter == IEditorPart.class) {
            return this.getActiveEditor();
        }
        if (adapter == CommandStack.class) {
            return this.getDelegatingCommandStack();
        }
        if (adapter == ZoomManager.class) {
            return this.getDelegatingZoomManager();
        }
        if (adapter == ActionRegistry.class) {
            return this.getActionRegistry();
        }
        if (adapter == IGotoMarker.class) {
            return new IGotoMarker(){

                public void gotoMarker(final IMarker marker) {
                    FacesConfigEditor.this._addPagesTask.pageSafeExecute(new Runnable(){

                        public void run() {
                            FacesConfigEditor.this.gotoMarker(marker);
                        }
                    });
                }
            };
        }
        if (adapter == StructuredTextEditor.class) {
            return this.sourcePage;
        }
        if (adapter == IContentOutlinePage.class) {
            return this.getOutlinePage();
        }
        if (adapter == IPropertySheetPage.class) {
            return this.getPropertySheetPage();
        }
        if (adapter == IProject.class) {
            return this.getProject();
        }
        if (adapter == CTabFolder.class) {
            return this.getContainer();
        }
        if (adapter == IOpenPage.class) {
            return new IOpenPage(){

                public void setActiveEditorPage(String pageID) {
                    FacesConfigEditor.this.setActiveEditorPage(pageID);
                }
            };
        }
        return super.getAdapter(adapter);
    }

    private CommandStack getSourcePageCommandStack() {
        if (this.sourceCommandStack == null) {
            IDocument doc = this.sourcePage.getDocumentProvider().getDocument((Object)this.getEditorInput());
            if (doc instanceof IStructuredDocument) {
                this.sourceCommandStack = new EMFCommandStackGEFAdapter(doc);
            } else {
                EditorPlugin.getDefault().getLog().log((IStatus)new Status(4, EditorPlugin.getPluginId(), 0, "Error getting undo stack for Faces Config editor.  Undo may be disabled", new Throwable()));
            }
        }
        return this.sourceCommandStack;
    }

    protected void addEditorAction(EditorPartAction action) {
        this.getActionRegistry().registerAction((IAction)action);
        this.editorActionIDs.add(action.getId());
    }

    protected void createActions() {
        this.addEditorAction((EditorPartAction)new SaveAction((IEditorPart)this));
    }

    protected void currentPageChanged() {
        IEditorActionBarContributor contributor;
        IEditorPart activeEditor = this.getActiveEditor();
        if (activeEditor == null) {
            return;
        }
        CommandStack cmdStack = null;
        if (activeEditor == this.pageflowPage) {
            cmdStack = (CommandStack)activeEditor.getAdapter(CommandStack.class);
        } else if (activeEditor == this.sourcePage) {
            cmdStack = this.getSourcePageCommandStack();
        }
        this.getMultiPageCommandStackListener().addCommandStack(cmdStack, activeEditor);
        this.getDelegatingCommandStack().setCurrentCommandStack(cmdStack);
        ZoomManager zoomManager = null;
        zoomManager = (ZoomManager)activeEditor.getAdapter(ZoomManager.class);
        if (zoomManager != null) {
            this.getDelegatingZoomManager().setCurrentZoomManager(zoomManager);
        }
        if ((contributor = this.getEditorSite().getActionBarContributor()) != null && contributor instanceof FacesConfigActionBarContributor) {
            ((FacesConfigActionBarContributor)contributor).setActivePage(activeEditor);
            PaletteView paletteView = (PaletteView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.gef.ui.palette_view");
            if (paletteView != null) {
                paletteView.partActivated((IWorkbenchPart)activeEditor);
            }
        }
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        this.currentPageChanged();
    }

    public void dispose() {
        this._isDisposed = true;
        this._modelLoader.dispose();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.adapterFactory.dispose();
        if (this.outlinePage != null) {
            this.outlinePage.dispose();
        }
        if (this.sourcePage != null) {
            this.sourcePage.dispose();
        }
        if (this.sourceCommandStack != null) {
            this.sourceCommandStack.dispose();
        }
        if (this.pageflowPage != null) {
            this.pageflowPage.dispose();
        }
        if (this.multiPageCommandStackListener != null) {
            this.multiPageCommandStackListener.dispose();
        }
        super.dispose();
    }

    public IProject getProject() {
        IFile file;
        if (this.currentProject == null && this._modelLoader.getEdit() != null && (file = this._modelLoader.getEdit().getFile()) != null) {
            this.currentProject = file.getProject();
        }
        return this.currentProject;
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    protected IContentOutlinePage getOutlinePage() {
        if (this.outlinePage == null) {
            this.outlinePage = new MultiPageEditorOutlinePage();
        }
        return this.outlinePage;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
    }

    private void gotoMarker(IMarker marker) {
        this.setActivePage(this.sourcePageId);
        IDE.gotoMarker((IEditorPart)this.sourcePage, (IMarker)marker);
    }

    public FacesConfigActionBarContributor getActionBarContributor() {
        return (FacesConfigActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    private IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public Object getSelectedPage() {
        IFormPage page = this.getActivePageInstance();
        if (page != null) {
            return page;
        }
        if (this.getActiveEditor() instanceof PageflowEditor) {
            return this.getActiveEditor();
        }
        return null;
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)EditorMessages.FacesConfigEditor_ErrorHandlingUndoConflicts_DialogTitle, (String)EditorMessages.FacesConfigEditor_ErrorHandlingUndoConflicts_DialogMessage);
    }

    protected void handleChangedResources() {
        if (!(this.changedResources.isEmpty() || this.isDirty() && !this.handleDirtyConflict())) {
            this.editingDomain.getCommandStack().flush();
            for (Resource resource : this.changedResources) {
                if (!resource.isLoaded()) continue;
                resource.unload();
                try {
                    resource.load(Collections.EMPTY_MAP);
                }
                catch (IOException exception) {
                    EditorPlugin.getDefault().getLog().log((IStatus)new Status(4, EditorPlugin.getPluginId(), 0, exception.getMessage() == null ? "" : exception.getMessage(), (Throwable)exception));
                }
            }
        }
    }

    public void setActiveEditorPage(String pageID) {
        if (pageID.equals("org.eclipse.jst.jsf.facesconfig.ui.pageflow.PageflowEditor")) {
            this.setActivePage(this.pageflowPageID);
        } else if (pageID.equals("org.eclipse.jst.jsf.facesconfig.ui.page.ManagedBeanPage")) {
            this.setActivePage(this.managedBeanPageID);
        } else if (pageID.equals("org.eclipse.jst.jsf.facesconfig.ui.page.ComponentsPage")) {
            this.setActivePage(this.componentsPageID);
        } else if (pageID.equals("org.eclipse.jst.jsf.facesconfig.ui.page.OthersPage")) {
            this.setActivePage(this.othersPageID);
        } else if (pageID.equals(SOURCE_PAGE_ID)) {
            this.setActivePage(this.sourcePageId);
        }
    }

    private boolean matches(IEditorInput input) {
        IProject project;
        IResource file = (IResource)input.getAdapter(IResource.class);
        boolean hasWebFacet = false;
        boolean hasJSFFacet = false;
        if (file != null && (project = file.getProject()) != null) {
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                if (facetedProject != null) {
                    Set facets = facetedProject.getProjectFacets();
                    for (IProjectFacetVersion version : facets) {
                        IProjectFacet facet = version.getProjectFacet();
                        if ("jst.jsf".equals(facet.getId())) {
                            hasJSFFacet = true;
                            continue;
                        }
                        if (!"jst.web".equals(facet.getId())) continue;
                        hasWebFacet = true;
                    }
                }
            }
            catch (CoreException ex) {
                EditorPlugin.getDefault().getLog().log((IStatus)new Status(4, EditorPlugin.getPluginId(), 0, ex.getMessage() == null ? "" : ex.getMessage(), (Throwable)ex));
            }
        }
        return hasWebFacet && hasJSFFacet;
    }

    public void doPageLoad(long timeoutMs) throws InterruptedException {
        this._modelLoader.waitForLoad(timeoutMs);
        this._addPagesTask.doRun(this._modelLoader.getEdit());
    }

    private class AddPagesTask
    extends ModelLoader.ModelLoaderComplete {
        private final AtomicBoolean _arePagesLoaded = new AtomicBoolean(false);
        private FormPage _waitPage;
        private List<Runnable> _deferredRunnables = new ArrayList<Runnable>();

        private AddPagesTask() {
        }

        public synchronized void pageSafeExecute(Runnable runnable) {
            if (!FacesConfigEditor.this._isDisposed) {
                if (!this._arePagesLoaded.get()) {
                    this._deferredRunnables.add(runnable);
                } else {
                    runnable.run();
                }
            }
        }

        public synchronized boolean getArePagesLoaded() {
            return this._arePagesLoaded.get();
        }

        public synchronized void removeWaitPage() {
            int index;
            if (this._waitPage != null && !this._waitPage.getPartControl().isDisposed() && (index = this._waitPage.getIndex()) >= 0) {
                FacesConfigEditor.this.removePage(index);
            }
        }

        public synchronized void maybeAddWaitPage() {
            if (!this.getArePagesLoaded()) {
                this._waitPage = new WaitForLoadPage(FacesConfigEditor.this, "WaitForLoad", EditorMessages.FacesConfigEditor_WaitForLoad_EditorTabTitle);
                try {
                    FacesConfigEditor.this.addPage(0, (IFormPage)this._waitPage);
                }
                catch (PartInitException pie) {
                    this._waitPage = null;
                    EditorPlugin.getDefault().getLog().log((IStatus)new Status(4, EditorPlugin.getPluginId(), 0, pie.getMessage() == null ? "" : pie.getMessage(), (Throwable)pie));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doRun(FacesConfigArtifactEdit edit) {
            AddPagesTask addPagesTask = this;
            synchronized (addPagesTask) {
                this.removeWaitPage();
                if (!this.getArePagesLoaded() && !FacesConfigEditor.this._isDisposed) {
                    try {
                        if (FacesConfigEditor.this.isWebProject && edit != null && edit.getFacesConfig() != null) {
                            if (GEMPreferences.getShowIntroEditor()) {
                                IntroductionPage page1 = new IntroductionPage(FacesConfigEditor.this);
                                FacesConfigEditor.this.addPage((IEditorPart)page1, FacesConfigEditor.this.getEditorInput());
                            }
                            OverviewPage overviewPage = new OverviewPage(FacesConfigEditor.this);
                            FacesConfigEditor.this.addPage((IEditorPart)overviewPage, FacesConfigEditor.this.getEditorInput());
                            FacesConfigEditor.this.createAndAddPageflowPage();
                            ManagedBeanPage managedBeanPage = new ManagedBeanPage(FacesConfigEditor.this);
                            FacesConfigEditor.this.managedBeanPageID = FacesConfigEditor.this.addPage((IEditorPart)managedBeanPage, FacesConfigEditor.this.getEditorInput());
                            ComponentsPage componentsPage = new ComponentsPage(FacesConfigEditor.this);
                            FacesConfigEditor.this.componentsPageID = FacesConfigEditor.this.addPage((IEditorPart)componentsPage, FacesConfigEditor.this.getEditorInput());
                            OthersPage othersPage = new OthersPage(FacesConfigEditor.this);
                            FacesConfigEditor.this.othersPageID = FacesConfigEditor.this.addPage((IEditorPart)othersPage, FacesConfigEditor.this.getEditorInput());
                        }
                        FacesConfigEditor.this.sourcePage = new StructuredTextEditor();
                        FacesConfigEditor.this.sourcePage.setEditorPart((IEditorPart)FacesConfigEditor.this);
                        FacesConfigEditor.this.sourcePageId = FacesConfigEditor.this.addPage((IEditorPart)FacesConfigEditor.this.sourcePage, FacesConfigEditor.this.getEditorInput());
                        FacesConfigEditor.this.setPageText(FacesConfigEditor.this.sourcePageId, EditorMessages.FacesConfigEditor_Source_TabName);
                        FacesConfigEditor.this.sourcePage.update();
                        IAction sourcePageSaveAction = FacesConfigEditor.this.sourcePage.getAction("save");
                        if (sourcePageSaveAction instanceof BaseSaveAction) {
                            ((BaseSaveAction)sourcePageSaveAction).partDeactivated((IWorkbenchPart)FacesConfigEditor.this);
                        }
                        FacesConfigEditor.this.setActivePage(0);
                        for (Runnable runnable : this._deferredRunnables) {
                            runnable.run();
                        }
                        this._arePagesLoaded.set(true);
                    }
                    catch (PartInitException e) {
                        EditorPlugin.getDefault().getLog().log((IStatus)new Status(4, EditorPlugin.getPluginId(), 0, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e));
                    }
                }
            }
        }
    }

    private class MultiPageCommandStackListener
    implements org.eclipse.gef.commands.CommandStackListener {
        private List commandStacks = new ArrayList(2);
        private HashMap mapEditorCommandStack = new HashMap();
        private boolean saveLocation = false;
        private List stackActionIDs = new ArrayList();
        private boolean isDirty = false;

        private MultiPageCommandStackListener() {
        }

        public void addCommandStack(CommandStack commandStack, IEditorPart editor) {
            if (commandStack == null) {
                return;
            }
            if (this.mapEditorCommandStack.get(commandStack) == editor) {
                return;
            }
            this.commandStacks.add(commandStack);
            commandStack.addCommandStackListener((org.eclipse.gef.commands.CommandStackListener)this);
            this.mapEditorCommandStack.put(commandStack, editor);
        }

        private void setEditorDirty(IEditorPart editor, boolean dirty) {
        }

        private void updateActions(List actionIds) {
            Iterator ids = actionIds.iterator();
            while (ids.hasNext()) {
                IAction action = FacesConfigEditor.this.getActionRegistry().getAction(ids.next());
                if (action == null || !(action instanceof UpdateAction)) continue;
                ((UpdateAction)action).update();
            }
        }

        public void commandStackChanged(EventObject event) {
            this.updateActions(this.stackActionIDs);
            if (((CommandStack)event.getSource()).isDirty()) {
                this.setEditorDirty((IEditorPart)this.mapEditorCommandStack.get(event.getSource()), true);
                this.setDirty(true);
            } else if (!this.saveLocation) {
                this.setEditorDirty((IEditorPart)this.mapEditorCommandStack.get(event.getSource()), true);
                this.setDirty(true);
            } else {
                this.setDirty(false);
            }
        }

        public void setDirty(boolean dirty) {
            if (this.isDirty != dirty) {
                this.isDirty = dirty;
                FacesConfigEditor.this.firePropertyChange(257);
            }
        }

        public void dispose() {
            Iterator stacks = this.commandStacks.iterator();
            while (stacks.hasNext()) {
                ((CommandStack)stacks.next()).removeCommandStackListener((org.eclipse.gef.commands.CommandStackListener)this);
            }
            this.commandStacks.clear();
        }

        public void markSaveLocations() {
            this.saveLocation = true;
            for (CommandStack stack : this.commandStacks) {
                stack.markSaveLocation();
            }
            this.saveLocation = false;
        }
    }
}

