/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.modules.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.ease.ui.tools.AbstractPopupItem;
import org.eclipse.ease.ui.tools.AbstractPopupMenu;

public class ModulePopupMenu
extends AbstractPopupMenu {
    private final List<AbstractPopupItem> fItems = new ArrayList<AbstractPopupItem>();

    public ModulePopupMenu(String name) {
        super(name);
    }

    @Override
    protected void populate() {
        for (AbstractPopupItem item : this.fItems) {
            this.addPopup(item);
        }
    }

    public void addEntry(AbstractPopupItem item) {
        this.fItems.add(item);
    }

    public void sortEntries() {
        Collections.sort(this.fItems, new Comparator<AbstractPopupItem>(){

            @Override
            public int compare(AbstractPopupItem o1, AbstractPopupItem o2) {
                if (o1 instanceof AbstractPopupMenu && !(o2 instanceof AbstractPopupMenu)) {
                    return -1;
                }
                if (o2 instanceof AbstractPopupMenu && !(o1 instanceof AbstractPopupMenu)) {
                    return 1;
                }
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
    }

    public List<AbstractPopupItem> getEntries() {
        return this.fItems;
    }
}

