/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.console;

import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.core.model.IStreamsProxy2;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.ease.ui.console.ScriptConsole;
import org.eclipse.ease.ui.console.actions.RemoveAllTerminatedConsolesAction;
import org.eclipse.ease.ui.console.actions.RemoveCurrentConsoleAction;
import org.eclipse.ease.ui.console.actions.ShowStandardErrorAction;
import org.eclipse.ease.ui.console.actions.ShowStandardOutAction;
import org.eclipse.ease.ui.console.actions.ShowWhenContentChangesAction;
import org.eclipse.ease.ui.console.actions.TerminateConsoleAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;

public class ScriptConsolePageParticipant
implements IConsolePageParticipant,
IShowInSource,
IShowInTargetList,
IDebugContextListener {
    private TerminateConsoleAction fTerminate;
    private RemoveCurrentConsoleAction fRemoveTerminated;
    private RemoveAllTerminatedConsolesAction fRemoveAllTerminated;
    private ShowWhenContentChangesAction fStdOut;
    private ShowWhenContentChangesAction fStdErr;
    private ScriptConsole fConsole;
    private IPageBookViewPage fPage;
    private IConsoleView fView;
    private EOFHandler fEOFHandler;
    private final String fContextId = "org.eclipse.debug.ui.console";
    private IContextActivation fActivatedContext;
    private IHandlerActivation fActivatedHandler;

    public void init(IPageBookViewPage page, IConsole console) {
        this.fPage = page;
        this.fConsole = (ScriptConsole)console;
        this.fConsole.setPageParticipant(this);
        this.fRemoveTerminated = new RemoveCurrentConsoleAction(this.fConsole);
        this.fRemoveAllTerminated = new RemoveAllTerminatedConsolesAction();
        this.fTerminate = new TerminateConsoleAction(page.getSite().getWorkbenchWindow(), this.fConsole);
        this.fStdOut = new ShowStandardOutAction(console);
        this.fStdErr = new ShowStandardErrorAction(console);
        this.fView = (IConsoleView)this.fPage.getSite().getPage().findView("org.eclipse.ui.console.ConsoleView");
        DebugUITools.getDebugContextManager().getContextService(this.fPage.getSite().getWorkbenchWindow()).addDebugContextListener((IDebugContextListener)this);
        IActionBars actionBars = this.fPage.getSite().getActionBars();
        this.configureToolBar(actionBars.getToolBarManager());
        this.fEOFHandler = new EOFHandler();
    }

    public void dispose() {
        this.fConsole.setPageParticipant(null);
        DebugUITools.getDebugContextManager().getContextService(this.fPage.getSite().getWorkbenchWindow()).removeDebugContextListener((IDebugContextListener)this);
        this.fRemoveTerminated = null;
        this.fRemoveAllTerminated = null;
        if (this.fTerminate != null) {
            this.fTerminate.dispose();
            this.fTerminate = null;
        }
        if (this.fStdOut != null) {
            this.fStdOut.dispose();
            this.fStdOut = null;
        }
        if (this.fStdErr != null) {
            this.fStdErr.dispose();
            this.fStdErr = null;
        }
        this.fConsole = null;
    }

    protected void configureToolBar(IToolBarManager mgr) {
        mgr.appendToGroup("launchGroup", (IAction)this.fTerminate);
        mgr.appendToGroup("launchGroup", (IAction)this.fRemoveTerminated);
        mgr.appendToGroup("launchGroup", (IAction)this.fRemoveAllTerminated);
        mgr.appendToGroup("outputGroup", (IAction)this.fStdOut);
        mgr.appendToGroup("outputGroup", (IAction)this.fStdErr);
    }

    public Object getAdapter(Class required) {
        if (IShowInSource.class.equals((Object)required)) {
            return this;
        }
        if (IShowInTargetList.class.equals((Object)required)) {
            return this;
        }
        if (ILaunchConfiguration.class.equals((Object)required)) {
            ILaunch launch = this.getProcess().getLaunch();
            if (launch != null) {
                return launch.getLaunchConfiguration();
            }
            return null;
        }
        return null;
    }

    public ShowInContext getShowInContext() {
        IProcess process = this.getProcess();
        if (process == null) {
            return null;
        }
        IDebugTarget target = (IDebugTarget)process.getAdapter(IDebugTarget.class);
        TreeSelection selection = null;
        selection = target == null ? new TreeSelection(new TreePath(new Object[]{DebugPlugin.getDefault().getLaunchManager(), process.getLaunch(), process})) : new TreeSelection(new TreePath(new Object[]{DebugPlugin.getDefault().getLaunchManager(), target.getLaunch(), target}));
        return new ShowInContext(null, (ISelection)selection);
    }

    public String[] getShowInTargetIds() {
        return new String[]{"org.eclipse.debug.ui.DebugView"};
    }

    protected IProcess getProcess() {
        return null;
    }

    public void activated() {
        IPageSite site = this.fPage.getSite();
        if (this.fActivatedContext == null && this.fActivatedHandler == null) {
            IHandlerService handlerService = (IHandlerService)site.getService(IHandlerService.class);
            IContextService contextService = (IContextService)site.getService(IContextService.class);
            this.fActivatedContext = contextService.activateContext("org.eclipse.debug.ui.console");
            this.fActivatedHandler = handlerService.activateHandler("org.eclipse.debug.ui.commands.eof", (IHandler)this.fEOFHandler);
        }
    }

    public void deactivated() {
        IPageSite site = this.fPage.getSite();
        IHandlerService handlerService = (IHandlerService)site.getService(IHandlerService.class);
        IContextService contextService = (IContextService)site.getService(IContextService.class);
        handlerService.deactivateHandler(this.fActivatedHandler);
        contextService.deactivateContext(this.fActivatedContext);
        this.fActivatedContext = null;
        this.fActivatedHandler = null;
    }

    public void debugContextChanged(DebugContextEvent event) {
        if ((event.getFlags() & 1) > 0 && this.fView != null && this.getProcess() != null && this.getProcess().equals(DebugUITools.getCurrentProcess())) {
            this.fView.display((IConsole)this.fConsole);
        }
    }

    public void engineChanged() {
        if (this.fTerminate != null) {
            this.fTerminate.update();
        }
    }

    private class EOFHandler
    extends AbstractHandler {
        private EOFHandler() {
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            IStreamsProxy proxy = ScriptConsolePageParticipant.this.getProcess().getStreamsProxy();
            if (proxy instanceof IStreamsProxy2) {
                IStreamsProxy2 proxy2 = (IStreamsProxy2)proxy;
                try {
                    proxy2.closeInputStream();
                }
                catch (IOException iOException) {}
            }
            return null;
        }
    }
}

