/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.petrinet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.comma.actions.actions.Action;
import org.eclipse.comma.actions.actions.ActionWithVars;
import org.eclipse.comma.actions.actions.AssignmentAction;
import org.eclipse.comma.actions.actions.CommandReply;
import org.eclipse.comma.actions.actions.CommandReplyWithVars;
import org.eclipse.comma.actions.actions.EventCall;
import org.eclipse.comma.actions.actions.EventWithVars;
import org.eclipse.comma.actions.actions.IfAction;
import org.eclipse.comma.actions.actions.Multiplicity;
import org.eclipse.comma.actions.actions.PCElement;
import org.eclipse.comma.actions.actions.PCFragmentReference;
import org.eclipse.comma.actions.actions.ParallelComposition;
import org.eclipse.comma.actions.actions.RecordFieldAssignmentAction;
import org.eclipse.comma.behavior.behavior.Clause;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.behavior.StateMachine;
import org.eclipse.comma.behavior.behavior.Transition;
import org.eclipse.comma.behavior.behavior.TriggeredTransition;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.parameters.parameters.NotificationParams;
import org.eclipse.comma.parameters.parameters.Parameters;
import org.eclipse.comma.parameters.parameters.Params;
import org.eclipse.comma.parameters.parameters.ReplyParams;
import org.eclipse.comma.parameters.parameters.StateParams;
import org.eclipse.comma.parameters.parameters.TriggerParams;
import org.eclipse.comma.petrinet.Guard;
import org.eclipse.comma.petrinet.GuardContext;
import org.eclipse.comma.petrinet.Input;
import org.eclipse.comma.petrinet.Output;
import org.eclipse.comma.petrinet.PTransition;
import org.eclipse.comma.petrinet.Place;
import org.eclipse.comma.petrinet.PythonHelper;
import org.eclipse.comma.petrinet.Token;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.types.types.Type;
import org.eclipse.comma.types.utilities.TypeUtilities;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class Petrinet {
    private final Interface itf;
    private final String port;
    private final ParameterPlaceMode mode;
    private final Parameters params;
    private Map<String, Place> places = new LinkedHashMap<String, Place>();
    private ArrayList<PTransition> transitions = new ArrayList();
    private ArrayList<Input> inputs = new ArrayList();
    private ArrayList<Output> outputs = new ArrayList();
    private List<String> globalVariables;

    Petrinet(Interface itf, Parameters params, ParameterPlaceMode mode, String port) {
        this.itf = itf;
        this.params = params;
        this.mode = mode;
        this.port = port;
        this.build();
    }

    private Petrinet build() {
        PTransition.resetIDCounter();
        this.globalVariables = this.itf.getVars().stream().map(v -> v.getName()).collect(Collectors.toList());
        for (StateMachine machine : this.itf.getMachines()) {
            for (State state : machine.getStates()) {
                Place source = this.add(Place.forState(machine, state));
                Iterator<Token> transitions = new ArrayList(state.getTransitions());
                machine.getInAllStates().stream().filter(s -> !s.getExcludedStates().contains((Object)state)).forEach(s -> {
                    boolean bl = transitions.addAll((Collection<Token>)s.getTransitions());
                });
                Iterator<Object> iterator = transitions.iterator();
                while (iterator.hasNext()) {
                    Transition transition = (Transition)iterator.next();
                    Place intermediate = this.add(Place.forTransition(machine, state, transition));
                    TriggeredTransition trigger = transition instanceof TriggeredTransition ? (TriggeredTransition)transition : null;
                    Guard guard = transition.getGuard() != null ? new Guard(transition.getGuard(), GuardContext.TRANSITION) : null;
                    this.add(new PTransition((Object)trigger, guard), source, intermediate, null);
                    for (Clause clause : transition.getClauses()) {
                        Place clausePlace = this.add(Place.forClause(intermediate, clause));
                        this.add(new PTransition(), intermediate, clausePlace, null);
                        State targetState = clause.getTarget() == null ? state : clause.getTarget();
                        Place target = this.add(Place.forState(machine, targetState));
                        if (clause.getActions() == null) {
                            this.add(new PTransition(), clausePlace, target, null);
                            continue;
                        }
                        this.addClause((List<Action>)clause.getActions().getActions(), clausePlace, target, trigger);
                    }
                }
            }
        }
        this.places.values().stream().filter(p -> p.isInitial()).forEach(p -> p.addToken(Token.empty()));
        for (PTransition transition : this.transitions) {
            Place place;
            boolean addTokens;
            Place place2;
            if (transition.event == null) continue;
            Place source = this.getSource(transition);
            if (transition.event instanceof ActionWithVars && this.mode != ParameterPlaceMode.TRIGGERED_FILLED_NONTRIGGERED_EMPTY) {
                place2 = Place.forParameters(transition, source.state);
                if (!this.places.containsKey(place2.name)) {
                    this.add(place2);
                    if (transition.event instanceof EventWithVars) {
                        for (Token t : this.getTokens(source, (EventWithVars)transition.event)) {
                            place2.addToken(t);
                        }
                    } else {
                        for (Token t : this.getTokens(source, (CommandReplyWithVars)transition.event)) {
                            place2.addToken(t);
                        }
                    }
                }
                this.inputs.add(new Input(place2, transition));
                this.outputs.add(new Output(place2, transition, null));
            } else if (transition.event instanceof CommandReply && this.mode != ParameterPlaceMode.TRIGGERED_FILLED_NONTRIGGERED_EMPTY) {
                if (this.getTokens(source, (CommandReply)transition.event).size() > 0) {
                    place2 = Place.forParameters(transition, source.state);
                    if (!this.places.containsKey(place2.name)) {
                        this.add(place2);
                        for (Token t : this.getTokens(source, (CommandReply)transition.event)) {
                            place2.addToken(t);
                        }
                    }
                    this.inputs.add(new Input(place2, transition));
                    this.outputs.add(new Output(place2, transition, null));
                }
            } else if (transition.event instanceof EventCall && this.mode != ParameterPlaceMode.TRIGGERED_FILLED_NONTRIGGERED_EMPTY && this.getTokens(source, (EventCall)transition.event).size() > 0) {
                place2 = Place.forParameters(transition, source.state);
                if (!this.places.containsKey(place2.name)) {
                    this.add(place2);
                    for (Token t : this.getTokens(source, (EventCall)transition.event)) {
                        place2.addToken(t);
                    }
                }
                this.inputs.add(new Input(place2, transition));
                this.outputs.add(new Output(place2, transition, null));
            }
            boolean isTriggered = transition.event instanceof TriggeredTransition;
            boolean bl = addTokens = isTriggered && this.mode != ParameterPlaceMode.TRIGGERED_EMPTY_NONTRIGGERED_NONE;
            if (!isTriggered && this.mode != ParameterPlaceMode.TRIGGERED_FILLED_NONTRIGGERED_EMPTY) continue;
            Place place3 = place = addTokens ? Place.forParameters(transition, source.state) : Place.forParameters(transition);
            if (!this.places.containsKey(place.name)) {
                this.add(place);
                if (addTokens) {
                    for (Token t : this.getTokens(source, (TriggeredTransition)transition.event)) {
                        place.addToken(t);
                    }
                }
            }
            this.inputs.add(new Input(place, transition));
            if (!addTokens) continue;
            this.outputs.add(new Output(place, transition, null));
        }
        Place variablesPlace = this.add(Place.forVariables());
        variablesPlace.addToken(Token.forVariables(this.globalVariables));
        this.outputs.stream().filter(o -> o.place.type == Place.PPlaceType.STATE).collect(Collectors.toList()).forEach(o -> {
            boolean bl = this.outputs.add(new Output(variablesPlace, o.transition));
        });
        this.inputs.stream().filter(i -> i.place.type == Place.PPlaceType.STATE).collect(Collectors.toList()).forEach(i -> {
            boolean bl = this.inputs.add(new Input(variablesPlace, i.transition));
        });
        return this;
    }

    private Place getSource(PTransition transition) {
        List inputs = this.inputs.stream().filter(i -> i.transition == transition && i.place.type != Place.PPlaceType.VARIABLES).collect(Collectors.toList());
        assert (inputs.size() == 1);
        return ((Input)inputs.get((int)0)).place;
    }

    private List<Token> getTokens(Place place, EventWithVars n) {
        ArrayList<Token> result = new ArrayList<Token>();
        if (this.params != null) {
            for (NotificationParams nParams : this.params.getNotificationParams()) {
                if (nParams.getEvent() != n.getEvent()) continue;
                for (StateParams stateParams : nParams.getStateParams()) {
                    if (stateParams.getState() != place.state) continue;
                    for (Params p : stateParams.getParams()) {
                        result.add(Token.forParameters((List<Expression>)p.getValue()));
                    }
                }
            }
        }
        if (result.isEmpty()) {
            result.add(Token.forParameters(new ArrayList<Expression>()));
        }
        return result;
    }

    private List<Token> getTokens(Place place, EventCall n) {
        ArrayList<Token> result = new ArrayList<Token>();
        if (this.params != null) {
            for (NotificationParams nParams : this.params.getNotificationParams()) {
                if (nParams.getEvent() != n.getEvent()) continue;
                for (StateParams stateParams : nParams.getStateParams()) {
                    if (stateParams.getState() != place.state) continue;
                    for (Params p : stateParams.getParams()) {
                        result.add(Token.forParameters((List<Expression>)p.getValue()));
                    }
                }
            }
        }
        return result;
    }

    private List<Token> getTokens(Place place, CommandReply r) {
        ArrayList<Token> result = new ArrayList<Token>();
        InterfaceEvent command = ((TriggeredTransition)EcoreUtil2.getContainerOfType((EObject)r, TriggeredTransition.class)).getTrigger();
        if (this.params != null) {
            for (ReplyParams rParams : this.params.getReplyParams()) {
                if (rParams.getEvent() != command) continue;
                for (StateParams stateParams : rParams.getStateParams()) {
                    if (stateParams.getState() != place.state) continue;
                    for (Params p : stateParams.getParams()) {
                        result.add(Token.forParameters((List<Expression>)p.getValue()));
                    }
                }
            }
        }
        return result;
    }

    private List<Token> getTokens(Place place, CommandReplyWithVars r) {
        ArrayList<Token> result = new ArrayList<Token>();
        InterfaceEvent command = ((TriggeredTransition)EcoreUtil2.getContainerOfType((EObject)r, TriggeredTransition.class)).getTrigger();
        if (this.params != null) {
            for (ReplyParams rParams : this.params.getReplyParams()) {
                if (rParams.getEvent() != command) continue;
                for (StateParams stateParams : rParams.getStateParams()) {
                    if (stateParams.getState() != place.state) continue;
                    for (Params p : stateParams.getParams()) {
                        result.add(Token.forParameters((List<Expression>)p.getValue()));
                    }
                }
            }
        }
        if (result.isEmpty()) {
            result.add(Token.forParameters(new ArrayList<Expression>()));
        }
        return result;
    }

    private List<Token> getTokens(Place place, TriggeredTransition event) {
        ArrayList<Token> result = new ArrayList<Token>();
        if (this.params != null) {
            for (TriggerParams triggerParams : this.params.getTriggerParams()) {
                if (triggerParams.getEvent() != event.getTrigger()) continue;
                for (StateParams stateParams : triggerParams.getStateParams()) {
                    if (stateParams.getState() != place.state) continue;
                    for (Params p : stateParams.getParams()) {
                        result.add(Token.forParameters((List<Expression>)p.getValue()));
                    }
                }
            }
        }
        if (result.isEmpty() && event.getTrigger().getParameters().stream().anyMatch(s -> s.getDirection() != DIRECTION.OUT)) {
            throw new RuntimeException(String.format("No parameters provided for: '%s'", event.getTrigger().getName()));
        }
        if (result.isEmpty()) {
            result.add(Token.forParameters(new ArrayList<Expression>()));
        }
        return result;
    }

    private void addClause(List<Action> actions, Place start, Place end, TriggeredTransition trigger) {
        ArrayList<Object> outputActions = new ArrayList<Action>();
        boolean skipLastTranstion = false;
        for (Action action : actions) {
            IfAction a;
            if (action instanceof AssignmentAction || action instanceof RecordFieldAssignmentAction) {
                outputActions.add(action);
                continue;
            }
            if (action instanceof IfAction) {
                a = (IfAction)action;
                Place splitPlace = this.add(Place.forClause(start, String.format("%d_split", actions.indexOf(action))));
                this.add(new PTransition(), start, splitPlace, outputActions);
                outputActions = new ArrayList();
                start = this.add(Place.forClause(start, String.format("%d_join", actions.indexOf(action))));
                Place ifPlace = this.add(Place.forClauseNest(splitPlace, "if_0"));
                this.add(new PTransition(new Guard(a.getGuard(), GuardContext.IF_THEN_ELSE)), splitPlace, ifPlace, outputActions);
                this.addClause((List<Action>)a.getThenList().getActions(), ifPlace, start, trigger);
                Place elsePlace = this.add(Place.forClauseNest(splitPlace, "else_0"));
                this.add(new PTransition(new Guard(a.getGuard(), GuardContext.IF_THEN_ELSE, true)), splitPlace, elsePlace, outputActions);
                this.addClause((List<Action>)(a.getElseList() == null ? new ArrayList() : a.getElseList().getActions()), elsePlace, start, trigger);
                outputActions = new ArrayList();
                continue;
            }
            if (action instanceof ActionWithVars) {
                Place actionEnd;
                ActionWithVars ev = (ActionWithVars)action;
                if (!outputActions.isEmpty()) {
                    Place next = this.add(Place.forClause(start, Integer.toString(actions.indexOf(action))));
                    this.add(new PTransition(), start, next, outputActions);
                    start = next;
                    outputActions = new ArrayList();
                }
                if (actions.indexOf(action) == actions.size() - 1) {
                    actionEnd = end;
                    skipLastTranstion = true;
                } else {
                    actionEnd = this.add(Place.forClause(start, Integer.toString(actions.indexOf(action) + 1)));
                }
                Guard guard = ev.getCondition() != null ? new Guard(ev.getCondition(), GuardContext.ACTION_WITH_VARS) : null;
                this.add(new PTransition((Object)action, guard), start, actionEnd, null);
                start = actionEnd;
                continue;
            }
            if (action instanceof CommandReply || action instanceof EventCall) {
                Place actionEnd;
                if (!outputActions.isEmpty()) {
                    Place next = this.add(Place.forClause(start, Integer.toString(actions.indexOf(action))));
                    this.add(new PTransition(), start, next, outputActions);
                    start = next;
                    outputActions = new ArrayList();
                }
                if (actions.indexOf(action) == actions.size() - 1) {
                    actionEnd = end;
                    skipLastTranstion = true;
                } else {
                    actionEnd = this.add(Place.forClause(start, Integer.toString(actions.indexOf(action) + 1)));
                }
                this.addMultiplicityAndOccurence(action, start, actionEnd, trigger);
                start = actionEnd;
                continue;
            }
            if (action instanceof ParallelComposition) {
                a = (ParallelComposition)action;
                Place anyOrderPlace = this.add(Place.forClause(start, String.format("%d_anyorder", actions.indexOf(action))));
                this.add(new PTransition(), start, anyOrderPlace, outputActions);
                outputActions = new ArrayList();
                PTransition anyOrderTransition = this.add(new PTransition(), anyOrderPlace, null, null);
                Place joinPlace = this.add(Place.forClause(start, String.format("%d_join", actions.indexOf(action))));
                PTransition joinTransition = this.add(new PTransition(), null, joinPlace, null);
                ArrayList pcActions = new ArrayList();
                a.getComponents().forEach(e -> {
                    class RecursiveHelper {
                        final Consumer<PCElement> addRecursive = element -> {
                            if (element instanceof PCFragmentReference) {
                                ((PCFragmentReference)element).getFragment().getComponents().forEach(e -> this.addRecursive.accept((PCElement)e));
                            } else {
                                list.add((Action)element);
                            }
                        };
                        private final /* synthetic */ List val$pcActions;

                        RecursiveHelper(List list) {
                            this.val$pcActions = list;
                        }
                    }
                    (Petrinet)this.new RecursiveHelper((List)list).addRecursive.accept((PCElement)e);
                });
                for (Action pcAction : pcActions) {
                    Place elementStart = this.add(Place.forClause(start, String.format("%d_anyorder_%d_start", actions.indexOf(action), pcActions.indexOf(pcAction))));
                    Place elementEnd = this.add(Place.forClause(start, String.format("%d_anyorder_%d_end", actions.indexOf(action), pcActions.indexOf(pcAction))));
                    this.outputs.add(new Output(elementStart, anyOrderTransition, null));
                    this.inputs.add(new Input(elementEnd, joinTransition));
                    this.addClause(Arrays.asList(pcAction), elementStart, elementEnd, trigger);
                }
                start = joinPlace;
                continue;
            }
            assert (false) : "Not supported";
        }
        if (!skipLastTranstion) {
            if (!outputActions.isEmpty() && end.state != null) {
                Place next = this.add(Place.forClause(start, Integer.toString(actions.size())));
                this.add(new PTransition(), start, next, outputActions);
                start = next;
                outputActions = new ArrayList();
            }
            this.add(new PTransition(), start, end, outputActions);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addMultiplicityAndOccurence(Action action, Place start, Place end, TriggeredTransition trigger) {
        long max;
        long min;
        if (!(action instanceof EventCall) || ((EventCall)action).getMultiplicity() == null && ((EventCall)action).getOccurence() == null) {
            this.add(new PTransition((Object)action, trigger), start, end, null);
            return;
        }
        EventCall event = (EventCall)action;
        Multiplicity multiplicity = event.getMultiplicity();
        String occurence = event.getOccurence();
        assert (multiplicity != null || occurence != null);
        if (occurence != null) {
            if (occurence.equals("?")) {
                min = 0L;
                max = 1L;
            } else if (occurence.equals("+")) {
                min = 1L;
                max = -1L;
            } else {
                if (!occurence.equals("*")) throw new RuntimeException("Not supported");
                min = 0L;
                max = -1L;
            }
        } else {
            min = multiplicity.getLower();
            max = multiplicity.getUpperInf() != null ? -1L : multiplicity.getUpper();
        }
        List startOutputs = this.outputs.stream().filter(o -> o.place == start).collect(Collectors.toList());
        if (startOutputs.size() != 1) {
            throw new RuntimeException("Not allowed");
        }
        if (min != 0L || max != -1L) {
            ((Output)startOutputs.get((int)0)).repeatAction = Output.RepeatAction.INIT;
        }
        Guard minGuard = min != 0L ? new Guard(Guard.PRepeatGuardType.MIN, min) : null;
        this.add(new PTransition(minGuard), start, end, null);
        if (max == 0L) return;
        Guard maxGuard = max != -1L ? new Guard(Guard.PRepeatGuardType.MAX, max) : null;
        this.add(new PTransition((Object)event, maxGuard), start, start, null);
        if (min == 0L && max == -1L) return;
        this.outputs.get((int)(this.outputs.size() - 1)).repeatAction = max == -1L ? Output.RepeatAction.SET_1 : Output.RepeatAction.INCREASE;
    }

    private PTransition add(PTransition transition, Place from, Place to, List<Action> outputActions) {
        this.transitions.add(transition);
        if (from != null) {
            this.inputs.add(new Input(from, transition));
        }
        if (to != null) {
            this.outputs.add(new Output(to, transition, outputActions));
        }
        return transition;
    }

    private Place add(Place place) {
        if (this.places.containsKey(place.name)) {
            return this.places.get(place.name);
        }
        this.places.put(place.name, place);
        return place;
    }

    public String toPython(String netFunctionName) {
        StringBuilder builder = new StringBuilder();
        builder.append("def " + netFunctionName + "():\n" + "    n = PetriNet(\"N\")\n" + "\n" + "    def add_place(place: Place, meta: Dict[str, Any]):\n" + "        n.add_place(place)\n" + "        place.meta = meta\n" + "\n" + "    def add_transition(transition: Transition, meta: Dict[str, Any]):\n" + "        n.add_transition(transition)\n" + "        transition.meta = meta\n" + "\n");
        Function<String, String> variablePrefix = variable -> this.globalVariables.contains(variable) ? "g." : "l.";
        builder.append("    # Variables\n");
        this.itf.getVars().forEach(v -> {
            StringBuilder stringBuilder2 = builder.append(String.format("    v_%s = %s\n", v.getName(), PythonHelper.defaultValue(TypeUtilities.getTypeObject((Type)v.getType()))));
        });
        if (this.params != null) {
            this.params.getVars().forEach(v -> {
                StringBuilder stringBuilder2 = builder.append(String.format("    p_%s = %s\n", v.getName(), PythonHelper.defaultValue(TypeUtilities.getTypeObject((Type)v.getType()))));
            });
        }
        builder.append("\n    # Init\n");
        this.itf.getInitActions().forEach(a -> {
            StringBuilder stringBuilder2 = builder.append("    " + PythonHelper.action(a, variable -> "v_", false, false) + "\n");
        });
        if (this.params != null) {
            this.params.getInitActions().forEach(a -> {
                StringBuilder stringBuilder2 = builder.append("    " + PythonHelper.action(a, variable -> "p_", false, false) + "\n");
            });
        }
        builder.append("\n    # Places\n");
        this.places.values().forEach(p -> {
            StringBuilder stringBuilder2 = builder.append("    " + p.toPython(this.itf));
        });
        builder.append("\n    # Transitions\n");
        this.transitions.forEach(p -> {
            StringBuilder stringBuilder2 = builder.append("    " + p.toPython(variablePrefix, this.itf, this.port));
        });
        builder.append("\n    # Inputs \n");
        this.inputs.forEach(p -> {
            StringBuilder stringBuilder2 = builder.append("    " + p.toPython(variablePrefix));
        });
        builder.append("\n    # Outputs\n");
        this.outputs.forEach(p -> {
            StringBuilder stringBuilder2 = builder.append("    " + p.toPython(variablePrefix));
        });
        builder.append("    return n\n");
        return builder.toString();
    }

    public static enum ParameterPlaceMode {
        TRIGGERED_EMPTY_NONTRIGGERED_NONE,
        TRIGGERED_FILLED_NONTRIGGERED_EMPTY,
        TRIGGERED_FILLED_NONTRIGGERED_NONE;

    }
}

