/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.behavior.interfaces.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.comma.actions.actions.Action;
import org.eclipse.comma.actions.actions.ActionList;
import org.eclipse.comma.actions.actions.ActionsPackage;
import org.eclipse.comma.actions.actions.CommandEvent;
import org.eclipse.comma.actions.actions.CommandReply;
import org.eclipse.comma.actions.actions.EventCall;
import org.eclipse.comma.actions.actions.IfAction;
import org.eclipse.comma.actions.actions.ParallelComposition;
import org.eclipse.comma.behavior.behavior.BehaviorPackage;
import org.eclipse.comma.behavior.behavior.Clause;
import org.eclipse.comma.behavior.behavior.NonTriggeredTransition;
import org.eclipse.comma.behavior.behavior.StateMachine;
import org.eclipse.comma.behavior.behavior.Transition;
import org.eclipse.comma.behavior.behavior.TriggeredTransition;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.behavior.interfaces.validation.AbstractInterfaceDefinitionValidator;
import org.eclipse.comma.behavior.utilities.StateMachineUtilities;
import org.eclipse.comma.expressions.expression.ExpressionPackage;
import org.eclipse.comma.expressions.expression.ExpressionVariable;
import org.eclipse.comma.expressions.expression.Variable;
import org.eclipse.comma.signature.interfaceSignature.Command;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.InterfaceSignatureDefinition;
import org.eclipse.comma.signature.interfaceSignature.Notification;
import org.eclipse.comma.signature.interfaceSignature.Parameter;
import org.eclipse.comma.signature.interfaceSignature.Signal;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.comma.types.types.Import;
import org.eclipse.comma.types.types.TypesPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class InterfaceDefinitionValidator
extends AbstractInterfaceDefinitionValidator {
    @Inject
    private IScopeProvider scopeProvider;
    public static final String INTERFACE_UNUSED_SIGNAL = "interface_unused_signal";
    public static final String INTERFACE_UNUSED_COMMAND = "interface_unused_command";
    public static final String INTERFACE_UNUSED_NOTIFICATION = "interface_unused_nontification";
    public static final String REPLY_NOT_POSSIBLE = "trigger_remove";

    @Check
    public void checkInterfaceNameEqualSignatureName(Interface i) {
        boolean _not;
        Iterable allInterfaces = this.scopeProvider.getScope((EObject)i, ExpressionPackage.Literals.INTERFACE_AWARE_TYPE__INTERFACE).getAllElements();
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)allInterfaces);
        boolean bl = _not = !_isEmpty;
        if (_not) {
            boolean _not_1;
            String importedSignatureName = ((IEObjectDescription[])Conversions.unwrapArray((Object)allInterfaces, IEObjectDescription.class))[0].getName().getFirstSegment();
            boolean _equals = i.getName().equals(importedSignatureName);
            boolean bl2 = _not_1 = !_equals;
            if (_not_1) {
                this.error("Interface name has to be the same as the signature name", (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
            }
        }
    }

    @Check
    public void checkImportForValidity(Import imp) {
        boolean _not;
        boolean _isValidUri = EcoreUtil2.isValidUri((EObject)imp, (URI)URI.createURI((String)imp.getImportURI()));
        boolean bl = _not = !_isValidUri;
        if (_not) {
            this.error("Invalid resource", (EObject)imp, (EStructuralFeature)TypesPackage.eINSTANCE.getImport_ImportURI());
        } else {
            Resource r = EcoreUtil2.getResource((Resource)imp.eResource(), (String)imp.getImportURI());
            EObject root = (EObject)IteratorExtensions.head((Iterator)r.getAllContents());
            if (!(root instanceof InterfaceSignatureDefinition)) {
                this.error("The imported resource is not an interface signature definition.", (EObject)imp, (EStructuralFeature)TypesPackage.eINSTANCE.getImport_ImportURI());
            }
        }
    }

    @Check
    public void checkUnusedInterfaceEvents(final Interface cInterface) {
        Signature signature = StateMachineUtilities.getSignatureForMachine((EObject)cInterface, (IScopeProvider)this.scopeProvider);
        if (signature == null) {
            return;
        }
        final HashSet usedEvents = new HashSet();
        Consumer<TriggeredTransition> _function = new Consumer<TriggeredTransition>(){

            @Override
            public void accept(TriggeredTransition it) {
                usedEvents.add(it.getTrigger());
            }
        };
        EcoreUtil2.getAllContentsOfType((EObject)cInterface, TriggeredTransition.class).forEach(_function);
        Consumer<EventCall> _function_1 = new Consumer<EventCall>(){

            @Override
            public void accept(EventCall it) {
                if (it.getEvent() != null && it.getEvent() instanceof Notification) {
                    usedEvents.add(it.getEvent());
                }
            }
        };
        EcoreUtil2.getAllContentsOfType((EObject)cInterface, EventCall.class).forEach(_function_1);
        Consumer<Command> _function_2 = new Consumer<Command>(){

            @Override
            public void accept(Command it) {
                boolean _not;
                boolean _contains = usedEvents.contains(it);
                boolean bl = _not = !_contains;
                if (_not) {
                    String _name = it.getName();
                    String _plus = "Unused command " + _name;
                    InterfaceDefinitionValidator.this.warning(_plus, (EObject)cInterface, (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME, InterfaceDefinitionValidator.INTERFACE_UNUSED_COMMAND, new String[]{it.getName()});
                }
            }
        };
        signature.getCommands().forEach((Consumer)_function_2);
        Consumer<Signal> _function_3 = new Consumer<Signal>(){

            @Override
            public void accept(Signal it) {
                boolean _not;
                boolean _contains = usedEvents.contains(it);
                boolean bl = _not = !_contains;
                if (_not) {
                    String _name = it.getName();
                    String _plus = "Unused signal " + _name;
                    InterfaceDefinitionValidator.this.warning(_plus, (EObject)cInterface, (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME, InterfaceDefinitionValidator.INTERFACE_UNUSED_SIGNAL, new String[]{it.getName()});
                }
            }
        };
        signature.getSignals().forEach((Consumer)_function_3);
        Consumer<Notification> _function_4 = new Consumer<Notification>(){

            @Override
            public void accept(Notification it) {
                boolean _not;
                boolean _contains = usedEvents.contains(it);
                boolean bl = _not = !_contains;
                if (_not) {
                    String _name = it.getName();
                    String _plus = "Unused notification " + _name;
                    InterfaceDefinitionValidator.this.warning(_plus, (EObject)cInterface, (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME, InterfaceDefinitionValidator.INTERFACE_UNUSED_NOTIFICATION, new String[]{it.getName()});
                }
            }
        };
        signature.getNotifications().forEach((Consumer)_function_4);
    }

    @Check
    public void checkTrigger(TriggeredTransition t) {
        if (t.getTrigger() != null && t.getTrigger() instanceof Notification) {
            this.error("Trigger must be a command or a signal", (EStructuralFeature)BehaviorPackage.Literals.TRIGGERED_TRANSITION__TRIGGER);
        }
    }

    @Check
    public void checkOutgoingEvents(EventCall e) {
        if (e.getEvent() != null && !(e.getEvent() instanceof Notification)) {
            this.error("Only notifications are allowed as outgoing events", (EStructuralFeature)ActionsPackage.Literals.INTERFACE_EVENT_INSTANCE__EVENT);
        }
    }

    @Check
    public void checkTransitionForReplies(TriggeredTransition t) {
        if (t.getTrigger() == null || !(t.getTrigger() instanceof Command)) {
            return;
        }
        Consumer<Clause> _function = new Consumer<Clause>(){

            @Override
            public void accept(Clause it) {
                boolean _not;
                boolean _isEmpty = EcoreUtil2.getAllContentsOfType((EObject)it, CommandReply.class).isEmpty();
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    boolean _not_1;
                    boolean _hasReply = InterfaceDefinitionValidator.this.hasReply(it.getActions());
                    boolean bl2 = _not_1 = !_hasReply;
                    if (_not_1) {
                        InterfaceDefinitionValidator.this.error("The body of this transition has a path that is missing a reply.", (EObject)it, (EStructuralFeature)BehaviorPackage.Literals.CLAUSE__ACTIONS);
                    }
                } else {
                    InterfaceDefinitionValidator.this.error("The body of this transition is missing a reply.", (EObject)it, (EStructuralFeature)BehaviorPackage.Literals.CLAUSE__ACTIONS);
                }
            }
        };
        t.getClauses().forEach((Consumer)_function);
    }

    public boolean hasReply(ActionList actionList) {
        if (actionList == null) {
            return false;
        }
        EList _actions = actionList.getActions();
        for (Action action : _actions) {
            if (action instanceof CommandReply) {
                return true;
            }
            if (action instanceof ParallelComposition) {
                boolean _not;
                boolean _isEmpty = IterableExtensions.isEmpty((Iterable)Iterables.filter((Iterable)((ParallelComposition)action).getComponents(), CommandReply.class));
                boolean bl = _not = !_isEmpty;
                if (!_not) continue;
                return true;
            }
            if (!(action instanceof IfAction) || !this.hasReply(((IfAction)action).getThenList()) || !this.hasReply(((IfAction)action).getElseList())) continue;
            return true;
        }
        return false;
    }

    @Check
    public void checkOutVariableUsage(ExpressionVariable exp) {
        int index;
        Variable v = exp.getVariable();
        EObject container = v.eContainer();
        if (container instanceof TriggeredTransition && (index = ((TriggeredTransition)container).getParameters().indexOf((Object)v)) < ((TriggeredTransition)container).getTrigger().getParameters().size() && Objects.equal((Object)((Parameter)((TriggeredTransition)container).getTrigger().getParameters().get(index)).getDirection(), (Object)DIRECTION.OUT)) {
            boolean _not;
            EObject _eContainer = exp.eContainer();
            boolean bl = _not = !(_eContainer instanceof CommandReply);
            if (_not) {
                this.error("Out parameters are write-only.", (EStructuralFeature)ExpressionPackage.Literals.EXPRESSION_VARIABLE__VARIABLE);
            }
        }
    }

    @Check
    public void checkSilentTransition(NonTriggeredTransition t) {
        EList _clauses = t.getClauses();
        for (Clause c : _clauses) {
            List calls = EcoreUtil2.getAllContentsOfType((EObject)t, EventCall.class);
            List anyOrder = EcoreUtil2.getAllContentsOfType((EObject)t, ParallelComposition.class);
            if (!calls.isEmpty() || !anyOrder.isEmpty()) continue;
            this.error("The clause has to contain at least one observable event", (EStructuralFeature)BehaviorPackage.Literals.TRANSITION__CLAUSES, t.getClauses().indexOf((Object)c));
        }
    }

    @Check
    public void checkReply(CommandReply r) {
        Transition context = StateMachineUtilities.getTransitionContainer((CommandReply)r);
        if (context == null) {
            this.checkReplyInConstraint(r);
        } else {
            this.checkReplyInTransition(context, r);
        }
    }

    public void checkReplyInConstraint(CommandReply r) {
        if (r.getParameters().size() > 0 && r.getCommand() != null && r.getCommand().getEvent() != null) {
            boolean _not;
            InterfaceEvent _event = r.getCommand().getEvent();
            boolean bl = _not = !(_event instanceof Command);
            if (_not) {
                return;
            }
            InterfaceEvent _event_1 = r.getCommand().getEvent();
            Command command = (Command)_event_1;
            this.checkReplyAgainstCommand(command, r);
        }
    }

    public void checkReplyInTransition(Transition context, CommandReply r) {
        if (context instanceof TriggeredTransition) {
            boolean _tripleNotEquals;
            boolean _not;
            InterfaceEvent _trigger = ((TriggeredTransition)context).getTrigger();
            boolean bl = _not = !(_trigger instanceof Command);
            if (_not) {
                Object _eGet = r.eContainer().eGet(r.eContainingFeature());
                this.error("Reply cannot be used for triggers that are notifications or signals.", r.eContainer(), r.eContainingFeature(), ((EList)_eGet).indexOf((Object)r), REPLY_NOT_POSSIBLE, null);
                return;
            }
            CommandEvent _command = r.getCommand();
            boolean bl2 = _tripleNotEquals = _command != null;
            if (_tripleNotEquals) {
                this.error("Reply cannot indicate a command in this transition.", (EStructuralFeature)ActionsPackage.Literals.COMMAND_REPLY__COMMAND);
                return;
            }
            InterfaceEvent _trigger_1 = ((TriggeredTransition)context).getTrigger();
            Command trigger = (Command)_trigger_1;
            this.checkReplyAgainstCommand(trigger, r);
        } else {
            Object _eGet_1 = r.eContainer().eGet(r.eContainingFeature());
            this.error("Reply cannot be used in a non-triggered transition", r.eContainer(), r.eContainingFeature(), ((EList)_eGet_1).indexOf((Object)r), REPLY_NOT_POSSIBLE, null);
        }
    }

    @Check
    public void checkDisjointEvents(Interface behaviorModel) {
        ArrayList setsOfTriggers = new ArrayList();
        EList _machines = behaviorModel.getMachines();
        for (StateMachine sm : _machines) {
            List _allTriggers = StateMachineUtilities.getAllTriggers((StateMachine)sm);
            HashSet eventsForMachine = new HashSet(_allTriggers);
            eventsForMachine.addAll(StateMachineUtilities.getAllNotifications((StateMachine)sm));
            for (Set set : setsOfTriggers) {
                boolean _greaterThan;
                HashSet intersection = new HashSet(eventsForMachine);
                intersection.retainAll(set);
                int _size = intersection.size();
                boolean bl = _greaterThan = _size > 0;
                if (!_greaterThan) continue;
                this.error("Some events are used in more than one machine", (EStructuralFeature)TypesPackage.Literals.NAMED_ELEMENT__NAME);
                return;
            }
            setsOfTriggers.add(eventsForMachine);
        }
    }
}

