/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.tasks;

import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.ProcessHelper;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CodewindProcessTask
extends Task.Backgroundable {
    protected final Runnable onSuccess;
    protected ProcessHelper.ProcessResult result;

    public CodewindProcessTask(@Nullable Project project, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String title, Runnable onSuccess) {
        if (title == null) {
            CodewindProcessTask.$$$reportNull$$$0(0);
        }
        this(project, title, true, null, onSuccess);
    }

    public CodewindProcessTask(@Nullable Project project, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String title, boolean canBeCancelled, @Nullable PerformInBackgroundOption backgroundOption, Runnable onSuccess) {
        if (title == null) {
            CodewindProcessTask.$$$reportNull$$$0(1);
        }
        super(project, title, canBeCancelled, backgroundOption);
        this.onSuccess = onSuccess;
    }

    public final void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            CodewindProcessTask.$$$reportNull$$$0(2);
        }
        try {
            this.result = this.runProcess(indicator);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract ProcessHelper.ProcessResult runProcess(@NotNull ProgressIndicator var1) throws Exception;

    protected abstract String getExceptionMessageKey();

    public void onFinished() {
        if (this.result == null) {
            return;
        }
        if (this.result.getExitValue() == 0) {
            this.onSuccess.run();
            return;
        }
        Logger.logWarning("Installer failed with return code: " + this.result.getExitValue() + ", output: " + this.result.getOutput() + ", error: " + this.result.getError());
        Messages.showErrorDialog((String)CodewindUIBundle.message(this.getExceptionMessageKey(), this.result.getError()), (String)CodewindUIBundle.message("CodewindLabel", new Object[0]));
        super.onFinished();
    }

    public void onThrowable(@NotNull Throwable error) {
        if (error == null) {
            CodewindProcessTask.$$$reportNull$$$0(3);
        }
        Throwable t = error;
        while (t.getCause() != null) {
            t = t.getCause();
        }
        Logger.logWarning("An error occurred starting Codewind: ", t);
        Messages.showErrorDialog((String)CodewindUIBundle.message(this.getExceptionMessageKey(), t), (String)CodewindUIBundle.message("CodewindLabel", new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
        }
        objectArray2[1] = "org/eclipse/codewind/intellij/ui/tasks/CodewindProcessTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "onThrowable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

