/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.form;

import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ui.HyperlinkAdapter;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class WidgetUtils {
    public static JTextArea createJTextArea(String textValue) {
        JTextArea textArea = new JTextArea();
        JTextField textField = new JTextField();
        textArea.setBorder(BorderFactory.createCompoundBorder(textField.getBorder(), BorderFactory.createEmptyBorder(3, 6, 3, 6)));
        textArea.setSelectedTextColor(textField.getSelectedTextColor());
        textArea.setFont(textField.getFont());
        textArea.setOpaque(false);
        textArea.setText(textValue);
        textArea.setRequestFocusEnabled(true);
        return textArea;
    }

    public static JLabel createHyperlinkUsingLabel(String urlValue) {
        final JLabel hyperlink = new JLabel(urlValue);
        hyperlink.setForeground(Color.BLUE.darker());
        hyperlink.setCursor(new Cursor(12));
        hyperlink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                super.mouseClicked(mouseEvent);
                try {
                    BrowserLauncher.getInstance().browse(new URI(hyperlink.getText()));
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        });
        JTextField tf = new JTextField();
        hyperlink.setBorder(BorderFactory.createCompoundBorder(tf.getBorder(), BorderFactory.createEmptyBorder(3, 6, 3, 6)));
        return hyperlink;
    }

    public static JEditorPane createHyperlink(String urlValue) {
        JEditorPane editorPane = new JEditorPane();
        JTextField tf = new JTextField();
        editorPane.setContentType("text/html");
        editorPane.setEditable(false);
        editorPane.setOpaque(false);
        editorPane.setBorder(BorderFactory.createCompoundBorder(tf.getBorder(), BorderFactory.createEmptyBorder(3, 6, 3, 6)));
        editorPane.setSelectedTextColor(tf.getSelectedTextColor());
        editorPane.setFont(tf.getFont());
        editorPane.setText(urlValue);
        InputMap inputMap = editorPane.getInputMap(2);
        KeyStroke goKey = KeyStroke.getKeyStroke(71, 2);
        inputMap.put(goKey, "activate-link-action");
        editorPane.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent event) {
                try {
                    BrowserLauncher.getInstance().browse(event.getURL().toURI());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return editorPane;
    }
}

