/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.core.constants;

import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.constants.StartMode;
import org.eclipse.codewind.intellij.core.messages.CodewindCoreBundle;

public enum AppStatus {
    STARTED("started", CodewindCoreBundle.message("AppStatusStarted", new Object[0])),
    STARTING("starting", CodewindCoreBundle.message("AppStatusStarting", new Object[0])),
    STOPPING("stopping", CodewindCoreBundle.message("AppStatusStopping", new Object[0])),
    STOPPED("stopped", CodewindCoreBundle.message("AppStatusStopped", new Object[0])),
    UNKNOWN("unknown", CodewindCoreBundle.message("AppStatusUnknown", new Object[0]));

    public final String appStatus;
    public final String displayString;

    private AppStatus(String appStatus, String displayString) {
        this.appStatus = appStatus;
        this.displayString = displayString;
    }

    public static AppStatus get(String appStatus) {
        for (AppStatus state : AppStatus.values()) {
            if (!state.appStatus.equals(appStatus)) continue;
            return state;
        }
        Logger.logWarning("Unrecognized application status: " + appStatus);
        return UNKNOWN;
    }

    public String getDisplayString(StartMode mode) {
        if (this == STARTED && StartMode.DEBUG_MODES.contains((Object)mode)) {
            return CodewindCoreBundle.message("AppStatusDebugging", new Object[0]);
        }
        return this.displayString;
    }
}

