/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.core.connection;

import io.socket.client.IO;
import io.socket.client.Socket;
import io.socket.emitter.Emitter;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.WebSocket;
import org.eclipse.codewind.intellij.core.CodewindApplication;
import org.eclipse.codewind.intellij.core.CodewindApplicationFactory;
import org.eclipse.codewind.intellij.core.CoreUtil;
import org.eclipse.codewind.intellij.core.HttpUtil;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.cli.AuthToken;
import org.eclipse.codewind.intellij.core.connection.CodewindConnection;
import org.eclipse.codewind.intellij.core.console.ProjectLogInfo;
import org.eclipse.codewind.intellij.core.console.SocketConsole;
import org.eclipse.codewind.intellij.core.constants.ProjectType;
import org.eclipse.codewind.intellij.core.constants.StartMode;
import org.eclipse.codewind.intellij.core.messages.CodewindCoreBundle;
import org.jetbrains.annotations.NonNls;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CodewindSocket {
    private final CodewindConnection connection;
    public final Socket socket;
    public final URI socketUri;
    private boolean hasLostConnection = false;
    private volatile boolean hasConnected = false;
    private Set<SocketConsole> socketConsoles = new HashSet<SocketConsole>();
    private Throwable previousException;
    @NonNls
    private static final String EVENT_PROJECT_CREATION = "projectCreation";
    @NonNls
    private static final String EVENT_PROJECT_CHANGED = "projectChanged";
    @NonNls
    private static final String EVENT_PROJECT_STATUS_CHANGE = "projectStatusChanged";
    @NonNls
    private static final String EVENT_PROJECT_RESTART = "projectRestartResult";
    @NonNls
    private static final String EVENT_PROJECT_CLOSED = "projectClosed";
    @NonNls
    private static final String EVENT_PROJECT_DELETION = "projectDeletion";
    @NonNls
    private static final String EVENT_PROJECT_VALIDATED = "projectValidated";
    @NonNls
    private static final String EVENT_LOG_UPDATE = "log-update";
    @NonNls
    private static final String EVENT_PROJECT_LOGS_LIST_CHANGED = "projectLogsListChanged";
    @NonNls
    private static final String EVENT_PROJECT_SETTINGS_CHANGED = "projectSettingsChanged";

    public CodewindSocket(final CodewindConnection connection, final AuthToken authToken) {
        this.connection = connection;
        URI uri = connection.getBaseURI();
        if (connection.getSocketNamespace() != null) {
            uri = uri.resolve(connection.getSocketNamespace());
        }
        this.socketUri = uri;
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (authToken != null) {
            builder.hostnameVerifier(HttpUtil.hostnameVerifier).sslSocketFactory(HttpUtil.sslContext.getSocketFactory(), HttpUtil.trustManager);
        }
        OkHttpClient okHttpClient = builder.readTimeout(0L, TimeUnit.MILLISECONDS).build();
        IO.setDefaultOkHttpCallFactory((Call.Factory)okHttpClient);
        IO.setDefaultOkHttpWebSocketFactory((WebSocket.Factory)okHttpClient);
        IO.Options opts = new IO.Options();
        opts.callFactory = okHttpClient;
        opts.webSocketFactory = okHttpClient;
        this.socket = IO.socket((URI)this.socketUri, (IO.Options)opts);
        this.socket.on("connect", new Emitter.Listener(){

            public void call(Object ... arg0) {
                if (authToken != null) {
                    try {
                        JSONObject obj = new JSONObject();
                        obj.put("token", (Object)authToken.getToken());
                        CodewindSocket.this.socket.emit("authentication", new Object[]{obj.toString()});
                    }
                    catch (Exception e) {
                        Logger.logWarning("An error occurred trying to pass the authentication token to the socket", e);
                        return;
                    }
                }
                if (!CodewindSocket.this.hasConnected) {
                    CodewindSocket.this.hasConnected = true;
                    Logger.log("SocketIO connect success @ " + CodewindSocket.this.socketUri);
                }
                if (CodewindSocket.this.hasLostConnection) {
                    connection.clearConnectionError();
                    CodewindSocket.this.previousException = null;
                }
            }
        }).on("connect_error", new Emitter.Listener(){

            public void call(Object ... arg0) {
                if (arg0[0] instanceof Exception) {
                    Throwable e = Logger.unwrap((Exception)arg0[0]);
                    if (CodewindSocket.this.previousException == null || !e.getMessage().equals(CodewindSocket.this.previousException.getMessage())) {
                        CodewindSocket.this.previousException = e;
                        Logger.logWarning("SocketIO Connect Error @ " + CodewindSocket.this.socketUri, e);
                    }
                }
                connection.onConnectionError();
                CodewindSocket.this.hasLostConnection = true;
            }
        }).on("error", new Emitter.Listener(){

            public void call(Object ... arg0) {
                if (arg0[0] instanceof Exception) {
                    Exception e = (Exception)arg0[0];
                    Logger.logWarning("SocketIO Error @ " + CodewindSocket.this.socketUri, Logger.unwrap(e));
                }
            }
        }).on("message", new Emitter.Listener(){

            public void call(Object ... arg0) {
                Logger.log("SocketIO EVENT_MESSAGE " + arg0[0].toString());
            }
        }).on(EVENT_PROJECT_CREATION, new Emitter.Listener(){

            public void call(Object ... arg0) {
                Logger.log("projectCreation: " + arg0[0].toString());
                try {
                    JSONObject event = new JSONObject(arg0[0].toString());
                    CodewindSocket.this.onProjectCreation(event);
                }
                catch (JSONException e) {
                    Logger.logWarning("Error parsing JSON: " + arg0[0].toString(), e);
                }
            }
        }).on(EVENT_PROJECT_CHANGED, new Emitter.Listener(){

            public void call(Object ... arg0) {
                Logger.log("projectChanged: " + arg0[0].toString());
                try {
                    JSONObject event = new JSONObject(arg0[0].toString());
                    CodewindSocket.this.onProjectChanged(event);
                }
                catch (JSONException e) {
                    Logger.logWarning("Error parsing JSON: " + arg0[0].toString(), e);
                }
            }
        }).on(EVENT_PROJECT_SETTINGS_CHANGED, new Emitter.Listener(){

            public void call(Object ... arg0) {
                Logger.log("projectSettingsChanged: " + arg0[0].toString());
                try {
                    JSONObject event = new JSONObject(arg0[0].toString());
                    CodewindSocket.this.onProjectSettingsChanged(event);
                }
                catch (JSONException e) {
                    Logger.logWarning("Error parsing JSON: " + arg0[0].toString(), e);
                }
            }
        }).on(EVENT_PROJECT_STATUS_CHANGE, new Emitter.Listener(){

            public void call(Object ... arg0) {
                Logger.log("projectStatusChanged: " + arg0[0].toString());
                try {
                    JSONObject event = new JSONObject(arg0[0].toString());
                    CodewindSocket.this.onProjectStatusChanged(event);
                }
                catch (JSONException e) {
                    Logger.logWarning("Error parsing JSON: " + arg0[0].toString(), e);
                }
            }
        }).on(EVENT_PROJECT_RESTART, new Emitter.Listener(){

            public void call(Object ... arg0) {
                Logger.log("projectRestartResult: " + arg0[0].toString());
                try {
                    JSONObject event = new JSONObject(arg0[0].toString());
                    CodewindSocket.this.onProjectRestart(event);
                }
                catch (JSONException e) {
                    Logger.logWarning("Error parsing JSON: " + arg0[0].toString(), e);
                }
            }
        }).on(EVENT_PROJECT_CLOSED, new Emitter.Listener(){

            public void call(Object ... arg0) {
                Logger.log("projectClosed: " + arg0[0].toString());
                try {
                    JSONObject event = new JSONObject(arg0[0].toString());
                    CodewindSocket.this.onProjectClosed(event);
                }
                catch (JSONException e) {
                    Logger.logWarning("Error parsing JSON: " + arg0[0].toString(), e);
                }
            }
        }).on(EVENT_PROJECT_DELETION, new Emitter.Listener(){

            public void call(Object ... arg0) {
                Logger.log("projectDeletion: " + arg0[0].toString());
                try {
                    JSONObject event = new JSONObject(arg0[0].toString());
                    CodewindSocket.this.onProjectDeletion(event);
                }
                catch (JSONException e) {
                    Logger.logWarning("Error parsing JSON: " + arg0[0].toString(), e);
                }
            }
        }).on(EVENT_PROJECT_LOGS_LIST_CHANGED, new Emitter.Listener(){

            public void call(Object ... arg0) {
                Logger.log("projectLogsListChanged: " + arg0[0].toString());
                try {
                    JSONObject event = new JSONObject(arg0[0].toString());
                    CodewindSocket.this.onProjectLogsListChanged(event);
                }
                catch (JSONException e) {
                    Logger.logWarning("Error parsing JSON: " + arg0[0].toString(), e);
                }
            }
        }).on(EVENT_LOG_UPDATE, new Emitter.Listener(){

            public void call(Object ... arg0) {
                Logger.log(CodewindSocket.EVENT_LOG_UPDATE);
                try {
                    JSONObject event = new JSONObject(arg0[0].toString());
                    CodewindSocket.this.onLogUpdate(event);
                }
                catch (JSONException e) {
                    Logger.logWarning("Error parsing JSON: " + arg0[0].toString(), e);
                }
            }
        }).on(EVENT_PROJECT_VALIDATED, new Emitter.Listener(){

            public void call(Object ... arg0) {
                Logger.log("projectValidated: " + arg0[0].toString());
                try {
                    JSONObject event = new JSONObject(arg0[0].toString());
                    CodewindSocket.this.onValidationEvent(event);
                }
                catch (JSONException e) {
                    Logger.logWarning("Error parsing JSON: " + arg0[0].toString(), e);
                }
            }
        });
        this.socket.connect();
        Logger.log("Created CodewindSocket connected to " + this.socketUri);
    }

    public void close() {
        if (this.socket != null) {
            if (this.socket.connected()) {
                this.socket.disconnect();
            }
            this.socket.close();
        }
    }

    private void onProjectCreation(JSONObject event) throws JSONException {
        String projectID = event.getString("projectID");
        this.connection.refreshApps(projectID);
        CodewindApplication app = this.connection.getAppByID(projectID);
        if (app != null) {
            app.setEnabled(true);
            CoreUtil.updateApplication(app);
        } else {
            Logger.logWarning("No application found matching the project id for the project creation event: " + projectID);
        }
    }

    private void onProjectChanged(JSONObject event) throws JSONException {
        String projectID = event.getString("projectID");
        CodewindApplication app = this.connection.getAppByID(projectID);
        if (app == null) {
            Logger.logWarning("No application found matching the project id for the project changed event: " + projectID);
            return;
        }
        CodewindApplicationFactory.updateApp(app, event);
        if (StartMode.DEBUG_MODES.contains((Object)app.getStartMode()) && app.getDebugPort() != -1) {
            app.reconnectDebugger();
        }
        CoreUtil.updateApplication(app);
    }

    private void onProjectSettingsChanged(JSONObject event) throws JSONException {
        String status;
        String projectID = event.getString("projectID");
        CodewindApplication app = this.connection.getAppByID(projectID);
        if (app == null) {
            Logger.logWarning("No application found matching the project id for the project settings changed event: " + projectID);
            return;
        }
        app.setEnabled(true);
        if (event.has("status") && !"success".equals(status = event.getString("status"))) {
            if (event.has("error")) {
                String errorMsg = event.getString("error");
                CoreUtil.openDialog(true, CodewindCoreBundle.message("ProjectSettingsUpdateErrorTitle", new Object[0]), errorMsg);
            } else {
                Logger.logWarning("The project settings request failed but there is no error message in the result");
            }
            return;
        }
        if (event.has("contextRoot")) {
            app.setContextRoot(event.getString("contextRoot"));
        }
        if (event.has("ports") && event.get("ports") instanceof JSONObject) {
            JSONObject portsObj = event.getJSONObject("ports");
            if (portsObj.has("internalPort")) {
                app.setContainerAppPort(portsObj.getString("internalPort"));
            }
            if (portsObj.has("internalDebugPort")) {
                app.setContainerDebugPort(portsObj.getString("internalDebugPort"));
            }
        }
        CoreUtil.updateApplication(app);
    }

    private void onProjectStatusChanged(JSONObject event) throws JSONException {
        String projectID = event.getString("projectID");
        CodewindApplication app = this.connection.getAppByID(projectID);
        if (app == null) {
            this.connection.refreshApps(projectID);
            CoreUtil.updateConnection(this.connection);
            return;
        }
        CodewindApplicationFactory.updateApp(app, event);
        CoreUtil.updateApplication(app);
    }

    private void onProjectRestart(JSONObject event) throws JSONException {
        String projectID = event.getString("projectID");
        CodewindApplication app = this.connection.getAppByID(projectID);
        if (app == null) {
            Logger.logWarning("No application found matching the project id for the project restart event: " + projectID);
            return;
        }
        app.setEnabled(true);
        String status = event.getString("status");
        if (!"success".equalsIgnoreCase(status)) {
            Logger.logWarning("Project restart failed on the application: " + event.toString());
            CoreUtil.openDialog(true, CodewindCoreBundle.message("Socket_ErrRestartingProjectDialogTitle", new Object[0]), CodewindCoreBundle.message("Socket_ErrRestartingProjectDialogMsg", app.name, status));
            return;
        }
        JSONObject portsObj = event.getJSONObject("ports");
        if (portsObj != null && portsObj.has("exposedPort")) {
            int port = CoreUtil.parsePort(portsObj.getString("exposedPort"));
            app.setHttpPort(port);
        } else {
            Logger.logWarning("No http port on project restart event for: " + app.name);
        }
        int debugPort = -1;
        if (portsObj != null && portsObj.has("exposedDebugPort")) {
            debugPort = CoreUtil.parsePort(portsObj.getString("exposedDebugPort"));
        }
        app.setDebugPort(debugPort);
        StartMode startMode = StartMode.get(event);
        app.setStartMode(startMode);
        if (event.has("containerId")) {
            String containerId = event.getString("containerId");
            app.setContainerId(containerId);
        }
        CoreUtil.updateApplication(app);
        app.clearDebugger();
        if (StartMode.DEBUG_MODES.contains((Object)startMode) && debugPort != -1) {
            app.connectDebugger();
        }
    }

    private void onProjectClosed(JSONObject event) throws JSONException {
        String projectID = event.getString("projectID");
        CodewindApplication app = this.connection.getAppByID(projectID);
        if (app == null) {
            Logger.logWarning("No application found for project being closed: " + projectID);
            return;
        }
        app.dispose();
        app.connection.refreshApps(app.projectID);
        CoreUtil.updateApplication(app);
    }

    private void onProjectDeletion(JSONObject event) throws JSONException {
        String projectID = event.getString("projectID");
        CodewindApplication app = this.connection.getAppByID(projectID);
        if (app == null) {
            Logger.log("No application found for project being deleted: " + projectID);
            return;
        }
        this.connection.removeApp(projectID);
    }

    public void registerSocketConsole(SocketConsole console) {
        Logger.log("Register socketConsole for project: " + console.app.name);
        this.socketConsoles.add(console);
    }

    public void deregisterSocketConsole(SocketConsole console) {
        this.socketConsoles.remove(console);
    }

    private void onLogUpdate(JSONObject event) throws JSONException {
        String projectID = event.getString("projectID");
        String type = event.getString("logType");
        String logName = event.getString("logName");
        Logger.log("Update the " + logName + " log for project: " + projectID);
        for (SocketConsole console : this.socketConsoles) {
            if (!console.app.projectID.equals(projectID) || !console.logInfo.isThisLogInfo(type, logName)) continue;
            try {
                String logContents = event.getString("logs");
                boolean reset = event.getBoolean("reset");
                console.update(logContents, reset);
            }
            catch (IOException e) {
                Logger.logWarning("Error updating console " + logName, e);
            }
        }
    }

    private void onProjectLogsListChanged(JSONObject event) throws JSONException {
        List<ProjectLogInfo> logInfos;
        JSONArray logs;
        String type;
        String projectID = event.getString("projectID");
        CodewindApplication app = this.connection.getAppByID(projectID);
        if (app == null) {
            this.connection.refreshApps(projectID);
            CoreUtil.updateConnection(this.connection);
            return;
        }
        if (event.has("build")) {
            type = "build";
            logs = event.getJSONArray("build");
            logInfos = CodewindConnection.getLogs(logs, type);
            app.addLogInfos(logInfos);
        }
        if (event.has("app")) {
            type = "app";
            logs = event.getJSONArray("app");
            logInfos = CodewindConnection.getLogs(logs, type);
            app.addLogInfos(logInfos);
        }
    }

    private void onValidationEvent(JSONObject event) throws JSONException {
        String projectID = event.getString("projectID");
        CodewindApplication app = this.connection.getAppByID(projectID);
        if (app == null) {
            Logger.logWarning("No application found for project: " + projectID);
            return;
        }
        app.resetValidation();
        String status = event.getString("validationStatus");
        if ("success".equals(status)) {
            return;
        }
        if (event.has("validationResults")) {
            JSONArray results = event.getJSONArray("validationResults");
            for (int i = 0; i < results.length(); ++i) {
                JSONObject result = results.getJSONObject(i);
                String severity = result.getString("severity");
                String filename = result.getString("filename");
                String filepath = result.getString("filepath");
                String type = null;
                if (result.has("type")) {
                    type = result.getString("type");
                }
                String details = result.getString("details");
                String quickFixId = null;
                String quickFixDescription = null;
                if (result.has("quickfix") && this.supportsQuickFix(app, type, filename)) {
                    JSONObject quickFix = result.getJSONObject("quickfix");
                    quickFixId = quickFix.getString("fixID");
                    quickFixDescription = quickFix.getString("description");
                }
                if ("warning".equals(severity)) {
                    app.validationWarning(filepath, details, quickFixId, quickFixDescription);
                    continue;
                }
                app.validationError(filepath, details, quickFixId, quickFixDescription);
            }
        } else {
            Logger.log("Validation event indicates failure but no validation results,");
        }
    }

    private boolean supportsQuickFix(CodewindApplication app, String type, String filename) {
        if (!"missing".equals(type) || app.projectType == ProjectType.TYPE_DOCKER) {
            return false;
        }
        if ("Dockerfile".equals(filename)) {
            return true;
        }
        return app.projectType == ProjectType.TYPE_LIBERTY && "Dockerfile-build".equals(filename);
    }

    boolean blockUntilFirstConnection() {
        int delay = 100;
        int timeout = 2500;
        int waited = 0;
        while (!this.hasConnected && waited < 2500) {
            try {
                Thread.sleep(100L);
                if ((waited += 100) % 500 != 0) continue;
                Logger.log("Waiting for CodewindSocket initial connection");
            }
            catch (InterruptedException e) {
                Logger.logWarning(e);
            }
        }
        Logger.log("CodewindSocket initialized in time ? " + this.hasConnected);
        return this.hasConnected;
    }
}

