/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.filewatchers.core.internal;

import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.codewind.filewatchers.core.FWLogger;
import org.eclipse.codewind.filewatchers.core.Filewatcher;
import org.eclipse.codewind.filewatchers.core.FilewatcherUtils;
import org.eclipse.codewind.filewatchers.core.ProjectToWatch;
import org.eclipse.codewind.filewatchers.core.internal.AuthTokenWrapper;
import org.eclipse.codewind.filewatchers.core.internal.HttpUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpGetStatusThread
extends Thread {
    private final Filewatcher parent;
    private final String baseUrl;
    private boolean threadRunning = true;
    private final FWLogger log = FWLogger.getInstance();
    private static final int REFRESH_EVERY_X_SECONDS = 120;
    private final List<Long> statusUpdateRequests_synch_lock = new ArrayList<Long>();
    private final Object lock = new Object();
    private final AuthTokenWrapper authTokenWrapper;

    public HttpGetStatusThread(String url, Filewatcher parent, AuthTokenWrapper authTokenWrapper) {
        this.parent = parent;
        this.baseUrl = url;
        this.authTokenWrapper = authTokenWrapper;
        this.setDaemon(true);
        this.setName(HttpGetStatusThread.class.getSimpleName());
    }

    @Override
    public void run() {
        try {
            this.log.logInfo(HttpGetStatusThread.class.getName() + " started, for '" + this.baseUrl + "'.");
            while (this.threadRunning) {
                try {
                    this.innerLoop();
                }
                catch (Throwable t) {
                    this.log.logSevere("Unexpected exception when getting filewatcher status", t, null);
                    FilewatcherUtils.sleepIgnoreInterrupt(1000L);
                }
            }
        }
        finally {
            this.log.logInfo(HttpGetStatusThread.class.getName() + " terminated, from '" + this.baseUrl + "'.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueStatusUpdate() {
        if (!this.threadRunning) {
            return;
        }
        boolean queued = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.statusUpdateRequests_synch_lock.size() == 0) {
                this.statusUpdateRequests_synch_lock.add(System.nanoTime());
                this.lock.notify();
                queued = true;
            } else {
                queued = false;
            }
        }
        if (queued) {
            this.log.logDebug("Queue status update received for '" + this.baseUrl + "', and was queued.");
        } else {
            this.log.logDebug("Queue status update received for '" + this.baseUrl + "', but was ignored as already present.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerLoop() throws InterruptedException, IOException {
        long nextWatchRefreshInNanos = 0L;
        while (this.threadRunning) {
            boolean performSynch = false;
            Object object = this.lock;
            synchronized (object) {
                if (this.statusUpdateRequests_synch_lock.size() > 0) {
                    performSynch = true;
                } else {
                    this.lock.wait(10000L);
                }
            }
            if (nextWatchRefreshInNanos == 0L) {
                nextWatchRefreshInNanos = System.nanoTime() + TimeUnit.NANOSECONDS.convert(120L, TimeUnit.SECONDS);
            } else if (System.nanoTime() > nextWatchRefreshInNanos) {
                performSynch = true;
                nextWatchRefreshInNanos = 0L;
            }
            if (!performSynch) continue;
            boolean success = false;
            List<ProjectToWatch> projectsToWatch = null;
            FilewatcherUtils.ExponentialBackoffUtil delay = FilewatcherUtils.getDefaultBackoffUtil(4000L);
            while (!success && this.threadRunning) {
                try {
                    projectsToWatch = this.doHttpRequest();
                }
                catch (Throwable t) {
                    if (t instanceof ConnectException && t.getMessage().contains("Connection refused")) {
                        this.log.logError("Unable to issue get request to " + this.baseUrl + " " + t.getClass().getSimpleName() + ": " + t.getMessage());
                    }
                    this.log.logError("Unable to issue get request to " + this.baseUrl, t);
                }
                if (success = projectsToWatch != null) continue;
                delay.sleep();
                delay.failIncrease();
            }
            nextWatchRefreshInNanos = 0L;
            Object object2 = this.lock;
            synchronized (object2) {
                this.statusUpdateRequests_synch_lock.clear();
            }
            if (projectsToWatch == null || projectsToWatch.size() <= 0) continue;
            this.parent.internal_updateFileWatchStateFromGetRequest(projectsToWatch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ProjectToWatch> doHttpRequest() throws IOException, URISyntaxException, JSONException {
        JSONArray arr;
        HttpUtil.HttpResult httpResult;
        String toGet;
        block8: {
            block7: {
                String responseStr;
                List<ProjectToWatch> list;
                toGet = this.baseUrl + "/api/v1/projects/watchlist";
                httpResult = null;
                try {
                    this.log.logInfo("Initiating GET request to " + toGet);
                    httpResult = HttpUtil.get(new URI(toGet), e -> {
                        e.setConnectTimeout(15000);
                        e.setReadTimeout(15000);
                        HttpUtil.allowAllCerts(e);
                    }, this.authTokenWrapper);
                    if (httpResult != null && httpResult.responseCode == 200) break block7;
                    this.log.logError("Get response failed for " + toGet + ", " + (httpResult != null ? Integer.valueOf(httpResult.responseCode) : "N/A"));
                    list = null;
                    responseStr = httpResult != null && httpResult.response != null ? httpResult.response.trim() : "N/A";
                }
                catch (Throwable throwable) {
                    String responseStr2 = httpResult != null && httpResult.response != null ? httpResult.response.trim() : "N/A";
                    responseStr2 = responseStr2.replace("\r", "");
                    responseStr2 = responseStr2.replace("\n", "");
                    this.log.logInfo("GET request completed, for " + toGet + ". Response: " + responseStr2);
                    throw throwable;
                }
                responseStr = responseStr.replace("\r", "");
                responseStr = responseStr.replace("\n", "");
                this.log.logInfo("GET request completed, for " + toGet + ". Response: " + responseStr);
                return list;
            }
            if (httpResult.response != null) break block8;
            this.log.logError("Get response was null for " + toGet);
            List<ProjectToWatch> list = null;
            String responseStr = httpResult != null && httpResult.response != null ? httpResult.response.trim() : "N/A";
            responseStr = responseStr.replace("\r", "");
            responseStr = responseStr.replace("\n", "");
            this.log.logInfo("GET request completed, for " + toGet + ". Response: " + responseStr);
            return list;
        }
        String responseStr = httpResult != null && httpResult.response != null ? httpResult.response.trim() : "N/A";
        responseStr = responseStr.replace("\r", "");
        responseStr = responseStr.replace("\n", "");
        this.log.logInfo("GET request completed, for " + toGet + ". Response: " + responseStr);
        try {
            JSONObject jo = new JSONObject(httpResult.response);
            arr = jo.getJSONArray("projects");
        }
        catch (JSONException je) {
            this.log.logSevere("Unable to parse JSON, response was: " + httpResult.response, je, null);
            throw je;
        }
        if (arr == null) {
            return null;
        }
        ArrayList<ProjectToWatch> result = new ArrayList<ProjectToWatch>();
        for (int x = 0; x < arr.length(); ++x) {
            JSONObject projectToWatchJson = arr.getJSONObject(x);
            ProjectToWatch ptw = new ProjectToWatch(projectToWatchJson, false);
            result.add(ptw);
        }
        return result;
    }

    public void dispose() {
        if (!this.threadRunning) {
            return;
        }
        this.log.logInfo("dispose() called on " + this.getClass().getSimpleName());
        this.threadRunning = false;
        FilewatcherUtils.newThread(() -> {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        });
    }
}

