/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.codewind.core.internal.CodewindObjectFactory;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionManager;
import org.eclipse.codewind.ui.internal.IDEUtil;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CodewindConnectionComposite
extends Composite {
    private Container container;
    private CodewindConnection connection;
    private Text connNameText;
    private Text connURLText;
    private Text connUserText;
    private Text connPassText;
    private Button connTestButton;

    public CodewindConnectionComposite(Composite parent, Container container) {
        super(parent, 0);
        this.container = container;
        this.createControl();
    }

    protected void createControl() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 8;
        layout.verticalSpacing = 20;
        this.setLayout((Layout)layout);
        this.createLabel("Connection name:", this, 1, 0);
        this.connNameText = new Text((Composite)this, 2048);
        this.connNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.connNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CodewindConnectionComposite.this.validateAndUpdate();
                if (CodewindConnectionComposite.this.connection != null) {
                    CodewindConnectionComposite.this.connection.setName(CodewindConnectionComposite.this.connNameText.getText().trim());
                }
            }
        });
        Group connGroup = new Group((Composite)this, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.horizontalSpacing = 7;
        layout.verticalSpacing = 7;
        connGroup.setLayout((Layout)layout);
        GridData data = new GridData(4, 1, true, false, 2, 1);
        connGroup.setLayoutData((Object)data);
        connGroup.setText("Deployment");
        Text connGroupLabel = new Text((Composite)connGroup, 8);
        connGroupLabel.setText("Fill in the deployment information:");
        connGroupLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        IDEUtil.normalizeBackground((Control)connGroupLabel, (Control)this);
        this.createLabel("URL:", (Composite)connGroup, 1, 15);
        this.connURLText = this.createConnText((Composite)connGroup, 0, 1);
        this.createLabel("User name:", (Composite)connGroup, 1, 15);
        this.connUserText = this.createConnText((Composite)connGroup, 0, 1);
        this.createLabel("Password:", (Composite)connGroup, 1, 15);
        this.connPassText = this.createConnText((Composite)connGroup, 0x400000, 1);
        this.connTestButton = new Button((Composite)connGroup, 8);
        this.connTestButton.setText("Test Connection");
        this.connTestButton.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false, 2, 1));
        this.connTestButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                CodewindConnectionComposite.this.testConnection();
                CodewindConnectionComposite.this.container.update();
            }
        });
        this.connTestButton.setEnabled(false);
        this.connNameText.setFocus();
    }

    private void createLabel(String labelStr, Composite parent, int horizontalSpan, int horizontalIndent) {
        Label label = new Label(parent, 0);
        label.setText(labelStr);
        GridData data = new GridData(4, 0x1000000, false, false, horizontalSpan, 1);
        data.horizontalIndent = horizontalIndent;
        label.setLayoutData((Object)data);
    }

    private Text createConnText(Composite parent, int styles, int horizontalSpan) {
        Text text = new Text(parent, 0x800 | styles);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, horizontalSpan, 1));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CodewindConnectionComposite.this.removePreviousConnection();
                CodewindConnectionComposite.this.validateAndUpdate();
            }
        });
        return text;
    }

    private void validateAndUpdate() {
        this.validate();
        this.container.update();
    }

    private void validate() {
        String name = this.connNameText.getText().trim();
        if (name.isEmpty()) {
            this.container.setErrorMessage("Fill in a name for the connection.");
            return;
        }
        CodewindConnection existingConnection = CodewindConnectionManager.getActiveConnectionByName((String)name);
        if (existingConnection != null) {
            this.container.setErrorMessage("The name " + name + " is already used for an existing connection");
            return;
        }
        String url = this.connURLText.getText().trim();
        if (!url.isEmpty()) {
            try {
                new URI(url);
            }
            catch (URISyntaxException e) {
                this.connTestButton.setEnabled(false);
                this.container.setErrorMessage("The url is not valid: " + url);
                return;
            }
            existingConnection = CodewindConnectionManager.getActiveConnection((String)(url.endsWith("/") ? url : url + "/"));
            if (existingConnection != null) {
                this.connTestButton.setEnabled(false);
                this.container.setErrorMessage("The " + existingConnection.getName() + " connection is already using url: " + url);
                return;
            }
        }
        String user = this.connUserText.getText().trim();
        String pass = this.connPassText.getText().trim();
        if (url.isEmpty() || user.isEmpty() || pass.isEmpty()) {
            this.connTestButton.setEnabled(false);
            this.container.setErrorMessage("Fill in all of the deployment info fields.");
            return;
        }
        this.connTestButton.setEnabled(true);
        if (this.connection == null) {
            this.container.setErrorMessage("Click `Test Connection` to validate the deployment info.");
            return;
        }
        this.container.setErrorMessage(null);
    }

    public boolean canFinish() {
        return this.connection != null && this.connection.isConnected();
    }

    void removePreviousConnection() {
        if (this.connection != null) {
            this.connection.close();
        }
        this.connection = null;
    }

    void testConnection() {
        this.removePreviousConnection();
        String urlStr = this.connURLText.getText().trim();
        URI uri = null;
        try {
            uri = new URI(urlStr);
        }
        catch (URISyntaxException e) {
            Logger.logError((Throwable)e);
            this.container.setErrorMessage(e.getMessage());
        }
        if (uri == null) {
            return;
        }
        Logger.log((String)("Validating connection: " + uri));
        this.connection = this.createConnection(this.connNameText.getText().trim(), uri);
        if (this.connection != null && this.connection.isConnected()) {
            this.container.setErrorMessage(null);
            this.container.setMessage(NLS.bind((String)Messages.NewConnectionPage_ConnectSucceeded, (Object)this.connection.getBaseURI()));
        } else {
            this.container.setErrorMessage(NLS.bind((String)Messages.NewConnectionPage_ErrCouldNotConnect, (Object)uri));
        }
        this.container.update();
    }

    CodewindConnection getConnection() {
        return this.connection;
    }

    private CodewindConnection createConnection(String name, final URI uri) {
        Exception exception = null;
        final Boolean[] isCanceled = new Boolean[]{false};
        final CodewindConnection conn = CodewindObjectFactory.createCodewindConnection((String)name, (URI)uri, (boolean)false);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    mon.setTaskName(NLS.bind((String)Messages.NewConnectionPage_TestConnectionJobLabel, (Object)uri));
                    conn.connect((IProgressMonitor)mon.split(100));
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e, "An error occurred trying to connect to Codewind: " + e.getMessage());
                }
                isCanceled[0] = monitor.isCanceled();
            }
        };
        try {
            this.container.run(runnable);
        }
        catch (InvocationTargetException e) {
            Logger.logError((String)("An error occurred trying to connect to Codewind at: " + uri), (Throwable)e);
            exception = e;
        }
        catch (InterruptedException e) {
            Logger.logError((String)"Codewind connect was interrupted", (Throwable)e);
            exception = e;
        }
        if (isCanceled[0].booleanValue()) {
            return null;
        }
        if (!conn.isConnected()) {
            if (exception != null) {
                Logger.logError((String)("Failed to connect to Codewind at: " + uri.toString()), (Throwable)exception);
                MultiStatus errorStatus = IDEUtil.getMultiStatus("An error occurred trying to connect to Codewind at: " + uri, exception);
                ErrorDialog.openError((Shell)this.getShell(), (String)"Codewind Connect Error", (String)("An error occurred trying to connect to Codewind at: " + uri), (IStatus)errorStatus);
            } else {
                Logger.logError((String)("Failed to connect to Codewind at: " + uri.toString()));
                MessageDialog.openError((Shell)this.getShell(), (String)"Codewind Connect Error", (String)"Connecting to Codewind was not successful. Check workspace logs for details.");
            }
        }
        return conn;
    }

    public static interface Container {
        public void setErrorMessage(String var1);

        public void setMessage(String var1);

        public void update();

        public void run(IRunnableWithProgress var1) throws InvocationTargetException, InterruptedException;
    }
}

