/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.cli.TemplateUtil;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.ProjectTypeInfo;
import org.eclipse.codewind.core.internal.constants.ProjectInfo;
import org.eclipse.codewind.core.internal.constants.ProjectLanguage;
import org.eclipse.codewind.core.internal.constants.ProjectType;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.prefs.RepositoryManagementDialog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ProjectTypeSelectionPage
extends WizardPage {
    private CodewindConnection connection = null;
    private Map<String, ProjectTypeInfo> typeMap;
    private Text subtypeLabel = null;
    private CheckboxTableViewer subtypeViewer = null;
    private Text typeLabel = null;
    private CheckboxTableViewer typeViewer = null;
    private ProjectInfo projectInfo = null;
    private ProjectTypeInfo projectTypeInfo = null;
    private ProjectTypeInfo.ProjectSubtypeInfo projectSubtypeInfo = null;

    protected ProjectTypeSelectionPage(CodewindConnection connection) {
        super(Messages.SelectProjectTypePageName);
        this.setTitle(Messages.SelectProjectTypePageTitle);
        this.setDescription(Messages.SelectProjectTypePageDescription);
        this.connection = connection;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 7;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.typeLabel = new Text(composite, 8);
        this.typeLabel.setText(Messages.SelectProjectTypePageProjectTypeLabel);
        this.typeLabel.setLayoutData((Object)new GridData(1, 2, false, false));
        this.typeLabel.setBackground(composite.getBackground());
        this.typeLabel.setForeground(composite.getForeground());
        this.typeViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2816);
        this.typeViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.typeViewer.setLabelProvider((IBaseLabelProvider)new ProjectTypeLabelProvider());
        this.typeViewer.setComparator(new ViewerComparator());
        GridData typeViewerData = new GridData(4, 4, true, true);
        typeViewerData.minimumHeight = 200;
        this.typeViewer.getTable().setLayoutData((Object)typeViewerData);
        this.subtypeLabel = new Text(composite, 8);
        this.subtypeLabel.setLayoutData((Object)new GridData(1, 2, false, false));
        this.subtypeLabel.setBackground(composite.getBackground());
        this.subtypeLabel.setForeground(composite.getForeground());
        this.subtypeViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2816);
        this.subtypeViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.subtypeViewer.setLabelProvider((IBaseLabelProvider)new ProjectSubtypeLabelProvider());
        this.subtypeViewer.setComparator(new ViewerComparator());
        this.subtypeViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.typeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    ProjectTypeSelectionPage.this.projectTypeInfo = (ProjectTypeInfo)event.getElement();
                    ProjectTypeSelectionPage.this.typeViewer.setCheckedElements(new Object[]{ProjectTypeSelectionPage.this.projectTypeInfo});
                } else {
                    ProjectTypeSelectionPage.this.projectTypeInfo = null;
                }
                ProjectTypeSelectionPage.this.updateSubtypes(false, ProjectTypeSelectionPage.this.projectTypeInfo);
            }
        });
        this.subtypeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    ProjectTypeSelectionPage.this.projectSubtypeInfo = (ProjectTypeInfo.ProjectSubtypeInfo)event.getElement();
                    ProjectTypeSelectionPage.this.subtypeViewer.setCheckedElements(new Object[]{ProjectTypeSelectionPage.this.projectSubtypeInfo});
                } else {
                    ProjectTypeSelectionPage.this.projectSubtypeInfo = null;
                }
                ProjectTypeSelectionPage.this.getWizard().getContainer().updateButtons();
            }
        });
        Composite manageReposComp = new Composite(composite, 0);
        manageReposComp.setLayout((Layout)new GridLayout(1, false));
        manageReposComp.setLayoutData((Object)new GridData(3, 4, false, false, 1, 1));
        Link manageRepoLink = new Link(manageReposComp, 0);
        manageRepoLink.setText(Messages.SelectProjectTypeManageRepoLabel + " <a>" + Messages.SelectProjectTypeManageRepoLink + "</a>");
        manageRepoLink.setToolTipText(Messages.SelectProjectTypeManageRepoTooltip);
        manageRepoLink.setLayoutData((Object)new GridData(3, 2, false, false));
        manageRepoLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                block5: {
                    try {
                        List repoList = TemplateUtil.listTemplateSources((String)ProjectTypeSelectionPage.this.connection.getConid(), (IProgressMonitor)new NullProgressMonitor());
                        final RepositoryManagementDialog repoDialog = new RepositoryManagementDialog(ProjectTypeSelectionPage.this.getShell(), ProjectTypeSelectionPage.this.connection, repoList);
                        if (repoDialog.open() != 0 || !repoDialog.hasChanges()) break block5;
                        IRunnableWithProgress runnable = new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                                SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.RepoUpdateTask, (int)100);
                                IStatus status = repoDialog.updateRepos((IProgressMonitor)mon.split(75));
                                if (!status.isOK()) {
                                    throw new InvocationTargetException(status.getException(), status.getMessage());
                                }
                                if (mon.isCanceled()) {
                                    return;
                                }
                                try {
                                    mon = mon.split(25);
                                    mon.setTaskName(Messages.SelectProjectTypeRefreshTypesTask);
                                    ProjectTypeSelectionPage.this.typeMap = ProjectTypeSelectionPage.this.getProjectTypeMap((IProgressMonitor)mon);
                                }
                                catch (Exception e) {
                                    throw new InvocationTargetException(e, Messages.SelectProjectTypeRefreshTypesError);
                                }
                            }
                        };
                        try {
                            ProjectTypeSelectionPage.this.getWizard().getContainer().run(true, true, runnable);
                        }
                        catch (InvocationTargetException e) {
                            MessageDialog.openError((Shell)ProjectTypeSelectionPage.this.getShell(), (String)Messages.RepoUpdateErrorTitle, (String)e.getMessage());
                            return;
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                        ProjectTypeSelectionPage.this.updateTables(false);
                    }
                    catch (Exception e) {
                        MessageDialog.openError((Shell)ProjectTypeSelectionPage.this.getShell(), (String)Messages.RepoListErrorTitle, (String)NLS.bind((String)Messages.RepoListErrorMsg, (Object)e));
                    }
                }
            }
        });
        this.subtypeLabel.setVisible(false);
        this.subtypeViewer.getTable().setVisible(false);
        this.typeViewer.getTable().setFocus();
        this.setControl((Control)composite);
    }

    public boolean isActivePage() {
        return this.isCurrentPage();
    }

    public boolean canFinish() {
        if (this.typeViewer == null) {
            return false;
        }
        ProjectTypeInfo projectType = this.getType();
        if (projectType == null) {
            return false;
        }
        if (!(projectType.eq(ProjectType.TYPE_DOCKER) || this.projectInfo != null && projectType.eq(this.projectInfo.type))) {
            return this.subtypeViewer.getCheckedElements().length != 0;
        }
        return true;
    }

    public void initPage(CodewindConnection connection, ProjectInfo projectInfo) {
        this.connection = connection;
        this.initTypeMap();
        this.projectInfo = projectInfo;
        if (projectInfo == null) {
            this.projectTypeInfo = null;
            this.projectSubtypeInfo = null;
        } else {
            ProjectTypeInfo projectTypeInfo = this.projectTypeInfo = this.typeMap.get(projectInfo.type.getId());
            projectTypeInfo.getClass();
            this.projectSubtypeInfo = new ProjectTypeInfo.ProjectSubtypeInfo(projectTypeInfo, projectInfo.language.getId());
        }
        this.updateTables(true);
    }

    public void initTypeMap() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.SelectProjectTypeGatherTypesTask, (int)100);
                ProjectTypeSelectionPage.this.typeMap = ProjectTypeSelectionPage.this.getProjectTypeMap((IProgressMonitor)mon.split(100));
            }
        };
        try {
            this.getContainer().run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            Logger.logError((String)("An error occurred gathering the project types for connection: " + this.connection.getBaseURI()), (Throwable)e);
            return;
        }
        catch (InterruptedException e) {
            return;
        }
    }

    public ProjectTypeInfo getType() {
        return this.projectTypeInfo;
    }

    public ProjectTypeInfo.ProjectSubtypeInfo getSubtype() {
        ProjectTypeInfo projectType = this.getType();
        if (projectType == null || projectType.getSubtypesLabel().length() == 0 || this.projectInfo != null && projectType.eq(this.projectInfo.type)) {
            return null;
        }
        return this.projectSubtypeInfo;
    }

    public String getLanguage() {
        ProjectTypeInfo projectType = this.getType();
        if (projectType == null) {
            return null;
        }
        if (projectType.getSubtypesLabel().length() == 0) {
            return this.projectSubtypeInfo == null ? ProjectLanguage.LANGUAGE_UNKNOWN.getId() : this.projectSubtypeInfo.id;
        }
        return this.projectInfo == null ? ProjectLanguage.LANGUAGE_UNKNOWN.getId() : this.projectInfo.language.getId();
    }

    private void updateTables(boolean init) {
        if (this.typeViewer == null || this.typeViewer.getTable().isDisposed()) {
            return;
        }
        Collection<ProjectTypeInfo> projectTypes = this.typeMap.values();
        this.typeViewer.setInput(projectTypes);
        if (projectTypes.size() == 0) {
            this.setErrorMessage(Messages.SelectProjectTypeNoProjectTypes);
            this.updateSubtypes(init, null);
            return;
        }
        this.setErrorMessage(null);
        if (init && this.projectInfo != null) {
            this.projectTypeInfo = this.typeMap.get(this.projectInfo.type.getId());
            if (this.projectTypeInfo != null) {
                this.typeViewer.setCheckedElements(new Object[]{this.projectTypeInfo});
            } else {
                this.typeViewer.setAllChecked(false);
            }
            this.updateSubtypes(init, this.projectTypeInfo);
        } else {
            Object[] checked = this.typeViewer.getCheckedElements();
            if (checked.length == 0) {
                this.updateSubtypes(init, null);
            }
        }
    }

    private void updateSubtypes(boolean init, ProjectTypeInfo projectType) {
        if (this.subtypeViewer == null || this.subtypeViewer.getTable().isDisposed()) {
            return;
        }
        boolean shouldShow = false;
        this.projectSubtypeInfo = null;
        if (projectType == null) {
            this.subtypeViewer.setInput((Object)new Object[0]);
        } else {
            boolean isDocker;
            List projectSubtypes = projectType.getSubtypes();
            this.subtypeViewer.setInput((Object)projectSubtypes);
            if (projectSubtypes.size() == 1) {
                this.projectSubtypeInfo = (ProjectTypeInfo.ProjectSubtypeInfo)projectSubtypes.get(0);
                this.subtypeViewer.setCheckedElements(new Object[]{this.projectSubtypeInfo});
            } else if (projectSubtypes.size() > 1 && ((isDocker = projectType.eq(ProjectType.TYPE_DOCKER)) || this.projectInfo == null || !projectType.eq(this.projectInfo.type))) {
                if (init && isDocker && this.projectInfo != null) {
                    ProjectTypeInfo projectTypeInfo = projectType;
                    projectTypeInfo.getClass();
                    this.projectSubtypeInfo = new ProjectTypeInfo.ProjectSubtypeInfo(projectTypeInfo, this.projectInfo.language.getId());
                    this.subtypeViewer.setCheckedElements(new Object[]{this.projectSubtypeInfo});
                }
                shouldShow = true;
                String label = projectType.getSubtypesLabel();
                label = "".equals(label) ? Messages.SelectProjectTypePageLanguageLabel : Messages.bind((String)Messages.SelectProjectTypePageSubtypeLabel, (Object)label);
                this.subtypeLabel.setText(label);
                this.subtypeLabel.pack();
            }
        }
        this.subtypeLabel.setVisible(shouldShow);
        this.subtypeViewer.getTable().setVisible(shouldShow);
        this.getWizard().getContainer().updateButtons();
    }

    private Map<String, ProjectTypeInfo> getProjectTypeMap(IProgressMonitor monitor) {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        List projectTypes = null;
        HashMap<String, ProjectTypeInfo> typeMap = new HashMap<String, ProjectTypeInfo>();
        try {
            projectTypes = this.connection.requestProjectTypes();
            mon.worked(100);
        }
        catch (Exception e) {
            Logger.logError((String)("An error occurred trying to get the list of project types for connection: " + this.connection.getBaseURI()), (Throwable)e);
            return typeMap;
        }
        if (projectTypes == null || projectTypes.isEmpty()) {
            Logger.log((String)("The list of project types is empty for connection: " + this.connection.getBaseURI()));
            return typeMap;
        }
        for (ProjectTypeInfo projectType : projectTypes) {
            ProjectTypeInfo existing = (ProjectTypeInfo)typeMap.get(projectType.getId());
            if (existing == null) {
                typeMap.put(projectType.getId(), projectType);
                continue;
            }
            existing.addSubtypes(projectType.getSubtypes());
        }
        return typeMap;
    }

    private class ProjectSubtypeLabelProvider
    extends LabelProvider {
        private ProjectSubtypeLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            String label = ((ProjectTypeInfo.ProjectSubtypeInfo)element).label;
            return ProjectLanguage.getDisplayName((String)label);
        }
    }

    private class ProjectTypeLabelProvider
    extends LabelProvider {
        private ProjectTypeLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            String label = ((ProjectTypeInfo)element).getId();
            return ProjectType.getDisplayName((String)label);
        }
    }
}

