/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.HttpUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.console.ProjectLogInfo;
import org.eclipse.codewind.core.internal.constants.AppStatus;
import org.eclipse.codewind.core.internal.constants.BuildStatus;
import org.eclipse.codewind.core.internal.constants.ProjectCapabilities;
import org.eclipse.codewind.core.internal.constants.ProjectLanguage;
import org.eclipse.codewind.core.internal.constants.ProjectType;
import org.eclipse.codewind.core.internal.constants.StartMode;
import org.eclipse.core.runtime.IPath;
import org.json.JSONObject;

public class CodewindApplication {
    public final CodewindConnection connection;
    public final String projectID;
    public final String name;
    public final String host;
    public final IPath fullLocalPath;
    public final ProjectType projectType;
    public final ProjectLanguage projectLanguage;
    private String contextRoot;
    private StartMode startMode;
    private AppStatus appStatus;
    private String appStatusDetails;
    private BuildStatus buildStatus;
    private String buildDetails;
    private boolean autoBuild = true;
    private boolean injectMetrics = false;
    private boolean enabled = true;
    private String containerId;
    private ProjectCapabilities projectCapabilities;
    private String action;
    private List<ProjectLogInfo> logInfos = new ArrayList<ProjectLogInfo>();
    private boolean metricsAvailable = false;
    private boolean hasConfirmedMetrics = false;
    private long lastBuild = -1L;
    private long lastImageBuild = -1L;
    private boolean isHttps = false;
    private boolean deleteContents = false;
    private URL baseUrl;
    private String appBaseUrl;
    private URL rootUrl;
    private int httpPort = -1;
    private int debugPort = -1;
    private String containerAppPort = null;
    private String containerDebugPort = null;

    CodewindApplication(CodewindConnection connection, String id, String name, ProjectType projectType, ProjectLanguage projectLanguage, IPath localPath) throws MalformedURLException {
        this.connection = connection;
        this.projectID = id;
        this.name = name;
        this.projectType = projectType;
        this.projectLanguage = projectLanguage;
        this.host = connection.getBaseURI().getHost();
        this.fullLocalPath = localPath;
        this.startMode = StartMode.RUN;
        this.appStatus = AppStatus.UNKNOWN;
        this.buildStatus = BuildStatus.UNKOWN;
    }

    private void setUrls() throws MalformedURLException {
        if (this.httpPort == -1) {
            Logger.log("Un-setting baseUrl because httpPort is not valid");
            this.baseUrl = null;
            this.rootUrl = null;
            return;
        }
        String httpStr = this.getIsHttps() ? "https" : "http";
        this.baseUrl = new URL(httpStr, this.host, this.httpPort, "");
        URL appUrl = null;
        if (this.appBaseUrl != null && !this.appBaseUrl.isEmpty()) {
            appUrl = new URL(this.appBaseUrl);
        }
        URL uRL = this.rootUrl = appUrl != null ? appUrl : this.baseUrl;
        if (this.contextRoot != null && !this.contextRoot.isEmpty()) {
            this.rootUrl = new URL(this.rootUrl, this.contextRoot);
        }
    }

    public synchronized void setAppStatus(String appStatus, String appStatusDetails) {
        if (appStatus != null) {
            this.appStatus = AppStatus.get(appStatus);
            this.appStatusDetails = appStatusDetails == null || appStatusDetails.trim().isEmpty() ? null : appStatusDetails;
        }
    }

    public synchronized void setBuildStatus(String buildStatus, String buildDetails) {
        if (buildStatus != null) {
            BuildStatus newStatus = BuildStatus.get(buildStatus);
            boolean hasChanged = newStatus != this.buildStatus;
            this.buildStatus = newStatus;
            this.buildDetails = buildDetails != null && buildDetails.trim().isEmpty() ? null : buildDetails;
            if (hasChanged && newStatus.isComplete()) {
                this.buildComplete();
            }
        }
    }

    public synchronized void setAppBaseUrl(String appBaseUrl) {
        this.appBaseUrl = appBaseUrl;
        try {
            this.setUrls();
        }
        catch (MalformedURLException e) {
            Logger.logError("An error occurred updating the application base url to: " + appBaseUrl, e);
        }
    }

    public synchronized void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
        try {
            this.setUrls();
        }
        catch (MalformedURLException e) {
            Logger.logError("An error occurred updating the base url with the new context root: " + contextRoot, e);
        }
    }

    public synchronized String getContextRoot() {
        return this.contextRoot;
    }

    public synchronized void setStartMode(StartMode startMode) {
        this.startMode = startMode;
    }

    public synchronized void setAutoBuild(boolean enabled) {
        this.autoBuild = enabled;
        CoreUtil.updateApplication(this);
    }

    public synchronized void setInjectMetrics(boolean enabled) {
        this.injectMetrics = enabled;
        CoreUtil.updateApplication(this);
    }

    public synchronized void setEnabled(boolean enabled) {
        boolean reenabled = enabled && !this.enabled;
        this.enabled = enabled;
        if (reenabled) {
            this.connection.refreshApps(this.projectID);
            CoreUtil.updateApplication(this);
        } else if (!enabled) {
            this.setHttpPort(-1);
            this.setDebugPort(-1);
            this.setContainerId(null);
        }
    }

    public synchronized void setContainerId(String id) {
        this.containerId = id;
    }

    public synchronized void setAction(String action) {
        this.action = action;
    }

    public synchronized void addLogInfos(List<ProjectLogInfo> newLogInfos) {
        if (newLogInfos == null || newLogInfos.isEmpty()) {
            Logger.logError("Trying to add empty log infos to project: " + this.name);
            return;
        }
        if (this.logInfos == null || this.logInfos.isEmpty()) {
            this.logInfos = newLogInfos;
            return;
        }
        for (ProjectLogInfo newLogInfo : newLogInfos) {
            boolean found = false;
            for (ProjectLogInfo logInfo : this.logInfos) {
                if (!logInfo.logName.equals(newLogInfo.logName)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.logInfos.add(newLogInfo);
        }
    }

    public synchronized void setLogInfos(List<ProjectLogInfo> logInfos) {
        if (logInfos == null) {
            Logger.logError("The logs should not be set to null for project: " + this.name);
            return;
        }
        this.logInfos = logInfos;
    }

    public synchronized void setMetricsAvailable(boolean value) {
        this.metricsAvailable = value;
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public URL getRootUrl() {
        return this.rootUrl;
    }

    public URL getMetricsUrl() {
        try {
            if (!this.injectMetrics && this.metricsAvailable) {
                return new URL(this.getBaseUrl(), this.projectLanguage.getMetricsRoot());
            }
            return this.connection.getBaseURI().resolve("performance/monitor/dashboard/" + this.projectLanguage.getId() + "?theme=dark&projectID=" + this.projectID).toURL();
        }
        catch (MalformedURLException e) {
            Logger.logError("An error occurred trying to construct the application metrics URL", e);
            return null;
        }
    }

    public synchronized void confirmMetricsAvailable() {
        if (this.hasConfirmedMetrics) {
            return;
        }
        this.hasConfirmedMetrics = true;
        if (!this.metricsAvailable || !this.projectType.isExtension()) {
            return;
        }
        try {
            URL metricsUrl = this.getMetricsUrl();
            if (metricsUrl == null) {
                return;
            }
            HttpUtil.HttpResult getMetricsResult = HttpUtil.get(metricsUrl.toURI());
            this.metricsAvailable = getMetricsResult.isGoodResponse;
        }
        catch (IOException | URISyntaxException e) {
            Logger.logError("An error occurred trying to confirm the application metrics status", e);
        }
    }

    public synchronized AppStatus getAppStatus() {
        return this.appStatus;
    }

    public synchronized String getAppStatusDetails() {
        return this.appStatusDetails;
    }

    public synchronized BuildStatus getBuildStatus() {
        return this.buildStatus;
    }

    public synchronized String getBuildDetails() {
        return this.buildDetails;
    }

    public synchronized int getHttpPort() {
        return this.httpPort;
    }

    public synchronized int getDebugPort() {
        return this.debugPort;
    }

    public synchronized StartMode getStartMode() {
        return this.startMode;
    }

    public synchronized boolean isAutoBuild() {
        return this.autoBuild;
    }

    public synchronized boolean isInjectMetrics() {
        return this.injectMetrics;
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    public synchronized String getContainerId() {
        return this.containerId;
    }

    public boolean isActive() {
        return this.getAppStatus() == AppStatus.STARTING || this.getAppStatus() == AppStatus.STARTED;
    }

    public boolean isRunning() {
        return this.rootUrl != null;
    }

    public boolean isDeleting() {
        return "deleting".equals(this.action);
    }

    public boolean isImporting() {
        return "validating".equals(this.action);
    }

    public boolean isAvailable() {
        return this.isEnabled() && !this.isImporting();
    }

    public List<ProjectLogInfo> getLogInfos() {
        return this.logInfos;
    }

    public boolean hasBuildLog() {
        return this.projectType != ProjectType.TYPE_NODEJS;
    }

    public synchronized boolean getMetricsAvailable() {
        return this.metricsAvailable;
    }

    public synchronized void setLastBuild(long timestamp) {
        this.lastBuild = timestamp;
    }

    public synchronized long getLastBuild() {
        return this.lastBuild;
    }

    public synchronized void setLastImageBuild(long timestamp) {
        this.lastImageBuild = timestamp;
    }

    public synchronized long getLastImageBuild() {
        return this.lastImageBuild;
    }

    public synchronized void setHttpPort(int httpPort) {
        Logger.log("Set HTTP port for " + this.rootUrl + " to " + httpPort);
        this.httpPort = httpPort;
        try {
            this.setUrls();
        }
        catch (MalformedURLException e) {
            Logger.logError(e);
        }
    }

    public synchronized void setDebugPort(int debugPort) {
        Logger.log("Set debug port for " + this.rootUrl + " to " + debugPort);
        this.debugPort = debugPort;
    }

    public synchronized void invalidatePorts() {
        Logger.log("Invalidate ports for " + this.name);
        this.httpPort = -1;
        this.debugPort = -1;
    }

    public synchronized void setContainerAppPort(String port) {
        this.containerAppPort = port;
    }

    public synchronized String getContainerAppPort() {
        return this.containerAppPort;
    }

    public synchronized void setContainerDebugPort(String port) {
        this.containerDebugPort = port;
    }

    public synchronized String getContainerDebugPort() {
        return this.containerDebugPort;
    }

    public synchronized void setIsHttps(boolean value) {
        this.isHttps = value;
        try {
            this.setUrls();
        }
        catch (MalformedURLException e) {
            Logger.logError("An error occurred updating isHttps to: " + value, e);
        }
    }

    public synchronized boolean getIsHttps() {
        return this.isHttps;
    }

    public synchronized void setDeleteContents(boolean value) {
        this.deleteContents = value;
    }

    public synchronized boolean getDeleteContents() {
        return this.deleteContents;
    }

    public ProjectCapabilities getProjectCapabilities() {
        if (this.projectCapabilities == null) {
            try {
                JSONObject obj = this.connection.requestProjectCapabilities(this);
                this.projectCapabilities = new ProjectCapabilities(obj);
            }
            catch (Exception e) {
                Logger.logError("Failed to get the project capabilities for application: " + this.name, e);
            }
        }
        if (this.projectCapabilities == null) {
            return ProjectCapabilities.emptyCapabilities;
        }
        return this.projectCapabilities;
    }

    public void clearDebugger() {
    }

    public void connectDebugger() {
    }

    public void reconnectDebugger() {
    }

    public void dispose() {
    }

    public void resetValidation() {
    }

    public void validationError(String filePath, String message, String quickFixId, String quickFixDescription) {
    }

    public void validationWarning(String filePath, String message, String quickFixId, String quickFixDescription) {
    }

    public boolean supportsDebug() {
        return false;
    }

    public void buildComplete() {
    }

    public boolean canInjectMetrics() {
        List<ProjectType> projectTypesWithMetricInjection = Arrays.asList(ProjectType.TYPE_LIBERTY, ProjectType.TYPE_SPRING, ProjectType.TYPE_NODEJS);
        return projectTypesWithMetricInjection.contains(this.projectType);
    }

    public String toString() {
        return String.format("%s@%s id=%s name=%s type=%s loc=%s", CodewindApplication.class.getSimpleName(), this.rootUrl.toString(), this.projectID, this.name, this.projectType, this.fullLocalPath.toOSString());
    }
}

