/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.views;

import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.cli.ProjectUtil;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.constants.ProjectType;
import org.eclipse.codewind.ui.internal.actions.OpenAppOverviewAction;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.prefs.RegistryManagementDialog;
import org.eclipse.codewind.ui.internal.views.ViewHelper;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;

public class CodewindNavigatorDropAssistant
extends CommonDropAdapterAssistant {
    private CodewindConnection targetConn;
    private CodewindApplication sourceApp;

    public IStatus validateDrop(Object target, int operation, TransferData transferData) {
        IStructuredSelection sel;
        Object obj;
        ISelection s;
        this.targetConn = null;
        this.sourceApp = null;
        if (!(target instanceof CodewindConnection) || !((CodewindConnection)target).isConnected()) {
            return Status.CANCEL_STATUS;
        }
        this.targetConn = (CodewindConnection)target;
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferData) && !(s = LocalSelectionTransfer.getTransfer().getSelection()).isEmpty() && s instanceof IStructuredSelection && (obj = (sel = (IStructuredSelection)s).getFirstElement()) instanceof CodewindApplication) {
            CodewindApplication app = this.targetConn.getAppByName(((CodewindApplication)obj).name);
            if (app != null) {
                return Status.CANCEL_STATUS;
            }
            this.sourceApp = (CodewindApplication)obj;
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus handleDrop(CommonDropAdapter dropAdapter, DropTargetEvent dropTargetEvent, Object target) {
        if (this.targetConn == null || this.sourceApp == null) {
            Logger.logError((String)"Drop handler called but either the target or the source is null");
            return Status.CANCEL_STATUS;
        }
        final String jobName = NLS.bind((String)Messages.MoveProjectJobLabel, (Object[])new String[]{this.targetConn.getName(), this.sourceApp.name});
        Job job = new Job(jobName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    final SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)jobName, (int)120);
                    if (!CodewindNavigatorDropAssistant.this.targetConn.isLocal() && ProjectType.isCodewindStyle((String)((CodewindNavigatorDropAssistant)CodewindNavigatorDropAssistant.this).sourceApp.projectType.getId()) && !CodewindNavigatorDropAssistant.this.targetConn.requestHasPushRegistry()) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (MessageDialog.openConfirm((Shell)CodewindNavigatorDropAssistant.this.getShell(), (String)Messages.NoPushRegistryTitle, (String)Messages.NoPushRegistryMessage)) {
                                    RegistryManagementDialog.open(CodewindNavigatorDropAssistant.this.getShell(), CodewindNavigatorDropAssistant.this.targetConn, (IProgressMonitor)mon.split(40));
                                } else {
                                    mon.setCanceled(true);
                                }
                            }
                        });
                        if (mon.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        if (!CodewindNavigatorDropAssistant.this.targetConn.requestHasPushRegistry()) {
                            return new Status(4, "org.eclipse.codewind.ui", Messages.NoPushRegistryError, null);
                        }
                    }
                    mon.setWorkRemaining(80);
                    ProjectUtil.removeProject((String)((CodewindNavigatorDropAssistant)CodewindNavigatorDropAssistant.this).sourceApp.name, (String)((CodewindNavigatorDropAssistant)CodewindNavigatorDropAssistant.this).sourceApp.projectID, (IProgressMonitor)mon.split(10));
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    ProjectUtil.bindProject((String)((CodewindNavigatorDropAssistant)CodewindNavigatorDropAssistant.this).sourceApp.name, (String)((CodewindNavigatorDropAssistant)CodewindNavigatorDropAssistant.this).sourceApp.fullLocalPath.toOSString(), (String)((CodewindNavigatorDropAssistant)CodewindNavigatorDropAssistant.this).sourceApp.projectLanguage.getId(), (String)((CodewindNavigatorDropAssistant)CodewindNavigatorDropAssistant.this).sourceApp.projectType.getId(), (String)CodewindNavigatorDropAssistant.this.targetConn.getConid(), (IProgressMonitor)mon.split(60));
                    if (mon.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    mon.split(10);
                    CodewindNavigatorDropAssistant.this.targetConn.refreshApps(null);
                    CodewindApplication newApp = CodewindNavigatorDropAssistant.this.targetConn.getAppByName(((CodewindNavigatorDropAssistant)CodewindNavigatorDropAssistant.this).sourceApp.name);
                    if (newApp != null) {
                        if (CodewindCorePlugin.getDefault().getPreferenceStore().getBoolean("autoOpenOverviewPage")) {
                            Display.getDefault().asyncExec(() -> OpenAppOverviewAction.openAppOverview(newApp));
                        }
                    } else {
                        Logger.logError((String)("The " + ((CodewindNavigatorDropAssistant)CodewindNavigatorDropAssistant.this).sourceApp.name + " application could not be found on connection: " + CodewindNavigatorDropAssistant.this.targetConn.getName()));
                    }
                    mon.worked(10);
                    mon.done();
                    ViewHelper.refreshCodewindExplorerView(CodewindNavigatorDropAssistant.this.targetConn);
                    ViewHelper.expandConnection(CodewindNavigatorDropAssistant.this.targetConn);
                }
                catch (Exception e) {
                    Logger.logError((String)("An error occured trying to move project: " + ((CodewindNavigatorDropAssistant)CodewindNavigatorDropAssistant.this).sourceApp.fullLocalPath.toOSString()), (Throwable)e);
                    return new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.MoveProjectError, (Object[])new String[]{((CodewindNavigatorDropAssistant)CodewindNavigatorDropAssistant.this).sourceApp.name, ((CodewindNavigatorDropAssistant)CodewindNavigatorDropAssistant.this).sourceApp.connection.getName(), CodewindNavigatorDropAssistant.this.targetConn.getName()}), (Throwable)e);
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        return Status.OK_STATUS;
    }
}

