/*******************************************************************************
 * Copyright (c) 2012-2016 Codenvy, S.A.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Codenvy, S.A. - initial API and implementation
 *******************************************************************************/


// GENERATED SOURCE. DO NOT EDIT.
package org.eclipse.che.api.user.server.dto;

import org.eclipse.che.dto.server.JsonSerializable;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;

import java.util.List;
import java.util.Map;


@SuppressWarnings({"unchecked", "cast"})
public class DtoServerImpls implements org.eclipse.che.dto.server.DtoFactoryVisitor {

  private static final Gson gson = new GsonBuilder().disableHtmlEscaping().create();

  @Override
  public void accept(org.eclipse.che.dto.server.DtoFactory dtoFactory) {
    dtoFactory.registerProvider(org.eclipse.che.api.user.shared.dto.ProfileDto.class, new org.eclipse.che.dto.server.DtoProvider<org.eclipse.che.api.user.shared.dto.ProfileDto>() {
        public Class<? extends org.eclipse.che.api.user.shared.dto.ProfileDto> getImplClass() {
            return ProfileDtoImpl.class;
        }

        public org.eclipse.che.api.user.shared.dto.ProfileDto newInstance() {
            return ProfileDtoImpl.make();
        }

        public org.eclipse.che.api.user.shared.dto.ProfileDto fromJson(String json) {
            return ProfileDtoImpl.fromJsonString(json);
        }

        public org.eclipse.che.api.user.shared.dto.ProfileDto fromJson(com.google.gson.JsonElement json) {
            return ProfileDtoImpl.fromJsonElement(json);
        }

        public org.eclipse.che.api.user.shared.dto.ProfileDto clone(org.eclipse.che.api.user.shared.dto.ProfileDto origin) {
            return new ProfileDtoImpl(origin);
        }
    });
    dtoFactory.registerProvider(org.eclipse.che.api.user.shared.dto.UserDto.class, new org.eclipse.che.dto.server.DtoProvider<org.eclipse.che.api.user.shared.dto.UserDto>() {
        public Class<? extends org.eclipse.che.api.user.shared.dto.UserDto> getImplClass() {
            return UserDtoImpl.class;
        }

        public org.eclipse.che.api.user.shared.dto.UserDto newInstance() {
            return UserDtoImpl.make();
        }

        public org.eclipse.che.api.user.shared.dto.UserDto fromJson(String json) {
            return UserDtoImpl.fromJsonString(json);
        }

        public org.eclipse.che.api.user.shared.dto.UserDto fromJson(com.google.gson.JsonElement json) {
            return UserDtoImpl.fromJsonElement(json);
        }

        public org.eclipse.che.api.user.shared.dto.UserDto clone(org.eclipse.che.api.user.shared.dto.UserDto origin) {
            return new UserDtoImpl(origin);
        }
    });
  }

  @org.eclipse.che.dto.shared.DTOImpl("server")
  public static class ProfileDtoImpl implements org.eclipse.che.api.user.shared.dto.ProfileDto, JsonSerializable  {

    public static ProfileDtoImpl make() {
        return new ProfileDtoImpl();
    }

    public ProfileDtoImpl() {
    }

    protected java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> links;
    protected java.util.Map<java.lang.String, java.lang.String> attributes;
    protected java.lang.String email;
    protected java.lang.String userId;

    @Override
    public java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> getLinks() {
      ensureLinks();
      return new org.eclipse.che.dto.server.JsonArrayImpl(links);
    }

    public void setLinks(java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> v) {
      this.links = v;
    }

    public void addLinks(org.eclipse.che.api.core.rest.shared.dto.Link v) {
      ensureLinks();
      links.add(v);
    }

    public void clearLinks() {
      ensureLinks();
      links.clear();
    }

    protected void ensureLinks() {
      if (links == null) {
        links = new java.util.ArrayList<org.eclipse.che.api.core.rest.shared.dto.Link>();
      }
    }
    @Override
    public java.util.Map<java.lang.String, java.lang.String> getAttributes() {
      ensureAttributes();
      return new org.eclipse.che.dto.server.JsonStringMapImpl(attributes);
    }

    public void setAttributes(java.util.Map<java.lang.String, java.lang.String> v) {
      this.attributes = v;
    }

    public void putAttributes(String k, java.lang.String v) {
      ensureAttributes();
      attributes.put(k, v);
    }

    public void clearAttributes() {
      ensureAttributes();
      attributes.clear();
    }

    protected void ensureAttributes() {
      if (attributes == null) {
        attributes = new java.util.HashMap<java.lang.String, java.lang.String>();
      }
    }
    @Override
    public java.lang.String getEmail() {
      return email;
    }

    public void setEmail(java.lang.String v) {
      this.email = v;
    }

    @Override
    public java.lang.String getUserId() {
      return userId;
    }

    public void setUserId(java.lang.String v) {
      this.userId = v;
    }

    @Override
    public boolean equals(Object o) {
      if (!(o instanceof ProfileDtoImpl)) {
        return false;
      }
      ProfileDtoImpl other = (ProfileDtoImpl) o;
      this.ensureLinks();
      other.ensureLinks();
      
      if (this.links != null) {
        if (!this.links.equals(other.links)) {
          return false;
        }
      } else {
        if (other.links != null) {
          return false;
        }
      }
      this.ensureAttributes();
      other.ensureAttributes();
      
      if (this.attributes != null) {
        if (!this.attributes.equals(other.attributes)) {
          return false;
        }
      } else {
        if (other.attributes != null) {
          return false;
        }
      }
      if (this.email != null) {
        if (!this.email.equals(other.email)) {
          return false;
        }
      } else {
        if (other.email != null) {
          return false;
        }
      }
      if (this.userId != null) {
        if (!this.userId.equals(other.userId)) {
          return false;
        }
      } else {
        if (other.userId != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      ensureLinks();
      hash = hash * 31 + (links != null ? links.hashCode() : 0);
      ensureAttributes();
      hash = hash * 31 + (attributes != null ? attributes.hashCode() : 0);
      hash = hash * 31 + (email != null ? email.hashCode() : 0);
      hash = hash * 31 + (userId != null ? userId.hashCode() : 0);
      return hash;
    }

    @Override
    public JsonElement toJsonElement() {
      return toJsonElementInt(true);
    }
    public JsonElement toJsonElementInt(boolean copyJsons) {
      JsonObject result = new JsonObject();

      JsonArray linksOut = new JsonArray();
      this.ensureLinks();
      for (org.eclipse.che.api.core.rest.shared.dto.Link links_ : this.links) {
        JsonElement linksOut_ = links_ == null ? JsonNull.INSTANCE : ((org.eclipse.che.api.core.server.dto.DtoServerImpls.LinkImpl)links_).toJsonElementInt(copyJsons);
        linksOut.add(linksOut_);
      }
      result.add("links", linksOut);

      JsonObject attributesOut = new JsonObject();
      this.ensureAttributes();
      for (java.util.Map.Entry<String, java.lang.String> entry0 : this.attributes.entrySet()) {
        java.lang.String attributes_ = entry0.getValue();
        JsonElement attributesOut_ = (attributes_ == null) ? JsonNull.INSTANCE : new JsonPrimitive(attributes_);
        attributesOut.add(entry0.getKey(), attributesOut_);
      }
      result.add("attributes", attributesOut);

      JsonElement emailOut = (this.email == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.email);
      result.add("email", emailOut);

      JsonElement userIdOut = (this.userId == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.userId);
      result.add("userId", userIdOut);
      return result;
    }

    @Override
    public String toJson() {
      return gson.toJson(toJsonElementInt(false));
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static ProfileDtoImpl fromJsonElement(JsonElement jsonElem) {
      return fromJsonElement(jsonElem, true);
    }
    public static ProfileDtoImpl fromJsonElement(JsonElement jsonElem, boolean copyJsons) {
      if (jsonElem == null || jsonElem.isJsonNull()) {
        return null;
      }

      ProfileDtoImpl dto = new ProfileDtoImpl();
      JsonObject json = jsonElem.getAsJsonObject();

      if (json.has("links")) {
        JsonElement linksIn = json.get("links");
        java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> linksOut = null;
        if (linksIn != null && !linksIn.isJsonNull()) {
          linksOut = new java.util.ArrayList<org.eclipse.che.api.core.rest.shared.dto.Link>();
          java.util.Iterator<JsonElement> linksInIterator = linksIn.getAsJsonArray().iterator();
          while (linksInIterator.hasNext()) {
            JsonElement linksIn_ = linksInIterator.next();
            org.eclipse.che.api.core.rest.shared.dto.Link linksOut_ = org.eclipse.che.api.core.server.dto.DtoServerImpls.LinkImpl.fromJsonElement(linksIn_, copyJsons);
            linksOut.add(linksOut_);
          }
        }
        dto.setLinks(linksOut);
      }

      if (json.has("attributes")) {
        JsonElement attributesIn = json.get("attributes");
        java.util.Map<java.lang.String, java.lang.String> attributesOut = null;
        if (attributesIn != null && !attributesIn.isJsonNull()) {
          attributesOut = new java.util.HashMap<java.lang.String, java.lang.String>();
          java.util.Set<java.util.Map.Entry<String, JsonElement>> entries0 = attributesIn.getAsJsonObject().entrySet();
          for (java.util.Map.Entry<String, JsonElement> entry0 : entries0) {
            JsonElement attributesIn_ = entry0.getValue();
            java.lang.String attributesOut_ = gson.fromJson(attributesIn_, java.lang.String.class);
            attributesOut.put(entry0.getKey(), attributesOut_);
          }
        }
        dto.setAttributes(attributesOut);
      }

      if (json.has("email")) {
        JsonElement emailIn = json.get("email");
        java.lang.String emailOut = gson.fromJson(emailIn, java.lang.String.class);
        dto.setEmail(emailOut);
      }

      if (json.has("userId")) {
        JsonElement userIdIn = json.get("userId");
        java.lang.String userIdOut = gson.fromJson(userIdIn, java.lang.String.class);
        dto.setUserId(userIdOut);
      }

      return dto;
    }

    public static ProfileDtoImpl fromJsonString(String jsonString) {
      if (jsonString == null) {
        return null;
      }

      return fromJsonElement(new JsonParser().parse(jsonString), false);
    }

    public ProfileDtoImpl(org.eclipse.che.api.user.shared.dto.ProfileDto origin) {
      java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> linksIn = origin.getLinks();
      if (linksIn != null) {
        java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> linksOut = new java.util.ArrayList<org.eclipse.che.api.core.rest.shared.dto.Link>();
        for (org.eclipse.che.api.core.rest.shared.dto.Link linksIn_ : linksIn) {
            linksOut.add(linksIn_);
        }
        this.links = linksOut;
      }
      java.util.Map<java.lang.String, java.lang.String> attributesIn = origin.getAttributes();
      if (attributesIn != null) {
        java.util.Map<java.lang.String, java.lang.String> attributesOut = new java.util.HashMap<java.lang.String, java.lang.String>();
        for (java.util.Map.Entry<String, java.lang.String> entry0 : attributesIn.entrySet()) {
          java.lang.String attributesIn_ = entry0.getValue();
            attributesOut.put(entry0.getKey(), attributesIn_);
        }
        this.attributes = attributesOut;
      }
      this.email = origin.getEmail();
      this.userId = origin.getUserId();
    }

    public org.eclipse.che.api.user.shared.dto.ProfileDto withLinks(java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> v) {
      this.links = v;
      return this;
    }

    public org.eclipse.che.api.user.shared.dto.ProfileDto withAttributes(java.util.Map<java.lang.String, java.lang.String> v) {
      this.attributes = v;
      return this;
    }

    public org.eclipse.che.api.user.shared.dto.ProfileDto withEmail(java.lang.String v) {
      this.email = v;
      return this;
    }

    public org.eclipse.che.api.user.shared.dto.ProfileDto withUserId(java.lang.String v) {
      this.userId = v;
      return this;
    }

  }

  @org.eclipse.che.dto.shared.DTOImpl("server")
  public static class UserDtoImpl implements org.eclipse.che.api.user.shared.dto.UserDto, JsonSerializable  {

    public static UserDtoImpl make() {
        return new UserDtoImpl();
    }

    public UserDtoImpl() {
    }

    protected java.lang.String password;
    protected java.util.List<java.lang.String> aliases;
    protected java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> links;
    protected java.lang.String name;
    protected java.lang.String email;
    protected java.lang.String id;

    @Override
    public java.lang.String getPassword() {
      return password;
    }

    public void setPassword(java.lang.String v) {
      this.password = v;
    }

    @Override
    public java.util.List<java.lang.String> getAliases() {
      ensureAliases();
      return new org.eclipse.che.dto.server.JsonArrayImpl(aliases);
    }

    public void setAliases(java.util.List<java.lang.String> v) {
      this.aliases = v;
    }

    public void addAliases(java.lang.String v) {
      ensureAliases();
      aliases.add(v);
    }

    public void clearAliases() {
      ensureAliases();
      aliases.clear();
    }

    protected void ensureAliases() {
      if (aliases == null) {
        aliases = new java.util.ArrayList<java.lang.String>();
      }
    }
    @Override
    public java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> getLinks() {
      ensureLinks();
      return new org.eclipse.che.dto.server.JsonArrayImpl(links);
    }

    public void setLinks(java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> v) {
      this.links = v;
    }

    public void addLinks(org.eclipse.che.api.core.rest.shared.dto.Link v) {
      ensureLinks();
      links.add(v);
    }

    public void clearLinks() {
      ensureLinks();
      links.clear();
    }

    protected void ensureLinks() {
      if (links == null) {
        links = new java.util.ArrayList<org.eclipse.che.api.core.rest.shared.dto.Link>();
      }
    }
    @Override
    public java.lang.String getName() {
      return name;
    }

    public void setName(java.lang.String v) {
      this.name = v;
    }

    @Override
    public java.lang.String getEmail() {
      return email;
    }

    public void setEmail(java.lang.String v) {
      this.email = v;
    }

    @Override
    public java.lang.String getId() {
      return id;
    }

    public void setId(java.lang.String v) {
      this.id = v;
    }

    @Override
    public boolean equals(Object o) {
      if (!(o instanceof UserDtoImpl)) {
        return false;
      }
      UserDtoImpl other = (UserDtoImpl) o;
      if (this.password != null) {
        if (!this.password.equals(other.password)) {
          return false;
        }
      } else {
        if (other.password != null) {
          return false;
        }
      }
      this.ensureAliases();
      other.ensureAliases();
      
      if (this.aliases != null) {
        if (!this.aliases.equals(other.aliases)) {
          return false;
        }
      } else {
        if (other.aliases != null) {
          return false;
        }
      }
      this.ensureLinks();
      other.ensureLinks();
      
      if (this.links != null) {
        if (!this.links.equals(other.links)) {
          return false;
        }
      } else {
        if (other.links != null) {
          return false;
        }
      }
      if (this.name != null) {
        if (!this.name.equals(other.name)) {
          return false;
        }
      } else {
        if (other.name != null) {
          return false;
        }
      }
      if (this.email != null) {
        if (!this.email.equals(other.email)) {
          return false;
        }
      } else {
        if (other.email != null) {
          return false;
        }
      }
      if (this.id != null) {
        if (!this.id.equals(other.id)) {
          return false;
        }
      } else {
        if (other.id != null) {
          return false;
        }
      }
      return true;
    }

    @Override
    public int hashCode() {
      int hash = 7;
      hash = hash * 31 + (password != null ? password.hashCode() : 0);
      ensureAliases();
      hash = hash * 31 + (aliases != null ? aliases.hashCode() : 0);
      ensureLinks();
      hash = hash * 31 + (links != null ? links.hashCode() : 0);
      hash = hash * 31 + (name != null ? name.hashCode() : 0);
      hash = hash * 31 + (email != null ? email.hashCode() : 0);
      hash = hash * 31 + (id != null ? id.hashCode() : 0);
      return hash;
    }

    @Override
    public JsonElement toJsonElement() {
      return toJsonElementInt(true);
    }
    public JsonElement toJsonElementInt(boolean copyJsons) {
      JsonObject result = new JsonObject();

      JsonElement passwordOut = (this.password == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.password);
      result.add("password", passwordOut);

      JsonArray aliasesOut = new JsonArray();
      this.ensureAliases();
      for (java.lang.String aliases_ : this.aliases) {
        JsonElement aliasesOut_ = (aliases_ == null) ? JsonNull.INSTANCE : new JsonPrimitive(aliases_);
        aliasesOut.add(aliasesOut_);
      }
      result.add("aliases", aliasesOut);

      JsonArray linksOut = new JsonArray();
      this.ensureLinks();
      for (org.eclipse.che.api.core.rest.shared.dto.Link links_ : this.links) {
        JsonElement linksOut_ = links_ == null ? JsonNull.INSTANCE : ((org.eclipse.che.api.core.server.dto.DtoServerImpls.LinkImpl)links_).toJsonElementInt(copyJsons);
        linksOut.add(linksOut_);
      }
      result.add("links", linksOut);

      JsonElement nameOut = (this.name == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.name);
      result.add("name", nameOut);

      JsonElement emailOut = (this.email == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.email);
      result.add("email", emailOut);

      JsonElement idOut = (this.id == null) ? JsonNull.INSTANCE : new JsonPrimitive(this.id);
      result.add("id", idOut);
      return result;
    }

    @Override
    public String toJson() {
      return gson.toJson(toJsonElementInt(false));
    }

    @Override
    public String toString() {
      return toJson();
    }

    public static UserDtoImpl fromJsonElement(JsonElement jsonElem) {
      return fromJsonElement(jsonElem, true);
    }
    public static UserDtoImpl fromJsonElement(JsonElement jsonElem, boolean copyJsons) {
      if (jsonElem == null || jsonElem.isJsonNull()) {
        return null;
      }

      UserDtoImpl dto = new UserDtoImpl();
      JsonObject json = jsonElem.getAsJsonObject();

      if (json.has("password")) {
        JsonElement passwordIn = json.get("password");
        java.lang.String passwordOut = gson.fromJson(passwordIn, java.lang.String.class);
        dto.setPassword(passwordOut);
      }

      if (json.has("aliases")) {
        JsonElement aliasesIn = json.get("aliases");
        java.util.List<java.lang.String> aliasesOut = null;
        if (aliasesIn != null && !aliasesIn.isJsonNull()) {
          aliasesOut = new java.util.ArrayList<java.lang.String>();
          java.util.Iterator<JsonElement> aliasesInIterator = aliasesIn.getAsJsonArray().iterator();
          while (aliasesInIterator.hasNext()) {
            JsonElement aliasesIn_ = aliasesInIterator.next();
            java.lang.String aliasesOut_ = gson.fromJson(aliasesIn_, java.lang.String.class);
            aliasesOut.add(aliasesOut_);
          }
        }
        dto.setAliases(aliasesOut);
      }

      if (json.has("links")) {
        JsonElement linksIn = json.get("links");
        java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> linksOut = null;
        if (linksIn != null && !linksIn.isJsonNull()) {
          linksOut = new java.util.ArrayList<org.eclipse.che.api.core.rest.shared.dto.Link>();
          java.util.Iterator<JsonElement> linksInIterator = linksIn.getAsJsonArray().iterator();
          while (linksInIterator.hasNext()) {
            JsonElement linksIn_ = linksInIterator.next();
            org.eclipse.che.api.core.rest.shared.dto.Link linksOut_ = org.eclipse.che.api.core.server.dto.DtoServerImpls.LinkImpl.fromJsonElement(linksIn_, copyJsons);
            linksOut.add(linksOut_);
          }
        }
        dto.setLinks(linksOut);
      }

      if (json.has("name")) {
        JsonElement nameIn = json.get("name");
        java.lang.String nameOut = gson.fromJson(nameIn, java.lang.String.class);
        dto.setName(nameOut);
      }

      if (json.has("email")) {
        JsonElement emailIn = json.get("email");
        java.lang.String emailOut = gson.fromJson(emailIn, java.lang.String.class);
        dto.setEmail(emailOut);
      }

      if (json.has("id")) {
        JsonElement idIn = json.get("id");
        java.lang.String idOut = gson.fromJson(idIn, java.lang.String.class);
        dto.setId(idOut);
      }

      return dto;
    }

    public static UserDtoImpl fromJsonString(String jsonString) {
      if (jsonString == null) {
        return null;
      }

      return fromJsonElement(new JsonParser().parse(jsonString), false);
    }

    public UserDtoImpl(org.eclipse.che.api.user.shared.dto.UserDto origin) {
      this.password = origin.getPassword();
      java.util.List<java.lang.String> aliasesIn = origin.getAliases();
      if (aliasesIn != null) {
        java.util.List<java.lang.String> aliasesOut = new java.util.ArrayList<java.lang.String>();
        for (java.lang.String aliasesIn_ : aliasesIn) {
            aliasesOut.add(aliasesIn_);
        }
        this.aliases = aliasesOut;
      }
      java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> linksIn = origin.getLinks();
      if (linksIn != null) {
        java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> linksOut = new java.util.ArrayList<org.eclipse.che.api.core.rest.shared.dto.Link>();
        for (org.eclipse.che.api.core.rest.shared.dto.Link linksIn_ : linksIn) {
            linksOut.add(linksIn_);
        }
        this.links = linksOut;
      }
      this.name = origin.getName();
      this.email = origin.getEmail();
      this.id = origin.getId();
    }

    public org.eclipse.che.api.user.shared.dto.UserDto withPassword(java.lang.String v) {
      this.password = v;
      return this;
    }

    public org.eclipse.che.api.user.shared.dto.UserDto withAliases(java.util.List<java.lang.String> v) {
      this.aliases = v;
      return this;
    }

    public org.eclipse.che.api.user.shared.dto.UserDto withLinks(java.util.List<org.eclipse.che.api.core.rest.shared.dto.Link> v) {
      this.links = v;
      return this;
    }

    public org.eclipse.che.api.user.shared.dto.UserDto withName(java.lang.String v) {
      this.name = v;
      return this;
    }

    public org.eclipse.che.api.user.shared.dto.UserDto withEmail(java.lang.String v) {
      this.email = v;
      return this;
    }

    public org.eclipse.che.api.user.shared.dto.UserDto withId(java.lang.String v) {
      this.id = v;
      return this;
    }

  }


}