/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.cloudfoundry.client.lib.CloudFoundryException;
import org.cloudfoundry.client.lib.CloudFoundryOperations;
import org.cloudfoundry.client.lib.StartingInfo;
import org.cloudfoundry.client.lib.domain.ApplicationLog;
import org.cloudfoundry.client.lib.domain.ApplicationStats;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.cloudfoundry.client.lib.domain.CloudDomain;
import org.cloudfoundry.client.lib.domain.CloudRoute;
import org.cloudfoundry.client.lib.domain.CloudService;
import org.cloudfoundry.client.lib.domain.CloudServiceOffering;
import org.cloudfoundry.client.lib.domain.InstancesInfo;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.ServerEventHandler;
import org.eclipse.cft.server.core.internal.application.EnvironmentVariable;
import org.eclipse.cft.server.core.internal.client.AppInStoppedStateAwareRequest;
import org.eclipse.cft.server.core.internal.client.AppUrlChangeEvent;
import org.eclipse.cft.server.core.internal.client.ApplicationRequest;
import org.eclipse.cft.server.core.internal.client.BaseClientRequest;
import org.eclipse.cft.server.core.internal.client.BehaviourRequest;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.cft.server.core.internal.client.FileRequest;
import org.eclipse.cft.server.core.internal.client.StagingAwareRequest;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.web.client.RestClientException;

public class ClientRequestFactory {
    protected final CloudFoundryServerBehaviour behaviour;

    public ClientRequestFactory(CloudFoundryServerBehaviour behaviour) {
        this.behaviour = behaviour;
    }

    public BaseClientRequest<?> getUpdateApplicationMemoryRequest(final CloudFoundryApplicationModule appModule, final int memory) {
        return new AppInStoppedStateAwareRequest<Void>(NLS.bind((String)Messages.CloudFoundryServerBehaviour_UPDATE_APP_MEMORY, (Object)appModule.getDeployedApplicationName()), this.behaviour){

            @Override
            protected Void doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                client.updateApplicationMemory(appModule.getDeployedApplicationName(), memory);
                return null;
            }
        };
    }

    public BaseClientRequest<List<CloudRoute>> getRoutes(final String domainName) throws CoreException {
        return new BehaviourRequest<List<CloudRoute>>(NLS.bind((String)Messages.ROUTES, (Object)domainName), this.behaviour){

            @Override
            protected List<CloudRoute> doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                return client.getRoutes(domainName);
            }
        };
    }

    public BaseClientRequest<StartingInfo> restartApplication(final String appName, String opLabel) throws CoreException {
        return new BehaviourRequest<StartingInfo>(opLabel, this.behaviour){

            @Override
            protected StartingInfo doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException, OperationCanceledException {
                return client.restartApplication(appName);
            }
        };
    }

    public BaseClientRequest<?> deleteApplication(final String appName) {
        return new BehaviourRequest<Void>(NLS.bind((String)Messages.DELETING_MODULE, (Object)appName), this.behaviour){

            @Override
            protected Void doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                client.deleteApplication(appName);
                return null;
            }
        };
    }

    public BaseClientRequest<?> getUpdateAppUrlsRequest(final String appName, final List<String> urls) {
        return new AppInStoppedStateAwareRequest<Void>(NLS.bind((String)Messages.CloudFoundryServerBehaviour_UPDATE_APP_URLS, (Object)appName), this.behaviour){

            @Override
            protected Void doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                List oldUrls;
                CloudFoundryApplicationModule existingAppModule = this.behaviour.getCloudFoundryServer().getExistingCloudModule(appName);
                List list = oldUrls = existingAppModule != null && existingAppModule.getDeploymentInfo() != null ? existingAppModule.getDeploymentInfo().getUris() : null;
                if (oldUrls == null) {
                    oldUrls = this.behaviour.getCloudApplication(appName, (IProgressMonitor)progress).getUris();
                }
                client.updateApplicationUris(appName, urls);
                if (existingAppModule != null) {
                    ServerEventHandler.getDefault().fireServerEvent(new AppUrlChangeEvent(this.behaviour.getCloudFoundryServer(), 430, existingAppModule.getLocalModule(), Status.OK_STATUS, oldUrls, urls));
                }
                return null;
            }
        };
    }

    public BaseClientRequest<?> getUpdateServicesRequest(final String appName, final List<String> services) {
        return new StagingAwareRequest<Void>(NLS.bind((String)Messages.CloudFoundryServerBehaviour_UPDATE_SERVICE_BINDING, (Object)appName), this.behaviour){

            @Override
            protected Void doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                client.updateApplicationServices(appName, services);
                return null;
            }
        };
    }

    public BaseClientRequest<Void> getUpdateEnvVarRequest(final String appName, final List<EnvironmentVariable> variables) {
        String label = NLS.bind((String)Messages.CloudFoundryServerBehaviour_UPDATE_ENV_VARS, (Object)appName);
        return new BehaviourRequest<Void>(label, this.behaviour){

            @Override
            protected Void doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                HashMap<String, String> varsMap = new HashMap<String, String>();
                if (variables != null) {
                    for (EnvironmentVariable var : variables) {
                        varsMap.put(var.getVariable(), var.getValue());
                    }
                }
                client.updateApplicationEnv(appName, varsMap);
                return null;
            }
        };
    }

    public BaseClientRequest<List<CloudService>> getDeleteServicesRequest(final List<String> services) {
        return new BehaviourRequest<List<CloudService>>(Messages.CloudFoundryServerBehaviour_DELETE_SERVICES, this.behaviour){

            /*
             * Unable to fully structure code
             */
            @Override
            protected List<CloudService> doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                serviceProgress = SubMonitor.convert((IProgressMonitor)progress, (int)services.size());
                boundServices = new ArrayList<String>();
                for (String service : services) {
                    block11: {
                        serviceProgress.subTask(NLS.bind((String)Messages.CloudFoundryServerBehaviour_DELETING_SERVICE, (Object)service));
                        shouldDelete = true;
                        try {
                            instance = client.getServiceInstance(service);
                            bindings = instance != null ? instance.getBindings() : null;
                            shouldDelete = bindings == null || bindings.isEmpty() != false;
                            break block11;
                        }
                        catch (Throwable v0) {
                            apps = this.behaviour.getApplications((IProgressMonitor)progress);
                            if (apps == null) break block11;
                            i = 0;
                            ** while (shouldDelete && i < apps.size())
                        }
lbl-1000:
                        // 1 sources

                        {
                            app = apps.get(i);
                            if (app != null && (appServices = app.getServices()) != null) {
                                for (String appServ : appServices) {
                                    if (!service.equals(appServ)) continue;
                                    shouldDelete = false;
                                    break;
                                }
                            }
                            ++i;
                            continue;
                        }
                    }
                    if (shouldDelete) {
                        client.deleteService(service);
                    } else {
                        boundServices.add(service);
                    }
                    serviceProgress.worked(1);
                }
                if (!boundServices.isEmpty()) {
                    writer = new StringWriter();
                    size = boundServices.size();
                    i = 0;
                    while (i < size) {
                        writer.append((CharSequence)boundServices.get(i));
                        if (i < size - 1) {
                            writer.append(',');
                            writer.append(' ');
                        }
                        ++i;
                    }
                    boundServs = writer.toString();
                    CloudFoundryPlugin.getCallback().displayAndLogError(CloudFoundryPlugin.getErrorStatus(NLS.bind((String)Messages.CloudFoundryServerBehaviour_ERROR_DELETE_SERVICES_BOUND, (Object)boundServs)));
                }
                return client.getServices();
            }
        };
    }

    public BaseClientRequest<List<CloudService>> getCreateServicesRequest(final CloudService[] services) {
        return new BehaviourRequest<List<CloudService>>(Messages.CloudFoundryServerBehaviour_CREATE_SERVICES, this.behaviour){

            @Override
            protected List<CloudService> doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                SubMonitor serviceProgress = SubMonitor.convert((IProgressMonitor)progress, (int)services.length);
                CloudService[] cloudServiceArray = services;
                int n = services.length;
                int n2 = 0;
                while (n2 < n) {
                    CloudService service = cloudServiceArray[n2];
                    serviceProgress.subTask(NLS.bind((String)Messages.CloudFoundryServerBehaviour_CREATING_SERVICE, (Object)service.getName()));
                    client.createService(service);
                    serviceProgress.worked(1);
                    ++n2;
                }
                return client.getServices();
            }
        };
    }

    public BaseClientRequest<CloudApplication> getCloudApplication(final String appName) throws CoreException {
        final String serverId = this.behaviour.getCloudFoundryServer().getServer().getId();
        return new ApplicationRequest<CloudApplication>(NLS.bind((String)Messages.CloudFoundryServerBehaviour_GET_APPLICATION, (Object)appName), this.behaviour){

            @Override
            protected CloudApplication doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                return client.getApplication(appName);
            }

            @Override
            protected String get503Error(Throwable error) {
                return NLS.bind((String)Messages.CloudFoundryServerBehaviour_ERROR_GET_APPLICATION_SERVER_503, (Object)appName, (Object)serverId);
            }
        };
    }

    public BaseClientRequest<?> deleteRoute(final List<CloudRoute> routes) throws CoreException {
        if (routes == null || routes.isEmpty()) {
            return null;
        }
        return new BehaviourRequest<Void>("Deleting routes", this.behaviour){

            @Override
            protected Void doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                for (CloudRoute route : routes) {
                    client.deleteRoute(route.getHost(), route.getDomain().getName());
                }
                return null;
            }
        };
    }

    public BaseClientRequest<?> register(final String email, final String password) {
        return new BehaviourRequest<Void>("Registering account", this.behaviour){

            @Override
            protected Void doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                client.register(email, password);
                return null;
            }
        };
    }

    public BaseClientRequest<?> connect() throws CoreException {
        final CloudFoundryServer cloudServer = this.behaviour.getCloudFoundryServer();
        return new BehaviourRequest<Void>("Login to " + this.behaviour.getCloudFoundryServer().getUrl(), this.behaviour){

            @Override
            protected Void doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                OAuth2AccessToken token = client.login();
                if (cloudServer.isSso()) {
                    try {
                        String tokenValue = new ObjectMapper().writeValueAsString((Object)token);
                        cloudServer.setAndSaveToken(tokenValue);
                    }
                    catch (JsonProcessingException e) {
                        CloudFoundryPlugin.logWarning(e.getMessage());
                    }
                }
                return null;
            }
        };
    }

    public BaseClientRequest<?> updateApplicationInstances(final String appName, final int instanceCount) throws CoreException {
        return new AppInStoppedStateAwareRequest<Void>("Updating application instances", this.behaviour){

            @Override
            protected Void doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                client.updateApplicationInstances(appName, instanceCount);
                return null;
            }
        };
    }

    public BaseClientRequest<?> updatePassword(final String newPassword) throws CoreException {
        return new BehaviourRequest<Void>("Updating password", this.behaviour){

            @Override
            protected Void doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                client.updatePassword(newPassword);
                return null;
            }
        };
    }

    public BaseClientRequest<List<ApplicationLog>> getRecentApplicationLogs(final String appName) throws CoreException {
        return new BehaviourRequest<List<ApplicationLog>>("Getting existing application logs for: " + appName, this.behaviour){

            @Override
            protected List<ApplicationLog> doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                List logs = null;
                if (appName != null) {
                    logs = client.getRecentLogs(appName);
                }
                if (logs == null) {
                    logs = Collections.emptyList();
                }
                return logs;
            }
        };
    }

    public BaseClientRequest<ApplicationStats> getApplicationStats(final String applicationId) throws CoreException {
        return new StagingAwareRequest<ApplicationStats>(NLS.bind((String)Messages.CloudFoundryServerBehaviour_APP_STATS, (Object)applicationId), this.behaviour){

            @Override
            protected ApplicationStats doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                try {
                    return client.getApplicationStats(applicationId);
                }
                catch (RestClientException ce) {
                    if (CloudErrorUtil.isAppStoppedStateError((Exception)((Object)ce)) || CloudErrorUtil.getBadRequestException((Exception)((Object)ce)) != null) {
                        return null;
                    }
                    throw ce;
                }
            }
        };
    }

    public BaseClientRequest<InstancesInfo> getInstancesInfo(final String applicationId) throws CoreException {
        return new StagingAwareRequest<InstancesInfo>(NLS.bind((String)Messages.CloudFoundryServerBehaviour_APP_INFO, (Object)applicationId), this.behaviour){

            @Override
            protected InstancesInfo doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                try {
                    return client.getApplicationInstances(applicationId);
                }
                catch (RestClientException ce) {
                    if (CloudErrorUtil.isAppStoppedStateError((Exception)((Object)ce)) || CloudErrorUtil.getBadRequestException((Exception)((Object)ce)) != null) {
                        return null;
                    }
                    throw ce;
                }
            }
        };
    }

    public BaseClientRequest<List<CloudApplication>> getApplications() throws CoreException {
        final String serverId = this.behaviour.getCloudFoundryServer().getServer().getId();
        String label = NLS.bind((String)Messages.CloudFoundryServerBehaviour_GET_ALL_APPS, (Object)serverId);
        return new ApplicationRequest<List<CloudApplication>>(label, this.behaviour){

            @Override
            protected List<CloudApplication> doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                return client.getApplications();
            }

            @Override
            protected String get503Error(Throwable error) {
                return NLS.bind((String)Messages.CloudFoundryServerBehaviour_ERROR_GET_APPLICATIONS_SERVER, (Object)serverId);
            }
        };
    }

    public BaseClientRequest<?> deleteAllApplications() throws CoreException {
        return new BehaviourRequest<Object>("Deleting all applications", this.behaviour){

            @Override
            protected Object doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                client.deleteAllApplications();
                return null;
            }
        };
    }

    public BaseClientRequest<List<CloudService>> getServices() throws CoreException {
        String label = NLS.bind((String)Messages.CloudFoundryServerBehaviour_GET_ALL_SERVICES, (Object)this.behaviour.getCloudFoundryServer().getServer().getId());
        return new BehaviourRequest<List<CloudService>>(label, this.behaviour){

            @Override
            protected List<CloudService> doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                return client.getServices();
            }
        };
    }

    public BaseClientRequest<List<CloudServiceOffering>> getServiceOfferings() throws CoreException {
        return new BehaviourRequest<List<CloudServiceOffering>>("Getting available service options", this.behaviour){

            @Override
            protected List<CloudServiceOffering> doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                return client.getServiceOfferings();
            }
        };
    }

    public BaseClientRequest<List<CloudDomain>> getDomainsForSpace() throws CoreException {
        return new BehaviourRequest<List<CloudDomain>>(Messages.CloudFoundryServerBehaviour_DOMAINS_FOR_SPACE, this.behaviour){

            @Override
            protected List<CloudDomain> doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                return client.getDomains();
            }
        };
    }

    public BaseClientRequest<List<CloudDomain>> getDomainsFromOrgs() throws CoreException {
        return new BehaviourRequest<List<CloudDomain>>("Getting domains for orgs", this.behaviour){

            @Override
            protected List<CloudDomain> doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                return client.getDomainsForOrg();
            }
        };
    }

    public BaseClientRequest<?> stopApplication(String message, final CloudFoundryApplicationModule cloudModule) {
        return new BehaviourRequest<Void>(message, this.behaviour){

            @Override
            protected Void doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                client.stopApplication(cloudModule.getDeployedApplicationName());
                return null;
            }
        };
    }

    public BaseClientRequest<String> getFile(final CloudApplication app, final int instanceIndex, final String path, boolean isDir) throws CoreException {
        String label = NLS.bind((String)Messages.CloudFoundryServerBehaviour_FETCHING_FILE, (Object)path, (Object)app.getName());
        return new FileRequest<String>(label, this.behaviour){

            @Override
            protected String doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                return client.getFile(app.getName(), instanceIndex, path);
            }
        };
    }

    public BaseClientRequest<Boolean> reserveRouteIfAvailable(final String host, final String domainName) {
        return new BehaviourRequest<Boolean>(Messages.bind((String)Messages.CloudFoundryServerBehaviour_CHECKING_HOSTNAME_AVAILABLE, (Object)host), this.behaviour){

            @Override
            protected Boolean doRun(CloudFoundryOperations client, SubMonitor progress) {
                try {
                    client.addRoute(host, domainName);
                }
                catch (CloudFoundryException cloudFoundryException) {
                    return false;
                }
                return true;
            }
        };
    }

    public BaseClientRequest<Void> deleteRoute(final String host, final String domainName) {
        return new BehaviourRequest<Void>(Messages.bind((String)Messages.CloudFoundryServerBehaviour_CLEANING_UP_RESERVED_HOSTNAME, (Object)host), this.behaviour){

            @Override
            protected Void doRun(CloudFoundryOperations client, SubMonitor progress) throws CoreException {
                client.deleteRoute(host, domainName);
                return null;
            }
        };
    }
}

