/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.operations;

import java.util.List;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.adapters.TraceMetaModelAdapter;
import org.eclipse.capra.core.adapters.TracePersistenceAdapter;
import org.eclipse.capra.core.helpers.EditingDomainHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.core.helpers.TraceHelper;
import org.eclipse.capra.ui.operations.OperationsHelper;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.swt.widgets.Shell;

public class DeleteTraceOperation
extends AbstractOperation {
    private static final String ERROR_DIALOG_TITLE = "Error deleting trace link";
    private static final String EXCEPTION_MESSAGE_RUNTIME_EXCEPTION = "An exception occured during the deletion of the trace link.";
    private Connection connection;

    public DeleteTraceOperation(String label, Connection connection) {
        super(label);
        this.connection = connection;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Shell shell = (Shell)info.getAdapter(Shell.class);
        IStatus executionStatus = null;
        try {
            this.deleteTrace();
            executionStatus = Status.OK_STATUS;
        }
        catch (IllegalStateException e) {
            executionStatus = new Status(4, "org.eclipse.capra.ui", e.getMessage(), (Throwable)e);
            OperationsHelper.createErrorMessage(shell, executionStatus, ERROR_DIALOG_TITLE, e.getMessage());
        }
        catch (RuntimeException e) {
            executionStatus = new Status(4, "org.eclipse.capra.ui", e.getMessage(), (Throwable)e);
            OperationsHelper.createErrorMessage(shell, executionStatus, ERROR_DIALOG_TITLE, EXCEPTION_MESSAGE_RUNTIME_EXCEPTION);
        }
        return executionStatus;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        TracePersistenceAdapter persistenceAdapter = (TracePersistenceAdapter)ExtensionPointHelper.getTracePersistenceAdapter().orElseThrow();
        ResourceSet resourceSet = EditingDomainHelper.getResourceSet();
        EObject traceModel = persistenceAdapter.getTraceModel(resourceSet);
        TraceHelper traceHelper = new TraceHelper(traceModel);
        traceHelper.createTrace(this.connection.getOrigins(), this.connection.getTargets(), this.connection.getTlink().eClass());
        return Status.OK_STATUS;
    }

    private void deleteTrace() {
        TraceMetaModelAdapter traceAdapter = (TraceMetaModelAdapter)ExtensionPointHelper.getTraceMetamodelAdapter().get();
        TracePersistenceAdapter persistenceAdapter = (TracePersistenceAdapter)ExtensionPointHelper.getTracePersistenceAdapter().get();
        ResourceSet resourceSet = EditingDomainHelper.getResourceSet();
        EObject traceModel = persistenceAdapter.getTraceModel(resourceSet);
        EObject artifactModel = persistenceAdapter.getArtifactWrappers(resourceSet);
        traceAdapter.deleteTrace(List.of(this.connection), traceModel);
        persistenceAdapter.saveTracesAndArtifacts(traceModel, artifactModel);
    }
}

