/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.handler.cdt;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.capra.handler.cdt.preferences.CDTPreferences;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class CDTAnnotate {
    private static Pattern FILE_TAG_PATTERN = Pattern.compile("^((/\\*[!*])|(\\s*\\*?))\\s*[@\\\\]file\\W", 8);
    private static final Pattern NON_SPACES_PATTERN = Pattern.compile("\\S");

    public static void annotateArtifact(ICElement handle, String annotation) throws CoreException {
        if (!(handle instanceof ISourceReference)) {
            return;
        }
        ISourceReference sourceRef = (ISourceReference)handle;
        IEclipsePreferences preferences = CDTPreferences.getPreferences();
        String tag = String.valueOf(preferences.get("ANNOTATE_CDT_TAG_PREFIX", "@").trim()) + preferences.get("ANNOTATE_CDT_TAG", "parent").trim();
        if (sourceRef instanceof ITranslationUnit) {
            CDTAnnotate.annotateFile(annotation, tag, (ITranslationUnit)sourceRef);
        } else {
            CDTAnnotate.annotateDeclaration(annotation, tag, sourceRef);
        }
    }

    private static void annotateFile(String annotation, String tag, ITranslationUnit translationUnit) throws CoreException {
        Optional<IASTComment> oldCommentNode = Arrays.stream(translationUnit.getAST().getComments()).filter(c -> CDTAnnotate.isDoxygenFileComment(c.getRawSignature())).findFirst();
        String newline = CDTAnnotate.findFirstNewline(translationUnit.getBuffer());
        String newCommentText = CDTAnnotate.createNewCommentString(oldCommentNode.map(c -> c.getRawSignature()), annotation, tag, newline, true);
        if (oldCommentNode.isPresent()) {
            IASTFileLocation loc = ((IASTComment)oldCommentNode.orElse(null)).getFileLocation();
            translationUnit.getBuffer().replace(loc.getNodeOffset(), loc.getNodeLength(), newCommentText);
        } else {
            translationUnit.getBuffer().replace(0, 0, String.valueOf(newCommentText) + newline);
        }
        translationUnit.getBuffer().save((IProgressMonitor)new NullProgressMonitor(), false);
    }

    static boolean isDoxygenFileComment(String comment) {
        return comment != null && FILE_TAG_PATTERN.matcher(comment).find();
    }

    private static void annotateDeclaration(String annotation, String tag, ISourceReference sourceRef) throws CoreException, CModelException {
        ITranslationUnit translationUnit = sourceRef.getTranslationUnit();
        IASTTranslationUnit ast = translationUnit.getAST();
        IASTNode node = CDTAnnotate.findNode(sourceRef, ast);
        String newline = CDTAnnotate.findNewlineAndIndentationBefore(translationUnit.getBuffer(), node.getFileLocation().getNodeOffset());
        ASTRewrite rewrite = ASTRewrite.create((IASTTranslationUnit)ast);
        Optional<IASTComment> oldCommentNode = CDTAnnotate.getDoxygenComment(rewrite.getComments(node, ASTRewrite.CommentPosition.leading));
        String newCommentText = CDTAnnotate.createNewCommentString(oldCommentNode.map(c -> c.getRawSignature()), annotation, tag, newline, false);
        if (oldCommentNode.isPresent()) {
            IASTFileLocation loc = oldCommentNode.get().getFileLocation();
            translationUnit.getBuffer().replace(loc.getNodeOffset(), loc.getNodeLength(), newCommentText);
        } else {
            translationUnit.getBuffer().replace(node.getFileLocation().getNodeOffset(), 0, newCommentText);
        }
        translationUnit.getBuffer().save((IProgressMonitor)new NullProgressMonitor(), false);
    }

    private static IASTNode findNode(ISourceReference sourceRef, IASTTranslationUnit ast) throws CModelException {
        IASTNode parent;
        ISourceRange sourceRange = sourceRef.getSourceRange();
        IASTNode node = ast.getNodeSelector(null).findEnclosingNode(sourceRange.getStartPos(), sourceRange.getLength());
        if (node instanceof IASTCompositeTypeSpecifier && (parent = ((IASTCompositeTypeSpecifier)node).getParent()) instanceof IASTSimpleDeclaration) {
            return parent;
        }
        return node;
    }

    static String createNewCommentString(Optional<String> oldCom, String annotation, String tag, String nl, boolean addFileTag) {
        if (!oldCom.isPresent()) {
            String newComment = "/**" + nl;
            if (addFileTag) {
                newComment = String.valueOf(newComment) + " * @file" + nl;
            }
            newComment = String.valueOf(newComment) + " * " + tag + " " + annotation + nl + " */" + nl;
            return newComment;
        }
        String oldComment = oldCom.get();
        int tagIx = oldComment.indexOf(tag);
        if (tagIx != -1) {
            Matcher endOfTagMatcher = Pattern.compile("(\r?\n\\s*\\*\\s*\r?\n)|(\\s*(\r?\n)?\\s*\\*/(\r?\n)?)").matcher(oldComment);
            if (endOfTagMatcher.find(tagIx + tag.length())) {
                String beforeTagText = oldComment.substring(0, tagIx);
                String afterTagText = oldComment.substring(endOfTagMatcher.start());
                return String.valueOf(beforeTagText) + tag + " " + annotation + afterTagText;
            }
        } else {
            Matcher commentEndMatcher = Pattern.compile(".*?((\r?\n)?\\s*\\*/)", 32).matcher(oldComment);
            if (commentEndMatcher.find()) {
                return String.valueOf(oldComment.substring(0, commentEndMatcher.start(1))) + nl + " * " + tag + " " + annotation + nl + " */";
            }
        }
        throw new IllegalStateException("Weird comment: " + oldComment);
    }

    private static Optional<IASTComment> getDoxygenComment(List<IASTComment> comments) {
        Collections.reverse(comments);
        return comments.stream().filter(c -> CDTAnnotate.isDoxygenComment(c)).filter(c -> !CDTAnnotate.isDoxygenFileComment(c.getRawSignature())).findAny();
    }

    private static boolean isDoxygenComment(IASTComment comment) {
        String text = comment.getRawSignature();
        return text.startsWith("/**") || text.startsWith("/*!");
    }

    private static String findFirstNewline(IBuffer text) {
        int charIx = 0;
        while (charIx < text.getLength()) {
            String newline = CDTAnnotate.getNewline(text, charIx);
            if (newline != null) {
                return newline;
            }
            ++charIx;
        }
        return "\n";
    }

    private static String getNewline(IBuffer text, int offset) {
        if (text.getChar(offset) == '\n') {
            if (offset > 0 && text.getChar(offset - 1) == '\r') {
                return "\r\n";
            }
            return "\n";
        }
        if (text.getChar(offset) == '\r') {
            return "\r";
        }
        return null;
    }

    private static String findNewlineAndIndentationBefore(IBuffer text, int offset) {
        int charIx = offset;
        while (charIx >= 0) {
            String newline = CDTAnnotate.getNewline(text, charIx);
            if (newline != null) {
                String indentation = text.getText(charIx + 1, offset - charIx - 1);
                return String.valueOf(newline) + NON_SPACES_PATTERN.matcher(indentation).replaceAll(" ");
            }
            --charIx;
        }
        return CDTAnnotate.findFirstNewline(text);
    }
}

