/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.IConstants;
import org.eclipse.bpel.validator.model.IFilter;
import org.eclipse.bpel.validator.model.Problem;
import org.eclipse.bpel.validator.model.RuleFactory;
import org.eclipse.bpel.validator.model.Validator;
import org.eclipse.bpel.validator.rules.CValidator;
import org.eclipse.bpel.validator.unsupported.Process;
import org.eclipse.bpel.validator.vprop.Property;
import org.eclipse.bpel.validator.wsdl.Definitions;
import org.eclipse.bpel.validator.wsdl.Factory;
import org.eclipse.bpel.validator.xpath0.XPathValidator;

public class Rules {
    static final String RULE_NAME_PREFIX = "rule_";
    List<Rule> mRules = new ArrayList<Rule>();
    static final Map<Class<? extends Validator>, Rules> RULES_BY_CLASS = new HashMap<Class<? extends Validator>, Rules>();
    static Comparator<Rule> SORTER = new Comparator<Rule>(){

        @Override
        public int compare(Rule o1, Rule o2) {
            int res = o1.getTag().compareTo(o2.getTag());
            if (res != 0) {
                return res;
            }
            return o1.index - o2.index;
        }
    };
    static PrintStream OUT = System.out;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Rules getRules(Class<? extends Validator> clazz) {
        Rules rules = RULES_BY_CLASS.get(clazz);
        if (rules != null) {
            return rules;
        }
        rules = new Rules(clazz);
        Map<Class<? extends Validator>, Rules> map = RULES_BY_CLASS;
        synchronized (map) {
            RULES_BY_CLASS.put(clazz, rules);
        }
        return rules;
    }

    public Rules(Class<? extends Validator> clazz) {
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (Rules.isRule(m)) {
                this.mRules.add(new Rule(m));
            }
            ++n2;
        }
        if (this.mRules.size() > 1) {
            Collections.sort(this.mRules);
        }
    }

    public static boolean isRule(Method m) {
        ARule a = m.getAnnotation(ARule.class);
        return m.getName().startsWith(RULE_NAME_PREFIX) || a != null && a.sa() >= 0;
    }

    public static void main(String[] args) throws FileNotFoundException {
        RuleFactory.INSTANCE.registerFactory(org.eclipse.bpel.validator.rules.Factory.INSTANCE);
        RuleFactory.INSTANCE.registerFactory(Factory.INSTANCE);
        RuleFactory.INSTANCE.registerFactory(org.eclipse.bpel.validator.plt.Factory.INSTANCE);
        RuleFactory.INSTANCE.registerFactory(org.eclipse.bpel.validator.vprop.Factory.INSTANCE);
        RuleFactory.INSTANCE.registerFactory(org.eclipse.bpel.validator.xpath0.Factory.INSTANCE);
        Field[] fields = IConstants.class.getFields();
        DecimalFormat saNumberFormat = new DecimalFormat("00000");
        File outputFile = null;
        File cssFile = null;
        if (args.length > 0) {
            outputFile = new File(args[0]);
            OUT = new PrintStream(outputFile);
            cssFile = new File(String.valueOf(outputFile.getParent()) + File.separator + "rules.css");
        }
        if (cssFile != null && cssFile.exists()) {
            block32: {
                Rules.p("<style type=\"text/css\">", new Object[0]);
                BufferedReader reader = null;
                try {
                    try {
                        String line;
                        reader = new BufferedReader(new FileReader(cssFile));
                        while ((line = reader.readLine()) != null) {
                            Rules.p(line, new Object[0]);
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                            break block32;
                        }
                        catch (Throwable throwable2) {}
                        break block32;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (Throwable throwable3) {}
                    throw throwable;
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Throwable throwable) {}
            }
            Rules.p("</style>", new Object[0]);
        }
        int totalRules = 0;
        TreeMap<ARule, Rule> annotationHash = new TreeMap<ARule, Rule>(new Comparator<ARule>(){

            @Override
            public int compare(ARule o1, ARule o2) {
                return o1.sa() - o2.sa();
            }
        });
        LinkedList<QName> nodes = new LinkedList<QName>();
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            block33: {
                Field f = fieldArray[n2];
                String n3 = f.getName();
                if (n3.startsWith("ND_") || n3.contains("_ND_")) {
                    QName qtype;
                    System.out.println("Field: " + n3);
                    try {
                        Object o = f.get(null);
                        if (!(o instanceof QName)) break block33;
                        qtype = (QName)o;
                    }
                    catch (Exception exception) {
                        break block33;
                    }
                    nodes.add(qtype);
                }
            }
            ++n2;
        }
        nodes.add(new QName("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0", IConstants.ND_CONDITION.getLocalPart()));
        nodes.add(new QName("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0", IConstants.ND_BRANCHES.getLocalPart()));
        nodes.add(new QName("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0", IConstants.ND_FINAL_COUNTER_VALUE.getLocalPart()));
        nodes.add(new QName("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0", IConstants.ND_START_COUNTER_VALUE.getLocalPart()));
        nodes.add(new QName("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0", IConstants.ND_FOR.getLocalPart()));
        nodes.add(new QName("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0", IConstants.ND_FROM.getLocalPart()));
        nodes.add(new QName("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0", IConstants.ND_JOIN_CONDITION.getLocalPart()));
        nodes.add(new QName("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0", IConstants.ND_REPEAT_EVERY.getLocalPart()));
        nodes.add(new QName("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0", IConstants.ND_TO.getLocalPart()));
        nodes.add(new QName("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0", IConstants.ND_TRANSITION_CONDITION.getLocalPart()));
        nodes.add(new QName("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0", IConstants.ND_UNTIL.getLocalPart()));
        nodes.add(new QName("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0", IConstants.ND_QUERY.getLocalPart()));
        Collections.sort(nodes, new Comparator<QName>(){

            @Override
            public int compare(QName o1, QName o2) {
                return o1.getLocalPart().compareTo(o2.getLocalPart());
            }
        });
        Rules.p("<h2>Validators</h2>", new Object[0]);
        Rules.p("<ol class='validators'>", new Object[0]);
        for (QName qtype : nodes) {
            Validator obj = RuleFactory.INSTANCE.createValidator(qtype);
            if (obj == null) {
                Rules.p("<li><div class='missing'>{0} - no validator.</div></li>", qtype);
                continue;
            }
            Class<?> clazz = obj.getClass();
            Rules rules = Rules.getRules(clazz);
            int length = rules.mRules.size();
            Rules.p("<li> <b>{0}</b><p>{1} rules in class <a href=\"source.php?c={2}\">{2}</a></p>", qtype, length, clazz.getName(), clazz.getName());
            totalRules += length;
            Rules.p("<table class='av2'>", new Object[0]);
            Rules.p("<tr>", new Object[0]);
            Rules.p("<th class='w1'>#</th>", new Object[0]);
            Rules.p("<th class='w4'>Rule</th>", new Object[0]);
            Rules.p("<th class='w1'>Seq</th>", new Object[0]);
            Rules.p("<th class='w2'>Tag</th>", new Object[0]);
            Rules.p("<th>Description</th>", new Object[0]);
            Rules.p("<th class='w2'>Date</th>", new Object[0]);
            Rules.p("<th class='w1'>SA</th>", new Object[0]);
            Rules.p("</tr>", new Object[0]);
            int cnt = 0;
            ArrayList<Rule> rlist = new ArrayList<Rule>(rules.mRules);
            Collections.sort(rlist, SORTER);
            for (Rule r : rlist) {
                Rules.p("<tr>", new Object[0]);
                Rules.p(" <td>{0}</td>", ++cnt);
                Rules.p(" <td><a href=\"source.php?c={1}&m={2}\">{0}</a></td>", r.name, clazz.getName(), r.method.getName());
                Rules.p(" <td>{0}</td>", r.getIndex());
                ARule a = r.method.getAnnotation(ARule.class);
                if (a != null) {
                    Rules.p(" <td>{0}</td>", a.tag());
                    Rules.p(" <td>{0}<br/><span class='author'>Author: {1}</span></td>", a.desc(), a.author());
                    Rules.p(" <td>{0}</td>", a.date());
                    if (Integer.valueOf(a.sa()).equals(0)) {
                        Rules.p(" <td>N/A</td>", new Object[0]);
                    } else {
                        Rules.p(" <td><a href=\"http://docs.oasis-open.org/wsbpel/2.0/OS/wsbpel-v2.0-OS.html#SA{0}_table\">{0}</a></td>", saNumberFormat.format(a.sa()));
                    }
                    annotationHash.put(a, r);
                } else {
                    Rules.p(" <td>{0}</td>", "pass1");
                    Rules.p(" <td colspan='2'>-</td>", new Object[0]);
                    Rules.p(" <td>0</td>", new Object[0]);
                }
                Rules.p("</tr>", new Object[0]);
            }
            Rules.p("</table>", new Object[0]);
        }
        Rules.p("</ol>", new Object[0]);
        Rules.p("<h2>Statistics </h2>", new Object[0]);
        Rules.p("<table class='av'>", new Object[0]);
        Rules.p(" <tr><th>Total Rules:</th><td>{0}</td></tr>", totalRules);
        Rules.p(" <tr><th>Annotated Rules:</th><td>{0}</td></tr>", annotationHash.size());
        Rules.p(" <tr><th>Total Nodes:</th><td>{0}</td></tr>", nodes.size());
        Rules.p("</table>", new Object[0]);
        Rules.p("<h2>SA Checks done (against the spec)</h2>", new Object[0]);
        Rules.p("<table class='av2'>", new Object[0]);
        Rules.p("<tr>", new Object[0]);
        Rules.p("<th class='w1'>SA</th>", new Object[0]);
        Rules.p("<th>Description</th>", new Object[0]);
        Rules.p("<th class='w5'>Method</th>", new Object[0]);
        Rules.p("</tr>", new Object[0]);
        int saNumber = 0;
        int missingSA = 0;
        int totalSA = 94;
        for (ARule a : annotationHash.keySet()) {
            if (a.sa() <= 0) continue;
            if (a.sa() - saNumber > 1 && a.sa() <= totalSA) {
                int i = saNumber + 1;
                int j = a.sa();
                while (i < j) {
                    ++missingSA;
                    Rules.p("<tr>", new Object[0]);
                    Rules.p(" <td class='warn'>{0}</td>", i);
                    Rules.p(" <td colspan='2'><div class='warn'>Check for SA code {0} is missing</td></tr>", i);
                    Rules.p("</tr>", new Object[0]);
                    ++i;
                }
            }
            Rule r = (Rule)annotationHash.get(a);
            Rules.p("<tr>", new Object[0]);
            Rules.p("<td>{0}</td>", a.sa());
            Rules.p("<td>{0}<br/><span class='author'>Author: {1}<br/>Date: {2}</span></td>", Rules.toSafeHTML(a.desc()), Rules.toSafeHTML(a.author()), Rules.toSafeHTML(a.date()));
            Rules.p("<td>Class: <tt>{0}</tt><br/>", r.method.getDeclaringClass().getSimpleName());
            Rules.p("Method: <a href=\"source.php?c={0}&m={1}\" alt=\"Checked by {3}.{1}\"><tt>{1}</tt></a></td>", r.method.getDeclaringClass().getName(), r.method.getName(), r.method.getDeclaringClass().getName(), r.method.getDeclaringClass().getName());
            Rules.p("</tr>", new Object[0]);
            saNumber = a.sa();
        }
        Rules.p("</table>", new Object[0]);
        Rules.p("<h2>Completeness of SA checks</h2>", new Object[0]);
        Rules.p("<table class='av'>", new Object[0]);
        Rules.p(" <tr><th>Total SA Checks:</th><td>{0}</td></tr>", totalSA);
        Rules.p(" <tr><th>Implemented SA Checks:</th><td>{0}</td></tr>", totalSA - missingSA);
        Rules.p(" <tr><th>Missing SA Checks:</th><td>{0}</td></tr>", missingSA);
        Rules.p(" <tr><th>% Complete:</th><td>{0,number,0.00}</td></tr>", 100.0 * (double)(totalSA - missingSA) / (double)totalSA);
        Rules.p(" <tr><th>% TODO:</th><td>{0,number,0.00}</td></tr>", 100.0 * (double)missingSA / (double)totalSA);
        Rules.p("</table>", new Object[0]);
        Hashtable<String, ArrayList<Integer>> errorList = new Hashtable<String, ArrayList<Integer>>();
        Hashtable<String, ArrayList<Integer>> warningList = new Hashtable<String, ArrayList<Integer>>();
        Hashtable<String, ArrayList<Integer>> infoList = new Hashtable<String, ArrayList<Integer>>();
        for (ARule a : annotationHash.keySet()) {
            Rules.buildMsgList(a, a.errors(), errorList);
            Rules.buildMsgList(a, a.warnings(), warningList);
            Rules.buildMsgList(a, a.infos(), infoList);
        }
        Rules.printMsgList("Error", errorList);
        Rules.printMsgList("Warning", warningList);
        Rules.printMsgList("Information", infoList);
    }

    static Hashtable<String, ArrayList<Integer>> buildMsgList(ARule a, String msgs, Hashtable<String, ArrayList<Integer>> msgList) {
        String[] msgArray;
        String[] stringArray = msgArray = msgs.split(",");
        int n = msgArray.length;
        int n2 = 0;
        while (n2 < n) {
            String msg = stringArray[n2];
            if (!msg.equals("")) {
                ArrayList<Integer> saList = null;
                try {
                    saList = msgList.get(msg);
                }
                catch (Exception exception) {}
                if (saList == null) {
                    saList = new ArrayList();
                    saList.add(a.sa());
                    msgList.put(msg, saList);
                } else {
                    saList.add(a.sa());
                }
            }
            ++n2;
        }
        return msgList;
    }

    static void printMsgList(String type, Hashtable<String, ArrayList<Integer>> msgList) {
        Problem pRules = new Problem(new CValidator());
        Problem pModel = new Problem(new Validator());
        Problem pUnsupported = new Problem(new Process());
        Problem pVprop = new Problem(new Property());
        Problem pWsdl = new Problem(new Definitions());
        Problem pXPath0 = new Problem(new XPathValidator());
        Rules.p("<h2>{0} messages being reported against SA checks</h2>", type);
        Rules.p("<table class='av2'>", new Object[0]);
        Rules.p("<tr>", new Object[0]);
        Rules.p("<th class='w5'>Message Text</th>", new Object[0]);
        Rules.p("<th class='w1'>SA</th>", new Object[0]);
        Rules.p("</tr>", new Object[0]);
        for (Map.Entry<String, ArrayList<Integer>> e : msgList.entrySet()) {
            Rules.p("<tr>", new Object[0]);
            String key = e.getKey();
            String msg = pRules.getMessage(key, null);
            if (msg == null) {
                msg = pModel.getMessage(key, null);
            }
            if (msg == null) {
                msg = pUnsupported.getMessage(key, null);
            }
            if (msg == null) {
                msg = pVprop.getMessage(key, null);
            }
            if (msg == null) {
                msg = pWsdl.getMessage(key, null);
            }
            if (msg == null) {
                msg = pXPath0.getMessage(key, null);
            }
            if (msg == null) {
                msg = key;
            }
            Rules.p(" <td>{0}</td>", msg);
            Rules.p(" <td>", new Object[0]);
            ArrayList<Integer> values = e.getValue();
            int i = 0;
            while (i < values.size()) {
                Rules.printSAlink(values.get(i));
                if (i != values.size() - 1) {
                    Rules.p("<br/>", new Object[0]);
                }
                ++i;
            }
            Rules.p(" </td>", new Object[0]);
            Rules.p("</tr>", new Object[0]);
        }
        Rules.p("</table>", new Object[0]);
    }

    static void printSAlink(Integer sa) {
        DecimalFormat saNumberFormat = new DecimalFormat("00000");
        Rules.p("<a href=\"http://docs.oasis-open.org/wsbpel/2.0/OS/wsbpel-v2.0-OS.html#SA{0}_table\">{0}</a>", saNumberFormat.format(sa));
    }

    static void p(String msg, Object ... args) {
        if (args.length == 0) {
            OUT.println(msg);
        } else {
            OUT.println(MessageFormat.format(msg, args));
        }
    }

    static String toSafeHTML(String s) {
        StringBuilder sb = new StringBuilder(s.length() + s.length() / 4);
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            switch (ch) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            ++n2;
        }
        return sb.toString();
    }

    public static class IndexFilter
    implements IFilter<Rule> {
        int low;
        int high;
        String tag;

        public IndexFilter(int l, int h) {
            this.low = Math.max(0, l);
            this.high = Math.min(h, 65536);
        }

        public IndexFilter(int l, int h, String t) {
            this(l, h);
            this.tag = t;
        }

        @Override
        public boolean select(Rule rule) {
            boolean s;
            boolean bl = s = this.low <= rule.getIndex() && rule.getIndex() <= this.high;
            if (this.tag == null) {
                return s;
            }
            return s && this.tag.equals(rule.getTag());
        }
    }

    public class Rule
    implements Comparable<Rule> {
        Method method;
        String name;
        int index;
        String fullName;
        ARule aRule;

        Rule(Method m) {
            this.method = m;
            this.aRule = this.method.getAnnotation(ARule.class);
            this.name = this.parseName(m.getName());
            this.index = this.parseIndex(m.getName());
            this.fullName = String.valueOf(m.getDeclaringClass().getSimpleName()) + "." + this.name + "." + this.index;
        }

        String parseName(String n) {
            int idx = n.lastIndexOf(95);
            int start = 0;
            if (n.startsWith(Rules.RULE_NAME_PREFIX)) {
                start = Rules.RULE_NAME_PREFIX.length();
            }
            if (idx > 0 && start < idx) {
                return n.substring(start, idx);
            }
            return n.substring(start);
        }

        int parseIndex(String n) {
            int idx = n.lastIndexOf(95);
            if (idx < 0) {
                if (this.aRule != null) {
                    return this.aRule.order();
                }
                return 0;
            }
            try {
                return Integer.parseInt(n.substring(idx + 1));
            }
            catch (NumberFormatException numberFormatException) {
                if (this.aRule != null) {
                    return this.aRule.order();
                }
                return 0;
            }
        }

        public String getName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }

        public String getTag() {
            if (this.aRule == null) {
                return "pass1";
            }
            return this.aRule.tag();
        }

        public ARule getARule() {
            return this.aRule;
        }

        public Object invoke(Object context, Object[] args) throws Exception {
            return this.method.invoke(context, args);
        }

        @Override
        public int compareTo(Rule rule) {
            return this.index - rule.index;
        }

        public String getFullName() {
            return this.fullName;
        }
    }
}

